/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import org.jetbrains.annotations.NotNull;

public class WalkingState<T> {
    private boolean isDown;
    protected boolean startedWalking;
    private final TreeGuide<T> myWalker;
    private boolean stopped;

    public void elementFinished(@NotNull T element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/util/WalkingState", "elementFinished"));
        }
    }

    public WalkingState(@NotNull TreeGuide<T> delegate) {
        if (delegate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "com/intellij/util/WalkingState", "<init>"));
        }
        this.myWalker = delegate;
    }

    public void visit(@NotNull T element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/util/WalkingState", "visit"));
        }
        this.elementStarted(element);
    }

    public void elementStarted(@NotNull T element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/util/WalkingState", "elementStarted"));
        }
        this.isDown = true;
        if (!this.startedWalking) {
            this.stopped = false;
            this.startedWalking = true;
            try {
                this.walkChildren(element);
            }
            finally {
                this.startedWalking = false;
            }
        }
    }

    private void walkChildren(@NotNull T root) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/util/WalkingState", "walkChildren"));
        }
        T element = this.next(root, root, this.isDown);
        while (element != null && !this.stopped) {
            this.isDown = false;
            T parent = this.myWalker.getParent(element);
            T next = this.myWalker.getNextSibling(element);
            this.visit(element);
            assert (this.myWalker.getNextSibling(element) == next) : "Next sibling of the element '" + element + "' changed. Was: " + next + "; Now:" + this.myWalker.getNextSibling(element) + "; Root:" + root;
            assert (this.myWalker.getParent(element) == parent) : "Parent of the element '" + element + "' changed. Was: " + parent + "; Now:" + this.myWalker.getParent(element) + "; Root:" + root;
            element = this.next(element, root, this.isDown);
        }
    }

    public T next(T element, @NotNull T root, boolean isDown) {
        T child;
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/util/WalkingState", "next"));
        }
        if (isDown && (child = this.myWalker.getFirstChild(element)) != null) {
            return child;
        }
        while (element != root && element != null) {
            T next = this.myWalker.getNextSibling(element);
            this.elementFinished(element);
            if (next != null) {
                T nextPrev = this.myWalker.getPrevSibling(next);
                if (nextPrev != element) {
                    T top;
                    String msg = "Element: " + element + "; next: " + next + "; next.prev: " + nextPrev;
                    while ((top = this.myWalker.getParent(element)) != null && top != root) {
                        element = top;
                    }
                    assert (false) : msg + " Top:" + element;
                }
                return next;
            }
            element = this.myWalker.getParent(element);
        }
        if (element != null) {
            this.elementFinished(element);
        }
        return null;
    }

    public static interface TreeGuide<T> {
        public T getNextSibling(@NotNull T var1);

        public T getPrevSibling(@NotNull T var1);

        public T getFirstChild(@NotNull T var1);

        public T getParent(@NotNull T var1);
    }
}

