/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import org.jetbrains.annotations.NotNull;

public class SystemProperties {
    public static String getUserHome() {
        return System.getProperty("user.home");
    }

    public static String getLineSeparator() {
        return System.getProperty("line.separator");
    }

    public static String getJavaVmVendor() {
        return System.getProperty("java.vm.vendor");
    }

    public static boolean getBooleanProperty(@NotNull String key, boolean defaultValue) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/util/SystemProperties", "getBooleanProperty"));
        }
        String value = System.getProperty(key);
        if (value != null) {
            return Boolean.parseBoolean(value);
        }
        return defaultValue;
    }

    public static String getJavaVendor() {
        return System.getProperty("java.vendor");
    }
}

