/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.tree;

import com.intellij.openapi.diagnostic.LogUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TokenSet {
    public static final TokenSet EMPTY = new TokenSet(Short.MAX_VALUE, 0){

        @Override
        public boolean contains(IElementType t) {
            return false;
        }
    };
    private final short myShift;
    private final short myMax;
    private final long[] myWords;

    private TokenSet(short shift, short max) {
        this.myShift = shift;
        this.myMax = max;
        int size = (max >> 6) + 1 - shift;
        this.myWords = size > 0 ? new long[size] : ArrayUtil.EMPTY_LONG_ARRAY;
    }

    private boolean get(int index) {
        int wordIndex = (index >> 6) - this.myShift;
        return wordIndex >= 0 && wordIndex < this.myWords.length && (this.myWords[wordIndex] & 1L << index) != 0L;
    }

    public boolean contains(@Nullable IElementType t) {
        if (t == null) {
            return false;
        }
        short i = t.getIndex();
        return 0 <= i && i <= this.myMax && this.get(i);
    }

    @NotNull
    public static TokenSet create(IElementType ... types) {
        if (types == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types", "com/intellij/psi/tree/TokenSet", "create"));
        }
        if (types.length == 0) {
            TokenSet tokenSet = EMPTY;
            if (tokenSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/tree/TokenSet", "create"));
            }
            return tokenSet;
        }
        short min = Short.MAX_VALUE;
        short max = 0;
        for (IElementType type : types) {
            if (type == null) continue;
            short index = type.getIndex();
            assert (index >= 0) : "Unregistered elements are not allowed here: " + LogUtil.objectAndClass(type);
            if (min > index) {
                min = index;
            }
            if (max >= index) continue;
            max = index;
        }
        short shift = (short)(min >> 6);
        TokenSet set = new TokenSet(shift, max);
        for (IElementType type : types) {
            int wordIndex;
            if (type == null) continue;
            short index = type.getIndex();
            int n = wordIndex = (index >> 6) - shift;
            set.myWords[n] = set.myWords[n] | 1L << index;
        }
        TokenSet tokenSet = set;
        if (tokenSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/tree/TokenSet", "create"));
        }
        return tokenSet;
    }
}

