/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PsiNameHelper {
    private static final Pattern WHITESPACE_PATTERN = Pattern.compile("(?:\\s)|(?:/\\*.*\\*/)|(?://[^\\n]*)");

    public abstract boolean isIdentifier(@Nullable String var1);

    public abstract boolean isIdentifier(@Nullable String var1, @NotNull LanguageLevel var2);

    public abstract boolean isKeyword(@Nullable String var1);

    public abstract boolean isQualifiedName(@Nullable String var1);

    @NotNull
    public static String getShortClassName(@NotNull String referenceText) {
        String sub;
        int i;
        if (referenceText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceText", "com/intellij/psi/PsiNameHelper", "getShortClassName"));
        }
        int lessPos = referenceText.length();
        int bracesBalance = 0;
        block5: for (i = referenceText.length() - 1; i >= 0; --i) {
            char ch = referenceText.charAt(i);
            switch (ch) {
                case ')': 
                case '>': {
                    ++bracesBalance;
                    continue block5;
                }
                case '(': 
                case '<': {
                    --bracesBalance;
                    lessPos = i;
                    continue block5;
                }
                case '.': 
                case '@': {
                    if (bracesBalance > 0) continue block5;
                    break block5;
                }
                default: {
                    if (!Character.isWhitespace(ch) || bracesBalance > 0) continue block5;
                    for (int j = i + 1; j < lessPos; ++j) {
                        if (!Character.isWhitespace(referenceText.charAt(j))) break block5;
                    }
                    lessPos = i;
                }
            }
        }
        String string = (sub = referenceText.substring(i + 1, lessPos).trim()).length() == referenceText.length() ? sub : new String(sub);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/PsiNameHelper", "getShortClassName"));
        }
        return string;
    }

    @NotNull
    public static String getPresentableText(@NotNull PsiJavaCodeReferenceElement ref) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/psi/PsiNameHelper", "getPresentableText"));
        }
        String name = ref.getReferenceName();
        PsiAnnotation[] annotations = (PsiAnnotation[])PsiTreeUtil.getChildrenOfType((PsiElement)ref, PsiAnnotation.class);
        String string = PsiNameHelper.getPresentableText(name, ObjectUtils.notNull(annotations, PsiAnnotation.EMPTY_ARRAY), ref.getTypeParameters());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/PsiNameHelper", "getPresentableText"));
        }
        return string;
    }

    @NotNull
    public static String getPresentableText(@Nullable String refName, @NotNull PsiAnnotation[] annotations, @NotNull PsiType[] types) {
        if (annotations == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotations", "com/intellij/psi/PsiNameHelper", "getPresentableText"));
        }
        if (types == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types", "com/intellij/psi/PsiNameHelper", "getPresentableText"));
        }
        if (types.length == 0 && annotations.length == 0) {
            String string = refName != null ? refName : "";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/PsiNameHelper", "getPresentableText"));
            }
            return string;
        }
        StringBuilder buffer = new StringBuilder();
        PsiNameHelper.appendAnnotations(buffer, annotations, false);
        buffer.append(refName);
        PsiNameHelper.appendTypeArgs(buffer, types, false, true);
        String string = buffer.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/PsiNameHelper", "getPresentableText"));
        }
        return string;
    }

    @NotNull
    public static String getQualifiedClassName(@NotNull String referenceText, boolean removeWhitespace) {
        if (referenceText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceText", "com/intellij/psi/PsiNameHelper", "getQualifiedClassName"));
        }
        if (removeWhitespace) {
            referenceText = PsiNameHelper.removeWhitespace(referenceText);
        }
        if (referenceText.indexOf(60) < 0) {
            String string = referenceText;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/PsiNameHelper", "getQualifiedClassName"));
            }
            return string;
        }
        StringBuilder buffer = new StringBuilder(referenceText.length());
        char[] chars = referenceText.toCharArray();
        int gtPos = 0;
        int count = 0;
        block4: for (int i = 0; i < chars.length; ++i) {
            char aChar = chars[i];
            switch (aChar) {
                case '<': {
                    if (++count != 1) continue block4;
                    buffer.append(new String(chars, gtPos, i - gtPos));
                    continue block4;
                }
                case '>': {
                    --count;
                    gtPos = i + 1;
                }
            }
        }
        if (count == 0) {
            buffer.append(new String(chars, gtPos, chars.length - gtPos));
        }
        String string = buffer.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/PsiNameHelper", "getQualifiedClassName"));
        }
        return string;
    }

    private static String removeWhitespace(@NotNull String referenceText) {
        if (referenceText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceText", "com/intellij/psi/PsiNameHelper", "removeWhitespace"));
        }
        boolean needsChange = false;
        for (int i = 0; i < referenceText.length(); ++i) {
            char c = referenceText.charAt(i);
            if (c != '/' && !Character.isWhitespace(c)) continue;
            needsChange = true;
            break;
        }
        if (!needsChange) {
            return referenceText;
        }
        return WHITESPACE_PATTERN.matcher(referenceText).replaceAll("");
    }

    @NotNull
    public static String[] getClassParametersText(@NotNull String referenceText) {
        if (referenceText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceText", "com/intellij/psi/PsiNameHelper", "getClassParametersText"));
        }
        if (referenceText.indexOf(60) < 0) {
            if (ArrayUtil.EMPTY_STRING_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/PsiNameHelper", "getClassParametersText"));
            }
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        char[] chars = referenceText.toCharArray();
        int afterLastDotIndex = 0;
        int level = 0;
        block15: for (int i = 0; i < chars.length; ++i) {
            char aChar = chars[i];
            switch (aChar) {
                case '<': {
                    ++level;
                    continue block15;
                }
                case '.': {
                    if (level != 0) continue block15;
                    afterLastDotIndex = i + 1;
                    continue block15;
                }
                case '>': {
                    --level;
                }
            }
        }
        if (level != 0) {
            if (ArrayUtil.EMPTY_STRING_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/PsiNameHelper", "getClassParametersText"));
            }
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        int dim = 0;
        block16: for (int i = afterLastDotIndex; i < chars.length; ++i) {
            char aChar = chars[i];
            switch (aChar) {
                case '<': {
                    if (++level != 1) continue block16;
                    ++dim;
                    continue block16;
                }
                case ',': {
                    if (level != 1) continue block16;
                    ++dim;
                    continue block16;
                }
                case '>': {
                    --level;
                }
            }
        }
        if (level != 0 || dim == 0) {
            if (ArrayUtil.EMPTY_STRING_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/PsiNameHelper", "getClassParametersText"));
            }
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        String[] result = new String[dim];
        dim = 0;
        int ltPos = 0;
        block17: for (int i = afterLastDotIndex; i < chars.length; ++i) {
            char aChar = chars[i];
            switch (aChar) {
                case '<': {
                    if (++level != 1) continue block17;
                    ltPos = i;
                    continue block17;
                }
                case ',': {
                    if (level != 1) continue block17;
                    result[dim++] = new String(chars, ltPos + 1, i - ltPos - 1);
                    ltPos = i;
                    continue block17;
                }
                case '>': {
                    if (--level != 0) continue block17;
                    result[dim++] = new String(chars, ltPos + 1, i - ltPos - 1);
                }
            }
        }
        if (result == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/PsiNameHelper", "getClassParametersText"));
        }
        return result;
    }

    public static boolean isSubpackageOf(@NotNull String subpackageName, @NotNull String packageName) {
        if (subpackageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subpackageName", "com/intellij/psi/PsiNameHelper", "isSubpackageOf"));
        }
        if (packageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "com/intellij/psi/PsiNameHelper", "isSubpackageOf"));
        }
        return subpackageName.equals(packageName) || subpackageName.startsWith(packageName) && subpackageName.charAt(packageName.length()) == '.';
    }

    public static void appendTypeArgs(@NotNull StringBuilder sb, @NotNull PsiType[] types, boolean canonical, boolean annotated) {
        if (sb == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sb", "com/intellij/psi/PsiNameHelper", "appendTypeArgs"));
        }
        if (types == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types", "com/intellij/psi/PsiNameHelper", "appendTypeArgs"));
        }
        if (types.length == 0) {
            return;
        }
        sb.append('<');
        for (int i = 0; i < types.length; ++i) {
            if (i > 0) {
                sb.append(canonical ? "," : ", ");
            }
            PsiType type = types[i];
            if (canonical) {
                sb.append(type.getCanonicalText(annotated));
                continue;
            }
            sb.append(type.getPresentableText());
        }
        sb.append('>');
    }

    public static boolean appendAnnotations(@NotNull StringBuilder sb, @NotNull PsiAnnotation[] annotations, boolean canonical) {
        if (sb == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sb", "com/intellij/psi/PsiNameHelper", "appendAnnotations"));
        }
        if (annotations == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotations", "com/intellij/psi/PsiNameHelper", "appendAnnotations"));
        }
        return PsiNameHelper.appendAnnotations(sb, Arrays.asList(annotations), canonical);
    }

    public static boolean appendAnnotations(@NotNull StringBuilder sb, @NotNull List<PsiAnnotation> annotations, boolean canonical) {
        if (sb == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sb", "com/intellij/psi/PsiNameHelper", "appendAnnotations"));
        }
        if (annotations == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotations", "com/intellij/psi/PsiNameHelper", "appendAnnotations"));
        }
        boolean updated = false;
        for (PsiAnnotation annotation : annotations) {
            if (canonical) {
                String name = annotation.getQualifiedName();
                if (name == null) continue;
                sb.append('@').append(name).append(annotation.getParameterList().getText()).append(' ');
                updated = true;
                continue;
            }
            PsiJavaCodeReferenceElement refElement = annotation.getNameReferenceElement();
            if (refElement == null) continue;
            sb.append('@').append(refElement.getText()).append(' ');
            updated = true;
        }
        return updated;
    }
}

