/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.util.containers.ConcurrentIntObjectMap;
import com.intellij.util.containers.ContainerUtil;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Key<T> {
    private static final AtomicInteger ourKeysCounter = new AtomicInteger();
    private final int myIndex;
    private final String myName;
    private static final ConcurrentIntObjectMap<Key> allKeys = ContainerUtil.createConcurrentIntObjectWeakValueMap();

    public Key(@NotNull @NonNls String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/util/Key", "<init>"));
        }
        this.myIndex = ourKeysCounter.getAndIncrement();
        this.myName = name;
        allKeys.put(this.myIndex, this);
    }

    public final int hashCode() {
        return this.myIndex;
    }

    public final boolean equals(Object obj) {
        return obj == this;
    }

    public static <T> Key<T> create(@NotNull @NonNls String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/util/Key", "create"));
        }
        return new Key<T>(name);
    }

    @Nullable(value="can become null if the key has been gc-ed")
    public static <T> Key<T> getKeyByIndex(int index) {
        return allKeys.get(index);
    }
}

