/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.utils;

import com.intellij.util.lang.JavaVersion;
import java.io.File;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u001f\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0005\bf\u0018\u00002\u00020\u0001:\u000256J\u0010\u0010(\u001a\u00020\u00032\u0006\u0010(\u001a\u00020)H&J\u0010\u0010*\u001a\u00020\u00032\u0006\u0010(\u001a\u00020)H&J\u0012\u0010+\u001a\u0004\u0018\u00010\u00032\u0006\u0010(\u001a\u00020)H&J\u001c\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00030#2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020)0.H\u0016J/\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00030#2\u0006\u0010/\u001a\u0002002\u0012\u00101\u001a\n\u0012\u0006\b\u0001\u0012\u00020)02\"\u00020)H\u0016\u00a2\u0006\u0002\u00103J'\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00030#2\u0012\u0010-\u001a\n\u0012\u0006\b\u0001\u0012\u00020)02\"\u00020)H\u0016\u00a2\u0006\u0002\u00104R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\u0005R\u0014\u0010\b\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0005R\u0014\u0010\n\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\u0005R\u0014\u0010\f\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u0005R\u0014\u0010\u000e\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0005R\u0014\u0010\u0010\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0005R\u0014\u0010\u0012\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0005R\u0014\u0010\u0014\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0005R\u0014\u0010\u0016\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0005R\u0014\u0010\u0018\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0005R\u0014\u0010\u001a\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0005R\u0014\u0010\u001c\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0005R\u0014\u0010\u001e\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u0005R\u0014\u0010 \u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u0005R\u001a\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00030#8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010%R\u0014\u0010&\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010\u0005\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u00067\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/kotlin/utils/KotlinPaths;", "", "homePath", "Ljava/io/File;", "getHomePath", "()Ljava/io/File;", "libPath", "getLibPath", "stdlibPath", "getStdlibPath", "reflectPath", "getReflectPath", "scriptRuntimePath", "getScriptRuntimePath", "kotlinTestPath", "getKotlinTestPath", "stdlibSourcesPath", "getStdlibSourcesPath", "jsStdLibKlibPath", "getJsStdLibKlibPath", "jsStdLibSrcJarPath", "getJsStdLibSrcJarPath", "jsKotlinTestKlibPath", "getJsKotlinTestKlibPath", "allOpenPluginJarPath", "getAllOpenPluginJarPath", "noArgPluginJarPath", "getNoArgPluginJarPath", "lombokPluginJarPath", "getLombokPluginJarPath", "samWithReceiverJarPath", "getSamWithReceiverJarPath", "trove4jJarPath", "getTrove4jJarPath", "compilerClasspath", "", "getCompilerClasspath", "()Ljava/util/List;", "compilerPath", "getCompilerPath", "jar", "Lorg/jetbrains/kotlin/utils/KotlinPaths$Jar;", "klib", "sourcesJar", "classPath", "jars", "Lkotlin/sequences/Sequence;", "base", "Lorg/jetbrains/kotlin/utils/KotlinPaths$ClassPaths;", "additionalJars", "", "(Lorg/jetbrains/kotlin/utils/KotlinPaths$ClassPaths;[Lorg/jetbrains/kotlin/utils/KotlinPaths$Jar;)Ljava/util/List;", "([Lorg/jetbrains/kotlin/utils/KotlinPaths$Jar;)Ljava/util/List;", "Jar", "ClassPaths", "util"})
public interface KotlinPaths {
    @NotNull
    public File getHomePath();

    @NotNull
    public File getLibPath();

    @NotNull
    default public File getStdlibPath() {
        return this.jar(Jar.StdLib);
    }

    @NotNull
    default public File getReflectPath() {
        return this.jar(Jar.Reflect);
    }

    @NotNull
    default public File getScriptRuntimePath() {
        return this.jar(Jar.ScriptRuntime);
    }

    @NotNull
    default public File getKotlinTestPath() {
        return this.jar(Jar.KotlinTest);
    }

    @NotNull
    default public File getStdlibSourcesPath() {
        File file2 = this.sourcesJar(Jar.StdLib);
        Intrinsics.checkNotNull((Object)file2);
        return file2;
    }

    @NotNull
    default public File getJsStdLibKlibPath() {
        return this.klib(Jar.JsStdLib);
    }

    @NotNull
    default public File getJsStdLibSrcJarPath() {
        File file2 = this.sourcesJar(Jar.JsStdLib);
        Intrinsics.checkNotNull((Object)file2);
        return file2;
    }

    @NotNull
    default public File getJsKotlinTestKlibPath() {
        return this.klib(Jar.JsKotlinTest);
    }

    @NotNull
    default public File getAllOpenPluginJarPath() {
        return this.jar(Jar.AllOpenPlugin);
    }

    @NotNull
    default public File getNoArgPluginJarPath() {
        return this.jar(Jar.NoArgPlugin);
    }

    @NotNull
    default public File getLombokPluginJarPath() {
        return this.jar(Jar.LombokPlugin);
    }

    @NotNull
    default public File getSamWithReceiverJarPath() {
        return this.jar(Jar.SamWithReceiver);
    }

    @NotNull
    default public File getTrove4jJarPath() {
        return this.jar(Jar.Trove4j);
    }

    @NotNull
    default public List<File> getCompilerClasspath() {
        return this.classPath(ClassPaths.Compiler, new Jar[0]);
    }

    @NotNull
    default public File getCompilerPath() {
        return this.jar(Jar.Compiler);
    }

    @NotNull
    public File jar(@NotNull Jar var1);

    @NotNull
    public File klib(@NotNull Jar var1);

    @Nullable
    public File sourcesJar(@NotNull Jar var1);

    @NotNull
    default public List<File> classPath(@NotNull Sequence<? extends Jar> jars) {
        Intrinsics.checkNotNullParameter(jars, (String)"jars");
        return SequencesKt.toList((Sequence)SequencesKt.map(jars, (Function1)((Function1)new Function1<Jar, File>((Object)this){

            public final File invoke(Jar p0) {
                Intrinsics.checkNotNullParameter((Object)((Object)p0), (String)"p0");
                return ((KotlinPaths)this.receiver).jar(p0);
            }

            public final String getSignature() {
                return "jar(Lorg/jetbrains/kotlin/utils/KotlinPaths$Jar;)Ljava/io/File;";
            }

            public final String getName() {
                return "jar";
            }

            public final KDeclarationContainer getOwner() {
                return (KDeclarationContainer)Reflection.getOrCreateKotlinClass(KotlinPaths.class);
            }
        })));
    }

    @NotNull
    default public List<File> classPath(@NotNull ClassPaths base, Jar ... additionalJars) {
        Intrinsics.checkNotNullParameter((Object)((Object)base), (String)"base");
        Intrinsics.checkNotNullParameter((Object)additionalJars, (String)"additionalJars");
        return this.classPath((Sequence<? extends Jar>)SequencesKt.plus((Sequence)CollectionsKt.asSequence((Iterable)base.getContents()), (Object[])additionalJars));
    }

    @NotNull
    default public List<File> classPath(Jar ... jars) {
        Intrinsics.checkNotNullParameter((Object)jars, (String)"jars");
        return this.classPath((Sequence<? extends Jar>)ArraysKt.asSequence((Object[])jars));
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0019\b\u0002\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006B\u001d\b\u0012\u0012\u0012\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\b\"\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\tB%\b\u0012\u0012\u0006\u0010\n\u001a\u00020\u0000\u0012\u0012\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\b\"\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u000bB1\b\u0012\u0012\u0012\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\b\"\u00020\u0004\u0012\u0012\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\r\u00a2\u0006\u0004\b\u0005\u0010\u000eR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013j\u0002\b\u0014j\u0002\b\u0015\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/utils/KotlinPaths$ClassPaths;", "", "contents", "", "Lorg/jetbrains/kotlin/utils/KotlinPaths$Jar;", "<init>", "(Ljava/lang/String;ILjava/util/List;)V", "jars", "", "(Ljava/lang/String;I[Lorg/jetbrains/kotlin/utils/KotlinPaths$Jar;)V", "baseClassPath", "(Ljava/lang/String;ILorg/jetbrains/kotlin/utils/KotlinPaths$ClassPaths;[Lorg/jetbrains/kotlin/utils/KotlinPaths$Jar;)V", "gen", "Lkotlin/Function0;", "(Ljava/lang/String;I[Lorg/jetbrains/kotlin/utils/KotlinPaths$Jar;Lkotlin/jvm/functions/Function0;)V", "getContents", "()Ljava/util/List;", "Empty", "StdLib", "Compiler", "CompilerWithScripting", "MainKts", "util"})
    public static final class ClassPaths
    extends Enum<ClassPaths> {
        @NotNull
        private final List<Jar> contents;
        public static final /* enum */ ClassPaths Empty = new ClassPaths("Empty", 0, null, 1, null);
        public static final /* enum */ ClassPaths StdLib;
        public static final /* enum */ ClassPaths Compiler;
        public static final /* enum */ ClassPaths CompilerWithScripting;
        public static final /* enum */ ClassPaths MainKts;
        private static final /* synthetic */ ClassPaths[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private ClassPaths(List<? extends Jar> contents) {
            this.contents = contents;
        }

        /* synthetic */ ClassPaths(String string2, int n, List list, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 1) != 0) {
                list = CollectionsKt.emptyList();
            }
            this(list);
        }

        @NotNull
        public final List<Jar> getContents() {
            return this.contents;
        }

        private ClassPaths(Jar ... jars) {
            this(ArraysKt.asList((Object[])jars));
        }

        private ClassPaths(ClassPaths baseClassPath, Jar ... jars) {
            this(CollectionsKt.plus((Collection)baseClassPath.contents, (Object[])jars));
        }

        private ClassPaths(Jar[] jars, Function0<? extends List<? extends Jar>> gen2) {
            this(CollectionsKt.plus((Collection)ArraysKt.asList((Object[])jars), (Iterable)((Iterable)gen2.invoke())));
        }

        public static ClassPaths[] values() {
            return (ClassPaths[])$VALUES.clone();
        }

        public static ClassPaths valueOf(String value2) {
            return Enum.valueOf(ClassPaths.class, value2);
        }

        @NotNull
        public static EnumEntries<ClassPaths> getEntries() {
            return $ENTRIES;
        }

        private static final List _init_$lambda$0() {
            List list;
            if (JavaVersion.current().compareTo(JavaVersion.compose((int)8)) >= 0) {
                Jar[] jarArray = new Jar[]{Jar.StdLibJdk7, Jar.StdLibJdk8};
                list = CollectionsKt.listOf((Object[])jarArray);
            } else {
                list = JavaVersion.current().compareTo(JavaVersion.compose((int)7)) >= 0 ? CollectionsKt.listOf((Object)((Object)Jar.StdLibJdk7)) : CollectionsKt.emptyList();
            }
            return list;
        }

        static {
            Jar[] jarArray = new Jar[]{Jar.StdLib};
            StdLib = new ClassPaths(jarArray, (Function0<? extends List<? extends Jar>>)((Function0)ClassPaths::_init_$lambda$0));
            jarArray = new Jar[]{Jar.Compiler, Jar.Reflect, Jar.ScriptRuntime, Jar.Trove4j, Jar.KotlinDaemon, Jar.CoroutinesCore};
            Compiler = new ClassPaths(StdLib, jarArray);
            jarArray = new Jar[]{Jar.ScriptingPlugin, Jar.ScriptingImpl, Jar.ScriptingLib, Jar.ScriptingJvmLib};
            CompilerWithScripting = new ClassPaths(Compiler, jarArray);
            jarArray = new Jar[]{Jar.MainKts, Jar.ScriptRuntime, Jar.Reflect};
            MainKts = new ClassPaths(StdLib, jarArray);
            $VALUES = classPathsArray = new ClassPaths[]{ClassPaths.Empty, ClassPaths.StdLib, ClassPaths.Compiler, ClassPaths.CompilerWithScripting, ClassPaths.MainKts};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u001b\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013j\u0002\b\u0014j\u0002\b\u0015j\u0002\b\u0016j\u0002\b\u0017j\u0002\b\u0018j\u0002\b\u0019j\u0002\b\u001aj\u0002\b\u001bj\u0002\b\u001cj\u0002\b\u001d\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/utils/KotlinPaths$Jar;", "", "baseName", "", "<init>", "(Ljava/lang/String;ILjava/lang/String;)V", "getBaseName", "()Ljava/lang/String;", "StdLib", "StdLibJdk7", "StdLibJdk8", "Reflect", "ScriptRuntime", "KotlinTest", "JsStdLib", "JsKotlinTest", "AllOpenPlugin", "NoArgPlugin", "LombokPlugin", "SamWithReceiver", "SerializationPlugin", "Trove4j", "Compiler", "ScriptingPlugin", "ScriptingImpl", "ScriptingLib", "ScriptingJvmLib", "CoroutinesCore", "KotlinDaemon", "MainKts", "util"})
    public static final class Jar
    extends Enum<Jar> {
        @NotNull
        private final String baseName;
        public static final /* enum */ Jar StdLib = new Jar("kotlin-stdlib");
        public static final /* enum */ Jar StdLibJdk7 = new Jar("kotlin-stdlib-jdk7");
        public static final /* enum */ Jar StdLibJdk8 = new Jar("kotlin-stdlib-jdk8");
        public static final /* enum */ Jar Reflect = new Jar("kotlin-reflect");
        public static final /* enum */ Jar ScriptRuntime = new Jar("kotlin-script-runtime");
        public static final /* enum */ Jar KotlinTest = new Jar("kotlin-test");
        public static final /* enum */ Jar JsStdLib = new Jar("kotlin-stdlib-js");
        public static final /* enum */ Jar JsKotlinTest = new Jar("kotlin-test-js");
        public static final /* enum */ Jar AllOpenPlugin = new Jar("allopen-compiler-plugin");
        public static final /* enum */ Jar NoArgPlugin = new Jar("noarg-compiler-plugin");
        public static final /* enum */ Jar LombokPlugin = new Jar("lombok-compiler-plugin");
        public static final /* enum */ Jar SamWithReceiver = new Jar("sam-with-receiver-compiler-plugin");
        public static final /* enum */ Jar SerializationPlugin = new Jar("kotlinx-serialization-compiler-plugin");
        public static final /* enum */ Jar Trove4j = new Jar("trove4j");
        public static final /* enum */ Jar Compiler = new Jar("kotlin-compiler");
        public static final /* enum */ Jar ScriptingPlugin = new Jar("kotlin-scripting-compiler");
        public static final /* enum */ Jar ScriptingImpl = new Jar("kotlin-scripting-compiler-impl");
        public static final /* enum */ Jar ScriptingLib = new Jar("kotlin-scripting-common");
        public static final /* enum */ Jar ScriptingJvmLib = new Jar("kotlin-scripting-jvm");
        public static final /* enum */ Jar CoroutinesCore = new Jar("kotlinx-coroutines-core-jvm");
        public static final /* enum */ Jar KotlinDaemon = new Jar("kotlin-daemon");
        public static final /* enum */ Jar MainKts = new Jar("kotlin-main-kts");
        private static final /* synthetic */ Jar[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private Jar(String baseName) {
            this.baseName = baseName;
        }

        @NotNull
        public final String getBaseName() {
            return this.baseName;
        }

        public static Jar[] values() {
            return (Jar[])$VALUES.clone();
        }

        public static Jar valueOf(String value2) {
            return Enum.valueOf(Jar.class, value2);
        }

        @NotNull
        public static EnumEntries<Jar> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = jarArray = new Jar[]{Jar.StdLib, Jar.StdLibJdk7, Jar.StdLibJdk8, Jar.Reflect, Jar.ScriptRuntime, Jar.KotlinTest, Jar.JsStdLib, Jar.JsKotlinTest, Jar.AllOpenPlugin, Jar.NoArgPlugin, Jar.LombokPlugin, Jar.SamWithReceiver, Jar.SerializationPlugin, Jar.Trove4j, Jar.Compiler, Jar.ScriptingPlugin, Jar.ScriptingImpl, Jar.ScriptingLib, Jar.ScriptingJvmLib, Jar.CoroutinesCore, Jar.KotlinDaemon, Jar.MainKts};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

