/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.serialization.builtins;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.builtins.jvm.JvmBuiltInClassDescriptorFactory;
import org.jetbrains.kotlin.cli.common.CLIConfigurationKeys;
import org.jetbrains.kotlin.cli.common.CommonCompilerPerformanceManager;
import org.jetbrains.kotlin.cli.common.config.ContentRootsKt;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSourceLocation;
import org.jetbrains.kotlin.cli.common.messages.GroupingMessageCollector;
import org.jetbrains.kotlin.cli.common.messages.MessageRenderer;
import org.jetbrains.kotlin.cli.common.messages.PrintingMessageCollector;
import org.jetbrains.kotlin.cli.jvm.compiler.EnvironmentConfigFiles;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment;
import org.jetbrains.kotlin.cli.jvm.config.JvmContentRootsKt;
import org.jetbrains.kotlin.cli.metadata.CommonAnalysisResult;
import org.jetbrains.kotlin.cli.metadata.MetadataSerializer;
import org.jetbrains.kotlin.config.CommonConfigurationKeys;
import org.jetbrains.kotlin.config.CommonConfigurationKeysKt;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PackageViewDescriptor;
import org.jetbrains.kotlin.descriptors.impl.EmptyPackageFragmentDescriptor;
import org.jetbrains.kotlin.metadata.builtins.BuiltInsBinaryVersion;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtCommonFile;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.scopes.DescriptorKindFilter;
import org.jetbrains.kotlin.resolve.scopes.ResolutionScope;
import org.jetbrains.kotlin.serialization.KotlinSerializerExtensionBase;
import org.jetbrains.kotlin.serialization.builtins.BuiltInsSerializer;
import org.jetbrains.kotlin.serialization.builtins.BuiltInsSerializerExtension;
import org.jetbrains.kotlin.serialization.deserialization.builtins.BuiltInSerializerProtocol;
import org.jetbrains.kotlin.storage.LockBasedStorageManager;
import org.jetbrains.kotlin.storage.StorageManager;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\b\u0010\u0010\u001a\u00020\u0011H\u0014J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/serialization/builtins/BuiltInsSerializer;", "Lorg/jetbrains/kotlin/cli/metadata/MetadataSerializer;", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "environment", "Lorg/jetbrains/kotlin/cli/jvm/compiler/KotlinCoreEnvironment;", "dependOnOldBuiltIns", "", "<init>", "(Lorg/jetbrains/kotlin/config/CompilerConfiguration;Lorg/jetbrains/kotlin/cli/jvm/compiler/KotlinCoreEnvironment;Z)V", "serialize", "", "analysisResult", "Lorg/jetbrains/kotlin/cli/metadata/CommonAnalysisResult;", "destDir", "Ljava/io/File;", "createSerializerExtension", "Lorg/jetbrains/kotlin/serialization/KotlinSerializerExtensionBase;", "createCloneable", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "module", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "Companion", "cli"})
@SourceDebugExtension(value={"SMAP\nBuiltInsSerializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BuiltInsSerializer.kt\norg/jetbrains/kotlin/serialization/builtins/BuiltInsSerializer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,126:1\n1557#2:127\n1628#2,3:128\n1863#2:131\n1368#2:132\n1454#2,5:133\n1864#2:138\n*S KotlinDebug\n*F\n+ 1 BuiltInsSerializer.kt\norg/jetbrains/kotlin/serialization/builtins/BuiltInsSerializer\n*L\n102#1:127\n102#1:128,3\n102#1:131\n106#1:132\n106#1:133,5\n102#1:138\n*E\n"})
public final class BuiltInsSerializer
extends MetadataSerializer {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public BuiltInsSerializer(@NotNull CompilerConfiguration configuration2, @NotNull KotlinCoreEnvironment environment, boolean dependOnOldBuiltIns) {
        Intrinsics.checkNotNullParameter((Object)configuration2, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        super(configuration2, environment, dependOnOldBuiltIns, BuiltInsBinaryVersion.INSTANCE);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void serialize(@NotNull CommonAnalysisResult analysisResult, @NotNull File destDir) {
        Iterable it;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)analysisResult, (String)"analysisResult");
        Intrinsics.checkNotNullParameter((Object)destDir, (String)"destDir");
        List<KtFile> files2 = this.getEnvironment().getSourceFiles();
        ModuleDescriptor module2 = analysisResult.getModuleDescriptor();
        FilesKt.deleteRecursively((File)destDir);
        if (!destDir.mkdirs()) {
            throw new AssertionError((Object)("Could not make directories: " + destDir));
        }
        Iterable $this$map$iv = files2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            KtFile ktFile = (KtFile)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((KtCommonFile)((Object)it)).getPackageFqName());
        }
        Iterable $this$forEach$iv = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$flatMapTo$iv$iv;
            void $this$flatMap$iv;
            FqName fqName = (FqName)element$iv;
            boolean bl = false;
            PackageViewDescriptor packageView = module2.getPackage(fqName);
            it = packageView.getFragments();
            Collection collection = CollectionsKt.plus((Collection)ResolutionScope.DefaultImpls.getContributedDescriptors$default(packageView.getMemberScope(), DescriptorKindFilter.CLASSIFIERS, null, 2, null), (Object)this.createCloneable(module2));
            MetadataSerializer metadataSerializer = this;
            boolean $i$f$flatMap = false;
            void var16_20 = $this$flatMap$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                PackageFragmentDescriptor fragment = (PackageFragmentDescriptor)element$iv$iv;
                boolean bl2 = false;
                Collection<DeclarationDescriptor> collection2 = DescriptorUtils.getAllDescriptors(fragment.getMemberScope());
                Intrinsics.checkNotNullExpressionValue(collection2, (String)"getAllDescriptors(...)");
                Iterable list$iv$iv = collection2;
                CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
            }
            List list = (List)destination$iv$iv2;
            DefaultConstructorMarker defaultConstructorMarker = null;
            int n = 32;
            Project project = null;
            LanguageVersionSettings languageVersionSettings = CommonConfigurationKeysKt.getLanguageVersionSettings(this.getEnvironment().getConfiguration());
            File file2 = new File(destDir, BuiltInSerializerProtocol.INSTANCE.getBuiltInsFilePath(packageView.getFqName()));
            FqName fqName2 = packageView.getFqName();
            Collection collection3 = list;
            Collection collection4 = collection;
            MetadataSerializer metadataSerializer2 = metadataSerializer;
            new MetadataSerializer.PackageSerializer(metadataSerializer2, collection4, collection3, fqName2, file2, languageVersionSettings, project, n, defaultConstructorMarker).run();
        }
    }

    @Override
    @NotNull
    protected KotlinSerializerExtensionBase createSerializerExtension() {
        return new BuiltInsSerializerExtension();
    }

    private final ClassDescriptor createCloneable(ModuleDescriptor module2) {
        StorageManager storageManager = LockBasedStorageManager.NO_LOCKS;
        Intrinsics.checkNotNullExpressionValue((Object)storageManager, (String)"NO_LOCKS");
        JvmBuiltInClassDescriptorFactory factory2 = new JvmBuiltInClassDescriptorFactory(storageManager, module2, (Function1<? super ModuleDescriptor, ? extends DeclarationDescriptor>)((Function1)arg_0 -> BuiltInsSerializer.createCloneable$lambda$3(module2, arg_0)));
        FqName fqName = StandardNames.FqNames.cloneable.toSafe();
        Intrinsics.checkNotNullExpressionValue((Object)fqName, (String)"toSafe(...)");
        ClassDescriptor classDescriptor = factory2.createClass(ClassId.Companion.topLevel(fqName));
        if (classDescriptor == null) {
            throw new IllegalStateException(("Could not create kotlin.Cloneable in " + module2).toString());
        }
        return classDescriptor;
    }

    private static final DeclarationDescriptor createCloneable$lambda$3(ModuleDescriptor $module, ModuleDescriptor it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new EmptyPackageFragmentDescriptor($module, StandardNames.BUILT_INS_PACKAGE_FQ_NAME);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000=\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\b\u0003*\u0001\u0015\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003Jj\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\t2\u0006\u0010\u000b\u001a\u00020\f26\u0010\r\u001a2\u0012\u0013\u0012\u00110\u000f\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0012\u0012\u0013\u0012\u00110\u000f\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0013\u0012\u0004\u0012\u00020\u00050\u000eJ\r\u0010\u0014\u001a\u00020\u0015H\u0002\u00a2\u0006\u0002\u0010\u0016\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/serialization/builtins/BuiltInsSerializer$Companion;", "", "<init>", "()V", "analyzeAndSerialize", "", "destDir", "Ljava/io/File;", "srcDirs", "", "extraClassPath", "dependOnOldBuiltIns", "", "onComplete", "Lkotlin/Function2;", "", "Lkotlin/ParameterName;", "name", "totalSize", "totalFiles", "createMessageCollector", "org/jetbrains/kotlin/serialization/builtins/BuiltInsSerializer$Companion$createMessageCollector$1", "()Lorg/jetbrains/kotlin/serialization/builtins/BuiltInsSerializer$Companion$createMessageCollector$1;", "cli"})
    @SourceDebugExtension(value={"SMAP\nBuiltInsSerializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BuiltInsSerializer.kt\norg/jetbrains/kotlin/serialization/builtins/BuiltInsSerializer$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,126:1\n1557#2:127\n1628#2,3:128\n*S KotlinDebug\n*F\n+ 1 BuiltInsSerializer.kt\norg/jetbrains/kotlin/serialization/builtins/BuiltInsSerializer$Companion\n*L\n57#1:127\n57#1:128,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        public final void analyzeAndSerialize(@NotNull File destDir, @NotNull List<? extends File> srcDirs, @NotNull List<? extends File> extraClassPath, boolean dependOnOldBuiltIns, @NotNull Function2<? super Integer, ? super Integer, Unit> onComplete) {
            Intrinsics.checkNotNullParameter((Object)destDir, (String)"destDir");
            Intrinsics.checkNotNullParameter(srcDirs, (String)"srcDirs");
            Intrinsics.checkNotNullParameter(extraClassPath, (String)"extraClassPath");
            Intrinsics.checkNotNullParameter(onComplete, (String)"onComplete");
            Disposable disposable = Disposer.newDisposable((String)("Disposable for " + Reflection.getOrCreateKotlinClass(BuiltInsSerializer.class).getSimpleName() + ".analyzeAndSerialize"));
            Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable(...)");
            Disposable rootDisposable = disposable;
            createMessageCollector.1 messageCollector2 = this.createMessageCollector();
            CommonCompilerPerformanceManager performanceManager2 = new CommonCompilerPerformanceManager(){};
            try {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                CompilerConfiguration compilerConfiguration;
                CompilerConfiguration $this$analyzeAndSerialize_u24lambda_u241 = compilerConfiguration = new CompilerConfiguration();
                boolean bl = false;
                CommonConfigurationKeysKt.setMessageCollector($this$analyzeAndSerialize_u24lambda_u241, messageCollector2);
                Iterable iterable = srcDirs;
                CompilerConfiguration compilerConfiguration2 = $this$analyzeAndSerialize_u24lambda_u241;
                boolean $i$f$map = false;
                void var16_15 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    File file2 = (File)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl2 = false;
                    collection.add(it.getPath());
                }
                ContentRootsKt.addKotlinSourceRoots(compilerConfiguration2, (List)destination$iv$iv);
                JvmContentRootsKt.addJvmClasspathRoots($this$analyzeAndSerialize_u24lambda_u241, extraClassPath);
                JvmContentRootsKt.configureJdkClasspathRoots($this$analyzeAndSerialize_u24lambda_u241);
                $this$analyzeAndSerialize_u24lambda_u241.put(CLIConfigurationKeys.METADATA_DESTINATION_DIRECTORY, destDir);
                $this$analyzeAndSerialize_u24lambda_u241.put(CommonConfigurationKeys.MODULE_NAME, "module for built-ins serialization");
                $this$analyzeAndSerialize_u24lambda_u241.put(CLIConfigurationKeys.PERF_MANAGER, performanceManager2);
                CompilerConfiguration configuration2 = compilerConfiguration;
                KotlinCoreEnvironment environment = KotlinCoreEnvironment.Companion.createForProduction(rootDisposable, configuration2, EnvironmentConfigFiles.JVM_CONFIG_FILES);
                BuiltInsSerializer serializer2 = new BuiltInsSerializer(configuration2, environment, dependOnOldBuiltIns);
                serializer2.analyzeAndSerialize();
                onComplete.invoke((Object)serializer2.getTotalSize(), (Object)serializer2.getTotalFiles());
            }
            finally {
                messageCollector2.flush();
                Disposer.dispose((Disposable)rootDisposable);
            }
        }

        private final createMessageCollector.1 createMessageCollector() {
            PrintingMessageCollector printingMessageCollector = new PrintingMessageCollector(System.err, MessageRenderer.PLAIN_RELATIVE_PATHS, false);
            return new GroupingMessageCollector(printingMessageCollector){

                public void report(CompilerMessageSeverity severity, String message, CompilerMessageSourceLocation location) {
                    Intrinsics.checkNotNullParameter((Object)((Object)severity), (String)"severity");
                    Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                    if (location == null) {
                        super.report(severity, message, location);
                    }
                }
            };
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

