/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.decompiler.konan;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.library.KotlinLibraryVersioning;
import org.jetbrains.kotlin.library.KotlinLibraryVersioningKt;
import org.jetbrains.kotlin.library.metadata.KlibMetadataDeserializationUtilsKt;
import org.jetbrains.kotlin.library.metadata.KlibMetadataProtoBuf;
import org.jetbrains.kotlin.library.metadata.KlibMetadataVersion;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.metadata.deserialization.BinaryVersion;

@Service
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\b\b\u0007\u0018\u0000 !2\u00020\u0001:\u0003\u001f !B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u000f\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0010\u001a\u00020\u0011J\u0010\u0010\u0012\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0013\u001a\u00020\u0011J\u001e\u0010\u0014\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\n\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\u00152\u0006\u0010\u0010\u001a\u00020\u0011J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0017\u001a\u00020\u0011H\u0002J\u0010\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0017\u001a\u00020\u0011H\u0002J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0013\u001a\u00020\u0011H\u0002J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u001e\u001a\u00020\u0011H\u0002R9\u0010\u0004\u001a-\u0012\u000e\u0012\f0\u0006\u00a2\u0006\u0002\b\u0007\u00a2\u0006\u0002\b\b\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\b\u0007\u00a2\u0006\u0002\b\b0\u0005\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R9\u0010\u000b\u001a-\u0012\u000e\u0012\f0\u0006\u00a2\u0006\u0002\b\u0007\u00a2\u0006\u0002\b\b\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\f0\t\u00a2\u0006\u0002\b\u0007\u00a2\u0006\u0002\b\b0\u0005\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R9\u0010\r\u001a-\u0012\u000e\u0012\f0\u0006\u00a2\u0006\u0002\b\u0007\u00a2\u0006\u0002\b\b\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u000e0\t\u00a2\u0006\u0002\b\u0007\u00a2\u0006\u0002\b\b0\u0005\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lorg/jetbrains/kotlin/analysis/decompiler/konan/KlibLoadingMetadataCache;", "", "<init>", "()V", "packageFragmentCache", "Ljava/util/concurrent/ConcurrentMap;", "Lorg/jetbrains/kotlin/analysis/decompiler/konan/KlibLoadingMetadataCache$CacheKey;", "Lkotlin/jvm/internal/EnhancedNullability;", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/kotlin/analysis/decompiler/konan/KlibLoadingMetadataCache$CacheValue;", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$PackageFragment;", "moduleHeaderCache", "Lorg/jetbrains/kotlin/library/metadata/KlibMetadataProtoBuf$Header;", "libraryMetadataVersionCache", "Lorg/jetbrains/kotlin/library/metadata/KlibMetadataVersion;", "getCachedPackageFragment", "packageFragmentFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "getCachedModuleHeader", "moduleHeaderFile", "getCachedPackageFragmentWithVersion", "Lkotlin/Pair;", "getCachedMetadataVersion", "libraryRoot", "getKlibLibraryRootForPackageFragment", "isMetadataCompatible", "", "computePackageFragment", "computeModuleHeader", "computeLibraryMetadataVersion", "manifestFile", "CacheKey", "CacheValue", "Companion", "decompiler-native"})
@SourceDebugExtension(value={"SMAP\nKlibLoadingMetadataCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KlibLoadingMetadataCache.kt\norg/jetbrains/kotlin/analysis/decompiler/konan/KlibLoadingMetadataCache\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,135:1\n1#2:136\n*E\n"})
public final class KlibLoadingMetadataCache {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ConcurrentMap<CacheKey, CacheValue<ProtoBuf.PackageFragment>> packageFragmentCache;
    @NotNull
    private final ConcurrentMap<CacheKey, CacheValue<KlibMetadataProtoBuf.Header>> moduleHeaderCache;
    @NotNull
    private final ConcurrentMap<CacheKey, CacheValue<KlibMetadataVersion>> libraryMetadataVersionCache;

    public KlibLoadingMetadataCache() {
        ConcurrentMap concurrentMap = ContainerUtil.createConcurrentWeakValueMap();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap, (String)"createConcurrentWeakValueMap(...)");
        this.packageFragmentCache = concurrentMap;
        ConcurrentMap concurrentMap2 = ContainerUtil.createConcurrentWeakValueMap();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap2, (String)"createConcurrentWeakValueMap(...)");
        this.moduleHeaderCache = concurrentMap2;
        ConcurrentMap concurrentMap3 = ContainerUtil.createConcurrentWeakValueMap();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap3, (String)"createConcurrentWeakValueMap(...)");
        this.libraryMetadataVersionCache = concurrentMap3;
    }

    @Nullable
    public final ProtoBuf.PackageFragment getCachedPackageFragment(@NotNull VirtualFile packageFragmentFile) {
        Intrinsics.checkNotNullParameter((Object)packageFragmentFile, (String)"packageFragmentFile");
        if (!Intrinsics.areEqual((Object)packageFragmentFile.getExtension(), (Object)"knm")) {
            boolean bl = false;
            String string2 = "Not a package metadata file: " + packageFragmentFile;
            throw new IllegalStateException(string2.toString());
        }
        return (ProtoBuf.PackageFragment)this.packageFragmentCache.computeIfAbsent(new CacheKey(packageFragmentFile), arg_0 -> KlibLoadingMetadataCache.getCachedPackageFragment$lambda$2(arg_0 -> KlibLoadingMetadataCache.getCachedPackageFragment$lambda$1(this, packageFragmentFile, arg_0), arg_0)).getValue();
    }

    @Nullable
    public final KlibMetadataProtoBuf.Header getCachedModuleHeader(@NotNull VirtualFile moduleHeaderFile) {
        Intrinsics.checkNotNullParameter((Object)moduleHeaderFile, (String)"moduleHeaderFile");
        if (!Intrinsics.areEqual((Object)moduleHeaderFile.getName(), (Object)"module")) {
            boolean bl = false;
            String string2 = "Not a module header file: " + moduleHeaderFile;
            throw new IllegalStateException(string2.toString());
        }
        return (KlibMetadataProtoBuf.Header)this.moduleHeaderCache.computeIfAbsent(new CacheKey(moduleHeaderFile), arg_0 -> KlibLoadingMetadataCache.getCachedModuleHeader$lambda$5(arg_0 -> KlibLoadingMetadataCache.getCachedModuleHeader$lambda$4(this, moduleHeaderFile, arg_0), arg_0)).getValue();
    }

    @NotNull
    public final Pair<ProtoBuf.PackageFragment, KlibMetadataVersion> getCachedPackageFragmentWithVersion(@NotNull VirtualFile packageFragmentFile) {
        Intrinsics.checkNotNullParameter((Object)packageFragmentFile, (String)"packageFragmentFile");
        ProtoBuf.PackageFragment packageFragment = this.getCachedPackageFragment(packageFragmentFile);
        if (packageFragment == null) {
            return TuplesKt.to(null, null);
        }
        ProtoBuf.PackageFragment packageFragment2 = packageFragment;
        KlibMetadataVersion version2 = this.getCachedMetadataVersion(this.getKlibLibraryRootForPackageFragment(packageFragmentFile));
        return TuplesKt.to((Object)packageFragment2, (Object)version2);
    }

    private final KlibMetadataVersion getCachedMetadataVersion(VirtualFile libraryRoot) {
        VirtualFile virtualFile = libraryRoot.findChild("manifest");
        if (virtualFile == null) {
            return null;
        }
        VirtualFile manifestFile2 = virtualFile;
        KlibMetadataVersion metadataVersion = (KlibMetadataVersion)this.libraryMetadataVersionCache.computeIfAbsent(new CacheKey(manifestFile2), arg_0 -> KlibLoadingMetadataCache.getCachedMetadataVersion$lambda$7(arg_0 -> KlibLoadingMetadataCache.getCachedMetadataVersion$lambda$6(this, manifestFile2, arg_0), arg_0)).getValue();
        return metadataVersion;
    }

    private final VirtualFile getKlibLibraryRootForPackageFragment(VirtualFile packageFragmentFile) {
        VirtualFile virtualFile = packageFragmentFile.getParent().getParent().getParent();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getParent(...)");
        return virtualFile;
    }

    private final boolean isMetadataCompatible(VirtualFile libraryRoot) {
        KlibMetadataVersion klibMetadataVersion = this.getCachedMetadataVersion(libraryRoot);
        if (klibMetadataVersion == null) {
            return false;
        }
        KlibMetadataVersion metadataVersion = klibMetadataVersion;
        return metadataVersion.isCompatibleWithCurrentCompilerVersion();
    }

    private final ProtoBuf.PackageFragment computePackageFragment(VirtualFile packageFragmentFile) {
        ProtoBuf.PackageFragment packageFragment;
        if (!this.isMetadataCompatible(this.getKlibLibraryRootForPackageFragment(packageFragmentFile))) {
            return null;
        }
        try {
            byte[] byArray = packageFragmentFile.contentsToByteArray(false);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"contentsToByteArray(...)");
            packageFragment = KlibMetadataDeserializationUtilsKt.parsePackageFragment(byArray);
        }
        catch (IOException iOException) {
            packageFragment = null;
        }
        return packageFragment;
    }

    private final KlibMetadataProtoBuf.Header computeModuleHeader(VirtualFile moduleHeaderFile) {
        KlibMetadataProtoBuf.Header header;
        VirtualFile virtualFile = moduleHeaderFile.getParent().getParent();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getParent(...)");
        if (!this.isMetadataCompatible(virtualFile)) {
            return null;
        }
        try {
            byte[] byArray = moduleHeaderFile.contentsToByteArray(false);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"contentsToByteArray(...)");
            header = KlibMetadataDeserializationUtilsKt.parseModuleHeader(byArray);
        }
        catch (IOException iOException) {
            header = null;
        }
        return header;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final KlibMetadataVersion computeLibraryMetadataVersion(VirtualFile manifestFile2) {
        try {
            Properties properties2;
            Properties $this$computeLibraryMetadataVersion_u24lambda_u249 = properties2 = new Properties();
            boolean bl = false;
            Object object = manifestFile2.getInputStream();
            Throwable throwable = null;
            try {
                InputStream it = (InputStream)object;
                boolean bl2 = false;
                $this$computeLibraryMetadataVersion_u24lambda_u249.load(it);
                it = Unit.INSTANCE;
            }
            catch (Throwable it) {
                throwable = it;
                throw it;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
            KotlinLibraryVersioning versioning = KotlinLibraryVersioningKt.readKonanLibraryVersioning(properties2);
            String string2 = versioning.getMetadataVersion();
            Object object2 = string2;
            if (string2 == null) return null;
            String string3 = object2;
            object = BinaryVersion.Companion;
            String p0 = string3;
            boolean bl3 = false;
            int[] nArray = ((BinaryVersion.Companion)object).parseVersionArray(p0);
            object2 = nArray;
            if (nArray == null) return null;
            Object p02 = object2;
            boolean bl4 = false;
            KlibMetadataVersion klibMetadataVersion = new KlibMetadataVersion((int[])p02);
            return klibMetadataVersion;
        }
        catch (IOException iOException) {
            return null;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    private static final CacheValue getCachedPackageFragment$lambda$1(KlibLoadingMetadataCache this$0, VirtualFile $packageFragmentFile, CacheKey it) {
        return new CacheValue<ProtoBuf.PackageFragment>(this$0.computePackageFragment($packageFragmentFile));
    }

    private static final CacheValue getCachedPackageFragment$lambda$2(Function1 $tmp0, Object p0) {
        return (CacheValue)$tmp0.invoke(p0);
    }

    private static final CacheValue getCachedModuleHeader$lambda$4(KlibLoadingMetadataCache this$0, VirtualFile $moduleHeaderFile, CacheKey it) {
        return new CacheValue<KlibMetadataProtoBuf.Header>(this$0.computeModuleHeader($moduleHeaderFile));
    }

    private static final CacheValue getCachedModuleHeader$lambda$5(Function1 $tmp0, Object p0) {
        return (CacheValue)$tmp0.invoke(p0);
    }

    private static final CacheValue getCachedMetadataVersion$lambda$6(KlibLoadingMetadataCache this$0, VirtualFile $manifestFile, CacheKey it) {
        return new CacheValue<KlibMetadataVersion>(this$0.computeLibraryMetadataVersion($manifestFile));
    }

    private static final CacheValue getCachedMetadataVersion$lambda$7(Function1 $tmp0, Object p0) {
        return (CacheValue)$tmp0.invoke(p0);
    }

    @JvmStatic
    @NotNull
    public static final KlibLoadingMetadataCache getInstance() {
        return Companion.getInstance();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0011\b\u0016\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\u0006\u0010\nJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/analysis/decompiler/konan/KlibLoadingMetadataCache$CacheKey;", "", "url", "", "modificationStamp", "", "<init>", "(Ljava/lang/String;J)V", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "(Lcom/intellij/openapi/vfs/VirtualFile;)V", "getUrl", "()Ljava/lang/String;", "getModificationStamp", "()J", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "decompiler-native"})
    private static final class CacheKey {
        @NotNull
        private final String url;
        private final long modificationStamp;

        public CacheKey(@NotNull String url, long modificationStamp) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            this.url = url;
            this.modificationStamp = modificationStamp;
        }

        @NotNull
        public final String getUrl() {
            return this.url;
        }

        public final long getModificationStamp() {
            return this.modificationStamp;
        }

        public CacheKey(@NotNull VirtualFile virtualFile) {
            Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
            String string2 = virtualFile.getUrl();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getUrl(...)");
            this(string2, virtualFile.getModificationStamp());
        }

        @NotNull
        public final String component1() {
            return this.url;
        }

        public final long component2() {
            return this.modificationStamp;
        }

        @NotNull
        public final CacheKey copy(@NotNull String url, long modificationStamp) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            return new CacheKey(url, modificationStamp);
        }

        public static /* synthetic */ CacheKey copy$default(CacheKey cacheKey, String string2, long l, int n, Object object) {
            if ((n & 1) != 0) {
                string2 = cacheKey.url;
            }
            if ((n & 2) != 0) {
                l = cacheKey.modificationStamp;
            }
            return cacheKey.copy(string2, l);
        }

        @NotNull
        public String toString() {
            return "CacheKey(url=" + this.url + ", modificationStamp=" + this.modificationStamp + ')';
        }

        public int hashCode() {
            int result2 = this.url.hashCode();
            result2 = result2 * 31 + Long.hashCode(this.modificationStamp);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CacheKey)) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)other;
            if (!Intrinsics.areEqual((Object)this.url, (Object)cacheKey.url)) {
                return false;
            }
            return this.modificationStamp == cacheKey.modificationStamp;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0007\b\u0002\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0002B\u0011\u0012\b\u0010\u0003\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0015\u0010\u0003\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\n\n\u0002\u0010\b\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/analysis/decompiler/konan/KlibLoadingMetadataCache$CacheValue;", "T", "", "value", "<init>", "(Ljava/lang/Object;)V", "getValue", "()Ljava/lang/Object;", "Ljava/lang/Object;", "decompiler-native"})
    private static final class CacheValue<T> {
        @Nullable
        private final T value;

        public CacheValue(@Nullable T value2) {
            this.value = value2;
        }

        @Nullable
        public final T getValue() {
            return this.value;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0007\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/analysis/decompiler/konan/KlibLoadingMetadataCache$Companion;", "", "<init>", "()V", "getInstance", "Lorg/jetbrains/kotlin/analysis/decompiler/konan/KlibLoadingMetadataCache;", "decompiler-native"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final KlibLoadingMetadataCache getInstance() {
            Object object = ApplicationManager.getApplication().getService(KlibLoadingMetadataCache.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            return (KlibLoadingMetadataCache)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

