/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.impl.base.util;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.impl.jar.CoreJarFileSystem;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.io.URLUtil;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.impl.base.util.JdkClassFinder;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\fJ0\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\fJ\u001e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0013\u001a\u00020\b2\b\b\u0002\u0010\u000b\u001a\u00020\fJ\u001c\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fJ\u001c\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\b0\u000e2\u0006\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\f\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/analysis/api/impl/base/util/LibraryUtils;", "", "<init>", "()V", "getAllVirtualFilesFromJar", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "jar", "Ljava/nio/file/Path;", "jarFileSystem", "Lcom/intellij/openapi/vfs/impl/jar/CoreJarFileSystem;", "includeRoot", "", "getAllPsiFilesFromJar", "", "Lcom/intellij/psi/PsiFile;", "project", "Lcom/intellij/openapi/project/Project;", "getAllVirtualFilesFromDirectory", "dir", "getAllVirtualFilesFromRoot", "root", "findClassesFromJdkHome", "jdkHome", "isJre", "analysis-api-impl-base"})
@SourceDebugExtension(value={"SMAP\nLibraryUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LibraryUtils.kt\norg/jetbrains/kotlin/analysis/api/impl/base/util/LibraryUtils\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,96:1\n1#2:97\n1#2:108\n1611#3,9:98\n1863#3:107\n1864#3:109\n1620#3:110\n1557#3:111\n1628#3,3:112\n*S KotlinDebug\n*F\n+ 1 LibraryUtils.kt\norg/jetbrains/kotlin/analysis/api/impl/base/util/LibraryUtils\n*L\n48#1:108\n48#1:98,9\n48#1:107\n48#1:109\n48#1:110\n90#1:111\n90#1:112,3\n*E\n"})
public final class LibraryUtils {
    @NotNull
    public static final LibraryUtils INSTANCE = new LibraryUtils();

    private LibraryUtils() {
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public final Collection<VirtualFile> getAllVirtualFilesFromJar(@NotNull Path jar, @NotNull CoreJarFileSystem jarFileSystem, boolean includeRoot) {
        Collection<VirtualFile> collection;
        Intrinsics.checkNotNullParameter((Object)jar, (String)"jar");
        Intrinsics.checkNotNullParameter((Object)jarFileSystem, (String)"jarFileSystem");
        VirtualFile virtualFile = jarFileSystem.refreshAndFindFileByPath(jar + "!/");
        if (virtualFile != null) {
            VirtualFile it = virtualFile;
            boolean bl = false;
            Collection<VirtualFile> collection2 = INSTANCE.getAllVirtualFilesFromRoot(it, includeRoot);
            if (collection2 != null) {
                collection = collection2;
                return collection;
            }
        }
        collection = SetsKt.emptySet();
        return collection;
    }

    public static /* synthetic */ Collection getAllVirtualFilesFromJar$default(LibraryUtils libraryUtils, Path path, CoreJarFileSystem coreJarFileSystem, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            coreJarFileSystem = new CoreJarFileSystem();
        }
        if ((n & 4) != 0) {
            bl = true;
        }
        return libraryUtils.getAllVirtualFilesFromJar(path, coreJarFileSystem, bl);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<PsiFile> getAllPsiFilesFromJar(@NotNull Path jar, @NotNull Project project, @NotNull CoreJarFileSystem jarFileSystem, boolean includeRoot) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        Intrinsics.checkNotNullParameter((Object)jar, (String)"jar");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)jarFileSystem, (String)"jarFileSystem");
        Collection<VirtualFile> virtualFiles = this.getAllVirtualFilesFromJar(jar, jarFileSystem, includeRoot);
        Iterable iterable = virtualFiles;
        boolean $i$f$mapNotNull = false;
        void var8_8 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            PsiFile it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            VirtualFile virtualFile = (VirtualFile)element$iv$iv;
            boolean bl2 = false;
            if (PsiManager.getInstance((Project)project).findFile(virtualFile) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public static /* synthetic */ List getAllPsiFilesFromJar$default(LibraryUtils libraryUtils, Path path, Project project, CoreJarFileSystem coreJarFileSystem, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            coreJarFileSystem = new CoreJarFileSystem();
        }
        if ((n & 8) != 0) {
            bl = true;
        }
        return libraryUtils.getAllPsiFilesFromJar(path, project, coreJarFileSystem, bl);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public final Collection<VirtualFile> getAllVirtualFilesFromDirectory(@NotNull Path dir2, boolean includeRoot) {
        Collection<VirtualFile> collection;
        Intrinsics.checkNotNullParameter((Object)dir2, (String)"dir");
        VirtualFileSystem fs = StandardFileSystems.local();
        VirtualFile virtualFile = fs.findFileByPath(((Object)dir2).toString());
        if (virtualFile != null) {
            VirtualFile it = virtualFile;
            boolean bl = false;
            Collection<VirtualFile> collection2 = INSTANCE.getAllVirtualFilesFromRoot(it, includeRoot);
            if (collection2 != null) {
                collection = collection2;
                return collection;
            }
        }
        collection = SetsKt.emptySet();
        return collection;
    }

    public static /* synthetic */ Collection getAllVirtualFilesFromDirectory$default(LibraryUtils libraryUtils, Path path, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return libraryUtils.getAllVirtualFilesFromDirectory(path, bl);
    }

    @NotNull
    public final Collection<VirtualFile> getAllVirtualFilesFromRoot(@NotNull VirtualFile root, boolean includeRoot) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Set files2 = new LinkedHashSet();
        if (includeRoot) {
            files2.add(root);
        }
        VfsUtilCore.iterateChildrenRecursively((VirtualFile)root, LibraryUtils::getAllVirtualFilesFromRoot$lambda$3, arg_0 -> LibraryUtils.getAllVirtualFilesFromRoot$lambda$4(files2, arg_0));
        return files2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Path> findClassesFromJdkHome(@NotNull Path jdkHome, boolean isJre) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)jdkHome, (String)"jdkHome");
        List<String> list = JdkClassFinder.findClasses(jdkHome, isJre);
        Intrinsics.checkNotNullExpressionValue(list, (String)"findClasses(...)");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void rawPath;
            String string2 = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string3 = URLUtil.extractPath((String)rawPath);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"extractPath(...)");
            String path = StringsKt.removeSuffix((String)StringsKt.removeSuffix((String)string3, (CharSequence)"/"), (CharSequence)"!");
            collection.add(Paths.get(path, new String[0]));
        }
        return (List)destination$iv$iv;
    }

    private static final boolean getAllVirtualFilesFromRoot$lambda$3(VirtualFile it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return true;
    }

    private static final boolean getAllVirtualFilesFromRoot$lambda$4(Set $files, VirtualFile virtualFile) {
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        if (!virtualFile.isDirectory()) {
            $files.add(virtualFile);
        }
        return true;
    }
}

