/*
 * Decompiled with CFR 0.152.
 */
package org.jline.terminal.impl.jna;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import org.jline.terminal.Attributes;
import org.jline.terminal.Size;
import org.jline.terminal.Terminal;
import org.jline.terminal.impl.PosixPtyTerminal;
import org.jline.terminal.impl.PosixSysTerminal;
import org.jline.terminal.impl.jna.JnaNativePty;
import org.jline.terminal.impl.jna.win.JnaWinSysTerminal;
import org.jline.terminal.spi.Pty;
import org.jline.terminal.spi.SystemStream;
import org.jline.terminal.spi.TerminalProvider;
import org.jline.utils.OSUtils;

public class JnaTerminalProvider
implements TerminalProvider {
    @Override
    public String name() {
        return "jna";
    }

    public Pty current(SystemStream systemStream) throws IOException {
        return JnaNativePty.current(this, systemStream);
    }

    public Pty open(Attributes attributes2, Size size) throws IOException {
        return JnaNativePty.open(this, attributes2, size);
    }

    @Override
    public Terminal sysTerminal(String name2, String type2, boolean ansiPassThrough, Charset encoding, boolean nativeSignals, Terminal.SignalHandler signalHandler, boolean paused, SystemStream systemStream) throws IOException {
        if (OSUtils.IS_WINDOWS) {
            return this.winSysTerminal(name2, type2, ansiPassThrough, encoding, nativeSignals, signalHandler, paused, systemStream);
        }
        return this.posixSysTerminal(name2, type2, ansiPassThrough, encoding, nativeSignals, signalHandler, paused, systemStream);
    }

    public Terminal winSysTerminal(String name2, String type2, boolean ansiPassThrough, Charset encoding, boolean nativeSignals, Terminal.SignalHandler signalHandler, boolean paused, SystemStream systemStream) throws IOException {
        return JnaWinSysTerminal.createTerminal(this, systemStream, name2, type2, ansiPassThrough, encoding, nativeSignals, signalHandler, paused);
    }

    public Terminal posixSysTerminal(String name2, String type2, boolean ansiPassThrough, Charset encoding, boolean nativeSignals, Terminal.SignalHandler signalHandler, boolean paused, SystemStream systemStream) throws IOException {
        Pty pty = this.current(systemStream);
        return new PosixSysTerminal(name2, type2, pty, encoding, nativeSignals, signalHandler);
    }

    @Override
    public Terminal newTerminal(String name2, String type2, InputStream in, OutputStream out, Charset encoding, Terminal.SignalHandler signalHandler, boolean paused, Attributes attributes2, Size size) throws IOException {
        Pty pty = this.open(attributes2, size);
        return new PosixPtyTerminal(name2, type2, pty, in, out, encoding, signalHandler, paused);
    }

    @Override
    public boolean isSystemStream(SystemStream stream) {
        try {
            if (OSUtils.IS_WINDOWS) {
                return this.isWindowsSystemStream(stream);
            }
            return this.isPosixSystemStream(stream);
        }
        catch (Throwable t) {
            return false;
        }
    }

    public boolean isWindowsSystemStream(SystemStream stream) {
        return JnaWinSysTerminal.isWindowsSystemStream(stream);
    }

    public boolean isPosixSystemStream(SystemStream stream) {
        return JnaNativePty.isPosixSystemStream(stream);
    }

    @Override
    public String systemStreamName(SystemStream stream) {
        if (OSUtils.IS_WINDOWS) {
            return null;
        }
        return JnaNativePty.posixSystemStreamName(stream);
    }

    @Override
    public int systemStreamWidth(SystemStream stream) {
        int n;
        block8: {
            Pty pty = this.current(stream);
            try {
                n = pty.getSize().getColumns();
                if (pty == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (pty != null) {
                        try {
                            pty.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    return -1;
                }
            }
            pty.close();
        }
        return n;
    }

    public String toString() {
        return "TerminalProvider[" + this.name() + "]";
    }
}

