/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.symbols;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.FirAnnotationContainer;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.expressions.FirAnnotationCall;
import org.jetbrains.kotlin.fir.expressions.FirCall;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.FirLazyDeclarationResolverKt;
import org.jetbrains.kotlin.fir.symbols.SymbolInternals;
import org.jetbrains.kotlin.fir.symbols.impl.FirBackingFieldSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.name.ClassId;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u0014\u0010\u0000\u001a\u00020\u00012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003H\u0007\u001a\u0018\u0010\u0004\u001a\u00020\u0005*\u00020\u00062\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003H\u0002\u001a\u001e\u0010\u0007\u001a\u00020\u0001*\b\u0012\u0004\u0012\u00020\t0\b2\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003H\u0007\u001a\u001e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\b*\u00020\u00062\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003H\u0007\u001a\u001e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\b*\u00020\u00062\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003H\u0007\u001a\u001e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\t0\b*\u00020\u00062\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003H\u0007\u001a\u001e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\b*\u00020\u00062\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003H\u0007\u00a8\u0006\u000f"}, d2={"resolveAnnotationsWithClassIds", "", "anchorElement", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "isDefinitelyEmpty", "", "Lorg/jetbrains/kotlin/fir/FirAnnotationContainer;", "resolveAnnotationsWithArguments", "", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotation;", "resolvedAnnotationClassIds", "Lorg/jetbrains/kotlin/name/ClassId;", "resolvedAnnotationsWithArguments", "resolvedAnnotationsWithClassIds", "resolvedCompilerRequiredAnnotations", "tree"})
@SourceDebugExtension(value={"SMAP\nFirBasedSymbol.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirBasedSymbol.kt\norg/jetbrains/kotlin/fir/symbols/FirBasedSymbolKt\n+ 2 FirExpressionUtil.kt\norg/jetbrains/kotlin/fir/expressions/FirExpressionUtilKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,138:1\n43#2:139\n2632#3,3:140\n1611#3,9:143\n1863#3:152\n1864#3:154\n1620#3:155\n1#4:153\n*S KotlinDebug\n*F\n+ 1 FirBasedSymbol.kt\norg/jetbrains/kotlin/fir/symbols/FirBasedSymbolKt\n*L\n92#1:139\n110#1:140,3\n131#1:143,9\n131#1:152\n131#1:154\n131#1:155\n131#1:153\n*E\n"})
public final class FirBasedSymbolKt {
    @SymbolInternals
    @NotNull
    public static final List<FirAnnotation> resolvedCompilerRequiredAnnotations(@NotNull FirAnnotationContainer $this$resolvedCompilerRequiredAnnotations, @NotNull FirBasedSymbol<?> anchorElement) {
        Intrinsics.checkNotNullParameter((Object)$this$resolvedCompilerRequiredAnnotations, (String)"<this>");
        Intrinsics.checkNotNullParameter(anchorElement, (String)"anchorElement");
        if ($this$resolvedCompilerRequiredAnnotations.getAnnotations().isEmpty()) {
            return CollectionsKt.emptyList();
        }
        FirLazyDeclarationResolverKt.lazyResolveToPhase(anchorElement, FirResolvePhase.COMPILER_REQUIRED_ANNOTATIONS);
        return $this$resolvedCompilerRequiredAnnotations.getAnnotations();
    }

    @SymbolInternals
    @NotNull
    public static final List<FirAnnotation> resolvedAnnotationsWithArguments(@NotNull FirAnnotationContainer $this$resolvedAnnotationsWithArguments, @NotNull FirBasedSymbol<?> anchorElement) {
        Intrinsics.checkNotNullParameter((Object)$this$resolvedAnnotationsWithArguments, (String)"<this>");
        Intrinsics.checkNotNullParameter(anchorElement, (String)"anchorElement");
        if (FirBasedSymbolKt.isDefinitelyEmpty($this$resolvedAnnotationsWithArguments, anchorElement)) {
            return CollectionsKt.emptyList();
        }
        FirBasedSymbolKt.resolveAnnotationsWithArguments($this$resolvedAnnotationsWithArguments.getAnnotations(), anchorElement);
        return $this$resolvedAnnotationsWithArguments.getAnnotations();
    }

    @SymbolInternals
    public static final void resolveAnnotationsWithArguments(@NotNull List<? extends FirAnnotation> $this$resolveAnnotationsWithArguments, @NotNull FirBasedSymbol<?> anchorElement) {
        Intrinsics.checkNotNullParameter($this$resolveAnnotationsWithArguments, (String)"<this>");
        Intrinsics.checkNotNullParameter(anchorElement, (String)"anchorElement");
        boolean hasAnnotationCallWithArguments = false;
        int n = ((Collection)$this$resolveAnnotationsWithArguments).size();
        for (int i2 = 0; i2 < n; ++i2) {
            FirAnnotation currentAnnotation = $this$resolveAnnotationsWithArguments.get(i2);
            if (!(currentAnnotation instanceof FirAnnotationCall)) continue;
            FirCall $this$arguments$iv = (FirCall)((Object)currentAnnotation);
            boolean $i$f$getArguments = false;
            if (!(!((Collection)$this$arguments$iv.getArgumentList().getArguments()).isEmpty())) continue;
            hasAnnotationCallWithArguments = true;
            break;
        }
        FirResolvePhase phase = hasAnnotationCallWithArguments ? FirResolvePhase.ANNOTATION_ARGUMENTS : FirResolvePhase.TYPES;
        FirLazyDeclarationResolverKt.lazyResolveToPhase(anchorElement, phase);
    }

    private static final boolean isDefinitelyEmpty(FirAnnotationContainer $this$isDefinitelyEmpty, FirBasedSymbol<?> anchorElement) {
        if ($this$isDefinitelyEmpty.getAnnotations().isEmpty()) {
            boolean bl;
            block6: {
                if (!(anchorElement instanceof FirBackingFieldSymbol)) {
                    return true;
                }
                Iterable $this$none$iv = ((FirBackingFieldSymbol)anchorElement).getPropertySymbol().getAnnotations();
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        FirAnnotation it = (FirAnnotation)element$iv;
                        boolean bl2 = false;
                        if (!(it.getUseSiteTarget() == null)) continue;
                        bl = false;
                        break block6;
                    }
                    bl = true;
                }
            }
            if (bl) {
                return true;
            }
        }
        return false;
    }

    @SymbolInternals
    @NotNull
    public static final List<FirAnnotation> resolvedAnnotationsWithClassIds(@NotNull FirAnnotationContainer $this$resolvedAnnotationsWithClassIds, @NotNull FirBasedSymbol<?> anchorElement) {
        Intrinsics.checkNotNullParameter((Object)$this$resolvedAnnotationsWithClassIds, (String)"<this>");
        Intrinsics.checkNotNullParameter(anchorElement, (String)"anchorElement");
        if (FirBasedSymbolKt.isDefinitelyEmpty($this$resolvedAnnotationsWithClassIds, anchorElement)) {
            return CollectionsKt.emptyList();
        }
        FirLazyDeclarationResolverKt.lazyResolveToPhase(anchorElement, FirResolvePhase.TYPES);
        return $this$resolvedAnnotationsWithClassIds.getAnnotations();
    }

    @SymbolInternals
    public static final void resolveAnnotationsWithClassIds(@NotNull FirBasedSymbol<?> anchorElement) {
        Intrinsics.checkNotNullParameter(anchorElement, (String)"anchorElement");
        FirLazyDeclarationResolverKt.lazyResolveToPhase(anchorElement, FirResolvePhase.TYPES);
    }

    /*
     * WARNING - void declaration
     */
    @SymbolInternals
    @NotNull
    public static final List<ClassId> resolvedAnnotationClassIds(@NotNull FirAnnotationContainer $this$resolvedAnnotationClassIds, @NotNull FirBasedSymbol<?> anchorElement) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$resolvedAnnotationClassIds, (String)"<this>");
        Intrinsics.checkNotNullParameter(anchorElement, (String)"anchorElement");
        Iterable $this$mapNotNull$iv = FirBasedSymbolKt.resolvedAnnotationsWithClassIds($this$resolvedAnnotationClassIds, anchorElement);
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            ClassId it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            FirAnnotation it = (FirAnnotation)element$iv$iv;
            boolean bl2 = false;
            ConeKotlinType coneKotlinType = FirTypeUtilsKt.getConeType(it.getAnnotationTypeRef());
            Object object = coneKotlinType instanceof ConeClassLikeType ? (ConeClassLikeType)coneKotlinType : null;
            if ((object != null && (object = ((ConeClassLikeType)object).getLookupTag()) != null ? ((ConeClassLikeLookupTag)object).getClassId() : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }
}

