/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.serialization.constant;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.constant.AnnotationValue;
import org.jetbrains.kotlin.constant.ArrayValue;
import org.jetbrains.kotlin.constant.BooleanValue;
import org.jetbrains.kotlin.constant.ByteValue;
import org.jetbrains.kotlin.constant.CharValue;
import org.jetbrains.kotlin.constant.ConstantValue;
import org.jetbrains.kotlin.constant.DoubleValue;
import org.jetbrains.kotlin.constant.EnumValue;
import org.jetbrains.kotlin.constant.FloatValue;
import org.jetbrains.kotlin.constant.IntValue;
import org.jetbrains.kotlin.constant.LongValue;
import org.jetbrains.kotlin.constant.NullValue;
import org.jetbrains.kotlin.constant.ShortValue;
import org.jetbrains.kotlin.constant.StringValue;
import org.jetbrains.kotlin.constant.UByteValue;
import org.jetbrains.kotlin.constant.UIntValue;
import org.jetbrains.kotlin.constant.ULongValue;
import org.jetbrains.kotlin.constant.UShortValue;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirEvaluatorResult;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.expressions.FirAnnotationCall;
import org.jetbrains.kotlin.fir.expressions.FirArgumentList;
import org.jetbrains.kotlin.fir.expressions.FirArrayLiteral;
import org.jetbrains.kotlin.fir.expressions.FirCall;
import org.jetbrains.kotlin.fir.expressions.FirEnumEntryDeserializedAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpressionEvaluator;
import org.jetbrains.kotlin.fir.expressions.FirExpressionUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirGetClassCall;
import org.jetbrains.kotlin.fir.expressions.FirLiteralExpression;
import org.jetbrains.kotlin.fir.expressions.FirPropertyAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirVarargArgumentsExpression;
import org.jetbrains.kotlin.fir.expressions.FirWrappedArgumentExpression;
import org.jetbrains.kotlin.fir.expressions.ReferenceUtilsKt;
import org.jetbrains.kotlin.fir.expressions.builder.FirAnnotationCallBuilder;
import org.jetbrains.kotlin.fir.expressions.impl.FirAnnotationArgumentMappingImplKt;
import org.jetbrains.kotlin.fir.expressions.impl.FirResolvedArgumentList;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.resolve.ScopeUtilsKt;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.resolve.transformers.body.resolve.FirArrayOfCallTransformer;
import org.jetbrains.kotlin.fir.scopes.CallableCopyTypeCalculator;
import org.jetbrains.kotlin.fir.scopes.FirScope;
import org.jetbrains.kotlin.fir.scopes.FirScopeKt;
import org.jetbrains.kotlin.fir.serialization.constant.ConstValueProvider;
import org.jetbrains.kotlin.fir.serialization.constant.ConstantValueUtilsKt;
import org.jetbrains.kotlin.fir.serialization.constant.FirToConstantValueTransformerData;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirEnumEntrySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirErrorFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirValueParameterSymbol;
import org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirTypeProjection;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import org.jetbrains.kotlin.fir.utils.exceptions.FirExceptionUtilsKt;
import org.jetbrains.kotlin.fir.visitors.FirDefaultVisitor;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.types.ConstantValueKind;
import org.jetbrains.kotlin.util.PrivateForInline;
import org.jetbrains.kotlin.utils.exceptions.ExceptionAttachmentBuilder;
import org.jetbrains.kotlin.utils.exceptions.KotlinExceptionWithAttachments;
import org.jetbrains.kotlin.utils.exceptions.KotlinIllegalArgumentExceptionWithAttachments;

@PrivateForInline
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c1\u0002\u0018\u00002\u0014\u0012\n\u0012\b\u0012\u0002\b\u0003\u0018\u00010\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00022\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u001c\u0010\t\u001a\u0006\u0012\u0002\b\u00030\u00022\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u001c\u0010\f\u001a\u0006\u0012\u0002\b\u00030\u00022\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u001e\u0010\u000f\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u001c\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u00022\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u001e\u0010\u0015\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u001e\u0010\u0018\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\b\u001a\u00020\u0003H\u0016J*\u0010\u001b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0002\"\u0004\b\u0000\u0010\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u0002H\u001c0\u001e2\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u001e\u0010\u001f\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\u0006\u0010 \u001a\u00020!2\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u001e\u0010\"\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\u0006\u0010#\u001a\u00020$2\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u001c\u0010%\u001a\u0006\u0012\u0002\b\u00030\u00022\u0006\u0010&\u001a\u00020'2\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u001e\u0010(\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\u0006\u0010)\u001a\u00020*2\u0006\u0010\b\u001a\u00020\u0003H\u0016J$\u0010+\u001a\u0012\u0012\u0004\u0012\u00020-\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020,*\u00020\u00072\u0006\u0010\b\u001a\u00020\u0003H\u0002J\u001a\u0010.\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0002*\u00020/2\u0006\u0010\b\u001a\u00020\u0003H\u0002\u00a8\u00060"}, d2={"Lorg/jetbrains/kotlin/fir/serialization/constant/FirToConstantValueTransformer;", "Lorg/jetbrains/kotlin/fir/visitors/FirDefaultVisitor;", "Lorg/jetbrains/kotlin/constant/ConstantValue;", "Lorg/jetbrains/kotlin/fir/serialization/constant/FirToConstantValueTransformerData;", "()V", "visitAnnotation", "annotation", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotation;", "data", "visitAnnotationCall", "annotationCall", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotationCall;", "visitArrayLiteral", "arrayLiteral", "Lorg/jetbrains/kotlin/fir/expressions/FirArrayLiteral;", "visitElement", "element", "Lorg/jetbrains/kotlin/fir/FirElement;", "visitEnumEntryDeserializedAccessExpression", "enumEntryDeserializedAccessExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirEnumEntryDeserializedAccessExpression;", "visitFunctionCall", "functionCall", "Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;", "visitGetClassCall", "getClassCall", "Lorg/jetbrains/kotlin/fir/expressions/FirGetClassCall;", "visitLiteralExpression", "T", "literalExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirLiteralExpression;", "visitPropertyAccessExpression", "propertyAccessExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirPropertyAccessExpression;", "visitQualifiedAccessExpression", "qualifiedAccessExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;", "visitVarargArgumentsExpression", "varargArgumentsExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirVarargArgumentsExpression;", "visitWrappedArgumentExpression", "wrappedArgumentExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirWrappedArgumentExpression;", "convertMapping", "", "Lorg/jetbrains/kotlin/name/Name;", "toConstantValue", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "fir-serialization"})
@SourceDebugExtension(value={"SMAP\nFirToConstantValueTransformer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirToConstantValueTransformer.kt\norg/jetbrains/kotlin/fir/serialization/constant/FirToConstantValueTransformer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 ExceptionAttachmentBuilder.kt\norg/jetbrains/kotlin/utils/exceptions/ExceptionAttachmentBuilderKt\n+ 6 FirAnnotationCallBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirAnnotationCallBuilderKt\n+ 7 FirExpressionUtil.kt\norg/jetbrains/kotlin/fir/expressions/FirExpressionUtilKt\n*L\n1#1,346:1\n1611#2,9:347\n1863#2:356\n1864#2:358\n1620#2:359\n1246#2,4:361\n1611#2,9:392\n1863#2:401\n1864#2:403\n1620#2:404\n1#3:357\n1#3:402\n412#4:360\n81#5,7:365\n76#5,2:372\n57#5:374\n78#5:375\n81#5,7:376\n76#5,2:383\n57#5:385\n78#5:386\n69#6,4:387\n43#7:391\n*S KotlinDebug\n*F\n+ 1 FirToConstantValueTransformer.kt\norg/jetbrains/kotlin/fir/serialization/constant/FirToConstantValueTransformer\n*L\n113#1:347,9\n113#1:356\n113#1:358\n113#1:359\n134#1:361,4\n257#1:392,9\n257#1:401\n257#1:403\n257#1:404\n113#1:357\n257#1:402\n134#1:360\n148#1:365,7\n148#1:372,2\n148#1:374\n148#1:375\n156#1:376,7\n156#1:383,2\n156#1:385\n156#1:386\n205#1:387,4\n254#1:391\n*E\n"})
public final class FirToConstantValueTransformer
extends FirDefaultVisitor<ConstantValue<?>, FirToConstantValueTransformerData> {
    @NotNull
    public static final FirToConstantValueTransformer INSTANCE = new FirToConstantValueTransformer();

    private FirToConstantValueTransformer() {
    }

    private final ConstantValue<?> toConstantValue(FirExpression $this$toConstantValue, FirToConstantValueTransformerData data2) {
        return (ConstantValue)$this$toConstantValue.accept(this, data2);
    }

    @Override
    @Nullable
    public ConstantValue<?> visitElement(@NotNull FirElement element, @NotNull FirToConstantValueTransformerData data2) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        throw new IllegalStateException(("Illegal element as annotation argument: " + Reflection.getOrCreateKotlinClass(element.getClass()).getQualifiedName() + " -> " + UtilsKt.render(element)).toString());
    }

    @Override
    @Nullable
    public <T> ConstantValue<?> visitLiteralExpression(@NotNull FirLiteralExpression<T> literalExpression, @NotNull FirToConstantValueTransformerData data2) {
        ConstantValue constantValue;
        Intrinsics.checkNotNullParameter(literalExpression, (String)"literalExpression");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        T value2 = literalExpression.getValue();
        ConstantValueKind<T> constantValueKind = literalExpression.getKind();
        if (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.Boolean.INSTANCE)) {
            Intrinsics.checkNotNull(value2, (String)"null cannot be cast to non-null type kotlin.Boolean");
            constantValue = new BooleanValue((Boolean)value2);
        } else if (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.Char.INSTANCE)) {
            Intrinsics.checkNotNull(value2, (String)"null cannot be cast to non-null type kotlin.Char");
            constantValue = new CharValue(((Character)value2).charValue());
        } else if (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.Byte.INSTANCE)) {
            Intrinsics.checkNotNull(value2, (String)"null cannot be cast to non-null type kotlin.Number");
            constantValue = new ByteValue(((Number)value2).byteValue());
        } else if (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.UnsignedByte.INSTANCE)) {
            Intrinsics.checkNotNull(value2, (String)"null cannot be cast to non-null type kotlin.Number");
            constantValue = new UByteValue(((Number)value2).byteValue());
        } else if (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.Short.INSTANCE)) {
            Intrinsics.checkNotNull(value2, (String)"null cannot be cast to non-null type kotlin.Number");
            constantValue = new ShortValue(((Number)value2).shortValue());
        } else if (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.UnsignedShort.INSTANCE)) {
            Intrinsics.checkNotNull(value2, (String)"null cannot be cast to non-null type kotlin.Number");
            constantValue = new UShortValue(((Number)value2).shortValue());
        } else if (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.Int.INSTANCE)) {
            Intrinsics.checkNotNull(value2, (String)"null cannot be cast to non-null type kotlin.Number");
            constantValue = new IntValue(((Number)value2).intValue());
        } else if (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.UnsignedInt.INSTANCE)) {
            Intrinsics.checkNotNull(value2, (String)"null cannot be cast to non-null type kotlin.Number");
            constantValue = new UIntValue(((Number)value2).intValue());
        } else if (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.Long.INSTANCE)) {
            Intrinsics.checkNotNull(value2, (String)"null cannot be cast to non-null type kotlin.Number");
            constantValue = new LongValue(((Number)value2).longValue());
        } else if (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.UnsignedLong.INSTANCE)) {
            Intrinsics.checkNotNull(value2, (String)"null cannot be cast to non-null type kotlin.Number");
            constantValue = new ULongValue(((Number)value2).longValue());
        } else if (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.String.INSTANCE)) {
            Intrinsics.checkNotNull(value2, (String)"null cannot be cast to non-null type kotlin.String");
            constantValue = new StringValue((String)value2);
        } else if (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.Float.INSTANCE)) {
            Intrinsics.checkNotNull(value2, (String)"null cannot be cast to non-null type kotlin.Number");
            constantValue = new FloatValue(((Number)value2).floatValue());
        } else if (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.Double.INSTANCE)) {
            Intrinsics.checkNotNull(value2, (String)"null cannot be cast to non-null type kotlin.Number");
            constantValue = new DoubleValue(((Number)value2).doubleValue());
        } else {
            constantValue = Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.Null.INSTANCE) ? (ConstantValue)NullValue.INSTANCE : null;
        }
        return constantValue;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public ConstantValue<?> visitArrayLiteral(@NotNull FirArrayLiteral arrayLiteral, @NotNull FirToConstantValueTransformerData data2) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)arrayLiteral, (String)"arrayLiteral");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        Iterable $this$mapNotNull$iv = arrayLiteral.getArgumentList().getArguments();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            ConstantValue<?> it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            FirExpression it = (FirExpression)element$iv$iv;
            boolean bl2 = false;
            if (INSTANCE.toConstantValue(it, data2) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List list2 = (List)destination$iv$iv;
        return new ArrayValue(list2);
    }

    @Override
    @NotNull
    public ConstantValue<?> visitAnnotation(@NotNull FirAnnotation annotation2, @NotNull FirToConstantValueTransformerData data2) {
        Intrinsics.checkNotNullParameter((Object)annotation2, (String)"annotation");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        Map<Name, ConstantValue<?>> mapping2 = this.convertMapping(annotation2, data2);
        return AnnotationValue.Companion.create(FirTypeUtilsKt.getConeType(annotation2.getAnnotationTypeRef()), mapping2);
    }

    @Override
    @NotNull
    public ConstantValue<?> visitAnnotationCall(@NotNull FirAnnotationCall annotationCall, @NotNull FirToConstantValueTransformerData data2) {
        Intrinsics.checkNotNullParameter((Object)annotationCall, (String)"annotationCall");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        return this.visitAnnotation((FirAnnotation)annotationCall, data2);
    }

    /*
     * WARNING - void declaration
     */
    private final Map<Name, ConstantValue<?>> convertMapping(FirAnnotation $this$convertMapping, FirToConstantValueTransformerData data2) {
        FirConstructorSymbol firConstructorSymbol2;
        Map result2;
        Map map;
        Object object;
        Object argument2;
        Object object2;
        List<FirConstructorSymbol> list2;
        Object object3;
        FirSession session2 = data2.component1();
        ScopeSession scopeSession = data2.component2();
        ConstValueProvider constValueProvider = data2.component3();
        boolean needsFirEvaluation = false;
        if (constValueProvider != null) {
            void destination$iv;
            void $this$mapValuesTo$iv;
            object3 = $this$convertMapping.getArgumentMapping().getMapping();
            list2 = new LinkedHashMap();
            boolean $i$f$mapValuesTo = false;
            Iterable $this$associateByTo$iv$iv = $this$mapValuesTo$iv.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                void it$iv;
                Map.Entry entry = (Map.Entry)element$iv$iv;
                void var16_25 = destination$iv;
                boolean bl = false;
                object2 = (Map.Entry)element$iv$iv;
                Object k = it$iv.getKey();
                void var32_38 = var16_25;
                boolean bl2 = false;
                argument2 = (FirExpression)object2.getValue();
                Object it = object = constValueProvider.findConstantValueFor((FirExpression)argument2);
                boolean bl3 = false;
                if (it == null) {
                    needsFirEvaluation = true;
                }
                Object object4 = object;
                var32_38.put(k, object4);
            }
            map = destination$iv;
        } else {
            needsFirEvaluation = true;
            map = result2 = (Map)new LinkedHashMap();
        }
        if (needsFirEvaluation) {
            Map<Name, FirEvaluatorResult> map2 = FirExpressionEvaluator.INSTANCE.evaluateAnnotationArguments($this$convertMapping, session2);
            if (map2 == null) {
                void $this$buildErrorWithAttachment_u24lambda_u240$iv$iv;
                String message$iv = "Can't compute constant annotation argument mapping";
                Throwable cause$iv = null;
                String attachmentName$iv = "info.txt";
                boolean $i$f$errorWithAttachment = false;
                boolean $i$f$buildErrorWithAttachment = false;
                KotlinIllegalArgumentExceptionWithAttachments exception$iv$iv = new KotlinIllegalArgumentExceptionWithAttachments(message$iv, cause$iv);
                KotlinExceptionWithAttachments $this$buildAttachment$iv$iv$iv = exception$iv$iv;
                boolean $i$f$buildAttachment = false;
                Object bl2 = object2 = new ExceptionAttachmentBuilder();
                argument2 = attachmentName$iv;
                object = $this$buildAttachment$iv$iv$iv;
                boolean bl = false;
                void $this$convertMapping_u24lambda_u243 = $this$buildErrorWithAttachment_u24lambda_u240$iv$iv;
                boolean bl4 = false;
                FirExceptionUtilsKt.withFirEntry((ExceptionAttachmentBuilder)$this$convertMapping_u24lambda_u243, "annotation", $this$convertMapping);
                object.withAttachment((String)argument2, ((ExceptionAttachmentBuilder)object2).buildString());
                throw (Throwable)exception$iv$iv;
            }
            Map<Name, FirEvaluatorResult> mappingFromFrontend = map2;
            list2 = $this$convertMapping.getArgumentMapping().getMapping().keySet().iterator();
            while (list2.hasNext()) {
                Name name2 = (Name)list2.next();
                if (result2.get(name2) != null) continue;
                if (mappingFromFrontend.get(name2) != null) {
                    ConstantValue constantValue;
                    FirEvaluatorResult it;
                    boolean bl = false;
                    Object object5 = it instanceof FirEvaluatorResult.Evaluated ? (FirEvaluatorResult.Evaluated)it : null;
                    if (object5 == null || (object5 = ((FirEvaluatorResult.Evaluated)object5).getResult()) == null) continue;
                    Object evaluatedValue = object5;
                    if ((ConstantValue)evaluatedValue.accept(this, data2) == null) {
                        void $this$buildErrorWithAttachment_u24lambda_u240$iv$iv;
                        ExceptionAttachmentBuilder exceptionAttachmentBuilder;
                        String message$iv = "Cannot convert value for parameter \"" + name2 + "\" to constant";
                        Throwable cause$iv = null;
                        String attachmentName$iv = "info.txt";
                        boolean $i$f$errorWithAttachment = false;
                        boolean $i$f$buildErrorWithAttachment = false;
                        KotlinIllegalArgumentExceptionWithAttachments exception$iv$iv = new KotlinIllegalArgumentExceptionWithAttachments(message$iv, cause$iv);
                        KotlinExceptionWithAttachments $this$buildAttachment$iv$iv$iv = exception$iv$iv;
                        boolean $i$f$buildAttachment = false;
                        ExceptionAttachmentBuilder exceptionAttachmentBuilder2 = exceptionAttachmentBuilder = new ExceptionAttachmentBuilder();
                        String string2 = attachmentName$iv;
                        KotlinExceptionWithAttachments kotlinExceptionWithAttachments = $this$buildAttachment$iv$iv$iv;
                        boolean bl5 = false;
                        void $this$convertMapping_u24lambda_u245_u24lambda_u244 = $this$buildErrorWithAttachment_u24lambda_u240$iv$iv;
                        boolean bl6 = false;
                        FirExpression firExpression2 = $this$convertMapping.getArgumentMapping().getMapping().get(name2);
                        Intrinsics.checkNotNull((Object)firExpression2);
                        FirExceptionUtilsKt.withFirEntry((ExceptionAttachmentBuilder)$this$convertMapping_u24lambda_u245_u24lambda_u244, "argument", firExpression2);
                        FirExceptionUtilsKt.withFirEntry((ExceptionAttachmentBuilder)$this$convertMapping_u24lambda_u245_u24lambda_u244, "annotation", $this$convertMapping);
                        kotlinExceptionWithAttachments.withAttachment(string2, exceptionAttachmentBuilder.buildString());
                        throw (Throwable)exception$iv$iv;
                    }
                    result2.put(name2, constantValue);
                }
            }
        }
        if ((object3 = ScopeUtilsKt.scope(FirTypeUtilsKt.getResolvedType($this$convertMapping), session2, scopeSession, CallableCopyTypeCalculator.Forced.INSTANCE, FirResolvePhase.TYPES)) != null && (list2 = FirScopeKt.getDeclaredConstructors((FirScope)object3)) != null && (firConstructorSymbol2 = (FirConstructorSymbol)CollectionsKt.firstOrNull(list2)) != null) {
            FirConstructorSymbol it = firConstructorSymbol2;
            boolean bl = false;
            for (FirValueParameterSymbol parameterSymbol : it.getValueParameterSymbols()) {
                if (result2.get(parameterSymbol.getName()) != null || !ConeBuiltinTypeUtilsKt.isArrayType(TypeExpansionUtilsKt.fullyExpandedType(FirTypeUtilsKt.getConeType(parameterSymbol.getResolvedReturnTypeRef()), session2))) continue;
                result2.put(parameterSymbol.getName(), new ArrayValue(CollectionsKt.emptyList()));
            }
        }
        return result2;
    }

    @Override
    @Nullable
    public ConstantValue<?> visitGetClassCall(@NotNull FirGetClassCall getClassCall, @NotNull FirToConstantValueTransformerData data2) {
        Intrinsics.checkNotNullParameter((Object)getClassCall, (String)"getClassCall");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        return ConstantValueUtilsKt.create(FirTypeUtilsKt.getResolvedType(getClassCall.getArgument()));
    }

    @Override
    @Nullable
    public ConstantValue<?> visitQualifiedAccessExpression(@NotNull FirQualifiedAccessExpression qualifiedAccessExpression, @NotNull FirToConstantValueTransformerData data2) {
        ConstantValue<?> constantValue;
        Intrinsics.checkNotNullParameter((Object)qualifiedAccessExpression, (String)"qualifiedAccessExpression");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        FirCallableSymbol<?> symbol2 = ReferenceUtilsKt.toResolvedCallableSymbol(qualifiedAccessExpression);
        if (symbol2 instanceof FirEnumEntrySymbol) {
            ClassId classId = symbol2.getCallableId().getClassId();
            if (classId == null) {
                return null;
            }
            ClassId classId2 = classId;
            constantValue = new EnumValue(classId2, symbol2.getName());
        } else if (symbol2 instanceof FirConstructorSymbol) {
            FirAnnotationCallBuilder firAnnotationCallBuilder;
            FirFunctionCall constructorCall = (FirFunctionCall)qualifiedAccessExpression;
            Object object = ClassMembersKt.containingClassLookupTag(symbol2);
            if (object == null || (object = LookupTagUtilsKt.toFirRegularClassSymbol((ConeClassLikeLookupTag)object, data2.getSession())) == null) {
                return null;
            }
            Object constructedClassSymbol = object;
            if (((FirClassSymbol)constructedClassSymbol).getClassKind() != ClassKind.ANNOTATION_CLASS) {
                return null;
            }
            boolean $i$f$buildAnnotationCall = false;
            FirAnnotationCallBuilder $this$visitQualifiedAccessExpression_u24lambda_u247 = firAnnotationCallBuilder = new FirAnnotationCallBuilder();
            boolean bl = false;
            $this$visitQualifiedAccessExpression_u24lambda_u247.setSource(constructorCall.getSource());
            $this$visitQualifiedAccessExpression_u24lambda_u247.setAnnotationTypeRef(TypeUtilsKt.toFirResolvedTypeRef$default(FirTypeUtilsKt.getResolvedType(constructorCall), null, null, 3, null));
            $this$visitQualifiedAccessExpression_u24lambda_u247.getTypeArguments().addAll((Collection<FirTypeProjection>)constructorCall.getTypeArguments());
            $this$visitQualifiedAccessExpression_u24lambda_u247.setArgumentList(constructorCall.getArgumentList());
            FirArgumentList firArgumentList = $this$visitQualifiedAccessExpression_u24lambda_u247.getArgumentList();
            Intrinsics.checkNotNull((Object)firArgumentList, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.impl.FirResolvedArgumentList");
            $this$visitQualifiedAccessExpression_u24lambda_u247.setArgumentMapping(FirAnnotationArgumentMappingImplKt.toAnnotationArgumentMapping((FirResolvedArgumentList)firArgumentList));
            $this$visitQualifiedAccessExpression_u24lambda_u247.setCalleeReference(constructorCall.getCalleeReference());
            $this$visitQualifiedAccessExpression_u24lambda_u247.setContainingDeclarationSymbol(new FirErrorFunctionSymbol());
            FirAnnotationCall annotationCall = firAnnotationCallBuilder.build();
            constantValue = this.visitAnnotationCall(annotationCall, data2);
        } else {
            constantValue = null;
        }
        return constantValue;
    }

    @Override
    @Nullable
    public ConstantValue<?> visitPropertyAccessExpression(@NotNull FirPropertyAccessExpression propertyAccessExpression, @NotNull FirToConstantValueTransformerData data2) {
        Intrinsics.checkNotNullParameter((Object)propertyAccessExpression, (String)"propertyAccessExpression");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        return this.visitQualifiedAccessExpression((FirQualifiedAccessExpression)propertyAccessExpression, data2);
    }

    @Override
    @NotNull
    public ConstantValue<?> visitEnumEntryDeserializedAccessExpression(@NotNull FirEnumEntryDeserializedAccessExpression enumEntryDeserializedAccessExpression, @NotNull FirToConstantValueTransformerData data2) {
        Intrinsics.checkNotNullParameter((Object)enumEntryDeserializedAccessExpression, (String)"enumEntryDeserializedAccessExpression");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        return new EnumValue(enumEntryDeserializedAccessExpression.getEnumClassId(), enumEntryDeserializedAccessExpression.getEnumEntryName());
    }

    @Override
    @Nullable
    public ConstantValue<?> visitFunctionCall(@NotNull FirFunctionCall functionCall, @NotNull FirToConstantValueTransformerData data2) {
        Intrinsics.checkNotNullParameter((Object)functionCall, (String)"functionCall");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        if (FirArrayOfCallTransformer.Companion.isArrayOfCall(functionCall, data2.getSession())) {
            return (ConstantValue)new FirArrayOfCallTransformer().transformFunctionCall(functionCall, data2.getSession()).accept(this, data2);
        }
        return this.visitQualifiedAccessExpression((FirQualifiedAccessExpression)functionCall, data2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public ConstantValue<?> visitVarargArgumentsExpression(@NotNull FirVarargArgumentsExpression varargArgumentsExpression, @NotNull FirToConstantValueTransformerData data2) {
        void $this$mapNotNullTo$iv$iv;
        List<FirExpression> list2;
        block4: {
            List<FirExpression> it;
            block3: {
                Intrinsics.checkNotNullParameter((Object)varargArgumentsExpression, (String)"varargArgumentsExpression");
                Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
                it = varargArgumentsExpression.getArguments();
                boolean bl = false;
                FirExpression firExpression2 = (FirExpression)CollectionsKt.singleOrNull(it);
                FirExpression firExpression3 = firExpression2 != null ? FirExpressionUtilKt.unwrapArgument(firExpression2) : null;
                list2 = firExpression3 instanceof FirArrayLiteral ? (FirArrayLiteral)firExpression3 : null;
                if (list2 == null) break block3;
                FirCall $this$arguments$iv = (FirCall)((Object)list2);
                boolean $i$f$getArguments = false;
                list2 = $this$arguments$iv.getArgumentList().getArguments();
                if (list2 != null) break block4;
            }
            list2 = it;
        }
        List<FirExpression> arguments2 = list2;
        Iterable $this$mapNotNull$iv = arguments2;
        boolean $i$f$mapNotNull = false;
        Iterable bl = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            ConstantValue<?> it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl2 = false;
            FirExpression it = (FirExpression)element$iv$iv;
            boolean bl3 = false;
            if (INSTANCE.toConstantValue(it, data2) == null) continue;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List list3 = (List)destination$iv$iv;
        return new ArrayValue(list3);
    }

    @Override
    @Nullable
    public ConstantValue<?> visitWrappedArgumentExpression(@NotNull FirWrappedArgumentExpression wrappedArgumentExpression, @NotNull FirToConstantValueTransformerData data2) {
        Intrinsics.checkNotNullParameter((Object)wrappedArgumentExpression, (String)"wrappedArgumentExpression");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        return this.toConstantValue(wrappedArgumentExpression.getExpression(), data2);
    }
}

