/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.calls;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.fir.FirLanguageSettingsComponentKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameter;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameterRef;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameterRefsOwner;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.resolve.calls.CallInfo;
import org.jetbrains.kotlin.fir.resolve.calls.Candidate;
import org.jetbrains.kotlin.fir.resolve.calls.CheckerSink;
import org.jetbrains.kotlin.fir.resolve.calls.CreateFreshTypeVariableSubstitutorStageKt;
import org.jetbrains.kotlin.fir.resolve.calls.FirSyntheticFunctionSymbol;
import org.jetbrains.kotlin.fir.resolve.calls.InapplicableCandidate;
import org.jetbrains.kotlin.fir.resolve.calls.InferenceError;
import org.jetbrains.kotlin.fir.resolve.calls.ResolutionContext;
import org.jetbrains.kotlin.fir.resolve.calls.ResolutionDiagnostic;
import org.jetbrains.kotlin.fir.resolve.calls.ResolutionStage;
import org.jetbrains.kotlin.fir.resolve.calls.TypeArgumentMapping;
import org.jetbrains.kotlin.fir.resolve.inference.model.ConeExplicitTypeParameterConstraintPosition;
import org.jetbrains.kotlin.fir.resolve.substitution.ConeSubstitutor;
import org.jetbrains.kotlin.fir.symbols.ConeTypeParameterLookupTag;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.FirLazyDeclarationResolverKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.types.ConeFlexibleType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeNullability;
import org.jetbrains.kotlin.fir.types.ConeSimpleKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeContext;
import org.jetbrains.kotlin.fir.types.ConeTypeVariable;
import org.jetbrains.kotlin.fir.types.FirPlaceholderProjection;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirStarProjection;
import org.jetbrains.kotlin.fir.types.FirTypeProjection;
import org.jetbrains.kotlin.fir.types.FirTypeProjectionWithVariance;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeComponentsKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import org.jetbrains.kotlin.resolve.calls.inference.model.ConstraintSystemError;
import org.jetbrains.kotlin.resolve.calls.inference.model.NewConstraintSystemImpl;
import org.jetbrains.kotlin.resolve.calls.inference.model.SimpleConstraintSystemConstraintPosition;
import org.jetbrains.kotlin.types.model.KotlinTypeMarker;
import org.jetbrains.kotlin.types.model.TypeConstructorMarker;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0096@\u00a2\u0006\u0002\u0010\rJ \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0014\u0010\u0015\u001a\u00020\u0016*\u00020\u00122\u0006\u0010\u000b\u001a\u00020\u0017H\u0002\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/calls/CreateFreshTypeVariableSubstitutorStage;", "Lorg/jetbrains/kotlin/fir/resolve/calls/ResolutionStage;", "()V", "check", "", "candidate", "Lorg/jetbrains/kotlin/fir/resolve/calls/Candidate;", "callInfo", "Lorg/jetbrains/kotlin/fir/resolve/calls/CallInfo;", "sink", "Lorg/jetbrains/kotlin/fir/resolve/calls/CheckerSink;", "context", "Lorg/jetbrains/kotlin/fir/resolve/calls/ResolutionContext;", "(Lorg/jetbrains/kotlin/fir/resolve/calls/Candidate;Lorg/jetbrains/kotlin/fir/resolve/calls/CallInfo;Lorg/jetbrains/kotlin/fir/resolve/calls/CheckerSink;Lorg/jetbrains/kotlin/fir/resolve/calls/ResolutionContext;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getTypePreservingFlexibilityWrtTypeVariable", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "type", "typeParameter", "Lorg/jetbrains/kotlin/fir/declarations/FirTypeParameterRef;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "shouldBeFlexible", "", "Lorg/jetbrains/kotlin/fir/types/ConeTypeContext;", "resolve"})
@SourceDebugExtension(value={"SMAP\nCreateFreshTypeVariableSubstitutorStage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CreateFreshTypeVariableSubstitutorStage.kt\norg/jetbrains/kotlin/fir/resolve/calls/CreateFreshTypeVariableSubstitutorStage\n+ 2 CheckerSink.kt\norg/jetbrains/kotlin/fir/resolve/calls/CheckerSinkKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,250:1\n28#2,2:251\n22#2,9:253\n22#2,4:262\n1755#3,3:266\n*S KotlinDebug\n*F\n+ 1 CreateFreshTypeVariableSubstitutorStage.kt\norg/jetbrains/kotlin/fir/resolve/calls/CreateFreshTypeVariableSubstitutorStage\n*L\n45#1:251,2\n45#1:253,9\n84#1:262,4\n174#1:266,3\n*E\n"})
public final class CreateFreshTypeVariableSubstitutorStage
extends ResolutionStage {
    @NotNull
    public static final CreateFreshTypeVariableSubstitutorStage INSTANCE = new CreateFreshTypeVariableSubstitutorStage();

    private CreateFreshTypeVariableSubstitutorStage() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Object check(@NotNull Candidate candidate2, @NotNull CallInfo callInfo, @NotNull CheckerSink sink, @NotNull ResolutionContext context2, @NotNull Continuation<? super Unit> $completion) {
        Object declaration = candidate2.getSymbol().getFir();
        FirLazyDeclarationResolverKt.lazyResolveToPhase(candidate2.getSymbol(), FirResolvePhase.STATUS);
        if (!(declaration instanceof FirTypeParameterRefsOwner) || ((FirTypeParameterRefsOwner)declaration).getTypeParameters().isEmpty()) {
            candidate2.setSubstitutor(ConeSubstitutor.Empty.INSTANCE);
            candidate2.setFreshVariables(CollectionsKt.emptyList());
            return Unit.INSTANCE;
        }
        NewConstraintSystemImpl csBuilder = candidate2.getSystem().getBuilder();
        Pair pair = CreateFreshTypeVariableSubstitutorStageKt.access$createToFreshVariableSubstitutorAndAddInitialConstraints((FirTypeParameterRefsOwner)declaration, csBuilder, context2.getSession());
        ConeSubstitutor substitutor2 = (ConeSubstitutor)pair.component1();
        List freshVariables = (List)pair.component2();
        candidate2.setSubstitutor(substitutor2);
        candidate2.setFreshVariables(freshVariables);
        if (csBuilder.getHasContradiction()) {
            void $this$yieldDiagnostic$iv;
            CheckerSink checkerSink = sink;
            ResolutionDiagnostic diagnostic$iv = InapplicableCandidate.INSTANCE;
            boolean $i$f$yieldDiagnostic = false;
            $this$yieldDiagnostic$iv.reportDiagnostic(diagnostic$iv);
            void $this$yieldIfNeed$iv$iv = $this$yieldDiagnostic$iv;
            boolean $i$f$yieldIfNeed = false;
            if ($this$yieldIfNeed$iv$iv.getNeedYielding()) {
                Object object = $this$yieldIfNeed$iv$iv.yield($completion);
                if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                    return object;
                }
            }
            return Unit.INSTANCE;
        }
        if (Intrinsics.areEqual((Object)candidate2.getTypeArgumentMapping(), (Object)TypeArgumentMapping.NoExplicitArguments.INSTANCE)) {
            return Unit.INSTANCE;
        }
        List<FirTypeParameterRef> typeParameters2 = ((FirTypeParameterRefsOwner)declaration).getTypeParameters();
        int $i$f$yieldDiagnostic = ((Collection)typeParameters2).size();
        for (int index2 = 0; index2 < $i$f$yieldDiagnostic; ++index2) {
            FirTypeParameterRef typeParameter2 = typeParameters2.get(index2);
            ConeTypeVariable freshVariable = (ConeTypeVariable)freshVariables.get(index2);
            FirTypeProjection typeArgument = candidate2.getTypeArgumentMapping().get(index2);
            if (typeArgument instanceof FirTypeProjectionWithVariance) {
                csBuilder.addEqualityConstraint(freshVariable.getDefaultType(), TypeExpansionUtilsKt.fullyExpandedType(this.getTypePreservingFlexibilityWrtTypeVariable(FirTypeUtilsKt.getConeType(((FirTypeProjectionWithVariance)typeArgument).getTypeRef()), typeParameter2, context2.getSession()), context2.getSession()), new ConeExplicitTypeParameterConstraintPosition(typeArgument));
                continue;
            }
            if (typeArgument instanceof FirStarProjection) {
                KotlinTypeMarker kotlinTypeMarker = freshVariable.getDefaultType();
                Object object = (FirResolvedTypeRef)CollectionsKt.firstOrNull(typeParameter2.getSymbol().getResolvedBounds());
                if (object == null || (object = FirTypeUtilsKt.getConeType((FirTypeRef)object)) == null) {
                    object = context2.getSession().getBuiltinTypes().getNullableAnyType().getType();
                }
                csBuilder.addEqualityConstraint(kotlinTypeMarker, (KotlinTypeMarker)object, SimpleConstraintSystemConstraintPosition.INSTANCE);
                continue;
            }
            boolean bl = typeArgument instanceof FirPlaceholderProjection;
            if (!_Assertions.ENABLED || bl) continue;
            boolean bl2 = false;
            String string2 = "Unexpected typeArgument: " + UtilsKt.renderWithType(typeArgument);
            throw new AssertionError((Object)string2);
        }
        if (csBuilder.getHasContradiction()) {
            for (ConstraintSystemError error : csBuilder.getErrors()) {
                sink.reportDiagnostic(new InferenceError(error));
            }
            CheckerSink $this$yieldIfNeed$iv = sink;
            boolean $i$f$yieldIfNeed = false;
            if ($this$yieldIfNeed$iv.getNeedYielding()) {
                Object object = $this$yieldIfNeed$iv.yield($completion);
                if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                    return object;
                }
            }
            return Unit.INSTANCE;
        }
        return Unit.INSTANCE;
    }

    private final ConeKotlinType getTypePreservingFlexibilityWrtTypeVariable(ConeKotlinType type2, FirTypeParameterRef typeParameter2, FirSession session2) {
        ConeKotlinType coneKotlinType;
        FirBasedSymbol<?> containingDeclarationSymbol = typeParameter2.getSymbol().getContainingDeclarationSymbol();
        if (containingDeclarationSymbol instanceof FirCallableSymbol && !(containingDeclarationSymbol instanceof FirSyntheticFunctionSymbol) && this.shouldBeFlexible(typeParameter2, TypeComponentsKt.getTypeContext(session2))) {
            ConeFlexibleType coneFlexibleType;
            ConeKotlinType coneKotlinType2 = type2;
            if (coneKotlinType2 instanceof ConeSimpleKotlinType) {
                coneFlexibleType = new ConeFlexibleType((ConeSimpleKotlinType)TypeUtilsKt.withNullability$default(type2, ConeNullability.NOT_NULL, TypeComponentsKt.getTypeContext(session2), null, false, 12, null), (ConeSimpleKotlinType)TypeUtilsKt.withNullability$default(type2, ConeNullability.NULLABLE, TypeComponentsKt.getTypeContext(session2), null, false, 12, null));
            } else if (coneKotlinType2 instanceof ConeFlexibleType) {
                coneFlexibleType = new ConeFlexibleType((ConeSimpleKotlinType)TypeUtilsKt.withNullability$default(((ConeFlexibleType)type2).getLowerBound(), ConeNullability.NOT_NULL, TypeComponentsKt.getTypeContext(session2), null, false, 12, null), (ConeSimpleKotlinType)TypeUtilsKt.withNullability$default(((ConeFlexibleType)type2).getUpperBound(), ConeNullability.NULLABLE, TypeComponentsKt.getTypeContext(session2), null, false, 12, null));
            } else {
                throw new NoWhenBranchMatchedException();
            }
            coneKotlinType = coneFlexibleType;
        } else {
            coneKotlinType = type2;
        }
        return coneKotlinType;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean shouldBeFlexible(FirTypeParameterRef $this$shouldBeFlexible, ConeTypeContext context2) {
        boolean bl;
        if (FirLanguageSettingsComponentKt.getLanguageVersionSettings(context2.getSession()).supportsFeature(LanguageFeature.JavaTypeParameterDefaultRepresentationWithDNN)) {
            return false;
        }
        Iterable $this$any$iv = $this$shouldBeFlexible.getSymbol().getResolvedBounds();
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator2 = $this$any$iv.iterator();
        do {
            if (!iterator2.hasNext()) return false;
            Object element$iv = iterator2.next();
            FirResolvedTypeRef it = (FirResolvedTypeRef)element$iv;
            boolean bl2 = false;
            ConeKotlinType type2 = FirTypeUtilsKt.getConeType(it);
            if (type2 instanceof ConeFlexibleType) return true;
            ConeTypeContext $this$shouldBeFlexible_u24lambda_u242_u24lambda_u241 = context2;
            boolean bl3 = false;
            TypeConstructorMarker typeConstructorMarker = $this$shouldBeFlexible_u24lambda_u242_u24lambda_u241.typeConstructor(type2);
            Object object = typeConstructorMarker instanceof ConeTypeParameterLookupTag ? (ConeTypeParameterLookupTag)typeConstructorMarker : null;
            boolean bl4 = object != null && (object = ((ConeTypeParameterLookupTag)object).getSymbol()) != null && (object = (FirTypeParameter)((FirBasedSymbol)object).getFir()) != null ? INSTANCE.shouldBeFlexible((FirTypeParameterRef)object, context2) : false;
            if (bl4) {
                return true;
            }
            bl = false;
        } while (!bl);
        return true;
    }
}

