/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.low.level.api.fir.providers;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.low.level.api.fir.providers.KmpModuleSorter;
import org.jetbrains.kotlin.analysis.project.structure.KtModule;
import org.jetbrains.kotlin.utils.SortUtilsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u0000 \u00172\u00020\u0001:\u0002\u0017\u0018B\u0015\b\u0002\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0014\u0010\u0010\u001a\u00060\bR\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0004H\u0002J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0004H\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0002J\u000e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0002J\u000e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0002R\u001e\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\u0004\u0012\b\u0012\u00060\bR\u00020\u00000\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u000f0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/analysis/low/level/api/fir/providers/KmpModuleSorter;", "", "modules", "", "Lorg/jetbrains/kotlin/analysis/project/structure/KtModule;", "(Ljava/util/List;)V", "groupsByModules", "", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/providers/KmpModuleSorter$KmpGroup;", "<set-?>", "", "hasErrors", "getHasErrors", "()Z", "originalPositions", "", "findOrCreateRootKmpGroup", "module", "getOriginalPositionOrSetCorrupted", "groupModules", "", "sort", "sortModules", "Companion", "KmpGroup", "low-level-api-fir"})
@SourceDebugExtension(value={"SMAP\nKmpModuleSorter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KmpModuleSorter.kt\norg/jetbrains/kotlin/analysis/low/level/api/fir/providers/KmpModuleSorter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,127:1\n1872#2,3:128\n669#2,11:132\n1#3:131\n381#4,7:143\n*S KotlinDebug\n*F\n+ 1 KmpModuleSorter.kt\norg/jetbrains/kotlin/analysis/low/level/api/fir/providers/KmpModuleSorter\n*L\n50#1:128,3\n69#1:132,11\n76#1:143,7\n*E\n"})
public final class KmpModuleSorter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<KtModule> modules;
    @NotNull
    private final Map<KtModule, KmpGroup> groupsByModules;
    @NotNull
    private final Map<KtModule, Integer> originalPositions;
    private boolean hasErrors;

    private KmpModuleSorter(List<? extends KtModule> modules2) {
        this.modules = modules2;
        this.groupsByModules = new LinkedHashMap();
        this.originalPositions = new LinkedHashMap();
    }

    public final boolean getHasErrors() {
        return this.hasErrors;
    }

    private final List<KtModule> sort() {
        this.groupModules();
        List<KtModule> sorted = this.sortModules();
        return this.hasErrors ? this.modules : sorted;
    }

    private final void groupModules() {
        Iterator iterator2 = ((Iterable)this.modules).iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int index2 = n++;
            KtModule module2 = (KtModule)iterator2.next();
            Integer n2 = index2;
            this.originalPositions.put(module2, n2);
            KmpGroup group = this.findOrCreateRootKmpGroup(module2);
            group.addModule(module2);
            this.groupsByModules.putIfAbsent(module2, group);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<KtModule> sortModules() {
        Object[] sortedModules2 = new KtModule[this.modules.size()];
        Iterable $this$forEachIndexed$iv = this.modules;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void module2;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            KtModule ktModule2 = (KtModule)item$iv;
            int index2 = n;
            boolean bl = false;
            KmpGroup group = this.groupsByModules.get(module2);
            if (group == null) {
                sortedModules2[index2] = module2;
                continue;
            }
            sortedModules2[group.getUpdatedIndexOf((KtModule)module2)] = module2;
        }
        return CollectionsKt.filterNotNull((Iterable)ArraysKt.toList((Object[])sortedModules2));
    }

    private final KmpGroup findOrCreateRootKmpGroup(KtModule module2) {
        KmpGroup kmpGroup;
        KtModule root;
        KtModule ktModule2;
        KmpGroup kmpGroup2 = this.groupsByModules.get(module2);
        if (kmpGroup2 != null) {
            KmpGroup it = kmpGroup2;
            boolean bl = false;
            return it;
        }
        if (module2.getDirectDependsOnDependencies().isEmpty()) {
            ktModule2 = module2;
        } else {
            Object v1;
            block8: {
                Iterable $this$singleOrNull$iv = module2.getTransitiveDependsOnDependencies();
                boolean $i$f$singleOrNull = false;
                Object single$iv = null;
                boolean found$iv = false;
                for (Object element$iv : $this$singleOrNull$iv) {
                    KtModule dependency = (KtModule)element$iv;
                    boolean bl = false;
                    if (!dependency.getDirectDependsOnDependencies().isEmpty()) continue;
                    if (found$iv) {
                        v1 = null;
                        break block8;
                    }
                    single$iv = element$iv;
                    found$iv = true;
                }
                v1 = !found$iv ? null : single$iv;
            }
            ktModule2 = root = (KtModule)v1;
        }
        if (root == null) {
            this.hasErrors = true;
            return new KmpGroup();
        }
        Map<KtModule, KmpGroup> $this$getOrPut$iv = this.groupsByModules;
        boolean $i$f$getOrPut = false;
        KmpGroup value$iv = $this$getOrPut$iv.get(root);
        if (value$iv == null) {
            boolean bl = false;
            KmpGroup answer$iv = new KmpGroup();
            $this$getOrPut$iv.put(root, answer$iv);
            kmpGroup = answer$iv;
        } else {
            kmpGroup = value$iv;
        }
        return kmpGroup;
    }

    private final int getOriginalPositionOrSetCorrupted(KtModule module2) {
        Integer originalPosition = this.originalPositions.get(module2);
        if (originalPosition == null) {
            this.hasErrors = true;
        }
        Integer n = originalPosition;
        return n != null ? n : 0;
    }

    public static final /* synthetic */ Map access$getOriginalPositions$p(KmpModuleSorter $this) {
        return $this.originalPositions;
    }

    public /* synthetic */ KmpModuleSorter(List modules2, DefaultConstructorMarker $constructor_marker) {
        this(modules2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/analysis/low/level/api/fir/providers/KmpModuleSorter$Companion;", "", "()V", "order", "", "Lorg/jetbrains/kotlin/analysis/project/structure/KtModule;", "modules", "low-level-api-fir"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<KtModule> order(@NotNull List<? extends KtModule> modules2) {
            Intrinsics.checkNotNullParameter(modules2, (String)"modules");
            if (modules2.size() < 2) {
                return modules2;
            }
            return new KmpModuleSorter(modules2, null).sort();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0005J\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0013\u001a\u00020\u0005R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R'\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\tR!\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\r8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u000b\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/analysis/low/level/api/fir/providers/KmpModuleSorter$KmpGroup;", "", "(Lorg/jetbrains/kotlin/analysis/low/level/api/fir/providers/KmpModuleSorter;)V", "modules", "", "Lorg/jetbrains/kotlin/analysis/project/structure/KtModule;", "oldReplacedModulesBySortedModules", "", "getOldReplacedModulesBySortedModules", "()Ljava/util/Map;", "oldReplacedModulesBySortedModules$delegate", "Lkotlin/Lazy;", "sortedModules", "", "getSortedModules", "()Ljava/util/List;", "sortedModules$delegate", "addModule", "", "module", "debugText", "", "getUpdatedIndexOf", "", "low-level-api-fir"})
    @SourceDebugExtension(value={"SMAP\nKmpModuleSorter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KmpModuleSorter.kt\norg/jetbrains/kotlin/analysis/low/level/api/fir/providers/KmpModuleSorter$KmpGroup\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,127:1\n1#2:128\n*E\n"})
    private final class KmpGroup {
        @NotNull
        private final List<KtModule> modules = new ArrayList();
        @NotNull
        private final Lazy sortedModules$delegate = LazyKt.lazy((Function0)((Function0)new Function0<List<? extends KtModule>>(this, KmpModuleSorter.this){
            final /* synthetic */ KmpGroup this$0;
            final /* synthetic */ KmpModuleSorter this$1;
            {
                this.this$0 = $receiver;
                this.this$1 = $receiver2;
                super(0);
            }

            public final List<KtModule> invoke() {
                List list2 = SortUtilsKt.topologicalSort$default(KmpGroup.access$getModules$p(this.this$0), null, sortedModules.1.INSTANCE, 2, null);
                KmpGroup kmpGroup = this.this$0;
                KmpModuleSorter kmpModuleSorter = this.this$1;
                List it = list2;
                boolean bl = false;
                if (it.size() != KmpGroup.access$getModules$p(kmpGroup).size()) {
                    KmpModuleSorter.access$setHasErrors$p(kmpModuleSorter, true);
                }
                return list2;
            }
        }));
        @NotNull
        private final Lazy oldReplacedModulesBySortedModules$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Map<KtModule, ? extends KtModule>>(this){
            final /* synthetic */ KmpGroup this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final Map<KtModule, KtModule> invoke() {
                return MapsKt.toMap((Iterable)CollectionsKt.zip((Iterable)KmpGroup.access$getSortedModules(this.this$0), (Iterable)KmpGroup.access$getModules$p(this.this$0)));
            }
        }));

        private final List<KtModule> getSortedModules() {
            Lazy lazy = this.sortedModules$delegate;
            return (List)lazy.getValue();
        }

        private final Map<KtModule, KtModule> getOldReplacedModulesBySortedModules() {
            Lazy lazy = this.oldReplacedModulesBySortedModules$delegate;
            return (Map)lazy.getValue();
        }

        public final void addModule(@NotNull KtModule module2) {
            Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
            this.modules.add(module2);
        }

        public final int getUpdatedIndexOf(@NotNull KtModule module2) {
            Integer newPosition;
            Integer n;
            Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
            if (!this.modules.contains(module2)) {
                String string2 = "Check failed.";
                throw new IllegalStateException(string2.toString());
            }
            if (this.modules.size() == 1) {
                return KmpModuleSorter.this.getOriginalPositionOrSetCorrupted(module2);
            }
            KtModule ktModule2 = this.getOldReplacedModulesBySortedModules().get(module2);
            if (ktModule2 != null) {
                KtModule ktModule3 = ktModule2;
                KmpModuleSorter kmpModuleSorter = KmpModuleSorter.this;
                KtModule it = ktModule3;
                boolean bl = false;
                n = kmpModuleSorter.getOriginalPositionOrSetCorrupted(it);
            } else {
                n = newPosition = null;
            }
            if (newPosition == null) {
                KmpModuleSorter.this.hasErrors = true;
            }
            Integer n2 = newPosition;
            return n2 != null ? n2 : 0;
        }

        @NotNull
        public final String debugText() {
            return CollectionsKt.joinToString$default((Iterable)this.getOldReplacedModulesBySortedModules().entrySet(), (CharSequence)"; ", (CharSequence)"[", (CharSequence)"]", (int)0, null, (Function1)((Function1)new Function1<Map.Entry<? extends KtModule, ? extends KtModule>, CharSequence>(KmpModuleSorter.this){
                final /* synthetic */ KmpModuleSorter this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final CharSequence invoke(Map.Entry<? extends KtModule, ? extends KtModule> entry) {
                    Intrinsics.checkNotNullParameter(entry, (String)"<name for destructuring parameter 0>");
                    KtModule sorted = entry.getKey();
                    KtModule replaced = entry.getValue();
                    return sorted + " -> " + replaced + " (ix -> ix': " + KmpModuleSorter.access$getOriginalPositions$p(this.this$0).get(sorted) + " -> " + KmpModuleSorter.access$getOriginalPositions$p(this.this$0).get(replaced) + ')';
                }
            }), (int)24, null);
        }

        public static final /* synthetic */ List access$getModules$p(KmpGroup $this) {
            return $this.modules;
        }

        public static final /* synthetic */ List access$getSortedModules(KmpGroup $this) {
            return $this.getSortedModules();
        }
    }
}

