/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.storage;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.SuppressJdk6SignatureCheck;
import org.jetbrains.kotlin.storage.CacheWithNotNullValues;
import org.jetbrains.kotlin.storage.CacheWithNullableValues;
import org.jetbrains.kotlin.storage.EmptySimpleLock;
import org.jetbrains.kotlin.storage.MemoizedFunctionToNotNull;
import org.jetbrains.kotlin.storage.MemoizedFunctionToNullable;
import org.jetbrains.kotlin.storage.NotNullLazyValue;
import org.jetbrains.kotlin.storage.NullableLazyValue;
import org.jetbrains.kotlin.storage.SimpleLock;
import org.jetbrains.kotlin.storage.SingleThreadValue;
import org.jetbrains.kotlin.storage.StorageManager;
import org.jetbrains.kotlin.utils.ExceptionUtilsKt;
import org.jetbrains.kotlin.utils.WrappedValues;

public class LockBasedStorageManager
implements StorageManager {
    private static final String PACKAGE_NAME = StringsKt.substringBeforeLast((String)LockBasedStorageManager.class.getCanonicalName(), (String)".", (String)"");
    public static final StorageManager NO_LOCKS = new LockBasedStorageManager("NO_LOCKS", ExceptionHandlingStrategy.THROW, EmptySimpleLock.INSTANCE){

        @Override
        @NotNull
        protected <K, V> RecursionDetectedResult<V> recursionDetectedDefault(@NotNull String source, K input) {
            if (source == null) {
                1.$$$reportNull$$$0(0);
            }
            RecursionDetectedResult recursionDetectedResult = RecursionDetectedResult.fallThrough();
            if (recursionDetectedResult == null) {
                1.$$$reportNull$$$0(1);
            }
            return recursionDetectedResult;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "source";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/kotlin/storage/LockBasedStorageManager$1";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/kotlin/storage/LockBasedStorageManager$1";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "recursionDetectedDefault";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "recursionDetectedDefault";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    };
    protected final SimpleLock lock;
    private final ExceptionHandlingStrategy exceptionHandlingStrategy;
    private final String debugText;

    @NotNull
    public static LockBasedStorageManager createWithExceptionHandling(@NotNull String debugText2, @NotNull ExceptionHandlingStrategy exceptionHandlingStrategy) {
        if (debugText2 == null) {
            LockBasedStorageManager.$$$reportNull$$$0(0);
        }
        if (exceptionHandlingStrategy == null) {
            LockBasedStorageManager.$$$reportNull$$$0(1);
        }
        return LockBasedStorageManager.createWithExceptionHandling(debugText2, exceptionHandlingStrategy, null, null);
    }

    @NotNull
    public static LockBasedStorageManager createWithExceptionHandling(@NotNull String debugText2, @NotNull ExceptionHandlingStrategy exceptionHandlingStrategy, @Nullable Runnable checkCancelled, @Nullable Function1<InterruptedException, Unit> interruptedExceptionHandler) {
        if (debugText2 == null) {
            LockBasedStorageManager.$$$reportNull$$$0(2);
        }
        if (exceptionHandlingStrategy == null) {
            LockBasedStorageManager.$$$reportNull$$$0(3);
        }
        return new LockBasedStorageManager(debugText2, exceptionHandlingStrategy, SimpleLock.Companion.simpleLock(checkCancelled, interruptedExceptionHandler));
    }

    private LockBasedStorageManager(@NotNull String debugText2, @NotNull ExceptionHandlingStrategy exceptionHandlingStrategy, @NotNull SimpleLock lock2) {
        if (debugText2 == null) {
            LockBasedStorageManager.$$$reportNull$$$0(4);
        }
        if (exceptionHandlingStrategy == null) {
            LockBasedStorageManager.$$$reportNull$$$0(5);
        }
        if (lock2 == null) {
            LockBasedStorageManager.$$$reportNull$$$0(6);
        }
        this.lock = lock2;
        this.exceptionHandlingStrategy = exceptionHandlingStrategy;
        this.debugText = debugText2;
    }

    public LockBasedStorageManager(String debugText2) {
        this(debugText2, (Runnable)null, null);
    }

    public LockBasedStorageManager(String debugText2, @Nullable Runnable checkCancelled, @Nullable Function1<InterruptedException, Unit> interruptedExceptionHandler) {
        this(debugText2, ExceptionHandlingStrategy.THROW, SimpleLock.Companion.simpleLock(checkCancelled, interruptedExceptionHandler));
    }

    public String toString() {
        return this.getClass().getSimpleName() + "@" + Integer.toHexString(this.hashCode()) + " (" + this.debugText + ")";
    }

    public LockBasedStorageManager replaceExceptionHandling(@NotNull String debugText2, @NotNull ExceptionHandlingStrategy exceptionHandlingStrategy) {
        if (debugText2 == null) {
            LockBasedStorageManager.$$$reportNull$$$0(7);
        }
        if (exceptionHandlingStrategy == null) {
            LockBasedStorageManager.$$$reportNull$$$0(8);
        }
        return new LockBasedStorageManager(debugText2, exceptionHandlingStrategy, this.lock);
    }

    @Override
    @NotNull
    public <K, V> MemoizedFunctionToNotNull<K, V> createMemoizedFunction(@NotNull Function1<? super K, ? extends V> compute2) {
        if (compute2 == null) {
            LockBasedStorageManager.$$$reportNull$$$0(9);
        }
        MemoizedFunctionToNotNull<? super K, ? extends V> memoizedFunctionToNotNull = this.createMemoizedFunction(compute2, LockBasedStorageManager.createConcurrentHashMap());
        if (memoizedFunctionToNotNull == null) {
            LockBasedStorageManager.$$$reportNull$$$0(10);
        }
        return memoizedFunctionToNotNull;
    }

    @Override
    @NotNull
    public <K, V> MemoizedFunctionToNotNull<K, V> createMemoizedFunction(@NotNull Function1<? super K, ? extends V> compute2, @NotNull Function2<? super K, ? super Boolean, ? extends V> onRecursiveCall) {
        if (compute2 == null) {
            LockBasedStorageManager.$$$reportNull$$$0(11);
        }
        if (onRecursiveCall == null) {
            LockBasedStorageManager.$$$reportNull$$$0(12);
        }
        MemoizedFunctionToNotNull<? super K, ? extends V> memoizedFunctionToNotNull = this.createMemoizedFunction(compute2, onRecursiveCall, LockBasedStorageManager.createConcurrentHashMap());
        if (memoizedFunctionToNotNull == null) {
            LockBasedStorageManager.$$$reportNull$$$0(13);
        }
        return memoizedFunctionToNotNull;
    }

    @Override
    @NotNull
    public <K, V> MemoizedFunctionToNotNull<K, V> createMemoizedFunction(@NotNull Function1<? super K, ? extends V> compute2, @NotNull ConcurrentMap<K, Object> map) {
        if (compute2 == null) {
            LockBasedStorageManager.$$$reportNull$$$0(14);
        }
        if (map == null) {
            LockBasedStorageManager.$$$reportNull$$$0(15);
        }
        return new MapBasedMemoizedFunctionToNotNull<K, V>(this, map, compute2);
    }

    @Override
    @NotNull
    public <K, V> MemoizedFunctionToNotNull<K, V> createMemoizedFunction(@NotNull Function1<? super K, ? extends V> compute2, final @NotNull Function2<? super K, ? super Boolean, ? extends V> onRecursiveCall, @NotNull ConcurrentMap<K, Object> map) {
        if (compute2 == null) {
            LockBasedStorageManager.$$$reportNull$$$0(16);
        }
        if (onRecursiveCall == null) {
            LockBasedStorageManager.$$$reportNull$$$0(17);
        }
        if (map == null) {
            LockBasedStorageManager.$$$reportNull$$$0(18);
        }
        return new MapBasedMemoizedFunctionToNotNull<K, V>(this, map, compute2){

            @Override
            @NotNull
            protected RecursionDetectedResult<V> recursionDetected(K input, boolean firstTime) {
                RecursionDetectedResult<Object> recursionDetectedResult = RecursionDetectedResult.value(onRecursiveCall.invoke(input, (Object)firstTime));
                if (recursionDetectedResult == null) {
                    2.$$$reportNull$$$0(0);
                }
                return recursionDetectedResult;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/storage/LockBasedStorageManager$2", "recursionDetected"));
            }
        };
    }

    @Override
    @NotNull
    public <K, V> MemoizedFunctionToNullable<K, V> createMemoizedFunctionWithNullableValues(@NotNull Function1<? super K, ? extends V> compute2) {
        if (compute2 == null) {
            LockBasedStorageManager.$$$reportNull$$$0(19);
        }
        MemoizedFunctionToNullable<? super K, ? extends V> memoizedFunctionToNullable = this.createMemoizedFunctionWithNullableValues(compute2, LockBasedStorageManager.createConcurrentHashMap());
        if (memoizedFunctionToNullable == null) {
            LockBasedStorageManager.$$$reportNull$$$0(20);
        }
        return memoizedFunctionToNullable;
    }

    @Override
    @NotNull
    public <K, V> MemoizedFunctionToNullable<K, V> createMemoizedFunctionWithNullableValues(@NotNull Function1<? super K, ? extends V> compute2, @NotNull ConcurrentMap<K, Object> map) {
        if (compute2 == null) {
            LockBasedStorageManager.$$$reportNull$$$0(21);
        }
        if (map == null) {
            LockBasedStorageManager.$$$reportNull$$$0(22);
        }
        return new MapBasedMemoizedFunction<K, V>(this, map, compute2);
    }

    @Override
    @NotNull
    public <T> NotNullLazyValue<T> createLazyValue(@NotNull Function0<? extends T> computable) {
        if (computable == null) {
            LockBasedStorageManager.$$$reportNull$$$0(23);
        }
        return new LockBasedNotNullLazyValue<T>(this, computable);
    }

    @Override
    @NotNull
    public <T> NotNullLazyValue<T> createLazyValue(@NotNull Function0<? extends T> computable, final @NotNull Function1<? super Boolean, ? extends T> onRecursiveCall) {
        if (computable == null) {
            LockBasedStorageManager.$$$reportNull$$$0(24);
        }
        if (onRecursiveCall == null) {
            LockBasedStorageManager.$$$reportNull$$$0(25);
        }
        return new LockBasedNotNullLazyValue<T>(this, computable){

            @Override
            @NotNull
            protected RecursionDetectedResult<T> recursionDetected(boolean firstTime) {
                RecursionDetectedResult<Object> recursionDetectedResult = RecursionDetectedResult.value(onRecursiveCall.invoke((Object)firstTime));
                if (recursionDetectedResult == null) {
                    3.$$$reportNull$$$0(0);
                }
                return recursionDetectedResult;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/storage/LockBasedStorageManager$3", "recursionDetected"));
            }
        };
    }

    @Override
    @NotNull
    public <T> NotNullLazyValue<T> createRecursionTolerantLazyValue(@NotNull Function0<? extends T> computable, final @NotNull T onRecursiveCall) {
        if (computable == null) {
            LockBasedStorageManager.$$$reportNull$$$0(26);
        }
        if (onRecursiveCall == null) {
            LockBasedStorageManager.$$$reportNull$$$0(27);
        }
        return new LockBasedNotNullLazyValue<T>(this, computable){

            @Override
            @NotNull
            protected RecursionDetectedResult<T> recursionDetected(boolean firstTime) {
                RecursionDetectedResult<Object> recursionDetectedResult = RecursionDetectedResult.value(onRecursiveCall);
                if (recursionDetectedResult == null) {
                    4.$$$reportNull$$$0(0);
                }
                return recursionDetectedResult;
            }

            @Override
            protected String presentableName() {
                return "RecursionTolerantLazyValue";
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/storage/LockBasedStorageManager$4", "recursionDetected"));
            }
        };
    }

    @Override
    @NotNull
    public <T> NotNullLazyValue<T> createLazyValueWithPostCompute(@NotNull Function0<? extends T> computable, final Function1<? super Boolean, ? extends T> onRecursiveCall, final @NotNull Function1<? super T, Unit> postCompute) {
        if (computable == null) {
            LockBasedStorageManager.$$$reportNull$$$0(28);
        }
        if (postCompute == null) {
            LockBasedStorageManager.$$$reportNull$$$0(29);
        }
        return new LockBasedNotNullLazyValueWithPostCompute<T>(this, computable){

            @Override
            @NotNull
            protected RecursionDetectedResult<T> recursionDetected(boolean firstTime) {
                if (onRecursiveCall == null) {
                    RecursionDetectedResult recursionDetectedResult = super.recursionDetected(firstTime);
                    if (recursionDetectedResult == null) {
                        5.$$$reportNull$$$0(0);
                    }
                    return recursionDetectedResult;
                }
                RecursionDetectedResult<Object> recursionDetectedResult = RecursionDetectedResult.value(onRecursiveCall.invoke((Object)firstTime));
                if (recursionDetectedResult == null) {
                    5.$$$reportNull$$$0(1);
                }
                return recursionDetectedResult;
            }

            @Override
            protected void doPostCompute(@NotNull T value2) {
                if (value2 == null) {
                    5.$$$reportNull$$$0(2);
                }
                postCompute.invoke(value2);
            }

            @Override
            protected String presentableName() {
                return "LockBasedNotNullLazyValueWithPostCompute";
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string2;
                switch (n) {
                    default: {
                        string2 = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 2: {
                        string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 2: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/jetbrains/kotlin/storage/LockBasedStorageManager$5";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "value";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "recursionDetected";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/jetbrains/kotlin/storage/LockBasedStorageManager$5";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "doPostCompute";
                        break;
                    }
                }
                String string3 = String.format(string2, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string3);
                        break;
                    }
                    case 2: {
                        runtimeException = new IllegalArgumentException(string3);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    @Override
    @NotNull
    public <T> NullableLazyValue<T> createNullableLazyValue(@NotNull Function0<? extends T> computable) {
        if (computable == null) {
            LockBasedStorageManager.$$$reportNull$$$0(30);
        }
        return new LockBasedLazyValue<T>(this, computable);
    }

    @Override
    @NotNull
    public <T> NullableLazyValue<T> createRecursionTolerantNullableLazyValue(@NotNull Function0<? extends T> computable, final T onRecursiveCall) {
        if (computable == null) {
            LockBasedStorageManager.$$$reportNull$$$0(31);
        }
        return new LockBasedLazyValue<T>(this, computable){

            @Override
            @NotNull
            protected RecursionDetectedResult<T> recursionDetected(boolean firstTime) {
                RecursionDetectedResult<Object> recursionDetectedResult = RecursionDetectedResult.value(onRecursiveCall);
                if (recursionDetectedResult == null) {
                    6.$$$reportNull$$$0(0);
                }
                return recursionDetectedResult;
            }

            @Override
            protected String presentableName() {
                return "RecursionTolerantNullableLazyValue";
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/storage/LockBasedStorageManager$6", "recursionDetected"));
            }
        };
    }

    @Override
    @NotNull
    public <T> NullableLazyValue<T> createNullableLazyValueWithPostCompute(@NotNull Function0<? extends T> computable, final @NotNull Function1<? super T, Unit> postCompute) {
        if (computable == null) {
            LockBasedStorageManager.$$$reportNull$$$0(32);
        }
        if (postCompute == null) {
            LockBasedStorageManager.$$$reportNull$$$0(33);
        }
        return new LockBasedLazyValueWithPostCompute<T>(this, computable){

            @Override
            protected void doPostCompute(T value2) {
                postCompute.invoke(value2);
            }

            @Override
            protected String presentableName() {
                return "NullableLazyValueWithPostCompute";
            }
        };
    }

    @Override
    public <T> T compute(@NotNull Function0<? extends T> computable) {
        if (computable == null) {
            LockBasedStorageManager.$$$reportNull$$$0(34);
        }
        this.lock.lock();
        try {
            Object object = computable.invoke();
            return (T)object;
        }
        catch (Throwable throwable) {
            throw this.exceptionHandlingStrategy.handleException(throwable);
        }
        finally {
            this.lock.unlock();
        }
    }

    @NotNull
    private static <K> ConcurrentMap<K, Object> createConcurrentHashMap() {
        return new ConcurrentHashMap(3, 1.0f, 2);
    }

    @NotNull
    protected <K, V> RecursionDetectedResult<V> recursionDetectedDefault(@NotNull String source, K input) {
        if (source == null) {
            LockBasedStorageManager.$$$reportNull$$$0(35);
        }
        throw LockBasedStorageManager.sanitizeStackTrace(new AssertionError((Object)("Recursion detected " + source + (input == null ? "" : "on input: " + input) + " under " + this)));
    }

    @NotNull
    private static <T extends Throwable> T sanitizeStackTrace(@NotNull T throwable) {
        if (throwable == null) {
            LockBasedStorageManager.$$$reportNull$$$0(36);
        }
        StackTraceElement[] stackTrace = throwable.getStackTrace();
        int size = stackTrace.length;
        int firstNonStorage = -1;
        for (int i2 = 0; i2 < size; ++i2) {
            if (stackTrace[i2].getClassName().startsWith(PACKAGE_NAME)) continue;
            firstNonStorage = i2;
            break;
        }
        assert (firstNonStorage >= 0) : "This method should only be called on exceptions created in LockBasedStorageManager";
        List<StackTraceElement> list2 = Arrays.asList(stackTrace).subList(firstNonStorage, size);
        throwable.setStackTrace(list2.toArray(new StackTraceElement[list2.size()]));
        T t = throwable;
        if (t == null) {
            LockBasedStorageManager.$$$reportNull$$$0(37);
        }
        return t;
    }

    @Override
    @NotNull
    public <K, V> CacheWithNullableValues<K, V> createCacheWithNullableValues() {
        return new CacheWithNullableValuesBasedOnMemoizedFunction(this, (ConcurrentMap)LockBasedStorageManager.createConcurrentHashMap());
    }

    @Override
    @NotNull
    public <K, V> CacheWithNotNullValues<K, V> createCacheWithNotNullValues() {
        return new CacheWithNotNullValuesBasedOnMemoizedFunction(this, (ConcurrentMap)LockBasedStorageManager.createConcurrentHashMap());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 13: 
            case 20: 
            case 37: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 13: 
            case 20: 
            case 37: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugText";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptionHandlingStrategy";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lock";
                break;
            }
            case 9: 
            case 11: 
            case 14: 
            case 16: 
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compute";
                break;
            }
            case 10: 
            case 13: 
            case 20: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/storage/LockBasedStorageManager";
                break;
            }
            case 12: 
            case 17: 
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onRecursiveCall";
                break;
            }
            case 15: 
            case 18: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 23: 
            case 24: 
            case 26: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computable";
                break;
            }
            case 29: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "postCompute";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "throwable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/storage/LockBasedStorageManager";
                break;
            }
            case 10: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createMemoizedFunction";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "createMemoizedFunctionWithNullableValues";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "sanitizeStackTrace";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createWithExceptionHandling";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "replaceExceptionHandling";
                break;
            }
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createMemoizedFunction";
                break;
            }
            case 10: 
            case 13: 
            case 20: 
            case 37: {
                break;
            }
            case 19: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "createMemoizedFunctionWithNullableValues";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "createLazyValue";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "createRecursionTolerantLazyValue";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "createLazyValueWithPostCompute";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "createNullableLazyValue";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "createRecursionTolerantNullableLazyValue";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "createNullableLazyValueWithPostCompute";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "compute";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "recursionDetectedDefault";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "sanitizeStackTrace";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 10: 
            case 13: 
            case 20: 
            case 37: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static class KeyWithComputation<K, V> {
        private final K key;
        private final Function0<? extends V> computation;

        public KeyWithComputation(K key, Function0<? extends V> computation) {
            this.key = key;
            this.computation = computation;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            KeyWithComputation that = (KeyWithComputation)o;
            return this.key.equals(that.key);
        }

        public int hashCode() {
            return this.key.hashCode();
        }
    }

    private static class CacheWithNotNullValuesBasedOnMemoizedFunction<K, V>
    extends CacheWithNullableValuesBasedOnMemoizedFunction<K, V>
    implements CacheWithNotNullValues<K, V> {
        private CacheWithNotNullValuesBasedOnMemoizedFunction(@NotNull LockBasedStorageManager storageManager, @NotNull ConcurrentMap<KeyWithComputation<K, V>, Object> map) {
            if (storageManager == null) {
                CacheWithNotNullValuesBasedOnMemoizedFunction.$$$reportNull$$$0(0);
            }
            if (map == null) {
                CacheWithNotNullValuesBasedOnMemoizedFunction.$$$reportNull$$$0(1);
            }
            super(storageManager, map);
        }

        @Override
        @NotNull
        public V computeIfAbsent(K key, @NotNull Function0<? extends V> computation) {
            if (computation == null) {
                CacheWithNotNullValuesBasedOnMemoizedFunction.$$$reportNull$$$0(2);
            }
            V result2 = super.computeIfAbsent(key, computation);
            assert (result2 != null) : "computeIfAbsent() returned null under " + this.getStorageManager();
            V v = result2;
            if (v == null) {
                CacheWithNotNullValuesBasedOnMemoizedFunction.$$$reportNull$$$0(3);
            }
            return v;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "storageManager";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "map";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "computation";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/kotlin/storage/LockBasedStorageManager$CacheWithNotNullValuesBasedOnMemoizedFunction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/kotlin/storage/LockBasedStorageManager$CacheWithNotNullValuesBasedOnMemoizedFunction";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "computeIfAbsent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "computeIfAbsent";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class CacheWithNullableValuesBasedOnMemoizedFunction<K, V>
    extends MapBasedMemoizedFunction<KeyWithComputation<K, V>, V>
    implements CacheWithNullableValues<K, V> {
        private CacheWithNullableValuesBasedOnMemoizedFunction(@NotNull LockBasedStorageManager storageManager, @NotNull ConcurrentMap<KeyWithComputation<K, V>, Object> map) {
            if (storageManager == null) {
                CacheWithNullableValuesBasedOnMemoizedFunction.$$$reportNull$$$0(0);
            }
            if (map == null) {
                CacheWithNullableValuesBasedOnMemoizedFunction.$$$reportNull$$$0(1);
            }
            super(storageManager, map, new Function1<KeyWithComputation<K, V>, V>(){

                public V invoke(KeyWithComputation<K, V> computation) {
                    return computation.computation.invoke();
                }
            });
        }

        @Override
        @Nullable
        public V computeIfAbsent(K key, @NotNull Function0<? extends V> computation) {
            if (computation == null) {
                CacheWithNullableValuesBasedOnMemoizedFunction.$$$reportNull$$$0(2);
            }
            return this.invoke(new KeyWithComputation<K, V>(key, computation));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "storageManager";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "map";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "computation";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/kotlin/storage/LockBasedStorageManager$CacheWithNullableValuesBasedOnMemoizedFunction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "computeIfAbsent";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MapBasedMemoizedFunctionToNotNull<K, V>
    extends MapBasedMemoizedFunction<K, V>
    implements MemoizedFunctionToNotNull<K, V> {
        public MapBasedMemoizedFunctionToNotNull(@NotNull LockBasedStorageManager storageManager, @NotNull ConcurrentMap<K, Object> map, @NotNull Function1<? super K, ? extends V> compute2) {
            if (storageManager == null) {
                MapBasedMemoizedFunctionToNotNull.$$$reportNull$$$0(0);
            }
            if (map == null) {
                MapBasedMemoizedFunctionToNotNull.$$$reportNull$$$0(1);
            }
            if (compute2 == null) {
                MapBasedMemoizedFunctionToNotNull.$$$reportNull$$$0(2);
            }
            super(storageManager, map, compute2);
        }

        @Override
        @NotNull
        public V invoke(K input) {
            Object result2 = super.invoke(input);
            assert (result2 != null) : "compute() returned null under " + this.getStorageManager();
            Object v = result2;
            if (v == null) {
                MapBasedMemoizedFunctionToNotNull.$$$reportNull$$$0(3);
            }
            return v;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "storageManager";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "map";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "compute";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/kotlin/storage/LockBasedStorageManager$MapBasedMemoizedFunctionToNotNull";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/kotlin/storage/LockBasedStorageManager$MapBasedMemoizedFunctionToNotNull";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "invoke";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class MapBasedMemoizedFunction<K, V>
    implements MemoizedFunctionToNullable<K, V> {
        private final LockBasedStorageManager storageManager;
        private final ConcurrentMap<K, Object> cache;
        private final Function1<? super K, ? extends V> compute;

        public MapBasedMemoizedFunction(@NotNull LockBasedStorageManager storageManager, @NotNull ConcurrentMap<K, Object> map, @NotNull Function1<? super K, ? extends V> compute2) {
            if (storageManager == null) {
                MapBasedMemoizedFunction.$$$reportNull$$$0(0);
            }
            if (map == null) {
                MapBasedMemoizedFunction.$$$reportNull$$$0(1);
            }
            if (compute2 == null) {
                MapBasedMemoizedFunction.$$$reportNull$$$0(2);
            }
            this.storageManager = storageManager;
            this.cache = map;
            this.compute = compute2;
        }

        @Nullable
        public V invoke(K input) {
            Object value2 = this.cache.get(input);
            if (value2 != null && value2 != NotValue.COMPUTING) {
                return WrappedValues.unescapeExceptionOrNull(value2);
            }
            this.storageManager.lock.lock();
            try {
                Object object;
                RecursionDetectedResult<V> result2;
                value2 = this.cache.get(input);
                if (value2 == NotValue.COMPUTING) {
                    value2 = NotValue.RECURSION_WAS_DETECTED;
                    result2 = this.recursionDetected(input, true);
                    if (!result2.isFallThrough()) {
                        V v = result2.getValue();
                        return v;
                    }
                }
                if (value2 == NotValue.RECURSION_WAS_DETECTED && !(result2 = this.recursionDetected(input, false)).isFallThrough()) {
                    V v = result2.getValue();
                    return v;
                }
                if (value2 != null) {
                    result2 = WrappedValues.unescapeExceptionOrNull(value2);
                    return (V)result2;
                }
                AssertionError error = null;
                try {
                    this.cache.put(input, (Object)NotValue.COMPUTING);
                    Object typedValue = this.compute.invoke(input);
                    Object oldValue = this.cache.put(input, WrappedValues.escapeNull(typedValue));
                    if (oldValue != NotValue.COMPUTING) {
                        error = this.raceCondition(input, oldValue);
                        throw error;
                    }
                    object = typedValue;
                }
                catch (Throwable throwable) {
                    if (ExceptionUtilsKt.isProcessCanceledException(throwable)) {
                        Object remove;
                        try {
                            remove = this.cache.remove(input);
                        }
                        catch (Throwable e) {
                            throw this.unableToRemoveKey(input, e);
                        }
                        if (remove != NotValue.COMPUTING) {
                            throw this.inconsistentComputingKey(input, remove);
                        }
                        throw (RuntimeException)throwable;
                    }
                    if (throwable == error) {
                        try {
                            this.cache.remove(input);
                        }
                        catch (Throwable e) {
                            throw this.unableToRemoveKey(input, e);
                        }
                        throw this.storageManager.exceptionHandlingStrategy.handleException(throwable);
                    }
                    Object oldValue = this.cache.put(input, WrappedValues.escapeThrowable(throwable));
                    if (oldValue != NotValue.COMPUTING) {
                        throw this.raceCondition(input, oldValue);
                    }
                    throw this.storageManager.exceptionHandlingStrategy.handleException(throwable);
                }
                return (V)object;
            }
            finally {
                this.storageManager.lock.unlock();
            }
        }

        @NotNull
        protected RecursionDetectedResult<V> recursionDetected(K input, boolean firstTime) {
            RecursionDetectedResult recursionDetectedResult = this.storageManager.recursionDetectedDefault("", input);
            if (recursionDetectedResult == null) {
                MapBasedMemoizedFunction.$$$reportNull$$$0(3);
            }
            return recursionDetectedResult;
        }

        @NotNull
        private AssertionError raceCondition(K input, Object oldValue) {
            AssertionError assertionError = (AssertionError)((Object)LockBasedStorageManager.sanitizeStackTrace((Throwable)((Object)new AssertionError((Object)("Race condition detected on input " + input + ". Old value is " + oldValue + " under " + this.storageManager)))));
            if (assertionError == null) {
                MapBasedMemoizedFunction.$$$reportNull$$$0(4);
            }
            return assertionError;
        }

        private AssertionError inconsistentComputingKey(K input, Object oldValue) {
            return (AssertionError)((Object)LockBasedStorageManager.sanitizeStackTrace((Throwable)((Object)new AssertionError((Object)("Inconsistent key detected. " + (Object)((Object)NotValue.COMPUTING) + " is expected, was: " + oldValue + ", most probably race condition detected on input " + input + " under " + this.storageManager)))));
        }

        @SuppressJdk6SignatureCheck
        private AssertionError unableToRemoveKey(K input, Throwable throwable) {
            return (AssertionError)((Object)LockBasedStorageManager.sanitizeStackTrace((Throwable)((Object)new AssertionError("Unable to remove " + input + " under " + this.storageManager, throwable))));
        }

        @Override
        public boolean isComputed(K key) {
            Object value2 = this.cache.get(key);
            return value2 != null && value2 != NotValue.COMPUTING;
        }

        protected LockBasedStorageManager getStorageManager() {
            return this.storageManager;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "storageManager";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "map";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "compute";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/kotlin/storage/LockBasedStorageManager$MapBasedMemoizedFunction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/kotlin/storage/LockBasedStorageManager$MapBasedMemoizedFunction";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "recursionDetected";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "raceCondition";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class LockBasedNotNullLazyValue<T>
    extends LockBasedLazyValue<T>
    implements NotNullLazyValue<T> {
        public LockBasedNotNullLazyValue(@NotNull LockBasedStorageManager storageManager, @NotNull Function0<? extends T> computable) {
            if (storageManager == null) {
                LockBasedNotNullLazyValue.$$$reportNull$$$0(0);
            }
            if (computable == null) {
                LockBasedNotNullLazyValue.$$$reportNull$$$0(1);
            }
            super(storageManager, computable);
        }

        @Override
        @NotNull
        public T invoke() {
            Object result2 = super.invoke();
            assert (result2 != null) : "compute() returned null";
            Object t = result2;
            if (t == null) {
                LockBasedNotNullLazyValue.$$$reportNull$$$0(2);
            }
            return t;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "storageManager";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "computable";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/kotlin/storage/LockBasedStorageManager$LockBasedNotNullLazyValue";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/kotlin/storage/LockBasedStorageManager$LockBasedNotNullLazyValue";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "invoke";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static abstract class LockBasedNotNullLazyValueWithPostCompute<T>
    extends LockBasedLazyValueWithPostCompute<T>
    implements NotNullLazyValue<T> {
        public LockBasedNotNullLazyValueWithPostCompute(@NotNull LockBasedStorageManager storageManager, @NotNull Function0<? extends T> computable) {
            if (storageManager == null) {
                LockBasedNotNullLazyValueWithPostCompute.$$$reportNull$$$0(0);
            }
            if (computable == null) {
                LockBasedNotNullLazyValueWithPostCompute.$$$reportNull$$$0(1);
            }
            super(storageManager, computable);
        }

        @Override
        @NotNull
        public T invoke() {
            Object result2 = super.invoke();
            assert (result2 != null) : "compute() returned null";
            Object t = result2;
            if (t == null) {
                LockBasedNotNullLazyValueWithPostCompute.$$$reportNull$$$0(2);
            }
            return t;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "storageManager";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "computable";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/kotlin/storage/LockBasedStorageManager$LockBasedNotNullLazyValueWithPostCompute";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/kotlin/storage/LockBasedStorageManager$LockBasedNotNullLazyValueWithPostCompute";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "invoke";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static abstract class LockBasedLazyValueWithPostCompute<T>
    extends LockBasedLazyValue<T> {
        @Nullable
        private volatile SingleThreadValue<T> valuePostCompute;

        public LockBasedLazyValueWithPostCompute(@NotNull LockBasedStorageManager storageManager, @NotNull Function0<? extends T> computable) {
            if (storageManager == null) {
                LockBasedLazyValueWithPostCompute.$$$reportNull$$$0(0);
            }
            if (computable == null) {
                LockBasedLazyValueWithPostCompute.$$$reportNull$$$0(1);
            }
            super(storageManager, computable);
            this.valuePostCompute = null;
        }

        @Override
        public T invoke() {
            SingleThreadValue<T> postComputeCache = this.valuePostCompute;
            if (postComputeCache != null && postComputeCache.hasValue()) {
                return postComputeCache.getValue();
            }
            return super.invoke();
        }

        @Override
        protected final void postCompute(T value2) {
            this.valuePostCompute = new SingleThreadValue<T>(value2);
            try {
                this.doPostCompute(value2);
            }
            finally {
                this.valuePostCompute = null;
            }
        }

        protected abstract void doPostCompute(T var1);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "storageManager";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "computable";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/kotlin/storage/LockBasedStorageManager$LockBasedLazyValueWithPostCompute";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class LockBasedLazyValue<T>
    implements NullableLazyValue<T> {
        private final LockBasedStorageManager storageManager;
        private final Function0<? extends T> computable;
        @Nullable
        private volatile Object value;

        public LockBasedLazyValue(@NotNull LockBasedStorageManager storageManager, @NotNull Function0<? extends T> computable) {
            if (storageManager == null) {
                LockBasedLazyValue.$$$reportNull$$$0(0);
            }
            if (computable == null) {
                LockBasedLazyValue.$$$reportNull$$$0(1);
            }
            this.value = NotValue.NOT_COMPUTED;
            this.storageManager = storageManager;
            this.computable = computable;
        }

        @Override
        public boolean isComputed() {
            return this.value != NotValue.NOT_COMPUTED && this.value != NotValue.COMPUTING;
        }

        @Override
        public boolean isComputing() {
            return this.value == NotValue.COMPUTING;
        }

        public T invoke() {
            Object _value2 = this.value;
            if (!(_value2 instanceof NotValue)) {
                return (T)WrappedValues.unescapeThrowable(_value2);
            }
            this.storageManager.lock.lock();
            try {
                Object object;
                RecursionDetectedResult<T> result2;
                _value2 = this.value;
                if (!(_value2 instanceof NotValue)) {
                    Object v = WrappedValues.unescapeThrowable(_value2);
                    return (T)v;
                }
                if (_value2 == NotValue.COMPUTING) {
                    this.value = NotValue.RECURSION_WAS_DETECTED;
                    result2 = this.recursionDetected(true);
                    if (!result2.isFallThrough()) {
                        T t = result2.getValue();
                        return t;
                    }
                }
                if (_value2 == NotValue.RECURSION_WAS_DETECTED && !(result2 = this.recursionDetected(false)).isFallThrough()) {
                    T t = result2.getValue();
                    return t;
                }
                this.value = NotValue.COMPUTING;
                try {
                    Object typedValue = this.computable.invoke();
                    this.postCompute(typedValue);
                    this.value = typedValue;
                    object = typedValue;
                }
                catch (Throwable throwable) {
                    if (ExceptionUtilsKt.isProcessCanceledException(throwable)) {
                        this.value = NotValue.NOT_COMPUTED;
                        throw (RuntimeException)throwable;
                    }
                    if (this.value == NotValue.COMPUTING) {
                        this.value = WrappedValues.escapeThrowable(throwable);
                    }
                    throw this.storageManager.exceptionHandlingStrategy.handleException(throwable);
                }
                return (T)object;
            }
            finally {
                this.storageManager.lock.unlock();
            }
        }

        @NotNull
        protected RecursionDetectedResult<T> recursionDetected(boolean firstTime) {
            RecursionDetectedResult recursionDetectedResult = this.storageManager.recursionDetectedDefault("in a lazy value", null);
            if (recursionDetectedResult == null) {
                LockBasedLazyValue.$$$reportNull$$$0(2);
            }
            return recursionDetectedResult;
        }

        protected void postCompute(T value2) {
        }

        @NotNull
        public String renderDebugInformation() {
            String string2 = this.presentableName() + ", storageManager=" + this.storageManager;
            if (string2 == null) {
                LockBasedLazyValue.$$$reportNull$$$0(3);
            }
            return string2;
        }

        protected String presentableName() {
            return this.getClass().getName();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "storageManager";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "computable";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/kotlin/storage/LockBasedStorageManager$LockBasedLazyValue";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/kotlin/storage/LockBasedStorageManager$LockBasedLazyValue";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "recursionDetected";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "renderDebugInformation";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static enum NotValue {
        NOT_COMPUTED,
        COMPUTING,
        RECURSION_WAS_DETECTED;

    }

    private static class RecursionDetectedResult<T> {
        private final T value;
        private final boolean fallThrough;

        @NotNull
        public static <T> RecursionDetectedResult<T> value(T value2) {
            return new RecursionDetectedResult<T>(value2, false);
        }

        @NotNull
        public static <T> RecursionDetectedResult<T> fallThrough() {
            return new RecursionDetectedResult<Object>(null, true);
        }

        private RecursionDetectedResult(T value2, boolean fallThrough) {
            this.value = value2;
            this.fallThrough = fallThrough;
        }

        public T getValue() {
            assert (!this.fallThrough) : "A value requested from FALL_THROUGH in " + this;
            return this.value;
        }

        public boolean isFallThrough() {
            return this.fallThrough;
        }

        public String toString() {
            return this.isFallThrough() ? "FALL_THROUGH" : String.valueOf(this.value);
        }
    }

    public static interface ExceptionHandlingStrategy {
        public static final ExceptionHandlingStrategy THROW = new ExceptionHandlingStrategy(){

            @Override
            @NotNull
            public RuntimeException handleException(@NotNull Throwable throwable) {
                if (throwable == null) {
                    1.$$$reportNull$$$0(0);
                }
                throw ExceptionUtilsKt.rethrow(throwable);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "throwable", "org/jetbrains/kotlin/storage/LockBasedStorageManager$ExceptionHandlingStrategy$1", "handleException"));
            }
        };

        @NotNull
        public RuntimeException handleException(@NotNull Throwable var1);
    }
}

