/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.preloading;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import org.jetbrains.kotlin.preloading.ClassCondition;
import org.jetbrains.kotlin.preloading.ClassHandler;
import org.jetbrains.kotlin.preloading.ResourceData;

public class MemoryBasedClassLoader
extends ClassLoader {
    private final ClassCondition classesToLoadByParent;
    private final ClassLoader parent;
    private final Map<String, Object> preloadedResources;
    private final ClassHandler handler;
    private final ClassLoader fallbackResourceLoader;

    public MemoryBasedClassLoader(ClassCondition classesToLoadByParent, ClassLoader parent2, Map<String, Object> preloadedResources, ClassHandler handler2, ClassLoader fallbackResourceLoader) {
        super(null);
        this.classesToLoadByParent = classesToLoadByParent;
        this.parent = parent2;
        this.preloadedResources = preloadedResources;
        this.handler = handler2;
        this.fallbackResourceLoader = fallbackResourceLoader;
    }

    @Override
    protected synchronized Class<?> loadClass(String name2, boolean resolve2) throws ClassNotFoundException {
        if (this.classesToLoadByParent != null && this.classesToLoadByParent.accept(name2)) {
            if (this.parent == null) {
                return super.loadClass(name2, resolve2);
            }
            try {
                return this.parent.loadClass(name2);
            }
            catch (ClassNotFoundException e) {
                return super.loadClass(name2, resolve2);
            }
        }
        Class<?> aClass = super.loadClass(name2, resolve2);
        if (aClass == null) {
            if (this.parent == null) {
                throw new ClassNotFoundException("Class not available in preloader: " + name2);
            }
            return this.parent.loadClass(name2);
        }
        return aClass;
    }

    @Override
    public Class<?> loadClass(String name2) throws ClassNotFoundException {
        return this.loadClass(name2, false);
    }

    @Override
    protected Class<?> findClass(String name2) throws ClassNotFoundException {
        String internalName = name2.replace('.', '/').concat(".class");
        Object resources = this.preloadedResources.get(internalName);
        if (resources == null) {
            return null;
        }
        this.preloadedResources.remove(internalName);
        ResourceData resourceData = resources instanceof ResourceData ? (ResourceData)resources : (ResourceData)((List)resources).get(0);
        int sizeInBytes = resourceData.bytes.length;
        if (this.handler != null) {
            this.handler.beforeDefineClass(name2, sizeInBytes);
        }
        Class<?> definedClass = this.defineClass(name2, resourceData.bytes, 0, sizeInBytes);
        if (this.handler != null) {
            this.handler.afterDefineClass(name2);
        }
        return definedClass;
    }

    @Override
    public URL getResource(String name2) {
        URL resource = super.getResource(name2);
        if (resource == null) {
            resource = this.fallbackResourceLoader.getResource(name2);
        }
        if (resource == null && this.parent != null) {
            return this.parent.getResource(name2);
        }
        return resource;
    }

    @Override
    protected URL findResource(String name2) {
        Enumeration<URL> resources = this.findResources(name2);
        return resources.hasMoreElements() ? resources.nextElement() : null;
    }

    @Override
    public Enumeration<URL> getResources(String name2) throws IOException {
        Enumeration<URL> own = super.getResources(name2);
        if (!own.hasMoreElements()) {
            own = this.fallbackResourceLoader.getResources(name2);
        }
        if (this.parent == null) {
            return own;
        }
        Enumeration<URL> fromParent = this.parent.getResources(name2);
        if (!own.hasMoreElements()) {
            return fromParent;
        }
        ArrayList<URL> result2 = new ArrayList<URL>();
        while (own.hasMoreElements()) {
            result2.add(own.nextElement());
        }
        while (fromParent.hasMoreElements()) {
            result2.add(fromParent.nextElement());
        }
        return Collections.enumeration(result2);
    }

    @Override
    protected Enumeration<URL> findResources(String name2) {
        Object resources = this.preloadedResources.get(name2);
        if (resources == null) {
            return Collections.enumeration(Collections.emptyList());
        }
        if (resources instanceof ResourceData) {
            return Collections.enumeration(Collections.singletonList(((ResourceData)resources).getURL()));
        }
        assert (resources instanceof ArrayList) : "Resource map should contain ResourceData or ArrayList<ResourceData>: " + name2;
        ArrayList resourceDatas = (ArrayList)resources;
        ArrayList<URL> urls = new ArrayList<URL>(resourceDatas.size());
        for (ResourceData data2 : resourceDatas) {
            urls.add(data2.getURL());
        }
        return Collections.enumeration(urls);
    }
}

