/*
 * Decompiled with CFR 0.152.
 */
package net.rubygrapefruit.platform.internal;

import net.rubygrapefruit.platform.NativeException;
import net.rubygrapefruit.platform.Terminal;
import net.rubygrapefruit.platform.TerminalSize;
import net.rubygrapefruit.platform.Terminals;
import net.rubygrapefruit.platform.internal.AbstractTerminal;
import net.rubygrapefruit.platform.internal.FunctionResult;
import net.rubygrapefruit.platform.internal.MutableTerminalSize;
import net.rubygrapefruit.platform.internal.jni.WindowsConsoleFunctions;

public class WindowsTerminal
extends AbstractTerminal {
    private final Terminals.Output output;

    public WindowsTerminal(Terminals.Output output2) {
        this.output = output2;
    }

    public String toString() {
        return String.format("Windows console on %s", this.getOutputDisplay());
    }

    private String getOutputDisplay() {
        return this.output.toString().toLowerCase();
    }

    protected void init() {
        FunctionResult result2 = new FunctionResult();
        WindowsConsoleFunctions.initConsole(this.output.ordinal(), result2);
        if (result2.isFailed()) {
            throw new NativeException(String.format("Could not open console for %s: %s", this.getOutputDisplay(), result2.getMessage()));
        }
    }

    public boolean supportsColor() {
        return true;
    }

    public boolean supportsTextAttributes() {
        return true;
    }

    public boolean supportsCursorMotion() {
        return true;
    }

    public TerminalSize getTerminalSize() {
        FunctionResult result2 = new FunctionResult();
        MutableTerminalSize size = new MutableTerminalSize();
        WindowsConsoleFunctions.getConsoleSize(this.output.ordinal(), size, result2);
        if (result2.isFailed()) {
            throw new NativeException(String.format("Could not determine console size for %s: %s", this.getOutputDisplay(), result2.getMessage()));
        }
        return size;
    }

    public Terminal bold() {
        FunctionResult result2 = new FunctionResult();
        WindowsConsoleFunctions.bold(result2);
        if (result2.isFailed()) {
            throw new NativeException(String.format("Could not switch console to bold mode for %s: %s", this.getOutputDisplay(), result2.getMessage()));
        }
        return this;
    }

    public Terminal foreground(Terminal.Color color) {
        FunctionResult result2 = new FunctionResult();
        WindowsConsoleFunctions.foreground(color.ordinal(), result2);
        if (result2.isFailed()) {
            throw new NativeException(String.format("Could not change console foreground color for %s: %s", this.getOutputDisplay(), result2.getMessage()));
        }
        return this;
    }

    public Terminal normal() {
        FunctionResult result2 = new FunctionResult();
        WindowsConsoleFunctions.normal(result2);
        if (result2.isFailed()) {
            throw new NativeException(String.format("Could not switch console to normal mode for %s: %s", this.getOutputDisplay(), result2.getMessage()));
        }
        return this;
    }

    public Terminal reset() {
        FunctionResult result2 = new FunctionResult();
        WindowsConsoleFunctions.reset(result2);
        if (result2.isFailed()) {
            throw new NativeException(String.format("Could not reset console for %s: %s", this.getOutputDisplay(), result2.getMessage()));
        }
        return this;
    }

    public Terminal cursorDown(int count) throws NativeException {
        FunctionResult result2 = new FunctionResult();
        WindowsConsoleFunctions.down(count, result2);
        if (result2.isFailed()) {
            throw new NativeException(String.format("Could not move cursor down for %s: %s", this.getOutputDisplay(), result2.getMessage()));
        }
        return this;
    }

    public Terminal cursorUp(int count) throws NativeException {
        FunctionResult result2 = new FunctionResult();
        WindowsConsoleFunctions.up(count, result2);
        if (result2.isFailed()) {
            throw new NativeException(String.format("Could not move cursor up for %s: %s", this.getOutputDisplay(), result2.getMessage()));
        }
        return this;
    }

    public Terminal cursorLeft(int count) throws NativeException {
        FunctionResult result2 = new FunctionResult();
        WindowsConsoleFunctions.left(count, result2);
        if (result2.isFailed()) {
            throw new NativeException(String.format("Could not move cursor left for %s: %s", this.getOutputDisplay(), result2.getMessage()));
        }
        return this;
    }

    public Terminal cursorRight(int count) throws NativeException {
        FunctionResult result2 = new FunctionResult();
        WindowsConsoleFunctions.right(count, result2);
        if (result2.isFailed()) {
            throw new NativeException(String.format("Could not move cursor right for %s: %s", this.getOutputDisplay(), result2.getMessage()));
        }
        return this;
    }

    public Terminal cursorStartOfLine() throws NativeException {
        FunctionResult result2 = new FunctionResult();
        WindowsConsoleFunctions.startLine(result2);
        if (result2.isFailed()) {
            throw new NativeException(String.format("Could not move cursor to start of line for %s: %s", this.getOutputDisplay(), result2.getMessage()));
        }
        return this;
    }

    public Terminal clearToEndOfLine() throws NativeException {
        FunctionResult result2 = new FunctionResult();
        WindowsConsoleFunctions.clearToEndOfLine(result2);
        if (result2.isFailed()) {
            throw new NativeException(String.format("Could clear to end of line for %s: %s", this.getOutputDisplay(), result2.getMessage()));
        }
        return this;
    }
}

