/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.kdoc.parser;

import com.intellij.lang.ASTNode;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiParser;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.kdoc.lexer.KDocTokens;
import org.jetbrains.kotlin.kdoc.parser.KDocElementTypes;
import org.jetbrains.kotlin.kdoc.parser.KDocKnownTag;

public class KDocParser
implements PsiParser {
    @NotNull
    public ASTNode parse(IElementType root, PsiBuilder builder2) {
        PsiBuilder.Marker rootMarker = builder2.mark();
        if (builder2.getTokenType() == KDocTokens.START) {
            builder2.advanceLexer();
        }
        PsiBuilder.Marker currentSectionMarker = builder2.mark();
        while (!builder2.eof()) {
            if (builder2.getTokenType() == KDocTokens.TAG_NAME) {
                currentSectionMarker = KDocParser.parseTag(builder2, currentSectionMarker);
                continue;
            }
            if (builder2.getTokenType() == KDocTokens.END) {
                if (currentSectionMarker != null) {
                    currentSectionMarker.done((IElementType)KDocElementTypes.KDOC_SECTION);
                    currentSectionMarker = null;
                }
                builder2.advanceLexer();
                continue;
            }
            builder2.advanceLexer();
        }
        if (currentSectionMarker != null) {
            currentSectionMarker.done((IElementType)KDocElementTypes.KDOC_SECTION);
        }
        rootMarker.done(root);
        ASTNode aSTNode = builder2.getTreeBuilt();
        if (aSTNode == null) {
            KDocParser.$$$reportNull$$$0(0);
        }
        return aSTNode;
    }

    private static PsiBuilder.Marker parseTag(PsiBuilder builder2, PsiBuilder.Marker currentSectionMarker) {
        String tagName = builder2.getTokenText();
        KDocKnownTag knownTag = KDocKnownTag.Companion.findByTagName(tagName);
        if (knownTag != null && knownTag.isSectionStart()) {
            currentSectionMarker.done((IElementType)KDocElementTypes.KDOC_SECTION);
            currentSectionMarker = builder2.mark();
        }
        PsiBuilder.Marker tagStart = builder2.mark();
        builder2.advanceLexer();
        while (!builder2.eof() && !KDocParser.isAtEndOfTag(builder2)) {
            builder2.advanceLexer();
        }
        tagStart.done((IElementType)KDocElementTypes.KDOC_TAG);
        return currentSectionMarker;
    }

    private static boolean isAtEndOfTag(PsiBuilder builder2) {
        if (builder2.getTokenType() == KDocTokens.END) {
            return true;
        }
        if (builder2.getTokenType() == KDocTokens.LEADING_ASTERISK) {
            int lookAheadCount = 1;
            if (builder2.lookAhead(1) == KDocTokens.TEXT) {
                ++lookAheadCount;
            }
            if (builder2.lookAhead(lookAheadCount) == KDocTokens.TAG_NAME) {
                return true;
            }
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/kdoc/parser/KDocParser", "parse"));
    }
}

