/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.jvm.checkers.expression;

import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtRealSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory1;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.jvm.FirJvmErrors;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.expressions.FirAnnotationCall;
import org.jetbrains.kotlin.fir.expressions.FirArgumentList;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirWrappedArgumentExpression;
import org.jetbrains.kotlin.fir.expressions.impl.FirResolvedArgumentList;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.StandardClassIds;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/jvm/checkers/expression/FirJavaAnnotationsChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotation;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirAnnotationChecker;", "()V", "javaToKotlinNameMap", "", "Lorg/jetbrains/kotlin/name/ClassId;", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers.jvm"})
@SourceDebugExtension(value={"SMAP\nFirJavaAnnotationsChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirJavaAnnotationsChecker.kt\norg/jetbrains/kotlin/fir/analysis/jvm/checkers/expression/FirJavaAnnotationsChecker\n+ 2 FirTypeUtils.kt\norg/jetbrains/kotlin/fir/types/FirTypeUtilsKt\n*L\n1#1,57:1\n24#2,4:58\n*S KotlinDebug\n*F\n+ 1 FirJavaAnnotationsChecker.kt\norg/jetbrains/kotlin/fir/analysis/jvm/checkers/expression/FirJavaAnnotationsChecker\n*L\n40#1:58,4\n*E\n"})
public final class FirJavaAnnotationsChecker
extends FirExpressionChecker<FirAnnotation> {
    @NotNull
    public static final FirJavaAnnotationsChecker INSTANCE = new FirJavaAnnotationsChecker();
    @NotNull
    private static final Map<ClassId, ClassId> javaToKotlinNameMap;

    private FirJavaAnnotationsChecker() {
    }

    @Override
    public void check(@NotNull FirAnnotation expression2, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter2) {
        FirArgumentList argumentList2;
        Object object;
        FirRegularClassSymbol callableSymbol;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter2, (String)"reporter");
        Object object2 = (FirDeclaration)CollectionsKt.lastOrNull(context.getContainingDeclarations());
        if (!Intrinsics.areEqual((Object)(object2 != null && (object2 = ((FirDeclaration)object2).getSource()) != null ? ((KtSourceElement)object2).getKind() : null), (Object)KtRealSourceElementKind.INSTANCE)) {
            return;
        }
        FirRegularClassSymbol firRegularClassSymbol = callableSymbol = FirHelpersKt.toRegularClassSymbol(expression2.getAnnotationTypeRef(), context.getSession());
        if (!((firRegularClassSymbol != null ? firRegularClassSymbol.getOrigin() : null) instanceof FirDeclarationOrigin.Java)) {
            return;
        }
        FirTypeRef $this$coneTypeSafe$iv = expression2.getAnnotationTypeRef();
        boolean $i$f$coneTypeSafe = false;
        FirResolvedTypeRef firResolvedTypeRef = $this$coneTypeSafe$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv : null;
        ConeKotlinType coneKotlinType = firResolvedTypeRef != null ? firResolvedTypeRef.getType() : null;
        if (!(coneKotlinType instanceof ConeClassLikeType)) {
            coneKotlinType = null;
        }
        if ((object = (ConeClassLikeType)((ConeKotlinType)((ConeClassLikeType)coneKotlinType))) == null || (object = ((ConeClassLikeType)object).getLookupTag()) == null) {
            return;
        }
        Object lookupTag2 = object;
        ClassId classId = javaToKotlinNameMap.get(((ConeClassLikeLookupTag)lookupTag2).getClassId());
        if (classId != null) {
            ClassId betterName = classId;
            boolean bl = false;
            AbstractKtSourceElement abstractKtSourceElement = expression2.getSource();
            KtDiagnosticFactory1<FqName> ktDiagnosticFactory1 = FirJvmErrors.INSTANCE.getDEPRECATED_JAVA_ANNOTATION();
            FqName fqName2 = betterName.asSingleFqName();
            Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"betterName.asSingleFqName()");
            KtDiagnosticReportHelpersKt.reportOn$default(reporter2, abstractKtSourceElement, ktDiagnosticFactory1, (Object)fqName2, (DiagnosticContext)context, null, 16, null);
        }
        if (expression2 instanceof FirAnnotationCall && (argumentList2 = ((FirAnnotationCall)expression2).getArgumentList()) instanceof FirResolvedArgumentList) {
            for (Map.Entry entry : ((Map)((FirResolvedArgumentList)argumentList2).getMapping()).entrySet()) {
                FirExpression key = (FirExpression)entry.getKey();
                FirValueParameter value2 = (FirValueParameter)entry.getValue();
                if (Intrinsics.areEqual((Object)value2.getName(), (Object)StandardClassIds.Annotations.ParameterNames.INSTANCE.getValue()) || key instanceof FirWrappedArgumentExpression) continue;
                KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)key.getSource(), FirJvmErrors.INSTANCE.getPOSITIONED_VALUE_ARGUMENT_FOR_JAVA_ANNOTATION(), (DiagnosticContext)context, null, 8, null);
            }
        }
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)StandardClassIds.Annotations.Java.INSTANCE.getTarget(), (Object)StandardClassIds.Annotations.INSTANCE.getTarget()), TuplesKt.to((Object)StandardClassIds.Annotations.Java.INSTANCE.getRetention(), (Object)StandardClassIds.Annotations.INSTANCE.getRetention()), TuplesKt.to((Object)StandardClassIds.Annotations.Java.INSTANCE.getDeprecated(), (Object)StandardClassIds.Annotations.INSTANCE.getDeprecated()), TuplesKt.to((Object)StandardClassIds.Annotations.Java.INSTANCE.getDocumented(), (Object)StandardClassIds.Annotations.INSTANCE.getMustBeDocumented())};
        javaToKotlinNameMap = MapsKt.mapOf((Pair[])pairArray);
    }
}

