/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.jvm.checkers.declaration;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.JvmFieldApplicabilityProblem;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory1;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirAnnotationContainer;
import org.jetbrains.kotlin.fir.FirLanguageSettingsComponentKt;
import org.jetbrains.kotlin.fir.FirPureAbstractElement;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.DeclarationUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.jvm.FirJvmErrors;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.utils.DeclarationAttributesKt;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirBackingFieldSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import org.jetbrains.kotlin.load.java.JvmAbi;
import org.jetbrains.kotlin.name.JvmNames;
import org.jetbrains.kotlin.name.StandardClassIds;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\f\u0010\u0013\u001a\u00020\r*\u00020\u0002H\u0002J\u0014\u0010\u0014\u001a\u00020\r*\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\f\u0010\u0016\u001a\u00020\r*\u00020\u0010H\u0002J\u0014\u0010\u0017\u001a\u00020\r*\u00020\u00182\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0014\u0010\u0019\u001a\u00020\r*\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0016\u0010\u001a\u001a\u00020\r*\u00020\u00022\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/jvm/checkers/declaration/FirJvmFieldApplicabilityChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirPropertyChecker;", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "isInsideJvmMultifileClassFile", "", "isInterfaceCompanionWithPublicJvmFieldProperties", "containingClass", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "hasCustomAccessor", "hasJvmFieldAnnotation", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;", "isDontMangleClass", "isInlineClassThatRequiresMangling", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "isInsideCompanionObjectOfInterface", "isOverridable", "checkers.jvm"})
@SourceDebugExtension(value={"SMAP\nFirJvmFieldApplicabilityChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirJvmFieldApplicabilityChecker.kt\norg/jetbrains/kotlin/fir/analysis/jvm/checkers/declaration/FirJvmFieldApplicabilityChecker\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 3 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,138:1\n21#2:139\n37#2:140\n45#2:141\n44#2:142\n21#2:144\n11#2:145\n66#3:143\n55#3,2:146\n71#3:148\n24#3:149\n13#3:150\n1747#4,3:151\n*S KotlinDebug\n*F\n+ 1 FirJvmFieldApplicabilityChecker.kt\norg/jetbrains/kotlin/fir/analysis/jvm/checkers/declaration/FirJvmFieldApplicabilityChecker\n*L\n50#1:139\n52#1:140\n53#1:141\n54#1:142\n94#1:144\n94#1:145\n86#1:143\n95#1:146,2\n104#1:148\n116#1:149\n116#1:150\n133#1:151,3\n*E\n"})
public final class FirJvmFieldApplicabilityChecker
extends FirDeclarationChecker<FirProperty> {
    @NotNull
    public static final FirJvmFieldApplicabilityChecker INSTANCE = new FirJvmFieldApplicabilityChecker();

    private FirJvmFieldApplicabilityChecker() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void check(@NotNull FirProperty declaration, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter2) {
        JvmFieldApplicabilityProblem jvmFieldApplicabilityProblem;
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter2, (String)"reporter");
        FirSession session2 = context.getSession();
        FirPureAbstractElement firPureAbstractElement = declaration.getBackingField();
        if (firPureAbstractElement == null || (firPureAbstractElement = FirAnnotationUtilsKt.getAnnotationByClassId((FirAnnotationContainer)((Object)firPureAbstractElement), JvmAbi.JVM_FIELD_ANNOTATION_CLASS_ID, session2)) == null) {
            return;
        }
        FirPureAbstractElement annotation2 = firPureAbstractElement;
        ConeClassLikeLookupTag coneClassLikeLookupTag = ClassMembersKt.containingClassLookupTag(declaration);
        FirRegularClassSymbol containingClassSymbol = coneClassLikeLookupTag != null ? LookupTagUtilsKt.toFirRegularClassSymbol(coneClassLikeLookupTag, session2) : null;
        if (declaration.getDelegate() != null) {
            jvmFieldApplicabilityProblem = JvmFieldApplicabilityProblem.DELEGATE;
        } else {
            if (!DeclarationAttributesKt.getHasBackingField(declaration)) {
                return;
            }
            if (this.isOverridable(declaration, containingClassSymbol)) {
                jvmFieldApplicabilityProblem = JvmFieldApplicabilityProblem.NOT_FINAL;
            } else {
                FirMemberDeclaration $this$visibility$iv = declaration;
                boolean $i$f$getVisibility = false;
                if (Visibilities.INSTANCE.isPrivate($this$visibility$iv.getStatus().getVisibility())) {
                    jvmFieldApplicabilityProblem = JvmFieldApplicabilityProblem.PRIVATE;
                } else if (this.hasCustomAccessor(declaration)) {
                    jvmFieldApplicabilityProblem = JvmFieldApplicabilityProblem.CUSTOM_ACCESSOR;
                } else {
                    FirMemberDeclaration $this$isOverride$iv = declaration;
                    boolean $i$f$isOverride = false;
                    if ($this$isOverride$iv.getStatus().isOverride()) {
                        jvmFieldApplicabilityProblem = JvmFieldApplicabilityProblem.OVERRIDES;
                    } else {
                        FirMemberDeclaration $this$isLateInit$iv = declaration;
                        boolean $i$f$isLateInit = false;
                        if ($this$isLateInit$iv.getStatus().isLateInit()) {
                            jvmFieldApplicabilityProblem = JvmFieldApplicabilityProblem.LATEINIT;
                        } else {
                            FirMemberDeclaration $this$isConst$iv = declaration;
                            boolean $i$f$isConst = false;
                            if ($this$isConst$iv.getStatus().isConst()) {
                                jvmFieldApplicabilityProblem = JvmFieldApplicabilityProblem.CONST;
                            } else if (containingClassSymbol != null && this.isInsideCompanionObjectOfInterface(containingClassSymbol, session2)) {
                                if (!FirLanguageSettingsComponentKt.getLanguageVersionSettings(session2).supportsFeature(LanguageFeature.JvmFieldInInterface)) {
                                    jvmFieldApplicabilityProblem = JvmFieldApplicabilityProblem.INSIDE_COMPANION_OF_INTERFACE;
                                } else {
                                    if (this.isInterfaceCompanionWithPublicJvmFieldProperties(containingClassSymbol, session2)) return;
                                    jvmFieldApplicabilityProblem = JvmFieldApplicabilityProblem.NOT_PUBLIC_VAL_WITH_JVMFIELD;
                                }
                            } else if (containingClassSymbol == null && this.isInsideJvmMultifileClassFile(context)) {
                                jvmFieldApplicabilityProblem = JvmFieldApplicabilityProblem.TOP_LEVEL_PROPERTY_OF_MULTIFILE_FACADE;
                            } else if (this.isInlineClassThatRequiresMangling(declaration.getReturnTypeRef(), session2)) {
                                jvmFieldApplicabilityProblem = JvmFieldApplicabilityProblem.RETURN_TYPE_IS_VALUE_CLASS;
                            } else {
                                if (!DeclarationUtilsKt.needsMultiFieldValueClassFlattening(declaration.getReturnTypeRef(), session2)) return;
                                jvmFieldApplicabilityProblem = JvmFieldApplicabilityProblem.RETURN_TYPE_IS_VALUE_CLASS;
                            }
                        }
                    }
                }
            }
        }
        JvmFieldApplicabilityProblem problem = jvmFieldApplicabilityProblem;
        KtDiagnosticFactory1<String> factory2 = Intrinsics.areEqual((Object)DeclarationAttributesKt.getFromPrimaryConstructor(declaration), (Object)true) && !FirLanguageSettingsComponentKt.getLanguageVersionSettings(context.getSession()).supportsFeature(LanguageFeature.ProhibitJvmFieldOnOverrideFromInterfaceInPrimaryConstructor) ? FirJvmErrors.INSTANCE.getINAPPLICABLE_JVM_FIELD_WARNING() : FirJvmErrors.INSTANCE.getINAPPLICABLE_JVM_FIELD();
        KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)((FirAnnotation)annotation2).getSource(), factory2, (Object)problem.getErrorMessage(), (DiagnosticContext)context, null, 16, null);
    }

    private final boolean isInlineClassThatRequiresMangling(FirTypeRef $this$isInlineClassThatRequiresMangling, FirSession session2) {
        FirRegularClassSymbol firRegularClassSymbol = TypeUtilsKt.toRegularClassSymbol(FirTypeUtilsKt.getConeType($this$isInlineClassThatRequiresMangling), session2);
        if (firRegularClassSymbol == null) {
            return false;
        }
        FirRegularClassSymbol symbol2 = firRegularClassSymbol;
        FirClassLikeSymbol $this$isInline$iv = symbol2;
        boolean $i$f$isInline = false;
        return $this$isInline$iv.getRawStatus().isInline() && !this.isDontMangleClass(symbol2);
    }

    private final boolean isDontMangleClass(FirRegularClassSymbol $this$isDontMangleClass) {
        return Intrinsics.areEqual((Object)$this$isDontMangleClass.getClassId(), (Object)StandardClassIds.INSTANCE.getResult());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isOverridable(FirProperty $this$isOverridable, FirRegularClassSymbol containingClass) {
        FirMemberDeclaration $this$visibility$iv = $this$isOverridable;
        boolean $i$f$getVisibility = false;
        if (Intrinsics.areEqual((Object)$this$visibility$iv.getStatus().getVisibility(), (Object)Visibilities.Private.INSTANCE)) return false;
        FirMemberDeclaration $this$modality$iv = $this$isOverridable;
        boolean $i$f$getModality = false;
        if ($this$modality$iv.getStatus().getModality() == Modality.FINAL) return false;
        FirRegularClassSymbol firRegularClassSymbol = containingClass;
        if (firRegularClassSymbol == null) return true;
        FirClassLikeSymbol $this$isFinal$iv = firRegularClassSymbol;
        boolean $i$f$isFinal = false;
        Modality modality = $this$isFinal$iv.getResolvedStatus().getModality();
        if (modality == null) {
            return false;
        }
        Modality modality$iv = modality;
        if (modality$iv != Modality.FINAL) return true;
        return false;
    }

    private final boolean hasCustomAccessor(FirProperty $this$hasCustomAccessor) {
        Object object;
        Object object2;
        return $this$hasCustomAccessor.getGetter() != null && !(((object2 = $this$hasCustomAccessor.getGetter()) != null && (object2 = ((FirPropertyAccessor)object2).getSource()) != null ? ((KtSourceElement)object2).getKind() : null) instanceof KtFakeSourceElementKind) || $this$hasCustomAccessor.getSetter() != null && !(((object = $this$hasCustomAccessor.getSetter()) != null && (object = ((FirPropertyAccessor)object).getSource()) != null ? ((KtSourceElement)object).getKind() : null) instanceof KtFakeSourceElementKind);
    }

    private final boolean isInsideCompanionObjectOfInterface(FirRegularClassSymbol $this$isInsideCompanionObjectOfInterface, FirSession session2) {
        FirClassLikeSymbol $this$isCompanion$iv = $this$isInsideCompanionObjectOfInterface;
        boolean $i$f$isCompanion = false;
        if (!$this$isCompanion$iv.getRawStatus().isCompanion()) {
            return false;
        }
        FirClassLikeSymbol<?> firClassLikeSymbol = FirHelpersKt.getContainingDeclarationSymbol($this$isInsideCompanionObjectOfInterface, session2);
        ClassKind outerClassKind = firClassLikeSymbol != null ? FirHelpersKt.getClassKind(firClassLikeSymbol) : null;
        return outerClassKind == ClassKind.INTERFACE || outerClassKind == ClassKind.ANNOTATION_CLASS;
    }

    private final boolean isInterfaceCompanionWithPublicJvmFieldProperties(FirRegularClassSymbol containingClass, FirSession session2) {
        for (FirBasedSymbol<?> symbol2 : containingClass.getDeclarationSymbols()) {
            block4: {
                block3: {
                    if (!(symbol2 instanceof FirPropertySymbol)) continue;
                    FirCallableSymbol $this$visibility$iv = (FirCallableSymbol)symbol2;
                    boolean $i$f$getVisibility = false;
                    if (!Intrinsics.areEqual((Object)$this$visibility$iv.getResolvedStatus().getVisibility(), (Object)Visibilities.Public.INSTANCE) || ((FirPropertySymbol)symbol2).isVar()) break block3;
                    FirCallableSymbol $this$modality$iv = (FirCallableSymbol)symbol2;
                    boolean $i$f$getModality = false;
                    if ($this$modality$iv.getResolvedStatus().getModality() == Modality.FINAL) break block4;
                }
                return false;
            }
            if (this.hasJvmFieldAnnotation((FirPropertySymbol)symbol2, session2)) continue;
            return false;
        }
        return true;
    }

    private final boolean hasJvmFieldAnnotation(FirPropertySymbol $this$hasJvmFieldAnnotation, FirSession session2) {
        FirBackingFieldSymbol firBackingFieldSymbol = $this$hasJvmFieldAnnotation.getBackingFieldSymbol();
        return (firBackingFieldSymbol != null ? FirAnnotationUtilsKt.getAnnotationByClassId(firBackingFieldSymbol, JvmAbi.JVM_FIELD_ANNOTATION_CLASS_ID, session2) : null) != null;
    }

    private final boolean isInsideJvmMultifileClassFile(CheckerContext context) {
        boolean bl;
        Object object = context.getContainingFile();
        if (object != null && (object = ((FirFile)object).getAnnotations()) != null) {
            boolean bl2;
            block5: {
                Iterable $this$any$iv = (Iterable)object;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        FirAnnotation it = (FirAnnotation)element$iv;
                        boolean bl3 = false;
                        if (!Intrinsics.areEqual((Object)ConeTypeUtilsKt.getClassId(FirTypeUtilsKt.getConeType(it.getAnnotationTypeRef())), (Object)JvmNames.INSTANCE.getJVM_MULTIFILE_CLASS_ID())) continue;
                        bl2 = true;
                        break block5;
                    }
                    bl2 = false;
                }
            }
            bl = bl2;
        } else {
            bl = false;
        }
        return bl;
    }
}

