/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers;

import com.intellij.lang.LighterASTNode;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.tree.IElementType;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.diagnostics.LightTreePositioningStrategiesKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.analysis.checkers.LightTreeSourceNavigator;
import org.jetbrains.kotlin.fir.analysis.checkers.SourceNavigator;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.symbols.impl.FirValueParameterSymbol;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.stubs.elements.KtNameReferenceExpressionElementType;
import org.jetbrains.kotlin.psi.stubs.elements.KtTypeProjectionElementType;
import org.jetbrains.kotlin.util.LightTreeUtilsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\r\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00042\u0014\u0010\b\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\n0\tH\u0002J\u0010\u0010\u000b\u001a\u0004\u0018\u00010\u0004*\u0004\u0018\u00010\u0006H\u0002J\u000e\u0010\f\u001a\u0004\u0018\u00010\r*\u00020\u0006H\u0016J\u000e\u0010\u000e\u001a\u0004\u0018\u00010\u000f*\u00020\u0010H\u0016J\f\u0010\u0011\u001a\u00020\u0012*\u00020\u0013H\u0016J\f\u0010\u0014\u001a\u00020\u0012*\u00020\u0015H\u0016J\f\u0010\u0016\u001a\u00020\u0012*\u00020\u0015H\u0016J\f\u0010\u0017\u001a\u00020\u0012*\u00020\u0015H\u0016J-\u0010\u0018\u001a\u0004\u0018\u0001H\u0019\"\u0004\b\u0000\u0010\u0019*\u00020\u001a2\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u0002H\u00190\u001cH\u0002\u00a2\u0006\u0002\u0010\u001d\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/LightTreeSourceNavigator;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/SourceNavigator;", "()V", "getNullableChild", "Lcom/intellij/lang/LighterASTNode;", "source", "Lorg/jetbrains/kotlin/KtSourceElement;", "node", "ref", "Lcom/intellij/openapi/util/Ref;", "", "getParentOfParent", "getRawIdentifier", "", "getRawName", "", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "isCatchElementParameter", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirValueParameterSymbol;", "isInConstructorCallee", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "isInTypeConstraint", "isRedundantNullable", "withSource", "T", "Lorg/jetbrains/kotlin/fir/FirElement;", "f", "Lkotlin/Function1;", "(Lorg/jetbrains/kotlin/fir/FirElement;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "checkers"})
@SourceDebugExtension(value={"SMAP\nSourceNavigator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SourceNavigator.kt\norg/jetbrains/kotlin/fir/analysis/checkers/LightTreeSourceNavigator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,156:1\n1#2:157\n*E\n"})
public class LightTreeSourceNavigator
implements SourceNavigator {
    private final <T> T withSource(FirElement $this$withSource, Function1<? super KtSourceElement, ? extends T> f) {
        Object object;
        KtSourceElement ktSourceElement = $this$withSource.getSource();
        if (ktSourceElement != null) {
            KtSourceElement it = ktSourceElement;
            boolean bl = false;
            object = f.invoke((Object)it);
        } else {
            object = null;
        }
        return (T)object;
    }

    @Override
    public boolean isInConstructorCallee(@NotNull FirTypeRef $this$isInConstructorCallee) {
        Intrinsics.checkNotNullParameter((Object)$this$isInConstructorCallee, (String)"<this>");
        Boolean bl = (Boolean)this.withSource($this$isInConstructorCallee, isInConstructorCallee.1.INSTANCE);
        return bl != null ? bl : false;
    }

    @Override
    public boolean isInTypeConstraint(@NotNull FirTypeRef $this$isInTypeConstraint) {
        Object v1;
        block2: {
            Intrinsics.checkNotNullParameter((Object)$this$isInTypeConstraint, (String)"<this>");
            KtSourceElement ktSourceElement = $this$isInTypeConstraint.getSource();
            if (ktSourceElement == null) {
                return false;
            }
            KtSourceElement source = ktSourceElement;
            Sequence<LighterASTNode> sequence2 = LightTreePositioningStrategiesKt.getAncestors(source.getTreeStructure(), source.getLighterASTNode());
            for (Object e : sequence2) {
                LighterASTNode it = (LighterASTNode)e;
                boolean bl = false;
                if (!(Intrinsics.areEqual((Object)it.getTokenType(), (Object)KtNodeTypes.TYPE_CONSTRAINT) || Intrinsics.areEqual((Object)it.getTokenType(), (Object)KtNodeTypes.TYPE_PARAMETER))) continue;
                v1 = e;
                break block2;
            }
            v1 = null;
        }
        LighterASTNode lighterASTNode2 = v1;
        return Intrinsics.areEqual((Object)(lighterASTNode2 != null ? lighterASTNode2.getTokenType() : null), (Object)KtNodeTypes.TYPE_CONSTRAINT);
    }

    @Override
    @Nullable
    public CharSequence getRawIdentifier(@NotNull KtSourceElement $this$getRawIdentifier) {
        Intrinsics.checkNotNullParameter((Object)$this$getRawIdentifier, (String)"<this>");
        IElementType iElementType = $this$getRawIdentifier.getElementType();
        return (iElementType instanceof KtNameReferenceExpressionElementType ? true : Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.IDENTIFIER))) ? (CharSequence)$this$getRawIdentifier.getLighterASTNode().toString() : (iElementType instanceof KtTypeProjectionElementType ? (CharSequence)CollectionsKt.last(LightTreeUtilsKt.getChildren($this$getRawIdentifier.getLighterASTNode(), $this$getRawIdentifier.getTreeStructure())).toString() : null);
    }

    @Override
    @Nullable
    public String getRawName(@NotNull FirDeclaration $this$getRawName) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)$this$getRawName, (String)"<this>");
        KtSourceElement ktSourceElement = $this$getRawName.getSource();
        if (ktSourceElement != null) {
            KtSourceElement it = ktSourceElement;
            boolean bl = false;
            LighterASTNode lighterASTNode2 = LightTreePositioningStrategiesKt.nameIdentifier(it.getTreeStructure(), it.getLighterASTNode());
            string2 = lighterASTNode2 != null ? lighterASTNode2.toString() : null;
        } else {
            string2 = null;
        }
        return string2;
    }

    @Override
    public boolean isCatchElementParameter(@NotNull FirValueParameterSymbol $this$isCatchElementParameter) {
        Intrinsics.checkNotNullParameter((Object)$this$isCatchElementParameter, (String)"<this>");
        KtSourceElement ktSourceElement = $this$isCatchElementParameter.getSource();
        return Intrinsics.areEqual(ktSourceElement != null && (ktSourceElement = this.getParentOfParent(ktSourceElement)) != null ? ktSourceElement.getTokenType() : null, (Object)KtNodeTypes.CATCH);
    }

    @Override
    public boolean isRedundantNullable(@NotNull FirTypeRef $this$isRedundantNullable) {
        Intrinsics.checkNotNullParameter((Object)$this$isRedundantNullable, (String)"<this>");
        KtSourceElement ktSourceElement = $this$isRedundantNullable.getSource();
        if (ktSourceElement == null) {
            return false;
        }
        KtSourceElement source = ktSourceElement;
        Ref ref = new Ref();
        LighterASTNode lighterASTNode2 = this.getNullableChild(source, source.getLighterASTNode(), (Ref<LighterASTNode[]>)ref);
        if (lighterASTNode2 == null) {
            return false;
        }
        LighterASTNode firstChild = lighterASTNode2;
        return this.getNullableChild(source, firstChild, (Ref<LighterASTNode[]>)ref) != null;
    }

    private final LighterASTNode getNullableChild(KtSourceElement source, LighterASTNode node, Ref<LighterASTNode[]> ref) {
        source.getTreeStructure().getChildren((Object)node, ref);
        Object object = ref.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ref.get()");
        LighterASTNode lighterASTNode2 = (LighterASTNode)ArraysKt.firstOrNull((Object[])((Object[])object));
        if (lighterASTNode2 == null) {
            return null;
        }
        LighterASTNode firstChild = lighterASTNode2;
        return !Intrinsics.areEqual((Object)firstChild.getTokenType(), (Object)KtNodeTypes.NULLABLE_TYPE) ? null : firstChild;
    }

    private final LighterASTNode getParentOfParent(KtSourceElement $this$getParentOfParent) {
        Object parent2;
        block1: {
            KtSourceElement ktSourceElement = $this$getParentOfParent;
            if (ktSourceElement == null) {
                return null;
            }
            KtSourceElement source = ktSourceElement;
            parent2 = null;
            parent2 = source.getTreeStructure().getParent((Object)source.getLighterASTNode());
            LighterASTNode lighterASTNode2 = (LighterASTNode)parent2;
            if (lighterASTNode2 == null) break block1;
            LighterASTNode it = lighterASTNode2;
            boolean bl = false;
            parent2 = source.getTreeStructure().getParent((Object)it);
        }
        return (LighterASTNode)parent2;
    }
}

