/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.low.level.api.fir.util;

import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.low.level.api.fir.api.KtDeclarationAndFirDeclarationEqualityChecker;
import org.jetbrains.kotlin.analysis.low.level.api.fir.providers.LLFirModuleWithDependenciesSymbolProvider;
import org.jetbrains.kotlin.analysis.low.level.api.fir.util.ExceptionUtilsKt;
import org.jetbrains.kotlin.analysis.low.level.api.fir.util.FirDeclarationForCompiledElementSearcher;
import org.jetbrains.kotlin.analysis.low.level.api.fir.util.FirDeclarationForCompiledElementSearcherKt;
import org.jetbrains.kotlin.analysis.project.structure.ProjectStructureProviderKt;
import org.jetbrains.kotlin.analysis.utils.errors.ExceptionAttachmentBuilder;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirEnumEntry;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProvider;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProviderKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.psi.KtClassLikeDeclaration;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtConstructor;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\u0005\u001a\u00020\u00062\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\bH\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\u000bH\u0002J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0007\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0007\u001a\u00020\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/analysis/low/level/api/fir/util/FirDeclarationForCompiledElementSearcher;", "", "symbolProvider", "Lorg/jetbrains/kotlin/fir/resolve/providers/FirSymbolProvider;", "(Lorg/jetbrains/kotlin/fir/resolve/providers/FirSymbolProvider;)V", "findConstructorOfNonLocalClass", "Lorg/jetbrains/kotlin/fir/declarations/FirConstructor;", "declaration", "Lorg/jetbrains/kotlin/psi/KtConstructor;", "findNonLocalClassLikeDeclaration", "Lorg/jetbrains/kotlin/fir/declarations/FirClassLikeDeclaration;", "Lorg/jetbrains/kotlin/psi/KtClassLikeDeclaration;", "findNonLocalDeclaration", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "ktDeclaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "findNonLocalEnumEntry", "Lorg/jetbrains/kotlin/fir/declarations/FirEnumEntry;", "Lorg/jetbrains/kotlin/psi/KtEnumEntry;", "findNonLocalFunction", "Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "findNonLocalProperty", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "Lorg/jetbrains/kotlin/psi/KtProperty;", "findParameter", "param", "Lorg/jetbrains/kotlin/psi/KtParameter;", "low-level-api-fir"})
@SourceDebugExtension(value={"SMAP\nFirDeclarationForCompiledElementSearcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirDeclarationForCompiledElementSearcher.kt\norg/jetbrains/kotlin/analysis/low/level/api/fir/util/FirDeclarationForCompiledElementSearcher\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,200:1\n1#2:201\n223#3,2:202\n661#3,11:204\n288#3,2:215\n288#3,2:217\n*S KotlinDebug\n*F\n+ 1 FirDeclarationForCompiledElementSearcher.kt\norg/jetbrains/kotlin/analysis/low/level/api/fir/util/FirDeclarationForCompiledElementSearcher\n*L\n62#1:202,2\n101#1:204,11\n113#1:215,2\n127#1:217,2\n*E\n"})
public final class FirDeclarationForCompiledElementSearcher {
    @NotNull
    private final FirSymbolProvider symbolProvider;

    public FirDeclarationForCompiledElementSearcher(@NotNull FirSymbolProvider symbolProvider) {
        Intrinsics.checkNotNullParameter((Object)symbolProvider, (String)"symbolProvider");
        this.symbolProvider = symbolProvider;
    }

    @NotNull
    public final FirDeclaration findNonLocalDeclaration(@NotNull KtDeclaration ktDeclaration) {
        FirDeclaration firDeclaration;
        Intrinsics.checkNotNullParameter((Object)ktDeclaration, (String)"ktDeclaration");
        KtDeclaration ktDeclaration2 = ktDeclaration;
        if (ktDeclaration2 instanceof KtEnumEntry) {
            firDeclaration = this.findNonLocalEnumEntry((KtEnumEntry)ktDeclaration);
        } else if (ktDeclaration2 instanceof KtClassLikeDeclaration) {
            firDeclaration = this.findNonLocalClassLikeDeclaration((KtClassLikeDeclaration)ktDeclaration);
        } else if (ktDeclaration2 instanceof KtConstructor) {
            firDeclaration = this.findConstructorOfNonLocalClass((KtConstructor)ktDeclaration);
        } else if (ktDeclaration2 instanceof KtNamedFunction) {
            firDeclaration = this.findNonLocalFunction((KtNamedFunction)ktDeclaration);
        } else if (ktDeclaration2 instanceof KtProperty) {
            firDeclaration = this.findNonLocalProperty((KtProperty)ktDeclaration);
        } else if (ktDeclaration2 instanceof KtParameter) {
            firDeclaration = this.findParameter((KtParameter)ktDeclaration);
        } else {
            ExceptionUtilsKt.errorWithFirSpecificEntries$default("Unsupported compiled declaration of type", null, null, null, ktDeclaration, null, 46, null);
            throw null;
        }
        return firDeclaration;
    }

    private final FirDeclaration findParameter(KtParameter param) {
        Object v2;
        FirFunction firFunction;
        block4: {
            KtDeclarationWithBody ktDeclarationWithBody = param.getOwnerFunction();
            if (ktDeclarationWithBody == null) {
                ExceptionUtilsKt.errorWithFirSpecificEntries$default("Unsupported compiled parameter", null, null, null, param, null, 46, null);
                throw null;
            }
            KtDeclarationWithBody ownerFunction = ktDeclarationWithBody;
            FirDeclaration firDeclaration = this.findNonLocalDeclaration(ownerFunction);
            FirFunction firFunction2 = firDeclaration instanceof FirFunction ? (FirFunction)firDeclaration : null;
            if (firFunction2 == null) {
                ExceptionUtilsKt.errorWithFirSpecificEntries$default("No fir function found by ktFunction", null, firDeclaration, null, ownerFunction, null, 42, null);
                throw null;
            }
            firFunction = firFunction2;
            Iterable iterable = firFunction.getValueParameters();
            for (Object t : iterable) {
                FirValueParameter it = (FirValueParameter)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)param.getNameAsSafeName())) continue;
                v2 = t;
                break block4;
            }
            v2 = null;
        }
        FirValueParameter firValueParameter = v2;
        if (firValueParameter == null) {
            ExceptionUtilsKt.errorWithFirSpecificEntries$default("No fir value parameter found", null, firFunction, null, param, null, 42, null);
            throw null;
        }
        return firValueParameter;
    }

    private final FirEnumEntry findNonLocalEnumEntry(KtEnumEntry declaration) {
        FirDeclaration firDeclaration;
        if (!(!declaration.isLocal())) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        Object object = KtPsiUtilKt.getContainingClassOrObject(declaration);
        if (object == null || (object = ((KtClassOrObject)object).getClassId()) == null) {
            ExceptionUtilsKt.errorWithFirSpecificEntries$default("Non-local class should have classId", null, null, null, declaration, null, 46, null);
            throw null;
        }
        Object classId = object;
        FirClassLikeSymbol<?> firClassLikeSymbol = this.symbolProvider.getClassLikeSymbolByClassId((ClassId)classId);
        if (firClassLikeSymbol == null) {
            ExceptionUtilsKt.errorWithFirSpecificEntries$default("We should be able to find a symbol for " + classId, null, null, null, declaration, null, 46, null);
            throw null;
        }
        FirClassLikeSymbol<?> classCandidate = firClassLikeSymbol;
        Object e = classCandidate.getFir();
        Object object2 = e instanceof FirRegularClass ? (FirRegularClass)e : null;
        if (object2 != null && (object2 = ((FirRegularClass)object2).getDeclarations()) != null) {
            Object element$iv2;
            block6: {
                Iterable $this$first$iv = (Iterable)object2;
                boolean $i$f$first = false;
                for (Object element$iv2 : $this$first$iv) {
                    FirDeclaration it = (FirDeclaration)element$iv2;
                    boolean bl = false;
                    if (!(it instanceof FirEnumEntry && Intrinsics.areEqual((Object)((FirEnumEntry)it).getName(), (Object)declaration.getNameAsName()))) continue;
                    break block6;
                }
                throw new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            firDeclaration = (FirDeclaration)element$iv2;
        } else {
            firDeclaration = null;
        }
        Intrinsics.checkNotNull(firDeclaration, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.declarations.FirEnumEntry");
        return (FirEnumEntry)firDeclaration;
    }

    private final FirClassLikeDeclaration findNonLocalClassLikeDeclaration(KtClassLikeDeclaration declaration) {
        FirClassLikeSymbol<?> classCandidate;
        FirClassLikeSymbol<Object> firClassLikeSymbol;
        ClassId classId = declaration.getClassId();
        if (classId == null) {
            ExceptionUtilsKt.errorWithFirSpecificEntries$default("Non-local class should have classId", null, null, null, declaration, null, 46, null);
            throw null;
        }
        ClassId classId2 = classId;
        if (this.symbolProvider instanceof LLFirModuleWithDependenciesSymbolProvider) {
            firClassLikeSymbol = ((LLFirModuleWithDependenciesSymbolProvider)this.symbolProvider).getClassLikeSymbolByFqNameWithoutDependencies(classId2);
            if (firClassLikeSymbol == null) {
                FirSymbolProvider firSymbolProvider = FirDeclarationForCompiledElementSearcherKt.access$getFriendBuiltinsProvider((LLFirModuleWithDependenciesSymbolProvider)this.symbolProvider);
                firClassLikeSymbol = firSymbolProvider != null ? firSymbolProvider.getClassLikeSymbolByClassId(classId2) : null;
            }
        } else {
            firClassLikeSymbol = this.symbolProvider.getClassLikeSymbolByClassId(classId2);
        }
        if ((classCandidate = firClassLikeSymbol) == null) {
            ExceptionUtilsKt.errorWithFirSpecificEntries$default("We should be able to find a symbol for " + classId2, null, null, null, declaration, (Function1)new Function1<ExceptionAttachmentBuilder, Unit>(classId2, declaration){
                final /* synthetic */ ClassId $classId;
                final /* synthetic */ KtClassLikeDeclaration $declaration;
                {
                    this.$classId = $classId;
                    this.$declaration = $declaration;
                    super(1);
                }

                public final void invoke(@NotNull ExceptionAttachmentBuilder $this$errorWithFirSpecificEntries) {
                    Intrinsics.checkNotNullParameter((Object)$this$errorWithFirSpecificEntries, (String)"$this$errorWithFirSpecificEntries");
                    $this$errorWithFirSpecificEntries.withEntry("classId", this.$classId, findNonLocalClassLikeDeclaration.1.INSTANCE);
                    $this$errorWithFirSpecificEntries.withEntry("ktModule", ProjectStructureProviderKt.getKtModule$default(this.$declaration, null, 1, null), findNonLocalClassLikeDeclaration.2.INSTANCE);
                }
            }, 14, null);
            throw null;
        }
        return (FirClassLikeDeclaration)classCandidate.getFir();
    }

    /*
     * WARNING - void declaration
     */
    private final FirConstructor findConstructorOfNonLocalClass(KtConstructor<?> declaration) {
        Object v2;
        block6: {
            void $this$singleOrNull$iv;
            KtClassOrObject ktClassOrObject = KtPsiUtilKt.getContainingClassOrObject(declaration);
            if (ktClassOrObject == null) {
                ExceptionUtilsKt.errorWithFirSpecificEntries$default("Constructor must have outer class", null, null, null, declaration, null, 46, null);
                throw null;
            }
            KtClassOrObject containingClass = ktClassOrObject;
            if (!(!containingClass.isLocal())) {
                String string2 = "Failed requirement.";
                throw new IllegalArgumentException(string2.toString());
            }
            ClassId classId = containingClass.getClassId();
            if (classId == null) {
                ExceptionUtilsKt.errorWithFirSpecificEntries$default("Non-local class should have classId", null, null, null, declaration, null, 46, null);
                throw null;
            }
            ClassId classId2 = classId;
            Iterable iterable = FirSymbolProviderKt.getClassDeclaredConstructors(this.symbolProvider, classId2);
            boolean $i$f$singleOrNull = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$singleOrNull$iv) {
                FirConstructorSymbol it = (FirConstructorSymbol)element$iv;
                boolean bl = false;
                if (!FirDeclarationForCompiledElementSearcherKt.access$representSameConstructor(declaration, (FirConstructor)it.getFir())) continue;
                if (found$iv) {
                    v2 = null;
                    break block6;
                }
                single$iv = element$iv;
                found$iv = true;
            }
            v2 = !found$iv ? null : single$iv;
        }
        FirConstructorSymbol firConstructorSymbol = v2;
        if (firConstructorSymbol == null) {
            ExceptionUtilsKt.errorWithFirSpecificEntries$default("We should be able to find a constructor", null, null, null, declaration, null, 46, null);
            throw null;
        }
        FirConstructorSymbol constructorCandidate = firConstructorSymbol;
        return (FirConstructor)constructorCandidate.getFir();
    }

    /*
     * WARNING - void declaration
     */
    private final FirFunction findNonLocalFunction(KtNamedFunction declaration) {
        Object v0;
        List candidates2;
        block3: {
            void $this$firstOrNull$iv;
            if (!(!declaration.isLocal())) {
                String string2 = "Failed requirement.";
                throw new IllegalArgumentException(string2.toString());
            }
            candidates2 = FirDeclarationForCompiledElementSearcherKt.access$findFunctionCandidates(this.symbolProvider, declaration);
            Iterable iterable = candidates2;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                FirFunctionSymbol it = (FirFunctionSymbol)element$iv;
                boolean bl = false;
                if (!KtDeclarationAndFirDeclarationEqualityChecker.INSTANCE.representsTheSameDeclaration(declaration, (FirCallableDeclaration)it.getFir())) continue;
                v0 = element$iv;
                break block3;
            }
            v0 = null;
        }
        FirFunctionSymbol firFunctionSymbol = v0;
        if (firFunctionSymbol == null) {
            ExceptionUtilsKt.errorWithFirSpecificEntries$default("We should be able to find a symbol for function", null, null, null, declaration, (Function1)new Function1<ExceptionAttachmentBuilder, Unit>(candidates2){
                final /* synthetic */ List<FirFunctionSymbol<?>> $candidates;
                {
                    this.$candidates = $candidates;
                    super(1);
                }

                public final void invoke(@NotNull ExceptionAttachmentBuilder $this$errorWithFirSpecificEntries) {
                    Intrinsics.checkNotNullParameter((Object)$this$errorWithFirSpecificEntries, (String)"$this$errorWithFirSpecificEntries");
                    FirDeclarationForCompiledElementSearcherKt.access$withCandidates($this$errorWithFirSpecificEntries, this.$candidates);
                }
            }, 14, null);
            throw null;
        }
        FirFunctionSymbol functionCandidate2 = firFunctionSymbol;
        return (FirFunction)functionCandidate2.getFir();
    }

    private final FirProperty findNonLocalProperty(KtProperty declaration) {
        Object v0;
        List candidates2;
        block3: {
            if (!(!declaration.isLocal())) {
                String string2 = "Failed requirement.";
                throw new IllegalArgumentException(string2.toString());
            }
            candidates2 = FirDeclarationForCompiledElementSearcherKt.access$findPropertyCandidates(this.symbolProvider, declaration);
            Iterable $this$firstOrNull$iv = candidates2;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                FirPropertySymbol it = (FirPropertySymbol)element$iv;
                boolean bl = false;
                if (!KtDeclarationAndFirDeclarationEqualityChecker.INSTANCE.representsTheSameDeclaration(declaration, (FirCallableDeclaration)it.getFir())) continue;
                v0 = element$iv;
                break block3;
            }
            v0 = null;
        }
        FirPropertySymbol firPropertySymbol = v0;
        if (firPropertySymbol == null) {
            ExceptionUtilsKt.errorWithFirSpecificEntries$default("We should be able to find a symbol for property", null, null, null, declaration, (Function1)new Function1<ExceptionAttachmentBuilder, Unit>((List<? extends FirPropertySymbol>)candidates2){
                final /* synthetic */ List<FirPropertySymbol> $candidates;
                {
                    this.$candidates = $candidates;
                    super(1);
                }

                public final void invoke(@NotNull ExceptionAttachmentBuilder $this$errorWithFirSpecificEntries) {
                    Intrinsics.checkNotNullParameter((Object)$this$errorWithFirSpecificEntries, (String)"$this$errorWithFirSpecificEntries");
                    FirDeclarationForCompiledElementSearcherKt.access$withCandidates($this$errorWithFirSpecificEntries, this.$candidates);
                }
            }, 14, null);
            throw null;
        }
        FirPropertySymbol propertyCandidate2 = firPropertySymbol;
        return (FirProperty)propertyCandidate2.getFir();
    }
}

