/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.fir.components;

import com.intellij.openapi.project.Project;
import com.intellij.psi.SmartPsiElementPointer;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.components.ShortenCommand;
import org.jetbrains.kotlin.analysis.api.fir.components.KtFirReferenceShortenerKt;
import org.jetbrains.kotlin.analysis.api.fir.utils.ShortenReferencesUtilsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtUserType;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001BW\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0012\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u00030\u0006\u0012\u0012\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u00030\u0006\u00a2\u0006\u0002\u0010\rJ\u0014\u0010\u0011\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u00030\u0006H\u0016J\u0014\u0010\u0012\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u00030\u0006H\u0016J\u000e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u0006H\u0016R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0010R\u001a\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u00030\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u00030\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/analysis/api/fir/components/ShortenCommandImpl;", "Lorg/jetbrains/kotlin/analysis/api/components/ShortenCommand;", "targetFile", "Lcom/intellij/psi/SmartPsiElementPointer;", "Lorg/jetbrains/kotlin/psi/KtFile;", "importsToAdd", "", "Lorg/jetbrains/kotlin/name/FqName;", "starImportsToAdd", "typesToShorten", "Lorg/jetbrains/kotlin/psi/KtUserType;", "qualifiersToShorten", "Lorg/jetbrains/kotlin/psi/KtDotQualifiedExpression;", "(Lcom/intellij/psi/SmartPsiElementPointer;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;)V", "isEmpty", "", "()Z", "getQualifiersToShorten", "getTypesToShorten", "invokeShortening", "Lorg/jetbrains/kotlin/psi/KtElement;", "analysis-api-fir"})
@SourceDebugExtension(value={"SMAP\nKtFirReferenceShortener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KtFirReferenceShortener.kt\norg/jetbrains/kotlin/analysis/api/fir/components/ShortenCommandImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1125:1\n1#2:1126\n*E\n"})
final class ShortenCommandImpl
implements ShortenCommand {
    @NotNull
    private final SmartPsiElementPointer<KtFile> targetFile;
    @NotNull
    private final List<FqName> importsToAdd;
    @NotNull
    private final List<FqName> starImportsToAdd;
    @NotNull
    private final List<SmartPsiElementPointer<KtUserType>> typesToShorten;
    @NotNull
    private final List<SmartPsiElementPointer<KtDotQualifiedExpression>> qualifiersToShorten;

    public ShortenCommandImpl(@NotNull SmartPsiElementPointer<KtFile> targetFile, @NotNull List<FqName> importsToAdd, @NotNull List<FqName> starImportsToAdd, @NotNull List<? extends SmartPsiElementPointer<KtUserType>> typesToShorten, @NotNull List<? extends SmartPsiElementPointer<KtDotQualifiedExpression>> qualifiersToShorten) {
        Intrinsics.checkNotNullParameter(targetFile, (String)"targetFile");
        Intrinsics.checkNotNullParameter(importsToAdd, (String)"importsToAdd");
        Intrinsics.checkNotNullParameter(starImportsToAdd, (String)"starImportsToAdd");
        Intrinsics.checkNotNullParameter(typesToShorten, (String)"typesToShorten");
        Intrinsics.checkNotNullParameter(qualifiersToShorten, (String)"qualifiersToShorten");
        this.targetFile = targetFile;
        this.importsToAdd = importsToAdd;
        this.starImportsToAdd = starImportsToAdd;
        this.typesToShorten = typesToShorten;
        this.qualifiersToShorten = qualifiersToShorten;
    }

    @Override
    @NotNull
    public List<KtElement> invokeShortening() {
        KtFile ktFile = (KtFile)this.targetFile.getElement();
        if (ktFile == null) {
            return CollectionsKt.emptyList();
        }
        KtFile targetFile = ktFile;
        for (FqName nameToImport : this.importsToAdd) {
            Project project = targetFile.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"targetFile.project");
            ShortenReferencesUtilsKt.addImportToFile$default(project, targetFile, nameToImport, false, null, 24, null);
        }
        for (FqName nameToImport : this.starImportsToAdd) {
            Project project = targetFile.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"targetFile.project");
            ShortenReferencesUtilsKt.addImportToFile$default(project, targetFile, nameToImport, true, null, 16, null);
        }
        List shorteningResults = new ArrayList();
        for (SmartPsiElementPointer<KtUserType> smartPsiElementPointer : this.typesToShorten) {
            KtUserType type2;
            if ((KtUserType)smartPsiElementPointer.getElement() == null) continue;
            type2.deleteQualifier();
            shorteningResults.add(type2);
        }
        for (SmartPsiElementPointer smartPsiElementPointer : this.qualifiersToShorten) {
            KtExpression it;
            KtDotQualifiedExpression call2;
            if ((KtDotQualifiedExpression)smartPsiElementPointer.getElement() == null) continue;
            if (KtFirReferenceShortenerKt.access$deleteQualifier(call2) == null) continue;
            boolean bl = false;
            shorteningResults.add(it);
        }
        return shorteningResults;
    }

    @Override
    public boolean isEmpty() {
        return this.typesToShorten.isEmpty() && this.qualifiersToShorten.isEmpty();
    }

    @Override
    @NotNull
    public List<SmartPsiElementPointer<KtUserType>> getTypesToShorten() {
        return this.typesToShorten;
    }

    @Override
    @NotNull
    public List<SmartPsiElementPointer<KtDotQualifiedExpression>> getQualifiersToShorten() {
        return this.qualifiersToShorten;
    }
}

