/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.fir.components;

import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.components.KtExpressionInfoProvider;
import org.jetbrains.kotlin.analysis.api.fir.KtFirAnalysisSession;
import org.jetbrains.kotlin.analysis.api.fir.components.KtFirAnalysisSessionComponent;
import org.jetbrains.kotlin.analysis.api.fir.components.KtFirExpressionInfoProviderKt;
import org.jetbrains.kotlin.analysis.api.lifetime.KtLifetimeToken;
import org.jetbrains.kotlin.analysis.api.symbols.KtCallableSymbol;
import org.jetbrains.kotlin.analysis.low.level.api.fir.api.LLFirResolveSession;
import org.jetbrains.kotlin.analysis.low.level.api.fir.api.LowLevelFirApiFacadeKt;
import org.jetbrains.kotlin.diagnostics.WhenMissingCase;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.declarations.FirErrorFunction;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.expressions.FirReturnExpression;
import org.jetbrains.kotlin.fir.expressions.FirWhenExpression;
import org.jetbrains.kotlin.fir.resolve.transformers.FirWhenExhaustivenessTransformer;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.psi.KtAnnotatedExpression;
import org.jetbrains.kotlin.psi.KtAnonymousInitializer;
import org.jetbrains.kotlin.psi.KtArrayAccessExpression;
import org.jetbrains.kotlin.psi.KtBackingField;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpressionWithTypeRHS;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtBreakExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtCatchClause;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtClassLikeDeclaration;
import org.jetbrains.kotlin.psi.KtCollectionLiteralExpression;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtConstructorCalleeExpression;
import org.jetbrains.kotlin.psi.KtConstructorDelegationReferenceExpression;
import org.jetbrains.kotlin.psi.KtContainerNode;
import org.jetbrains.kotlin.psi.KtContinueExpression;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtDoubleColonExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtEnumEntrySuperclassReferenceExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFinallySection;
import org.jetbrains.kotlin.psi.KtForExpression;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtIsExpression;
import org.jetbrains.kotlin.psi.KtLabelReferenceExpression;
import org.jetbrains.kotlin.psi.KtLabeledExpression;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtLoopExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectLiteralExpression;
import org.jetbrains.kotlin.psi.KtOperationReferenceExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.KtScript;
import org.jetbrains.kotlin.psi.KtScriptInitializer;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.KtSuperExpression;
import org.jetbrains.kotlin.psi.KtThisExpression;
import org.jetbrains.kotlin.psi.KtThrowExpression;
import org.jetbrains.kotlin.psi.KtTryExpression;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.psi.KtUnaryExpression;
import org.jetbrains.kotlin.psi.KtUserType;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.KtVariableDeclaration;
import org.jetbrains.kotlin.psi.KtWhenCondition;
import org.jetbrains.kotlin.psi.KtWhenEntry;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.psi.KtWhileExpressionBase;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u000fH\u0002J\u0010\u0010\u001c\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0005\u001a\u00020\u0006X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/analysis/api/fir/components/KtFirExpressionInfoProvider;", "Lorg/jetbrains/kotlin/analysis/api/components/KtExpressionInfoProvider;", "Lorg/jetbrains/kotlin/analysis/api/fir/components/KtFirAnalysisSessionComponent;", "analysisSession", "Lorg/jetbrains/kotlin/analysis/api/fir/KtFirAnalysisSession;", "token", "Lorg/jetbrains/kotlin/analysis/api/lifetime/KtLifetimeToken;", "(Lorg/jetbrains/kotlin/analysis/api/fir/KtFirAnalysisSession;Lorg/jetbrains/kotlin/analysis/api/lifetime/KtLifetimeToken;)V", "getAnalysisSession", "()Lorg/jetbrains/kotlin/analysis/api/fir/KtFirAnalysisSession;", "getToken", "()Lorg/jetbrains/kotlin/analysis/api/lifetime/KtLifetimeToken;", "doesParentUseChild", "", "parent", "Lcom/intellij/psi/PsiElement;", "child", "getReturnExpressionTargetSymbol", "Lorg/jetbrains/kotlin/analysis/api/symbols/KtCallableSymbol;", "returnExpression", "Lorg/jetbrains/kotlin/psi/KtReturnExpression;", "getWhenMissingCases", "", "Lorg/jetbrains/kotlin/diagnostics/WhenMissingCase;", "whenExpression", "Lorg/jetbrains/kotlin/psi/KtWhenExpression;", "isUsed", "psiElement", "isUsedAsExpression", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "analysis-api-fir"})
@SourceDebugExtension(value={"SMAP\nKtFirExpressionInfoProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KtFirExpressionInfoProvider.kt\norg/jetbrains/kotlin/analysis/api/fir/components/KtFirExpressionInfoProvider\n+ 2 LowLevelFirApiFacade.kt\norg/jetbrains/kotlin/analysis/low/level/api/fir/api/LowLevelFirApiFacadeKt\n*L\n1#1,437:1\n117#2:438\n117#2:439\n*S KotlinDebug\n*F\n+ 1 KtFirExpressionInfoProvider.kt\norg/jetbrains/kotlin/analysis/api/fir/components/KtFirExpressionInfoProvider\n*L\n32#1:438\n39#1:439\n*E\n"})
public final class KtFirExpressionInfoProvider
extends KtExpressionInfoProvider
implements KtFirAnalysisSessionComponent {
    @NotNull
    private final KtFirAnalysisSession analysisSession;
    @NotNull
    private final KtLifetimeToken token;

    public KtFirExpressionInfoProvider(@NotNull KtFirAnalysisSession analysisSession, @NotNull KtLifetimeToken token) {
        Intrinsics.checkNotNullParameter((Object)analysisSession, (String)"analysisSession");
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        this.analysisSession = analysisSession;
        this.token = token;
    }

    @Override
    @NotNull
    public KtFirAnalysisSession getAnalysisSession() {
        return this.analysisSession;
    }

    @Override
    @NotNull
    protected KtLifetimeToken getToken() {
        return this.token;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public KtCallableSymbol getReturnExpressionTargetSymbol(@NotNull KtReturnExpression returnExpression) {
        void $this$getOrBuildFirSafe$iv;
        Intrinsics.checkNotNullParameter((Object)returnExpression, (String)"returnExpression");
        KtElement ktElement = returnExpression;
        LLFirResolveSession firResolveSession$iv = this.getFirResolveSession();
        boolean $i$f$getOrBuildFirSafe = false;
        FirElement firElement = LowLevelFirApiFacadeKt.getOrBuildFir((KtElement)$this$getOrBuildFirSafe$iv, firResolveSession$iv);
        if (!(firElement instanceof FirReturnExpression)) {
            firElement = null;
        }
        FirReturnExpression firReturnExpression = (FirReturnExpression)((FirElement)((FirReturnExpression)firElement));
        if (firReturnExpression == null) {
            return null;
        }
        FirReturnExpression fir = firReturnExpression;
        FirFunction firTargetSymbol = fir.getTarget().getLabeledElement();
        if (firTargetSymbol instanceof FirErrorFunction) {
            return null;
        }
        return this.getFirSymbolBuilder().getCallableBuilder().buildCallableSymbol((FirCallableSymbol)firTargetSymbol.getSymbol());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<WhenMissingCase> getWhenMissingCases(@NotNull KtWhenExpression whenExpression) {
        void $this$getOrBuildFirSafe$iv;
        Intrinsics.checkNotNullParameter((Object)whenExpression, (String)"whenExpression");
        KtElement ktElement = whenExpression;
        LLFirResolveSession firResolveSession$iv = this.getAnalysisSession().getFirResolveSession();
        boolean $i$f$getOrBuildFirSafe = false;
        FirElement firElement = LowLevelFirApiFacadeKt.getOrBuildFir((KtElement)$this$getOrBuildFirSafe$iv, firResolveSession$iv);
        if (!(firElement instanceof FirWhenExpression)) {
            firElement = null;
        }
        FirWhenExpression firWhenExpression = (FirWhenExpression)((FirElement)((FirWhenExpression)firElement));
        if (firWhenExpression == null) {
            return CollectionsKt.emptyList();
        }
        FirWhenExpression firWhenExpression2 = firWhenExpression;
        return FirWhenExhaustivenessTransformer.Companion.computeAllMissingCases(this.getAnalysisSession().getFirResolveSession().getUseSiteFirSession(), firWhenExpression2);
    }

    @Override
    public boolean isUsedAsExpression(@NotNull KtExpression expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        return this.isUsed((PsiElement)expression2);
    }

    private final boolean isUsed(PsiElement psiElement) {
        boolean bl;
        PsiElement psiElement2 = psiElement;
        if (psiElement2 instanceof KtFunctionLiteral) {
            PsiElement psiElement3 = ((KtFunctionLiteral)psiElement).getParent();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement3, (String)"psiElement.parent");
            bl = this.doesParentUseChild(psiElement3, psiElement);
        } else if (psiElement2 instanceof KtNamedFunction) {
            PsiElement psiElement4 = ((KtNamedFunction)psiElement).getParent();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement4, (String)"psiElement.parent");
            bl = this.doesParentUseChild(psiElement4, psiElement);
        } else if (psiElement2 instanceof KtDeclaration) {
            bl = false;
        } else if (psiElement2 instanceof KtThrowExpression) {
            bl = false;
        } else if (psiElement2 instanceof KtReturnExpression) {
            bl = false;
        } else if (psiElement2 instanceof KtBreakExpression) {
            bl = false;
        } else if (psiElement2 instanceof KtContinueExpression) {
            bl = false;
        } else if (psiElement2 instanceof KtLoopExpression) {
            bl = false;
        } else if (psiElement2 instanceof KtConstructorDelegationReferenceExpression) {
            bl = false;
        } else if (psiElement2 instanceof KtEnumEntrySuperclassReferenceExpression) {
            bl = false;
        } else if (psiElement2 instanceof KtConstructorCalleeExpression) {
            bl = false;
        } else if (psiElement2 instanceof KtLabelReferenceExpression) {
            bl = false;
        } else if (psiElement2 instanceof KtOperationReferenceExpression) {
            bl = false;
        } else {
            PsiElement psiElement5 = psiElement.getParent();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement5, (String)"psiElement.parent");
            bl = this.doesParentUseChild(psiElement5, psiElement);
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean doesParentUseChild(PsiElement parent2, PsiElement child) {
        boolean bl;
        PsiElement psiElement = parent2;
        if (psiElement instanceof KtValueArgument) {
            bl = Intrinsics.areEqual((Object)((KtValueArgument)parent2).getArgumentExpression(), (Object)child);
            return bl;
        } else if (psiElement instanceof KtContainerNode) {
            PsiElement psiElement2 = ((KtContainerNode)parent2).getParent();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"parent.parent");
            bl = this.doesParentUseChild(psiElement2, child);
            return bl;
        } else {
            if (psiElement instanceof KtWhenEntry) {
                if (Intrinsics.areEqual((Object)((KtWhenEntry)parent2).getExpression(), (Object)child)) {
                    PsiElement psiElement3 = ((KtWhenEntry)parent2).getParent();
                    Intrinsics.checkNotNullExpressionValue((Object)psiElement3, (String)"parent.parent");
                    if (this.isUsed(psiElement3)) return true;
                }
                KtWhenCondition[] ktWhenConditionArray = ((KtWhenEntry)parent2).getConditions();
                Intrinsics.checkNotNullExpressionValue((Object)ktWhenConditionArray, (String)"parent.conditions");
                if (!ArraysKt.contains((Object[])ktWhenConditionArray, (Object)child)) return false;
                return true;
            }
            if (psiElement instanceof KtWhenCondition) {
                PsiElement psiElement4 = ((KtWhenCondition)parent2).getParent();
                Intrinsics.checkNotNullExpressionValue((Object)psiElement4, (String)"parent.parent");
                bl = this.doesParentUseChild(psiElement4, parent2);
                return bl;
            } else {
                if (psiElement instanceof KtUserType) {
                    return false;
                }
                if (psiElement instanceof KtFile) {
                    return false;
                }
                if (psiElement instanceof KtScript) {
                    return false;
                }
                if (psiElement instanceof KtClassBody) {
                    return false;
                }
                if (psiElement instanceof KtStringTemplateEntry) {
                    bl = Intrinsics.areEqual((Object)((KtStringTemplateEntry)parent2).getExpression(), (Object)child);
                    return bl;
                } else if (psiElement instanceof KtCatchClause) {
                    PsiElement psiElement5 = ((KtCatchClause)parent2).getParent();
                    Intrinsics.checkNotNullExpressionValue((Object)psiElement5, (String)"parent.parent");
                    bl = this.doesParentUseChild(psiElement5, parent2);
                    return bl;
                } else {
                    if (psiElement instanceof KtFinallySection) {
                        return false;
                    }
                    if (!(psiElement instanceof KtExpression)) {
                        throw new IllegalStateException(("Unhandled Non-KtExpression parent of KtExpression: " + Reflection.getOrCreateKotlinClass(parent2.getClass())).toString());
                    }
                    if (psiElement instanceof KtEnumEntry) {
                        return false;
                    }
                    if (psiElement instanceof KtTypeParameter) {
                        return false;
                    }
                    if (psiElement instanceof KtLambdaExpression) {
                        return false;
                    }
                    if (psiElement instanceof KtScriptInitializer) {
                        return false;
                    }
                    if (psiElement instanceof KtBlockExpression) {
                        List<KtExpression> list2 = ((KtBlockExpression)parent2).getStatements();
                        Intrinsics.checkNotNullExpressionValue(list2, (String)"parent.statements");
                        if (!Intrinsics.areEqual((Object)CollectionsKt.lastOrNull(list2), (Object)child)) return false;
                        if (!this.isUsed(parent2)) return false;
                        return true;
                    }
                    if (psiElement instanceof KtDestructuringDeclaration) {
                        bl = Intrinsics.areEqual((Object)((KtDestructuringDeclaration)parent2).getInitializer(), (Object)child);
                        return bl;
                    } else if (psiElement instanceof KtBackingField) {
                        bl = Intrinsics.areEqual((Object)((KtBackingField)parent2).getInitializer(), (Object)child);
                        return bl;
                    } else {
                        if (psiElement instanceof KtPropertyAccessor) {
                            if (!Intrinsics.areEqual((Object)((KtPropertyAccessor)parent2).getBodyExpression(), (Object)child)) return false;
                            if (!KtFirExpressionInfoProviderKt.access$doesPropertyAccessorUseBody((KtPropertyAccessor)parent2, child)) return false;
                            return true;
                        }
                        if (psiElement instanceof KtFunctionLiteral) {
                            if (!Intrinsics.areEqual((Object)((KtFunctionLiteral)parent2).getBodyBlockExpression(), (Object)child)) return false;
                            if (KtFirExpressionInfoProviderKt.access$returnsUnit((KtDeclaration)parent2)) return false;
                            return true;
                        }
                        if (psiElement instanceof KtNamedFunction) {
                            bl = KtFirExpressionInfoProviderKt.access$doesNamedFunctionUseBody((KtNamedFunction)parent2, child);
                            return bl;
                        } else if (psiElement instanceof KtParameter) {
                            bl = Intrinsics.areEqual((Object)((KtParameter)parent2).getDefaultValue(), (Object)child);
                            return bl;
                        } else if (psiElement instanceof KtVariableDeclaration) {
                            bl = Intrinsics.areEqual((Object)((KtVariableDeclaration)parent2).getInitializer(), (Object)child);
                            return bl;
                        } else {
                            if (psiElement instanceof KtBinaryExpression) {
                                if (Intrinsics.areEqual((Object)((KtBinaryExpression)parent2).getLeft(), (Object)child)) return true;
                                if (!Intrinsics.areEqual((Object)((KtBinaryExpression)parent2).getRight(), (Object)child)) return false;
                                return true;
                            }
                            if (psiElement instanceof KtBinaryExpressionWithTypeRHS) {
                                bl = Intrinsics.areEqual((Object)((KtBinaryExpressionWithTypeRHS)parent2).getLeft(), (Object)child);
                                return bl;
                            } else if (psiElement instanceof KtIsExpression) {
                                bl = Intrinsics.areEqual((Object)((KtIsExpression)parent2).getLeftHandSide(), (Object)child);
                                return bl;
                            } else if (psiElement instanceof KtUnaryExpression) {
                                bl = Intrinsics.areEqual((Object)((KtUnaryExpression)parent2).getBaseExpression(), (Object)child);
                                return bl;
                            } else {
                                if (psiElement instanceof KtQualifiedExpression) {
                                    if (Intrinsics.areEqual((Object)((KtQualifiedExpression)parent2).getReceiverExpression(), (Object)child)) return true;
                                    if (!Intrinsics.areEqual((Object)((KtQualifiedExpression)parent2).getSelectorExpression(), (Object)child)) return false;
                                    if (!this.isUsed(parent2)) return false;
                                    return true;
                                }
                                if (psiElement instanceof KtArrayAccessExpression) {
                                    List<KtExpression> list3 = ((KtArrayAccessExpression)parent2).getIndexExpressions();
                                    Intrinsics.checkNotNullExpressionValue(list3, (String)"parent.indexExpressions");
                                    if (CollectionsKt.contains((Iterable)list3, (Object)child)) return true;
                                    if (!Intrinsics.areEqual((Object)((KtArrayAccessExpression)parent2).getArrayExpression(), (Object)child)) return false;
                                    return true;
                                }
                                if (psiElement instanceof KtCallExpression) {
                                    if (!Intrinsics.areEqual((Object)((KtCallExpression)parent2).getCalleeExpression(), (Object)child)) return false;
                                    if (!KtFirExpressionInfoProviderKt.access$doesCallExpressionUseCallee(child)) return false;
                                    return true;
                                }
                                if (psiElement instanceof KtCollectionLiteralExpression) {
                                    List<KtExpression> list4 = ((KtCollectionLiteralExpression)parent2).getInnerExpressions();
                                    Intrinsics.checkNotNullExpressionValue(list4, (String)"parent.getInnerExpressions()");
                                    bl = CollectionsKt.contains((Iterable)list4, (Object)child);
                                    return bl;
                                } else {
                                    if (psiElement instanceof KtAnnotatedExpression) {
                                        if (!Intrinsics.areEqual((Object)((KtAnnotatedExpression)parent2).getBaseExpression(), (Object)child)) return false;
                                        if (!this.isUsed(parent2)) return false;
                                        return true;
                                    }
                                    if (psiElement instanceof KtDoubleColonExpression) {
                                        if (!Intrinsics.areEqual((Object)((KtDoubleColonExpression)parent2).getLhs(), (Object)child)) return false;
                                        if (!KtFirExpressionInfoProviderKt.access$doesDoubleColonUseLHS(child)) return false;
                                        return true;
                                    }
                                    if (psiElement instanceof KtParenthesizedExpression) {
                                        PsiElement psiElement6 = ((KtParenthesizedExpression)parent2).getParent();
                                        Intrinsics.checkNotNullExpressionValue((Object)psiElement6, (String)"parent.parent");
                                        bl = this.doesParentUseChild(psiElement6, parent2);
                                        return bl;
                                    } else {
                                        if (psiElement instanceof KtWhenExpression) {
                                            if (!Intrinsics.areEqual((Object)((KtWhenExpression)parent2).getSubjectExpression(), (Object)child)) return false;
                                            List<KtWhenEntry> list5 = ((KtWhenExpression)parent2).getEntries();
                                            Intrinsics.checkNotNullExpressionValue(list5, (String)"parent.entries");
                                            KtWhenEntry ktWhenEntry = (KtWhenEntry)CollectionsKt.firstOrNull(list5);
                                            if (ktWhenEntry == null) return false;
                                            if (ktWhenEntry.isElse()) return false;
                                            return true;
                                        }
                                        if (psiElement instanceof KtThrowExpression) {
                                            bl = Intrinsics.areEqual((Object)((KtThrowExpression)parent2).getThrownExpression(), (Object)child);
                                            return bl;
                                        } else {
                                            if (psiElement instanceof KtTryExpression) {
                                                if (!Intrinsics.areEqual((Object)((KtTryExpression)parent2).getTryBlock(), (Object)child)) {
                                                    List<KtCatchClause> list6 = ((KtTryExpression)parent2).getCatchClauses();
                                                    Intrinsics.checkNotNullExpressionValue(list6, (String)"parent.catchClauses");
                                                    if (!CollectionsKt.contains((Iterable)list6, (Object)child)) return false;
                                                }
                                                if (!this.isUsed(parent2)) return false;
                                                return true;
                                            }
                                            if (psiElement instanceof KtIfExpression) {
                                                if (Intrinsics.areEqual((Object)((KtIfExpression)parent2).getCondition(), (Object)child)) return true;
                                                if (!Intrinsics.areEqual((Object)((KtIfExpression)parent2).getThen(), (Object)child)) {
                                                    if (!Intrinsics.areEqual((Object)((KtIfExpression)parent2).getElse(), (Object)child)) return false;
                                                }
                                                if (!this.isUsed(parent2)) return false;
                                                return true;
                                            }
                                            if (psiElement instanceof KtForExpression) {
                                                bl = Intrinsics.areEqual((Object)((KtForExpression)parent2).getLoopRange(), (Object)child);
                                                return bl;
                                            } else if (psiElement instanceof KtWhileExpressionBase) {
                                                bl = Intrinsics.areEqual((Object)((KtWhileExpressionBase)parent2).getCondition(), (Object)child);
                                                return bl;
                                            } else if (psiElement instanceof KtReturnExpression) {
                                                bl = Intrinsics.areEqual((Object)((KtReturnExpression)parent2).getReturnedExpression(), (Object)child);
                                                return bl;
                                            } else {
                                                if (psiElement instanceof KtLabeledExpression) {
                                                    if (!Intrinsics.areEqual((Object)((KtLabeledExpression)parent2).getBaseExpression(), (Object)child)) return false;
                                                    if (!this.isUsed(parent2)) return false;
                                                    return true;
                                                }
                                                if (psiElement instanceof KtConstantExpression) {
                                                    return false;
                                                }
                                                if (psiElement instanceof KtAnonymousInitializer) {
                                                    return false;
                                                }
                                                if (psiElement instanceof KtPrimaryConstructor) {
                                                    return false;
                                                }
                                                if (psiElement instanceof KtSecondaryConstructor) {
                                                    return false;
                                                }
                                                if (psiElement instanceof KtClassLikeDeclaration) {
                                                    return false;
                                                }
                                                if (psiElement instanceof KtSimpleNameExpression) {
                                                    return false;
                                                }
                                                if (psiElement instanceof KtConstructorDelegationReferenceExpression) {
                                                    return false;
                                                }
                                                if (psiElement instanceof KtObjectLiteralExpression) {
                                                    return false;
                                                }
                                                if (psiElement instanceof KtBreakExpression) {
                                                    return false;
                                                }
                                                if (psiElement instanceof KtContinueExpression) {
                                                    return false;
                                                }
                                                if (psiElement instanceof KtSuperExpression) {
                                                    return false;
                                                }
                                                if (psiElement instanceof KtThisExpression) {
                                                    return false;
                                                }
                                                if (!(psiElement instanceof KtStringTemplateExpression)) throw new IllegalStateException(("Unhandled KtElement subtype: " + Reflection.getOrCreateKotlinClass(parent2.getClass())).toString());
                                                return false;
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }
}

