/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.inline.clean;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.js.backend.ast.HasName;
import org.jetbrains.kotlin.js.backend.ast.JsContext;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsPropertyInitializer;
import org.jetbrains.kotlin.js.backend.ast.JsVisitorWithContextImpl;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.inline.clean.ReferenceTracker;
import org.jetbrains.kotlin.js.inline.util.CollectUtilsKt;
import org.jetbrains.kotlin.js.inline.util.CollectionUtilsKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\u0010\u0006J\u001c\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00052\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u0013H\u0016J\u001c\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00142\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u0013H\u0016J\u0012\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0002J\u0006\u0010\u0019\u001a\u00020\u0010J\u0018\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u0005H\u0002J\u0010\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u0005H\u0002J\u001c\u0010\u001e\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u00052\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u0013H\u0016J\u001c\u0010\u001e\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u001f2\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u0013H\u0016J\u0012\u0010 \u001a\u00020\u00162\b\u0010\u001c\u001a\u0004\u0018\u00010\u0005H\u0002R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/js/inline/clean/UnusedLocalFunctionsCollector;", "Lorg/jetbrains/kotlin/js/backend/ast/JsVisitorWithContextImpl;", "functions", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "Lorg/jetbrains/kotlin/js/backend/ast/JsFunction;", "(Ljava/util/Map;)V", "processed", "", "removableFunctions", "", "getRemovableFunctions", "()Ljava/util/List;", "tracker", "Lorg/jetbrains/kotlin/js/inline/clean/ReferenceTracker;", "endVisit", "", "x", "ctx", "Lorg/jetbrains/kotlin/js/backend/ast/JsContext;", "Lorg/jetbrains/kotlin/js/backend/ast/JsNameRef;", "isFunctionReference", "", "nameRef", "Lorg/jetbrains/kotlin/js/backend/ast/HasName;", "process", "processLocalFunction", "name", "function", "processNonLocalFunction", "visit", "Lorg/jetbrains/kotlin/js/backend/ast/JsPropertyInitializer;", "wasProcessed", "js.translator"})
@SourceDebugExtension(value={"SMAP\nremoveUnusedFunctionDefinitions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 removeUnusedFunctionDefinitions.kt\norg/jetbrains/kotlin/js/inline/clean/UnusedLocalFunctionsCollector\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,114:1\n515#2:115\n500#2,6:116\n215#3,2:122\n*S KotlinDebug\n*F\n+ 1 removeUnusedFunctionDefinitions.kt\norg/jetbrains/kotlin/js/inline/clean/UnusedLocalFunctionsCollector\n*L\n59#1:115\n59#1:116,6\n60#1:122,2\n*E\n"})
final class UnusedLocalFunctionsCollector
extends JsVisitorWithContextImpl {
    @NotNull
    private final Map<JsName, JsFunction> functions;
    @NotNull
    private final ReferenceTracker<JsName, JsFunction> tracker;
    @NotNull
    private final Set<JsFunction> processed;

    public UnusedLocalFunctionsCollector(@NotNull Map<JsName, JsFunction> functions2) {
        Intrinsics.checkNotNullParameter(functions2, (String)"functions");
        this.functions = functions2;
        this.tracker = new ReferenceTracker();
        this.processed = CollectionUtilsKt.IdentitySet();
    }

    @NotNull
    public final List<JsFunction> getRemovableFunctions() {
        return this.tracker.getRemovable();
    }

    public final void process() {
        Iterator $this$filterTo$iv$iv;
        Map<JsName, JsFunction> $this$filter$iv = this.functions;
        boolean $i$f$filter = false;
        Map<JsName, JsFunction> map = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator2 = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator2.next();
            boolean bl = false;
            if (!MetadataProperties.isLocal((JsFunction)it.getValue())) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Map $this$forEach$iv = destination$iv$iv;
        boolean $i$f$forEach = false;
        $this$filterTo$iv$iv = $this$forEach$iv.entrySet().iterator();
        while ($this$filterTo$iv$iv.hasNext()) {
            Map.Entry element$iv;
            Map.Entry it = element$iv = $this$filterTo$iv$iv.next();
            boolean bl = false;
            this.tracker.addCandidateForRemoval((JsName)it.getKey(), (JsFunction)((JsNode)it.getValue()));
        }
        for (Map.Entry<JsName, JsFunction> entry : this.functions.entrySet()) {
            JsName name2 = entry.getKey();
            JsFunction function2 = entry.getValue();
            if (MetadataProperties.isLocal(function2)) {
                this.processLocalFunction(name2, function2);
            } else {
                this.processNonLocalFunction(function2);
            }
            this.processed.add(function2);
        }
    }

    public boolean visit(@NotNull JsPropertyInitializer x, @NotNull JsContext<?> ctx) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        Intrinsics.checkNotNullParameter(ctx, (String)"ctx");
        JsExpression jsExpression = x.getValueExpr();
        Intrinsics.checkNotNullExpressionValue((Object)jsExpression, (String)"x.valueExpr");
        JsExpression value2 = jsExpression;
        return value2 instanceof JsFunction ? !this.wasProcessed((JsFunction)value2) : super.visit(x, ctx);
    }

    public boolean visit(@NotNull JsFunction x, @NotNull JsContext<?> ctx) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        Intrinsics.checkNotNullParameter(ctx, (String)"ctx");
        return !this.wasProcessed(x);
    }

    public void endVisit(@NotNull JsFunction x, @NotNull JsContext<?> ctx) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        Intrinsics.checkNotNullParameter(ctx, (String)"ctx");
        this.processed.add(x);
    }

    public void endVisit(@NotNull JsNameRef x, @NotNull JsContext<?> ctx) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        Intrinsics.checkNotNullParameter(ctx, (String)"ctx");
        JsName name2 = x.getName();
        if (this.isFunctionReference(x) && name2 != null) {
            this.tracker.markReachable(name2);
        }
    }

    private final void processLocalFunction(JsName name2, JsFunction function2) {
        for (JsName referenced : CollectUtilsKt.collectReferencedNames(function2)) {
            this.tracker.addRemovableReference(name2, referenced);
        }
    }

    private final void processNonLocalFunction(JsFunction function2) {
        for (JsName referenced : CollectUtilsKt.collectReferencedNames(function2)) {
            this.tracker.markReachable(referenced);
        }
    }

    private final boolean isFunctionReference(HasName nameRef) {
        Object object = nameRef;
        return (object != null && (object = object.getName()) != null ? MetadataProperties.getStaticRef((JsName)object) : null) instanceof JsFunction;
    }

    private final boolean wasProcessed(JsFunction function2) {
        return function2 != null && this.processed.contains(function2);
    }
}

