/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental;

import java.io.File;
import java.nio.file.Path;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.compilerRunner.OutputItemsCollector;
import org.jetbrains.kotlin.incremental.CompilationTransaction;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0005J\u001e\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\nH\u0016R\u000e\u0010\u0004\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/incremental/TransactionOutputsRegistrar;", "Lorg/jetbrains/kotlin/compilerRunner/OutputItemsCollector;", "transaction", "Lorg/jetbrains/kotlin/incremental/CompilationTransaction;", "origin", "(Lorg/jetbrains/kotlin/incremental/CompilationTransaction;Lorg/jetbrains/kotlin/compilerRunner/OutputItemsCollector;)V", "add", "", "sourceFiles", "", "Ljava/io/File;", "outputFile", "kotlin-build-common"})
public final class TransactionOutputsRegistrar
implements OutputItemsCollector {
    @NotNull
    private final CompilationTransaction transaction;
    @NotNull
    private final OutputItemsCollector origin;

    public TransactionOutputsRegistrar(@NotNull CompilationTransaction transaction, @NotNull OutputItemsCollector origin) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)origin, (String)"origin");
        this.transaction = transaction;
        this.origin = origin;
    }

    public void add(@NotNull Collection<? extends File> sourceFiles, @NotNull File outputFile) {
        Intrinsics.checkNotNullParameter(sourceFiles, (String)"sourceFiles");
        Intrinsics.checkNotNullParameter((Object)outputFile, (String)"outputFile");
        Path path2 = outputFile.toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"outputFile.toPath()");
        this.transaction.registerAddedOrChangedFile(path2);
        this.origin.add(sourceFiles, outputFile);
    }
}

