/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.dfa.cfg;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.references.FirControlFlowGraphReference;
import org.jetbrains.kotlin.fir.resolve.dfa.FirControlFlowGraphReferenceImpl;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.CFGNode;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.CFGNodeRendererKt;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.CFGNodeWithSubgraphs;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.ControlFlowGraph;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.Edge;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.EnterNodeMarker;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.ExitNodeMarker;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.UnionNodeMarker;
import org.jetbrains.kotlin.fir.visitors.FirVisitorVoid;
import org.jetbrains.kotlin.utils.DFS;
import org.jetbrains.kotlin.utils.Printer;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 $2\u00020\u0001:\u0001$B\u001b\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0014\u0010\u001c\u001a\u00020\u0013*\u00020\f2\u0006\u0010\u001d\u001a\u00020\u000eH\u0002J\f\u0010\u001e\u001a\u00020\u0013*\u00020\fH\u0002J$\u0010\u001f\u001a\u00020\u0013*\u00020\f2\u0016\u0010 \u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\"\u0012\u0004\u0012\u00020\t0!H\u0002J$\u0010#\u001a\u00020\u0013*\u00020\f2\u0016\u0010 \u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\"\u0012\u0004\u0012\u00020\t0!H\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u0004\u0018\u00010\u000e*\u00020\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006%"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/FirControlFlowGraphRenderVisitor;", "Lorg/jetbrains/kotlin/fir/visitors/FirVisitorVoid;", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "renderLevels", "", "(Ljava/lang/StringBuilder;Z)V", "clusterCounter", "", "nodeCounter", "printer", "Lorg/jetbrains/kotlin/utils/Printer;", "style", "", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/Edge;", "getStyle", "(Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/Edge;)Ljava/lang/String;", "visitControlFlowGraphReference", "", "controlFlowGraphReference", "Lorg/jetbrains/kotlin/fir/references/FirControlFlowGraphReference;", "visitElement", "element", "Lorg/jetbrains/kotlin/fir/FirElement;", "visitFile", "file", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "enterCluster", "color", "exitCluster", "renderEdges", "nodes", "", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/CFGNode;", "renderNodes", "Companion", "resolve"})
@SourceDebugExtension(value={"SMAP\nControlFlowGraphRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ControlFlowGraphRenderer.kt\norg/jetbrains/kotlin/fir/resolve/dfa/cfg/FirControlFlowGraphRenderVisitor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,148:1\n1#2:149\n1#2:179\n1477#3:150\n1502#3,3:151\n1505#3,3:161\n1045#3:164\n1549#3:165\n1620#3,3:166\n1603#3,9:169\n1855#3:178\n1856#3:180\n1612#3:181\n1285#3,4:182\n361#4,7:154\n*S KotlinDebug\n*F\n+ 1 ControlFlowGraphRenderer.kt\norg/jetbrains/kotlin/fir/resolve/dfa/cfg/FirControlFlowGraphRenderVisitor\n*L\n111#1:179\n103#1:150\n103#1:151,3\n103#1:161,3\n103#1:164\n104#1:165\n104#1:166,3\n111#1:169,9\n111#1:178\n111#1:180\n111#1:181\n131#1:182,4\n103#1:154,7\n*E\n"})
public final class FirControlFlowGraphRenderVisitor
extends FirVisitorVoid {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean renderLevels;
    @NotNull
    private final Printer printer;
    private int nodeCounter;
    private int clusterCounter;
    @NotNull
    private static final String EDGE = " -> ";
    @NotNull
    private static final String RED = "red";
    @NotNull
    private static final String BLUE = "blue";
    @NotNull
    private static final Regex DIGIT_REGEX = new Regex("\\d");

    public FirControlFlowGraphRenderVisitor(@NotNull StringBuilder builder2, boolean renderLevels) {
        Intrinsics.checkNotNullParameter((Object)builder2, (String)"builder");
        this.renderLevels = renderLevels;
        this.printer = new Printer(builder2);
    }

    public /* synthetic */ FirControlFlowGraphRenderVisitor(StringBuilder stringBuilder2, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        this(stringBuilder2, bl);
    }

    @Override
    public void visitFile(@NotNull FirFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        String name2 = StringsKt.replace$default((String)file2.getName(), (String)".", (String)"_", (boolean)false, (int)4, null);
        if (DIGIT_REGEX.matches((CharSequence)String.valueOf(StringsKt.first((CharSequence)name2)))) {
            name2 = '_' + name2;
        }
        Object[] objectArray = new Object[]{"digraph " + name2 + " {"};
        Printer printer = this.printer.println(objectArray).pushIndent();
        objectArray = new Object[]{"graph [nodesep=3]"};
        Printer printer2 = printer.println(objectArray);
        objectArray = new Object[]{"node [shape=box penwidth=2]"};
        Printer printer3 = printer2.println(objectArray);
        objectArray = new Object[]{"edge [penwidth=2]"};
        printer3.println(objectArray).println(new Object[0]);
        this.visitElement(file2);
        objectArray = new Object[]{"}"};
        this.printer.popIndent().println(objectArray);
    }

    private final void renderNodes(Printer $this$renderNodes, Map<CFGNode<?>, Integer> nodes) {
        String color = RED;
        for (Map.Entry<CFGNode<?>, Integer> entry : nodes.entrySet()) {
            String label;
            CFGNode<?> node = entry.getKey();
            int index2 = ((Number)entry.getValue()).intValue();
            if (node instanceof EnterNodeMarker) {
                this.enterCluster($this$renderNodes, color);
                color = BLUE;
            }
            List attributes2 = new ArrayList();
            Object[] objectArray = new StringBuilder();
            StringBuilder $this$renderNodes_u24lambda_u240 = objectArray;
            boolean bl = false;
            $this$renderNodes_u24lambda_u240.append(StringsKt.replace$default((String)CFGNodeRendererKt.render(node), (String)"\"", (String)"", (boolean)false, (int)4, null));
            if (this.renderLevels) {
                $this$renderNodes_u24lambda_u240.append(" [" + node.getLevel() + ']');
            }
            Intrinsics.checkNotNullExpressionValue((Object)objectArray.toString(), (String)"StringBuilder().apply(builderAction).toString()");
            ((Collection)attributes2).add("label=\"" + label + '\"');
            Object object = node.isDead() ? "gray" : (Intrinsics.areEqual(node, node.getOwner().getEnterNode()) || Intrinsics.areEqual(node, node.getOwner().getExitNode()) ? RED : (objectArray = node instanceof UnionNodeMarker ? "yellow" : null));
            if (objectArray != null) {
                Object it = objectArray;
                boolean bl2 = false;
                ((Collection)attributes2).add("style=\"filled\"");
                ((Collection)attributes2).add("fillcolor=" + (String)it);
            }
            objectArray = new Object[]{index2, CollectionsKt.joinToString$default((Iterable)attributes2, (CharSequence)" ", (CharSequence)" [", (CharSequence)"];", (int)0, null, null, (int)56, null)};
            $this$renderNodes.println(objectArray);
            if (!(node instanceof ExitNodeMarker)) continue;
            this.exitCluster($this$renderNodes);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final String getStyle(Edge $this$style) {
        Object object;
        String string2;
        Object object2 = new String[3];
        object2[0] = !$this$style.getKind().getUsedInDfa() && !$this$style.getKind().getUsedInDeadDfa() ? "color=green" : (!$this$style.getKind().getUsedInCfa() ? "color=red" : null);
        object2[1] = $this$style.getKind().isDead() ? "style=dotted" : ($this$style.getKind().isBack() ? "style=dashed" : null);
        Object[] objectArray = object2;
        int n = 2;
        String string3 = $this$style.getLabel().getLabel();
        if (string3 != null) {
            void it;
            String string4 = string3;
            int n2 = n;
            Object[] objectArray2 = objectArray;
            boolean bl = false;
            String string5 = "label=\"" + (String)it + '\"';
            objectArray = objectArray2;
            n = n2;
            string2 = string5;
        } else {
            string2 = null;
        }
        objectArray[n] = string2;
        object2 = CollectionsKt.listOfNotNull((Object[])object2);
        if (object2.isEmpty()) {
            boolean bl = false;
            object = null;
        } else {
            object = object2;
        }
        List list2 = (List)object;
        return list2 != null ? CollectionsKt.joinToString$default((Iterable)list2, (CharSequence)" ", (CharSequence)"[", (CharSequence)"]", (int)0, null, null, (int)56, null) : null;
    }

    /*
     * WARNING - void declaration
     */
    private final void renderEdges(Printer $this$renderEdges, Map<CFGNode<?>, Integer> nodes) {
        for (Map.Entry<CFGNode<?>, Integer> entry : nodes.entrySet()) {
            void $this$mapNotNullTo$iv$iv;
            Object[] objectArray;
            Iterable group;
            void $this$groupByTo$iv$iv;
            CFGNode<?> node = entry.getKey();
            int index2 = ((Number)entry.getValue()).intValue();
            Iterable $this$groupBy$iv = node.getFollowingNodes();
            boolean $i$f$groupBy = false;
            Iterable iterable = $this$groupBy$iv;
            Object destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                Object object;
                CFGNode it = (CFGNode)element$iv$iv;
                boolean bl = false;
                String key$iv$iv = this.getStyle(node.edgeTo(it));
                Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl2 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object = answer$iv$iv$iv;
                } else {
                    object = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object;
                list$iv$iv.add(element$iv$iv);
            }
            Object $this$sortedBy$iv2 = destination$iv$iv.entrySet();
            boolean $i$f$sortedBy = false;
            for (Object $this$sortedBy$iv2 : CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv2, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    Map.Entry it = (Map.Entry)a;
                    boolean bl = false;
                    Comparable comparable = (Comparable)((Object)((String)it.getKey()));
                    it = (Map.Entry)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)((String)it.getKey()))));
                }
            })) {
                void $this$mapTo$iv$iv;
                String style = (String)$this$sortedBy$iv2.getKey();
                group = (List)$this$sortedBy$iv2.getValue();
                Object[] $this$map$iv = (Object[])group;
                boolean $i$f$map = false;
                Object[] element$iv$iv = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    CFGNode $i$f$getOrPut = (CFGNode)item$iv$iv;
                    Collection collection = destination$iv$iv2;
                    boolean bl = false;
                    collection.add(((Number)MapsKt.getValue(nodes, (Object)it)).intValue());
                }
                List mappedGroup = CollectionsKt.sorted((Iterable)((List)destination$iv$iv2));
                $this$map$iv = new Object[]{index2, EDGE, CollectionsKt.joinToString$default((Iterable)mappedGroup, (CharSequence)" ", (CharSequence)"{", (CharSequence)"}", (int)0, null, null, (int)56, null)};
                $this$renderEdges.print($this$map$iv);
                if (style != null) {
                    String it;
                    boolean bl = false;
                    objectArray = new Object[]{' ' + it};
                    $this$renderEdges.printWithNoIndent(objectArray);
                }
                $this$map$iv = new Object[]{";"};
                $this$renderEdges.printlnWithNoIndent($this$map$iv);
            }
            if (!(node instanceof CFGNodeWithSubgraphs)) continue;
            Iterable $this$mapNotNull$iv = ((CFGNodeWithSubgraphs)node).getSubGraphs();
            boolean $i$f$mapNotNull = false;
            group = $this$mapNotNull$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            objectArray = $this$forEach$iv$iv$iv.iterator();
            while (objectArray.hasNext()) {
                Integer it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = objectArray.next();
                boolean bl = false;
                ControlFlowGraph it = (ControlFlowGraph)element$iv$iv;
                boolean bl3 = false;
                if (nodes.get(it.getEnterNode()) == null) continue;
                boolean bl4 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List subNodes = CollectionsKt.sorted((Iterable)((List)destination$iv$iv));
            if (!(!((Collection)subNodes).isEmpty())) continue;
            Object[] objectArray2 = new Object[]{index2, EDGE, CollectionsKt.joinToString$default((Iterable)subNodes, (CharSequence)" ", (CharSequence)"{", (CharSequence)"}", (int)0, null, null, (int)56, null)};
            $this$renderEdges.print(objectArray2);
            objectArray2 = new Object[]{" [style=dashed];"};
            $this$renderEdges.printlnWithNoIndent(objectArray2);
        }
    }

    @Override
    public void visitElement(@NotNull FirElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        element.acceptChildren(this);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visitControlFlowGraphReference(@NotNull FirControlFlowGraphReference controlFlowGraphReference) {
        void destination$iv;
        void $this$associateWithTo$iv;
        Intrinsics.checkNotNullParameter((Object)controlFlowGraphReference, (String)"controlFlowGraphReference");
        Object object = controlFlowGraphReference instanceof FirControlFlowGraphReferenceImpl ? (FirControlFlowGraphReferenceImpl)controlFlowGraphReference : null;
        if (object == null || (object = ((FirControlFlowGraphReferenceImpl)object).getControlFlowGraph()) == null) {
            return;
        }
        Object controlFlowGraph = object;
        if (((ControlFlowGraph)controlFlowGraph).isSubGraph()) {
            return;
        }
        List<CFGNode> list2 = DFS.topologicalOrder(CollectionsKt.listOf(((ControlFlowGraph)controlFlowGraph).getEnterNode()), FirControlFlowGraphRenderVisitor::visitControlFlowGraphReference$lambda$9);
        Intrinsics.checkNotNullExpressionValue(list2, (String)"topologicalOrder(listOf(\u2026e)) { it.followingNodes }");
        Iterable iterable = list2;
        Map map = new LinkedHashMap();
        boolean $i$f$associateWithTo = false;
        for (Object element$iv : $this$associateWithTo$iv) {
            CFGNode cFGNode = (CFGNode)element$iv;
            Object t = element$iv;
            void var12_11 = destination$iv;
            boolean bl = false;
            int n = this.nodeCounter;
            this.nodeCounter = n + 1;
            Integer n2 = n;
            var12_11.put(t, n2);
        }
        LinkedHashMap nodes = (LinkedHashMap)destination$iv;
        this.renderNodes(this.printer, nodes);
        this.renderEdges(this.printer, nodes);
        this.printer.println(new Object[0]);
    }

    private final void enterCluster(Printer $this$enterCluster, String color) {
        Object[] objectArray = new Object[1];
        int n = this.clusterCounter;
        this.clusterCounter = n + 1;
        objectArray[0] = "subgraph cluster_" + n + " {";
        $this$enterCluster.println(objectArray);
        $this$enterCluster.pushIndent();
        objectArray = new Object[]{"color=" + color};
        $this$enterCluster.println(objectArray);
    }

    private final void exitCluster(Printer $this$exitCluster) {
        $this$exitCluster.popIndent();
        Object[] objectArray = new Object[]{"}"};
        $this$exitCluster.println(objectArray);
    }

    private static final Iterable visitControlFlowGraphReference$lambda$9(CFGNode it) {
        return it.getFollowingNodes();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/FirControlFlowGraphRenderVisitor$Companion;", "", "()V", "BLUE", "", "DIGIT_REGEX", "Lkotlin/text/Regex;", "EDGE", "RED", "resolve"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

