/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.optimization.temporaryVals;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codegen.inline.InlineCodegenUtilsKt;
import org.jetbrains.kotlin.codegen.optimization.common.InsnSequence;
import org.jetbrains.kotlin.codegen.optimization.common.UtilKt;
import org.jetbrains.kotlin.codegen.optimization.nullCheck.RedundantNullCheckMethodTransformerKt;
import org.jetbrains.kotlin.codegen.optimization.temporaryVals.TemporaryVal;
import org.jetbrains.kotlin.codegen.optimization.temporaryVals.TemporaryValsAnalyzer;
import org.jetbrains.kotlin.codegen.optimization.transformer.MethodTransformer;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.utils.SmartList;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.FieldInsnNode;
import org.jetbrains.org.objectweb.asm.tree.InsnList;
import org.jetbrains.org.objectweb.asm.tree.InsnNode;
import org.jetbrains.org.objectweb.asm.tree.JumpInsnNode;
import org.jetbrains.org.objectweb.asm.tree.LabelNode;
import org.jetbrains.org.objectweb.asm.tree.LdcInsnNode;
import org.jetbrains.org.objectweb.asm.tree.LineNumberNode;
import org.jetbrains.org.objectweb.asm.tree.LocalVariableNode;
import org.jetbrains.org.objectweb.asm.tree.LookupSwitchInsnNode;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;
import org.jetbrains.org.objectweb.asm.tree.TableSwitchInsnNode;
import org.jetbrains.org.objectweb.asm.tree.TryCatchBlockNode;
import org.jetbrains.org.objectweb.asm.tree.VarInsnNode;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0015\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001#B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u001e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0002J\u0010\u0010\u0012\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u0013\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0018\u0010\u001a\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0014\u0010\u001d\u001a\u00020\b*\u00020\n2\u0006\u0010\u001e\u001a\u00020\u000eH\u0002J\u0018\u0010\u001f\u001a\u00020\b*\u00020\n2\n\u0010 \u001a\u00020!\"\u00020\"H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lorg/jetbrains/kotlin/codegen/optimization/temporaryVals/TemporaryVariablesEliminationTransformer;", "Lorg/jetbrains/kotlin/codegen/optimization/transformer/MethodTransformer;", "state", "Lorg/jetbrains/kotlin/codegen/state/GenerationState;", "(Lorg/jetbrains/kotlin/codegen/state/GenerationState;)V", "temporaryValsAnalyzer", "Lorg/jetbrains/kotlin/codegen/optimization/temporaryVals/TemporaryValsAnalyzer;", "isRewritableSafeCallPart", "", "branchInsn", "Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;", "optimizeTemporaryVals", "", "cfg", "Lorg/jetbrains/kotlin/codegen/optimization/temporaryVals/TemporaryVariablesEliminationTransformer$ControlFlowGraph;", "temporaryVals", "", "Lorg/jetbrains/kotlin/codegen/optimization/temporaryVals/TemporaryVal;", "processLabels", "rewriteSafeCallPart", "insnList", "Lorg/jetbrains/org/objectweb/asm/tree/InsnList;", "simplifyKnownSafeCallPatterns", "simplifyTrivialInstructions", "methodNode", "Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "transform", "internalClassName", "", "isIntervening", "context", "matchOpcodes", "opcodes", "", "", "ControlFlowGraph", "backend"})
@SourceDebugExtension(value={"SMAP\nTemporaryVariablesEliminationTransformer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TemporaryVariablesEliminationTransformer.kt\norg/jetbrains/kotlin/codegen/optimization/temporaryVals/TemporaryVariablesEliminationTransformer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,584:1\n1747#2,3:585\n1620#2,3:588\n1726#2,3:593\n1855#2,2:596\n2141#3,2:591\n*S KotlinDebug\n*F\n+ 1 TemporaryVariablesEliminationTransformer.kt\norg/jetbrains/kotlin/codegen/optimization/temporaryVals/TemporaryVariablesEliminationTransformer\n*L\n29#1:585,3\n69#1:588,3\n463#1:593,3\n464#1:596,2\n232#1:591,2\n*E\n"})
public final class TemporaryVariablesEliminationTransformer
extends MethodTransformer {
    @NotNull
    private final GenerationState state;
    @NotNull
    private final TemporaryValsAnalyzer temporaryValsAnalyzer;

    public TemporaryVariablesEliminationTransformer(@NotNull GenerationState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        this.state = state;
        this.temporaryValsAnalyzer = new TemporaryValsAnalyzer();
    }

    @Override
    public void transform(@NotNull String internalClassName, @NotNull MethodNode methodNode) {
        boolean bl;
        block6: {
            Intrinsics.checkNotNullParameter((Object)internalClassName, (String)"internalClassName");
            Intrinsics.checkNotNullParameter((Object)methodNode, (String)"methodNode");
            if (!this.state.isIrBackend()) {
                return;
            }
            InsnList insnList = methodNode.instructions;
            Intrinsics.checkNotNullExpressionValue((Object)insnList, (String)"methodNode.instructions");
            Iterable $this$any$iv = (Iterable)insnList;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    AbstractInsnNode it = (AbstractInsnNode)element$iv;
                    boolean bl2 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    if (!InlineCodegenUtilsKt.isSuspendInlineMarker(it)) continue;
                    bl = true;
                    break block6;
                }
                bl = false;
            }
        }
        if (bl) {
            return;
        }
        this.simplifyTrivialInstructions(methodNode);
        ControlFlowGraph cfg = new ControlFlowGraph(methodNode);
        this.processLabels(cfg);
        this.simplifyKnownSafeCallPatterns(cfg);
        List<TemporaryVal> temporaryVals = this.temporaryValsAnalyzer.analyze(internalClassName, methodNode);
        if (!((Collection)temporaryVals).isEmpty()) {
            this.optimizeTemporaryVals(cfg, temporaryVals);
        }
        UtilKt.removeUnusedLocalVariables(methodNode);
    }

    /*
     * WARNING - void declaration
     */
    private final void simplifyTrivialInstructions(MethodNode methodNode) {
        void $this$mapTo$iv;
        InsnList insnList = methodNode.instructions;
        AbstractInsnNode[] abstractInsnNodeArray = insnList.toArray();
        Intrinsics.checkNotNullExpressionValue((Object)abstractInsnNodeArray, (String)"insnList.toArray()");
        for (AbstractInsnNode insn : abstractInsnNodeArray) {
            Object popInsn;
            Intrinsics.checkNotNullExpressionValue((Object)insn, (String)"insn");
            int[] nArray = new int[]{21, 87};
            if (this.matchOpcodes(insn, nArray) || this.matchOpcodes(insn, nArray = new int[]{23, 87}) || this.matchOpcodes(insn, nArray = new int[]{25, 87})) {
                popInsn = insn.getNext();
                insnList.insert(insn, (AbstractInsnNode)new InsnNode(0));
                insnList.remove(insn);
                insnList.remove(popInsn);
                continue;
            }
            popInsn = new int[2];
            popInsn[0] = (AbstractInsnNode)24;
            popInsn[1] = (AbstractInsnNode)88;
            if (!this.matchOpcodes(insn, (int[])popInsn)) {
                popInsn = new int[2];
                popInsn[0] = (AbstractInsnNode)22;
                popInsn[1] = (AbstractInsnNode)88;
                if (!this.matchOpcodes(insn, (int[])popInsn)) continue;
            }
            AbstractInsnNode pop2Insn = insn.getNext();
            insnList.insert(insn, (AbstractInsnNode)new InsnNode(0));
            insnList.remove(insn);
            insnList.remove(pop2Insn);
        }
        List list2 = methodNode.tryCatchBlocks;
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"methodNode.tryCatchBlocks");
        AbstractInsnNode[] abstractInsnNodeArray2 = (AbstractInsnNode[])list2;
        Collection destination$iv = new HashSet();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            TryCatchBlockNode tryCatchBlockNode = (TryCatchBlockNode)item$iv;
            Collection collection = destination$iv;
            boolean bl = false;
            collection.add(it.start);
        }
        HashSet tcbStartLabels = (HashSet)destination$iv;
        AbstractInsnNode[] abstractInsnNodeArray3 = insnList.toArray();
        Intrinsics.checkNotNullExpressionValue((Object)abstractInsnNodeArray3, (String)"insnList.toArray()");
        for (AbstractInsnNode insn : abstractInsnNodeArray3) {
            AbstractInsnNode next;
            AbstractInsnNode prev;
            if (insn.getOpcode() != 0 || CollectionsKt.contains((Iterable)tcbStartLabels, (Object)(prev = insn.getPrevious())) || ((next = insn.getNext()) == null || !UtilKt.isMeaningful(next)) && (prev == null || !UtilKt.isMeaningful(prev))) continue;
            insnList.remove(insn);
        }
    }

    private final void processLabels(ControlFlowGraph cfg) {
        AbstractInsnNode last;
        cfg.reset();
        MethodNode methodNode = cfg.getMethodNode();
        InsnList insnList = methodNode.instructions;
        HashSet<LabelNode> usedLabels = new HashSet<LabelNode>();
        AbstractInsnNode first = insnList.getFirst();
        if (first instanceof LabelNode) {
            usedLabels.add((LabelNode)first);
        }
        if ((last = insnList.getLast()) instanceof LabelNode) {
            usedLabels.add((LabelNode)last);
        }
        for (AbstractInsnNode insn : insnList) {
            switch (insn.getType()) {
                case 15: {
                    Intrinsics.checkNotNull((Object)insn, (String)"null cannot be cast to non-null type org.jetbrains.org.objectweb.asm.tree.LineNumberNode");
                    usedLabels.add(((LineNumberNode)insn).start);
                    break;
                }
                case 7: {
                    Intrinsics.checkNotNullExpressionValue((Object)insn, (String)"insn");
                    LabelNode labelNode = ((JumpInsnNode)insn).label;
                    Intrinsics.checkNotNullExpressionValue((Object)labelNode, (String)"insn as JumpInsnNode).label");
                    TemporaryVariablesEliminationTransformer.processLabels$addCfgEdgeToLabel(usedLabels, cfg, insn, labelNode);
                    break;
                }
                case 12: {
                    Intrinsics.checkNotNull((Object)insn, (String)"null cannot be cast to non-null type org.jetbrains.org.objectweb.asm.tree.LookupSwitchInsnNode");
                    LookupSwitchInsnNode switchInsn = (LookupSwitchInsnNode)insn;
                    LabelNode labelNode = switchInsn.dflt;
                    Intrinsics.checkNotNullExpressionValue((Object)labelNode, (String)"switchInsn.dflt");
                    TemporaryVariablesEliminationTransformer.processLabels$addCfgEdgeToLabel(usedLabels, cfg, insn, labelNode);
                    List list2 = switchInsn.labels;
                    Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"switchInsn.labels");
                    TemporaryVariablesEliminationTransformer.processLabels$addCfgEdgesToLabels(usedLabels, cfg, insn, list2);
                    break;
                }
                case 11: {
                    Intrinsics.checkNotNull((Object)insn, (String)"null cannot be cast to non-null type org.jetbrains.org.objectweb.asm.tree.TableSwitchInsnNode");
                    LookupSwitchInsnNode switchInsn = (TableSwitchInsnNode)insn;
                    LabelNode labelNode = switchInsn.dflt;
                    Intrinsics.checkNotNullExpressionValue((Object)labelNode, (String)"switchInsn.dflt");
                    TemporaryVariablesEliminationTransformer.processLabels$addCfgEdgeToLabel(usedLabels, cfg, insn, labelNode);
                    List list3 = switchInsn.labels;
                    Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"switchInsn.labels");
                    TemporaryVariablesEliminationTransformer.processLabels$addCfgEdgesToLabels(usedLabels, cfg, insn, list3);
                }
            }
        }
        for (LocalVariableNode lv : methodNode.localVariables) {
            usedLabels.add(lv.start);
            usedLabels.add(lv.end);
        }
        for (TryCatchBlockNode tcb : methodNode.tryCatchBlocks) {
            usedLabels.add(tcb.start);
            usedLabels.add(tcb.end);
            LabelNode labelNode = tcb.start;
            Intrinsics.checkNotNullExpressionValue((Object)labelNode, (String)"tcb.start");
            AbstractInsnNode abstractInsnNode = (AbstractInsnNode)labelNode;
            LabelNode labelNode2 = tcb.handler;
            Intrinsics.checkNotNullExpressionValue((Object)labelNode2, (String)"tcb.handler");
            TemporaryVariablesEliminationTransformer.processLabels$addCfgEdgeToLabel(usedLabels, cfg, abstractInsnNode, labelNode2);
        }
        AbstractInsnNode insn = insnList.getFirst();
        while (insn != null) {
            AbstractInsnNode abstractInsnNode;
            if (insn instanceof LabelNode && !usedLabels.contains(insn)) {
                AbstractInsnNode next = ((LabelNode)insn).getNext();
                insnList.remove(insn);
                abstractInsnNode = next;
            } else {
                abstractInsnNode = insn.getNext();
            }
            insn = abstractInsnNode;
        }
    }

    private final void optimizeTemporaryVals(ControlFlowGraph cfg, List<TemporaryVal> temporaryVals) {
        InsnList insnList = cfg.getMethodNode().instructions;
        int maxStackIncrement = 0;
        for (TemporaryVal tmp : temporaryVals) {
            Object loadInsn;
            block12: {
                Object aLoad1;
                Object $this$none$iv;
                VarInsnNode storeInsn;
                block14: {
                    block13: {
                        boolean bl;
                        block11: {
                            if (tmp.getLoadInsns().isEmpty()) {
                                int n;
                                switch (tmp.getStoreInsn().getOpcode()) {
                                    case 54: 
                                    case 56: 
                                    case 58: {
                                        n = 87;
                                        break;
                                    }
                                    default: {
                                        n = 88;
                                    }
                                }
                                int popOpcode = n;
                                insnList.insertBefore((AbstractInsnNode)tmp.getStoreInsn(), (AbstractInsnNode)new InsnNode(popOpcode));
                                insnList.remove((AbstractInsnNode)tmp.getStoreInsn());
                                continue;
                            }
                            if (tmp.getLoadInsns().size() != 1) break block12;
                            storeInsn = tmp.getStoreInsn();
                            loadInsn = tmp.getLoadInsns().get(0);
                            if (Intrinsics.areEqual((Object)storeInsn.getNext(), (Object)loadInsn)) break block13;
                            AbstractInsnNode abstractInsnNode = storeInsn.getNext();
                            Intrinsics.checkNotNullExpressionValue((Object)abstractInsnNode, (String)"storeInsn.next");
                            $this$none$iv = new InsnSequence(abstractInsnNode, (AbstractInsnNode)loadInsn);
                            boolean $i$f$none = false;
                            for (Object element$iv : $this$none$iv) {
                                AbstractInsnNode it = (AbstractInsnNode)element$iv;
                                boolean bl2 = false;
                                if (!this.isIntervening(it, cfg)) continue;
                                bl = false;
                                break block11;
                            }
                            bl = true;
                        }
                        if (!bl) break block14;
                    }
                    insnList.remove((AbstractInsnNode)storeInsn);
                    insnList.remove((AbstractInsnNode)loadInsn);
                    continue;
                }
                $this$none$iv = new int[3];
                $this$none$iv[0] = (Sequence)58;
                $this$none$iv[1] = (Sequence)25;
                $this$none$iv[2] = (Sequence)25;
                if (this.matchOpcodes((AbstractInsnNode)storeInsn, (int[])$this$none$iv)) {
                    AbstractInsnNode abstractInsnNode = storeInsn.getNext();
                    Intrinsics.checkNotNull((Object)abstractInsnNode, (String)"null cannot be cast to non-null type org.jetbrains.org.objectweb.asm.tree.VarInsnNode");
                    aLoad1 = (VarInsnNode)abstractInsnNode;
                    AbstractInsnNode abstractInsnNode2 = aLoad1.getNext();
                    Intrinsics.checkNotNull((Object)abstractInsnNode2, (String)"null cannot be cast to non-null type org.jetbrains.org.objectweb.asm.tree.VarInsnNode");
                    VarInsnNode aLoad2 = (VarInsnNode)abstractInsnNode2;
                    if (Intrinsics.areEqual((Object)aLoad2, (Object)loadInsn)) {
                        insnList.remove((AbstractInsnNode)storeInsn);
                        insnList.remove((AbstractInsnNode)loadInsn);
                        insnList.insert((AbstractInsnNode)aLoad1, (AbstractInsnNode)new InsnNode(95));
                        continue;
                    }
                }
                if (!this.matchOpcodes((AbstractInsnNode)storeInsn, (int)(aLoad1 = new int[]{58, 178, 25}))) continue;
                AbstractInsnNode abstractInsnNode = storeInsn.getNext();
                Intrinsics.checkNotNull((Object)abstractInsnNode, (String)"null cannot be cast to non-null type org.jetbrains.org.objectweb.asm.tree.FieldInsnNode");
                FieldInsnNode getStaticInsn = (FieldInsnNode)abstractInsnNode;
                AbstractInsnNode abstractInsnNode3 = getStaticInsn.getNext();
                Intrinsics.checkNotNull((Object)abstractInsnNode3, (String)"null cannot be cast to non-null type org.jetbrains.org.objectweb.asm.tree.VarInsnNode");
                VarInsnNode aLoad2 = (VarInsnNode)abstractInsnNode3;
                if (!Intrinsics.areEqual((Object)aLoad2, (Object)loadInsn) || Type.getType((String)getStaticInsn.desc).getSize() != 1) continue;
                insnList.remove((AbstractInsnNode)storeInsn);
                insnList.remove((AbstractInsnNode)loadInsn);
                insnList.insert((AbstractInsnNode)getStaticInsn, (AbstractInsnNode)new InsnNode(95));
                continue;
            }
            if (tmp.getLoadInsns().size() != 2) continue;
            VarInsnNode storeInsn = tmp.getStoreInsn();
            loadInsn = new int[5];
            loadInsn[0] = (VarInsnNode)58;
            loadInsn[1] = (VarInsnNode)25;
            loadInsn[2] = (VarInsnNode)18;
            loadInsn[3] = (VarInsnNode)184;
            loadInsn[4] = (VarInsnNode)25;
            if (!this.matchOpcodes((AbstractInsnNode)storeInsn, (int[])loadInsn)) continue;
            AbstractInsnNode aLoad1Insn = storeInsn.getNext();
            AbstractInsnNode ldcInsn = aLoad1Insn.getNext();
            AbstractInsnNode invokeStaticInsn = ldcInsn.getNext();
            AbstractInsnNode aLoad2Insn = invokeStaticInsn.getNext();
            Intrinsics.checkNotNull((Object)aLoad1Insn, (String)"null cannot be cast to non-null type org.jetbrains.org.objectweb.asm.tree.VarInsnNode");
            if (((VarInsnNode)aLoad1Insn).var != tmp.getIndex()) continue;
            Intrinsics.checkNotNull((Object)ldcInsn, (String)"null cannot be cast to non-null type org.jetbrains.org.objectweb.asm.tree.LdcInsnNode");
            if (!(((LdcInsnNode)ldcInsn).cst instanceof String)) continue;
            Intrinsics.checkNotNullExpressionValue((Object)invokeStaticInsn, (String)"invokeStaticInsn");
            if (!RedundantNullCheckMethodTransformerKt.isCheckExpressionValueIsNotNull(invokeStaticInsn) && !RedundantNullCheckMethodTransformerKt.isCheckNotNullWithMessage(invokeStaticInsn)) continue;
            Intrinsics.checkNotNull((Object)aLoad2Insn, (String)"null cannot be cast to non-null type org.jetbrains.org.objectweb.asm.tree.VarInsnNode");
            if (((VarInsnNode)aLoad2Insn).var != tmp.getIndex()) continue;
            insnList.remove((AbstractInsnNode)storeInsn);
            insnList.remove(aLoad1Insn);
            insnList.insertBefore(ldcInsn, (AbstractInsnNode)new InsnNode(89));
            insnList.remove(aLoad2Insn);
            maxStackIncrement = Math.max(maxStackIncrement, 1);
        }
        MethodNode methodNode = cfg.getMethodNode();
        methodNode.maxStack += maxStackIncrement;
    }

    private final void simplifyKnownSafeCallPatterns(ControlFlowGraph cfg) {
        InsnList insnList = cfg.getMethodNode().instructions;
        int maxStackIncrement = 0;
        MethodNode methodNode = insnList.toArray();
        Intrinsics.checkNotNullExpressionValue((Object)methodNode, (String)"insnList.toArray()");
        for (AbstractInsnNode insn : methodNode) {
            AbstractInsnNode it;
            boolean bl;
            List<AbstractInsnNode> predecessors;
            LabelNode ifNullLabel;
            block8: {
                Object aLoad1;
                Intrinsics.checkNotNullExpressionValue((Object)insn, (String)"insn");
                int[] nArray = new int[]{25, 199};
                if (this.matchOpcodes(insn, nArray)) {
                    AbstractInsnNode label1Next;
                    aLoad1 = (VarInsnNode)insn;
                    AbstractInsnNode abstractInsnNode = ((VarInsnNode)insn).getNext();
                    Intrinsics.checkNotNull((Object)abstractInsnNode, (String)"null cannot be cast to non-null type org.jetbrains.org.objectweb.asm.tree.JumpInsnNode");
                    JumpInsnNode ifNonNull = (JumpInsnNode)abstractInsnNode;
                    LabelNode label1 = ifNonNull.label;
                    LabelNode labelNode = ifNonNull.label;
                    Intrinsics.checkNotNullExpressionValue((Object)labelNode, (String)"ifNonNull.label");
                    if (!cfg.hasSinglePredecessor(labelNode, (AbstractInsnNode)ifNonNull) || label1.getNext() == null) continue;
                    if (label1Next.getOpcode() == 25) {
                        VarInsnNode aLoad2 = (VarInsnNode)label1Next;
                        if (aLoad2.var == aLoad1.var) {
                            insnList.insertBefore((AbstractInsnNode)ifNonNull, (AbstractInsnNode)new InsnNode(89));
                            insnList.insert((AbstractInsnNode)ifNonNull, (AbstractInsnNode)new InsnNode(87));
                            insnList.remove((AbstractInsnNode)aLoad2);
                            maxStackIncrement = Math.max(maxStackIncrement, 1);
                            continue;
                        }
                        AbstractInsnNode aLoad2Next = aLoad2.getNext();
                        if (aLoad2Next.getOpcode() != 25) continue;
                        Intrinsics.checkNotNull((Object)aLoad2Next, (String)"null cannot be cast to non-null type org.jetbrains.org.objectweb.asm.tree.VarInsnNode");
                        VarInsnNode aLoad3 = (VarInsnNode)aLoad2Next;
                        if (aLoad3.var != aLoad1.var) continue;
                        insnList.insertBefore((AbstractInsnNode)ifNonNull, (AbstractInsnNode)new InsnNode(89));
                        insnList.insert((AbstractInsnNode)ifNonNull, (AbstractInsnNode)new InsnNode(87));
                        insnList.insert((AbstractInsnNode)aLoad2, (AbstractInsnNode)new InsnNode(95));
                        insnList.remove((AbstractInsnNode)aLoad3);
                        maxStackIncrement = Math.max(maxStackIncrement, 1);
                        continue;
                    }
                    int[] aLoad2 = new int[]{178, 25};
                    if (!this.matchOpcodes(label1Next, aLoad2)) continue;
                    FieldInsnNode getStaticInsn = (FieldInsnNode)label1Next;
                    AbstractInsnNode abstractInsnNode2 = getStaticInsn.getNext();
                    Intrinsics.checkNotNull((Object)abstractInsnNode2, (String)"null cannot be cast to non-null type org.jetbrains.org.objectweb.asm.tree.VarInsnNode");
                    VarInsnNode aLoad3 = (VarInsnNode)abstractInsnNode2;
                    if (Type.getType((String)getStaticInsn.desc).getSize() != 1 || aLoad3.var != aLoad1.var) continue;
                    insnList.insertBefore((AbstractInsnNode)ifNonNull, (AbstractInsnNode)new InsnNode(89));
                    insnList.insert((AbstractInsnNode)ifNonNull, (AbstractInsnNode)new InsnNode(87));
                    insnList.insert((AbstractInsnNode)getStaticInsn, (AbstractInsnNode)new InsnNode(95));
                    insnList.remove((AbstractInsnNode)aLoad3);
                    maxStackIncrement = Math.max(maxStackIncrement, 1);
                    continue;
                }
                aLoad1 = new int[2];
                aLoad1[0] = (VarInsnNode)25;
                aLoad1[1] = (VarInsnNode)198;
                if (!this.matchOpcodes(insn, (int[])aLoad1)) continue;
                AbstractInsnNode abstractInsnNode = insn.getNext();
                Intrinsics.checkNotNull((Object)abstractInsnNode, (String)"null cannot be cast to non-null type org.jetbrains.org.objectweb.asm.tree.JumpInsnNode");
                JumpInsnNode ifNull1 = (JumpInsnNode)abstractInsnNode;
                ifNullLabel = ifNull1.label;
                Intrinsics.checkNotNullExpressionValue((Object)ifNullLabel, (String)"ifNullLabel");
                predecessors = cfg.getAllPredecessors(ifNullLabel);
                Iterable $this$all$iv = predecessors;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        it = (AbstractInsnNode)element$iv;
                        boolean bl2 = false;
                        if (this.isRewritableSafeCallPart(it)) continue;
                        bl = false;
                        break block8;
                    }
                    bl = true;
                }
            }
            if (!bl) continue;
            Iterable $this$forEach$iv = predecessors;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (AbstractInsnNode)element$iv;
                boolean bl3 = false;
                Intrinsics.checkNotNullExpressionValue((Object)insnList, (String)"insnList");
                this.rewriteSafeCallPart(it, insnList);
            }
            insnList.insert((AbstractInsnNode)ifNullLabel, (AbstractInsnNode)new InsnNode(87));
            maxStackIncrement = Math.max(maxStackIncrement, 1);
        }
        MethodNode methodNode2 = cfg.getMethodNode();
        methodNode2.maxStack += maxStackIncrement;
    }

    private final boolean isRewritableSafeCallPart(AbstractInsnNode branchInsn) {
        AbstractInsnNode abstractInsnNode = branchInsn.getPrevious();
        if (abstractInsnNode == null) {
            return false;
        }
        AbstractInsnNode start = abstractInsnNode;
        int[] nArray = new int[]{25, 198};
        if (this.matchOpcodes(start, nArray)) {
            VarInsnNode aLoad1 = (VarInsnNode)start;
            AbstractInsnNode abstractInsnNode2 = ((VarInsnNode)start).getNext();
            Intrinsics.checkNotNull((Object)abstractInsnNode2, (String)"null cannot be cast to non-null type org.jetbrains.org.objectweb.asm.tree.JumpInsnNode");
            JumpInsnNode ifNull = (JumpInsnNode)abstractInsnNode2;
            AbstractInsnNode ifNullNext = ifNull.getNext();
            if (ifNullNext.getOpcode() == 25) {
                Intrinsics.checkNotNull((Object)ifNullNext, (String)"null cannot be cast to non-null type org.jetbrains.org.objectweb.asm.tree.VarInsnNode");
                VarInsnNode aLoad2 = (VarInsnNode)ifNullNext;
                if (aLoad2.var == aLoad1.var) {
                    return true;
                }
                AbstractInsnNode aLoad2Next = aLoad2.getNext();
                if (aLoad2Next.getOpcode() == 25) {
                    Intrinsics.checkNotNull((Object)aLoad2Next, (String)"null cannot be cast to non-null type org.jetbrains.org.objectweb.asm.tree.VarInsnNode");
                    VarInsnNode aLoad3 = (VarInsnNode)aLoad2Next;
                    if (aLoad3.var == aLoad1.var) {
                        return true;
                    }
                }
            } else {
                Intrinsics.checkNotNullExpressionValue((Object)ifNullNext, (String)"ifNullNext");
                int[] aLoad2 = new int[]{178, 25};
                if (this.matchOpcodes(ifNullNext, aLoad2)) {
                    FieldInsnNode getStaticInsn = (FieldInsnNode)ifNullNext;
                    if (Type.getType((String)getStaticInsn.desc).getSize() != 1) {
                        return false;
                    }
                    AbstractInsnNode abstractInsnNode3 = getStaticInsn.getNext();
                    Intrinsics.checkNotNull((Object)abstractInsnNode3, (String)"null cannot be cast to non-null type org.jetbrains.org.objectweb.asm.tree.VarInsnNode");
                    VarInsnNode aLoad22 = (VarInsnNode)abstractInsnNode3;
                    if (aLoad22.var == aLoad1.var) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private final void rewriteSafeCallPart(AbstractInsnNode branchInsn, InsnList insnList) {
        AbstractInsnNode start = branchInsn.getPrevious();
        Intrinsics.checkNotNull((Object)start, (String)"null cannot be cast to non-null type org.jetbrains.org.objectweb.asm.tree.VarInsnNode");
        VarInsnNode aLoad1 = (VarInsnNode)start;
        AbstractInsnNode abstractInsnNode = ((VarInsnNode)start).getNext();
        Intrinsics.checkNotNull((Object)abstractInsnNode, (String)"null cannot be cast to non-null type org.jetbrains.org.objectweb.asm.tree.JumpInsnNode");
        JumpInsnNode ifNull = (JumpInsnNode)abstractInsnNode;
        AbstractInsnNode ifNullNext = ifNull.getNext();
        if (ifNullNext.getOpcode() == 25) {
            Intrinsics.checkNotNull((Object)ifNullNext, (String)"null cannot be cast to non-null type org.jetbrains.org.objectweb.asm.tree.VarInsnNode");
            VarInsnNode aLoad2 = (VarInsnNode)ifNullNext;
            if (aLoad2.var == aLoad1.var) {
                insnList.insertBefore((AbstractInsnNode)ifNull, (AbstractInsnNode)new InsnNode(89));
                insnList.remove((AbstractInsnNode)aLoad2);
                return;
            }
            AbstractInsnNode abstractInsnNode2 = aLoad2.getNext();
            Intrinsics.checkNotNull((Object)abstractInsnNode2, (String)"null cannot be cast to non-null type org.jetbrains.org.objectweb.asm.tree.VarInsnNode");
            VarInsnNode aLoad3 = (VarInsnNode)abstractInsnNode2;
            insnList.insertBefore((AbstractInsnNode)ifNull, (AbstractInsnNode)new InsnNode(89));
            insnList.remove((AbstractInsnNode)aLoad3);
            insnList.insert((AbstractInsnNode)aLoad2, (AbstractInsnNode)new InsnNode(95));
            return;
        }
        AbstractInsnNode aLoad2 = ifNullNext.getNext();
        insnList.insertBefore((AbstractInsnNode)ifNull, (AbstractInsnNode)new InsnNode(89));
        insnList.remove(aLoad2);
        insnList.insert(ifNullNext, (AbstractInsnNode)new InsnNode(95));
    }

    private final boolean matchOpcodes(AbstractInsnNode $this$matchOpcodes, int ... opcodes) {
        AbstractInsnNode insn = $this$matchOpcodes;
        int n = opcodes.length;
        for (int i2 = 0; i2 < n; ++i2) {
            if (insn.getOpcode() != opcodes[i2]) {
                return false;
            }
            if (insn.getNext() != null) continue;
            return false;
        }
        return true;
    }

    private final boolean isIntervening(AbstractInsnNode $this$isIntervening, ControlFlowGraph context) {
        boolean bl;
        switch ($this$isIntervening.getType()) {
            case 14: 
            case 15: {
                bl = false;
                break;
            }
            case 8: {
                Intrinsics.checkNotNull((Object)$this$isIntervening, (String)"null cannot be cast to non-null type org.jetbrains.org.objectweb.asm.tree.LabelNode");
                bl = context.hasNonTrivialPredecessors((LabelNode)$this$isIntervening);
                break;
            }
            case 0: {
                if ($this$isIntervening.getOpcode() != 0) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            default: {
                bl = true;
            }
        }
        return bl;
    }

    private static final void processLabels$addCfgEdgeToLabel(HashSet<LabelNode> usedLabels, ControlFlowGraph $cfg, AbstractInsnNode from2, LabelNode label) {
        usedLabels.add(label);
        $cfg.addNonTrivialPredecessor(label, from2);
    }

    private static final void processLabels$addCfgEdgesToLabels(HashSet<LabelNode> usedLabels, ControlFlowGraph $cfg, AbstractInsnNode from2, Collection<? extends LabelNode> labels2) {
        usedLabels.addAll(labels2);
        for (LabelNode labelNode : labels2) {
            $cfg.addNonTrivialPredecessor(labelNode, from2);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u000bJ\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00122\u0006\u0010\u000f\u001a\u00020\tJ\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\tJ\u0016\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u000bJ\u0006\u0010\u0017\u001a\u00020\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R6\u0010\u0007\u001a*\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\bj\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/codegen/optimization/temporaryVals/TemporaryVariablesEliminationTransformer$ControlFlowGraph;", "", "methodNode", "Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "(Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;)V", "getMethodNode", "()Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "nonTrivialPredecessors", "Ljava/util/HashMap;", "Lorg/jetbrains/org/objectweb/asm/tree/LabelNode;", "", "Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;", "Lkotlin/collections/HashMap;", "addNonTrivialPredecessor", "", "label", "pred", "getAllPredecessors", "", "hasNonTrivialPredecessors", "", "hasSinglePredecessor", "expectedPredecessor", "reset", "backend"})
    @SourceDebugExtension(value={"SMAP\nTemporaryVariablesEliminationTransformer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TemporaryVariablesEliminationTransformer.kt\norg/jetbrains/kotlin/codegen/optimization/temporaryVals/TemporaryVariablesEliminationTransformer$ControlFlowGraph\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,584:1\n361#2,7:585\n*S KotlinDebug\n*F\n+ 1 TemporaryVariablesEliminationTransformer.kt\norg/jetbrains/kotlin/codegen/optimization/temporaryVals/TemporaryVariablesEliminationTransformer$ControlFlowGraph\n*L\n92#1:585,7\n*E\n"})
    private static final class ControlFlowGraph {
        @NotNull
        private final MethodNode methodNode;
        @NotNull
        private final HashMap<LabelNode, List<AbstractInsnNode>> nonTrivialPredecessors;

        public ControlFlowGraph(@NotNull MethodNode methodNode) {
            Intrinsics.checkNotNullParameter((Object)methodNode, (String)"methodNode");
            this.methodNode = methodNode;
            this.nonTrivialPredecessors = new HashMap();
        }

        @NotNull
        public final MethodNode getMethodNode() {
            return this.methodNode;
        }

        public final void reset() {
            this.nonTrivialPredecessors.clear();
        }

        public final void addNonTrivialPredecessor(@NotNull LabelNode label, @NotNull AbstractInsnNode pred) {
            Object object;
            Intrinsics.checkNotNullParameter((Object)label, (String)"label");
            Intrinsics.checkNotNullParameter((Object)pred, (String)"pred");
            Map $this$getOrPut$iv = this.nonTrivialPredecessors;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(label);
            if (value$iv == null) {
                boolean bl = false;
                List answer$iv = new SmartList();
                $this$getOrPut$iv.put(label, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            ((List)object).add(pred);
        }

        public final boolean hasNonTrivialPredecessors(@NotNull LabelNode label) {
            Intrinsics.checkNotNullParameter((Object)label, (String)"label");
            return this.nonTrivialPredecessors.containsKey(label);
        }

        @NotNull
        public final List<AbstractInsnNode> getAllPredecessors(@NotNull LabelNode label) {
            Intrinsics.checkNotNullParameter((Object)label, (String)"label");
            ArrayList<AbstractInsnNode> result2 = new ArrayList<AbstractInsnNode>();
            AbstractInsnNode trivialPredecessor = label.getPrevious();
            if (trivialPredecessor.getOpcode() != 167) {
                int n = trivialPredecessor.getOpcode();
                if (!(172 <= n ? n < 178 : false) && trivialPredecessor.getOpcode() != 191) {
                    result2.add(trivialPredecessor);
                }
            }
            List<AbstractInsnNode> list2 = this.nonTrivialPredecessors.get(label);
            result2.addAll(list2 == null ? (Collection)CollectionsKt.emptyList() : (Collection)list2);
            return result2;
        }

        /*
         * Unable to fully structure code
         */
        public final boolean hasSinglePredecessor(@NotNull LabelNode label, @NotNull AbstractInsnNode expectedPredecessor) {
            Intrinsics.checkNotNullParameter((Object)label, (String)"label");
            Intrinsics.checkNotNullParameter((Object)expectedPredecessor, (String)"expectedPredecessor");
            trivialPredecessor = label.getPrevious();
            if (trivialPredecessor.getOpcode() == 167) ** GOTO lbl-1000
            var4_4 = trivialPredecessor.getOpcode();
            v0 = 172 <= var4_4 ? var4_4 < 178 : false;
            if (v0 || trivialPredecessor.getOpcode() == 191) lbl-1000:
            // 2 sources

            {
                trivialPredecessor = null;
            } else if (!Intrinsics.areEqual((Object)trivialPredecessor, (Object)expectedPredecessor)) {
                return false;
            }
            v1 = this.nonTrivialPredecessors.get(label);
            if (v1 == null) {
                return trivialPredecessor != null;
            }
            nonTrivialPredecessors = v1;
            return nonTrivialPredecessors.size() > 1 ? false : (nonTrivialPredecessors.size() == 0 ? Intrinsics.areEqual((Object)trivialPredecessor, (Object)expectedPredecessor) : trivialPredecessor == null && Intrinsics.areEqual((Object)nonTrivialPredecessors.get(0), (Object)expectedPredecessor) != false);
        }
    }
}

