/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.phaser.NamedCompilerPhase;
import org.jetbrains.kotlin.backend.common.phaser.PhaseBuildersKt;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.lower.ElvisInfo;
import org.jetbrains.kotlin.backend.jvm.lower.JvmSafeCallChainFoldingLoweringKt;
import org.jetbrains.kotlin.backend.jvm.lower.SafeCallInfo;
import org.jetbrains.kotlin.ir.IrBuiltIns;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBlock;
import org.jetbrains.kotlin.ir.expressions.IrBranch;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrWhen;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0007\u001a\u0004\u0018\u00010\b*\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0000\u001a\u0016\u0010\f\u001a\u0004\u0018\u00010\r*\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0000\"-\u0010\u0000\u001a\u001e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001j\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003`\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000e"}, d2={"jvmSafeCallFoldingPhase", "Lorg/jetbrains/kotlin/backend/common/phaser/NamedCompilerPhase;", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "Lorg/jetbrains/kotlin/backend/common/phaser/SameTypeNamedCompilerPhase;", "getJvmSafeCallFoldingPhase", "()Lorg/jetbrains/kotlin/backend/common/phaser/NamedCompilerPhase;", "parseElvis", "Lorg/jetbrains/kotlin/backend/jvm/lower/ElvisInfo;", "Lorg/jetbrains/kotlin/ir/expressions/IrBlock;", "irBuiltIns", "Lorg/jetbrains/kotlin/ir/IrBuiltIns;", "parseSafeCall", "Lorg/jetbrains/kotlin/backend/jvm/lower/SafeCallInfo;", "backend.jvm.lower"})
public final class JvmSafeCallChainFoldingLoweringKt {
    @NotNull
    private static final NamedCompilerPhase<JvmBackendContext, IrFile> jvmSafeCallFoldingPhase = PhaseBuildersKt.makeIrFilePhase$default((Function1)jvmSafeCallFoldingPhase.1.INSTANCE, (String)"JvmSafeCallChainFoldingLowering", (String)"Fold safe call chains to more compact forms", null, null, null, null, null, (int)248, null);

    @NotNull
    public static final NamedCompilerPhase<JvmBackendContext, IrFile> getJvmSafeCallFoldingPhase() {
        return jvmSafeCallFoldingPhase;
    }

    @Nullable
    public static final SafeCallInfo parseSafeCall(@NotNull IrBlock $this$parseSafeCall, @NotNull IrBuiltIns irBuiltIns) {
        Intrinsics.checkNotNullParameter((Object)$this$parseSafeCall, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)irBuiltIns, (String)"irBuiltIns");
        if ($this$parseSafeCall.getStatements().size() != 2) {
            return null;
        }
        IrStatement irStatement = $this$parseSafeCall.getStatements().get(0);
        IrVariable irVariable2 = irStatement instanceof IrVariable ? (IrVariable)irStatement : null;
        if (irVariable2 == null) {
            return null;
        }
        IrVariable tmpVal = irVariable2;
        IrStatement irStatement2 = $this$parseSafeCall.getStatements().get(1);
        IrWhen irWhen = irStatement2 instanceof IrWhen ? (IrWhen)irStatement2 : null;
        if (irWhen == null) {
            return null;
        }
        IrWhen whenExpr = irWhen;
        if (whenExpr.getBranches().size() != 2) {
            return null;
        }
        IrBranch ifNullBranch = whenExpr.getBranches().get(0);
        IrExpression ifNullBranchCondition = ifNullBranch.getCondition();
        if (!(ifNullBranchCondition instanceof IrCall)) {
            return null;
        }
        if (!Intrinsics.areEqual((Object)((IrCall)ifNullBranchCondition).getSymbol(), (Object)irBuiltIns.getEqeqSymbol())) {
            return null;
        }
        IrExpression arg0 = ((IrCall)ifNullBranchCondition).getValueArgument(0);
        if (!(arg0 instanceof IrGetValue) || !Intrinsics.areEqual((Object)((IrGetValue)arg0).getSymbol(), (Object)tmpVal.getSymbol())) {
            return null;
        }
        IrExpression arg1 = ((IrCall)ifNullBranchCondition).getValueArgument(1);
        if (!(arg1 instanceof IrConst) || ((IrConst)arg1).getValue() != null) {
            return null;
        }
        IrExpression ifNullBranchResult = ifNullBranch.getResult();
        if (!(ifNullBranchResult instanceof IrConst) || ((IrConst)ifNullBranchResult).getValue() != null) {
            return null;
        }
        IrBranch ifNotNullBranch = whenExpr.getBranches().get(1);
        return new SafeCallInfo($this$parseSafeCall, tmpVal, ifNullBranch, ifNotNullBranch);
    }

    @Nullable
    public static final ElvisInfo parseElvis(@NotNull IrBlock $this$parseElvis, @NotNull IrBuiltIns irBuiltIns) {
        Intrinsics.checkNotNullParameter((Object)$this$parseElvis, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)irBuiltIns, (String)"irBuiltIns");
        if ($this$parseElvis.getStatements().size() != 2) {
            return null;
        }
        IrStatement irStatement = $this$parseElvis.getStatements().get(0);
        IrVariable irVariable2 = irStatement instanceof IrVariable ? (IrVariable)irStatement : null;
        if (irVariable2 == null) {
            return null;
        }
        IrVariable tmpVal = irVariable2;
        IrStatement irStatement2 = $this$parseElvis.getStatements().get(1);
        IrWhen irWhen = irStatement2 instanceof IrWhen ? (IrWhen)irStatement2 : null;
        if (irWhen == null) {
            return null;
        }
        IrWhen whenExpr = irWhen;
        if (whenExpr.getBranches().size() != 2) {
            return null;
        }
        IrExpression irExpression = tmpVal.getInitializer();
        if (irExpression == null) {
            return null;
        }
        IrExpression elvisLhs = irExpression;
        IrBranch ifNullBranch = whenExpr.getBranches().get(0);
        IrExpression ifNullBranchCondition = ifNullBranch.getCondition();
        if (!(ifNullBranchCondition instanceof IrCall)) {
            return null;
        }
        if (!Intrinsics.areEqual((Object)((IrCall)ifNullBranchCondition).getSymbol(), (Object)irBuiltIns.getEqeqSymbol())) {
            return null;
        }
        IrExpression arg0 = ((IrCall)ifNullBranchCondition).getValueArgument(0);
        if (!(arg0 instanceof IrGetValue) || !Intrinsics.areEqual((Object)((IrGetValue)arg0).getSymbol(), (Object)tmpVal.getSymbol())) {
            return null;
        }
        IrExpression arg1 = ((IrCall)ifNullBranchCondition).getValueArgument(1);
        if (!(arg1 instanceof IrConst) || ((IrConst)arg1).getValue() != null) {
            return null;
        }
        IrExpression elvisRhs = ifNullBranch.getResult();
        IrBranch ifNonNullBranch = whenExpr.getBranches().get(1);
        IrExpression ifNonNullBranchResult = ifNonNullBranch.getResult();
        if (!(ifNonNullBranchResult instanceof IrGetValue) || !Intrinsics.areEqual((Object)((IrGetValue)ifNonNullBranchResult).getSymbol(), (Object)tmpVal.getSymbol())) {
            return null;
        }
        return new ElvisInfo($this$parseElvis, tmpVal, elvisLhs, elvisRhs);
    }
}

