/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.low.level.api.fir.providers;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.low.level.api.fir.LLFirModuleResolveComponents;
import org.jetbrains.kotlin.analysis.low.level.api.fir.providers.LLFirProviderHelper;
import org.jetbrains.kotlin.analysis.providers.KotlinDeclarationProvider;
import org.jetbrains.kotlin.analysis.providers.KotlinPackageProvider;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirBackingField;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.synthetic.FirSyntheticProperty;
import org.jetbrains.kotlin.fir.resolve.providers.FirProvider;
import org.jetbrains.kotlin.fir.resolve.providers.FirProviderKt;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProvider;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProviderInternals;
import org.jetbrains.kotlin.fir.symbols.impl.FirBackingFieldSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirSyntheticPropertySymbol;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001)B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0016\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\n\u0010\u001e\u001a\u0006\u0012\u0002\b\u00030\u001fH\u0016J\u0012\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\"\u001a\u00020#H\u0016J\u0014\u0010$\u001a\u00020\u001d2\n\u0010\u001e\u001a\u0006\u0012\u0002\b\u00030%H\u0016J\u0010\u0010$\u001a\u00020\u001d2\u0006\u0010\u001a\u001a\u00020#H\u0016J\u0016\u0010&\u001a\u0004\u0018\u00010\u001d2\n\u0010\u001e\u001a\u0006\u0012\u0002\b\u00030%H\u0016J\u0012\u0010&\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001a\u001a\u00020#H\u0016J\u0016\u0010'\u001a\b\u0012\u0004\u0012\u00020\u001d0(2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u0014X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006*"}, d2={"Lorg/jetbrains/kotlin/analysis/low/level/api/fir/providers/LLFirProvider;", "Lorg/jetbrains/kotlin/fir/resolve/providers/FirProvider;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "moduleComponents", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/LLFirModuleResolveComponents;", "declarationProvider", "Lorg/jetbrains/kotlin/analysis/providers/KotlinDeclarationProvider;", "packageProvider", "Lorg/jetbrains/kotlin/analysis/providers/KotlinPackageProvider;", "canContainKotlinPackage", "", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/analysis/low/level/api/fir/LLFirModuleResolveComponents;Lorg/jetbrains/kotlin/analysis/providers/KotlinDeclarationProvider;Lorg/jetbrains/kotlin/analysis/providers/KotlinPackageProvider;Z)V", "isPhasedFirAllowed", "()Z", "providerHelper", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/providers/LLFirProviderHelper;", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "symbolProvider", "Lorg/jetbrains/kotlin/fir/resolve/providers/FirSymbolProvider;", "getSymbolProvider", "()Lorg/jetbrains/kotlin/fir/resolve/providers/FirSymbolProvider;", "getClassNamesInPackage", "", "Lorg/jetbrains/kotlin/name/Name;", "fqName", "Lorg/jetbrains/kotlin/name/FqName;", "getFirCallableContainerFile", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "symbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "getFirClassifierByFqName", "Lorg/jetbrains/kotlin/fir/declarations/FirClassLikeDeclaration;", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "getFirClassifierContainerFile", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassLikeSymbol;", "getFirClassifierContainerFileIfAny", "getFirFilesByPackage", "", "SymbolProvider", "low-level-api-fir"})
@SourceDebugExtension(value={"SMAP\nLLFirProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LLFirProvider.kt\norg/jetbrains/kotlin/analysis/low/level/api/fir/providers/LLFirProvider\n+ 2 ClassMembers.kt\norg/jetbrains/kotlin/fir/ClassMembersKt\n*L\n1#1,121:1\n60#2:122\n*S KotlinDebug\n*F\n+ 1 LLFirProvider.kt\norg/jetbrains/kotlin/analysis/low/level/api/fir/providers/LLFirProvider\n*L\n70#1:122\n*E\n"})
public final class LLFirProvider
extends FirProvider {
    @NotNull
    private final FirSession session;
    @NotNull
    private final LLFirModuleResolveComponents moduleComponents;
    @NotNull
    private final KotlinDeclarationProvider declarationProvider;
    @NotNull
    private final FirSymbolProvider symbolProvider;
    @NotNull
    private final LLFirProviderHelper providerHelper;

    public LLFirProvider(@NotNull FirSession session2, @NotNull LLFirModuleResolveComponents moduleComponents, @NotNull KotlinDeclarationProvider declarationProvider, @NotNull KotlinPackageProvider packageProvider, boolean canContainKotlinPackage) {
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        Intrinsics.checkNotNullParameter((Object)moduleComponents, (String)"moduleComponents");
        Intrinsics.checkNotNullParameter((Object)declarationProvider, (String)"declarationProvider");
        Intrinsics.checkNotNullParameter((Object)packageProvider, (String)"packageProvider");
        this.session = session2;
        this.moduleComponents = moduleComponents;
        this.declarationProvider = declarationProvider;
        this.symbolProvider = new SymbolProvider();
        this.providerHelper = new LLFirProviderHelper(this.session, this.moduleComponents.getFirFileBuilder(), this.declarationProvider, packageProvider, canContainKotlinPackage);
    }

    @NotNull
    public final FirSession getSession() {
        return this.session;
    }

    @Override
    @NotNull
    public FirSymbolProvider getSymbolProvider() {
        return this.symbolProvider;
    }

    @Override
    public boolean isPhasedFirAllowed() {
        return true;
    }

    @Override
    @Nullable
    public FirClassLikeDeclaration getFirClassifierByFqName(@NotNull ClassId classId) {
        Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
        return this.providerHelper.getFirClassifierByFqName(classId);
    }

    @Override
    @NotNull
    public FirFile getFirClassifierContainerFile(@NotNull ClassId fqName2) {
        Intrinsics.checkNotNullParameter((Object)fqName2, (String)"fqName");
        FirFile firFile = this.getFirClassifierContainerFileIfAny(fqName2);
        if (firFile == null) {
            throw new IllegalStateException(("Couldn't find container for " + fqName2).toString());
        }
        return firFile;
    }

    @Override
    @Nullable
    public FirFile getFirClassifierContainerFileIfAny(@NotNull ClassId fqName2) {
        Intrinsics.checkNotNullParameter((Object)fqName2, (String)"fqName");
        FirClassLikeDeclaration firClassLikeDeclaration = this.getFirClassifierByFqName(fqName2);
        if (firClassLikeDeclaration == null) {
            return null;
        }
        FirClassLikeDeclaration fir = firClassLikeDeclaration;
        return this.moduleComponents.getCache().getContainerFirFile(fir);
    }

    @Override
    @NotNull
    public FirFile getFirClassifierContainerFile(@NotNull FirClassLikeSymbol<?> symbol2) {
        Intrinsics.checkNotNullParameter(symbol2, (String)"symbol");
        FirFile firFile = this.getFirClassifierContainerFileIfAny(symbol2);
        if (firFile == null) {
            throw new IllegalStateException(("Couldn't find container for " + symbol2.getClassId()).toString());
        }
        return firFile;
    }

    @Override
    @Nullable
    public FirFile getFirClassifierContainerFileIfAny(@NotNull FirClassLikeSymbol<?> symbol2) {
        Intrinsics.checkNotNullParameter(symbol2, (String)"symbol");
        return this.moduleComponents.getCache().getContainerFirFile((FirDeclaration)symbol2.getFir());
    }

    @Override
    @Nullable
    public FirFile getFirCallableContainerFile(@NotNull FirCallableSymbol<?> symbol2) {
        FirCallableSymbol<? extends FirCallableDeclaration> firCallableSymbol;
        FirCallableDeclaration firCallableDeclaration;
        Intrinsics.checkNotNullParameter(symbol2, (String)"symbol");
        FirCallableDeclaration $this$originalForSubstitutionOverride$iv = (FirCallableDeclaration)symbol2.getFir();
        boolean $i$f$getOriginalForSubstitutionOverride = false;
        FirCallableDeclaration firCallableDeclaration2 = firCallableDeclaration = ClassMembersKt.isSubstitutionOverride($this$originalForSubstitutionOverride$iv) ? ClassMembersKt.getOriginalForSubstitutionOverrideAttr($this$originalForSubstitutionOverride$iv) : null;
        if (firCallableDeclaration != null && (firCallableSymbol = firCallableDeclaration.getSymbol()) != null) {
            FirCallableSymbol<? extends FirCallableDeclaration> originalSymbol = firCallableSymbol;
            boolean bl = false;
            return FirProviderKt.getFirProvider(originalSymbol.getModuleData().getSession()).getFirCallableContainerFile(originalSymbol);
        }
        FirCallableDeclaration fir = (FirCallableDeclaration)symbol2.getFir();
        return symbol2 instanceof FirBackingFieldSymbol ? this.getFirCallableContainerFile(((FirBackingField)((FirBackingFieldSymbol)symbol2).getFir()).getPropertySymbol()) : (symbol2 instanceof FirSyntheticPropertySymbol && fir instanceof FirSyntheticProperty ? this.getFirCallableContainerFile(((FirSyntheticProperty)fir).getGetter().getDelegate().getSymbol()) : this.moduleComponents.getCache().getContainerFirFile((FirDeclaration)symbol2.getFir()));
    }

    @Override
    @NotNull
    public List<FirFile> getFirFilesByPackage(@NotNull FqName fqName2) {
        Intrinsics.checkNotNullParameter((Object)fqName2, (String)"fqName");
        throw new IllegalStateException("Should not be called in FIR IDE".toString());
    }

    @Override
    @NotNull
    public Set<Name> getClassNamesInPackage(@NotNull FqName fqName2) {
        Intrinsics.checkNotNullParameter((Object)fqName2, (String)"fqName");
        return this.declarationProvider.getTopLevelKotlinClassLikeDeclarationNamesInPackage(fqName2);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\bH\u0016J\"\u0010\n\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f0\u000b2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J*\u0010\u0010\u001a\u00020\u00112\u0010\u0010\u0012\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f0\u00132\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0017J\u001e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u000b2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J&\u0010\u0016\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00150\u00132\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0017J\u001e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u000b2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J&\u0010\u0019\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00180\u00132\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0017\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/analysis/low/level/api/fir/providers/LLFirProvider$SymbolProvider;", "Lorg/jetbrains/kotlin/fir/resolve/providers/FirSymbolProvider;", "(Lorg/jetbrains/kotlin/analysis/low/level/api/fir/providers/LLFirProvider;)V", "getClassLikeSymbolByClassId", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassLikeSymbol;", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "getPackage", "Lorg/jetbrains/kotlin/name/FqName;", "fqName", "getTopLevelCallableSymbols", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "packageFqName", "name", "Lorg/jetbrains/kotlin/name/Name;", "getTopLevelCallableSymbolsTo", "", "destination", "", "getTopLevelFunctionSymbols", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirNamedFunctionSymbol;", "getTopLevelFunctionSymbolsTo", "getTopLevelPropertySymbols", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;", "getTopLevelPropertySymbolsTo", "low-level-api-fir"})
    private final class SymbolProvider
    extends FirSymbolProvider {
        public SymbolProvider() {
            super(LLFirProvider.this.getSession());
        }

        @Override
        @NotNull
        public List<FirCallableSymbol<?>> getTopLevelCallableSymbols(@NotNull FqName packageFqName, @NotNull Name name2) {
            Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            return LLFirProvider.this.providerHelper.getTopLevelCallableSymbols(packageFqName, name2);
        }

        @Override
        @FirSymbolProviderInternals
        public void getTopLevelCallableSymbolsTo(@NotNull List<FirCallableSymbol<?>> destination, @NotNull FqName packageFqName, @NotNull Name name2) {
            Intrinsics.checkNotNullParameter(destination, (String)"destination");
            Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            CollectionsKt.addAll((Collection)destination, (Iterable)this.getTopLevelCallableSymbols(packageFqName, name2));
        }

        @Override
        @NotNull
        public List<FirNamedFunctionSymbol> getTopLevelFunctionSymbols(@NotNull FqName packageFqName, @NotNull Name name2) {
            Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            return LLFirProvider.this.providerHelper.getTopLevelFunctionSymbols(packageFqName, name2);
        }

        @Override
        @FirSymbolProviderInternals
        public void getTopLevelFunctionSymbolsTo(@NotNull List<FirNamedFunctionSymbol> destination, @NotNull FqName packageFqName, @NotNull Name name2) {
            Intrinsics.checkNotNullParameter(destination, (String)"destination");
            Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            CollectionsKt.addAll((Collection)destination, (Iterable)this.getTopLevelFunctionSymbols(packageFqName, name2));
        }

        @Override
        @NotNull
        public List<FirPropertySymbol> getTopLevelPropertySymbols(@NotNull FqName packageFqName, @NotNull Name name2) {
            Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            return LLFirProvider.this.providerHelper.getTopLevelPropertySymbols(packageFqName, name2);
        }

        @Override
        @FirSymbolProviderInternals
        public void getTopLevelPropertySymbolsTo(@NotNull List<FirPropertySymbol> destination, @NotNull FqName packageFqName, @NotNull Name name2) {
            Intrinsics.checkNotNullParameter(destination, (String)"destination");
            Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            CollectionsKt.addAll((Collection)destination, (Iterable)this.getTopLevelPropertySymbols(packageFqName, name2));
        }

        @Override
        @Nullable
        public FqName getPackage(@NotNull FqName fqName2) {
            Intrinsics.checkNotNullParameter((Object)fqName2, (String)"fqName");
            return LLFirProvider.this.providerHelper.getPackage(fqName2);
        }

        @Override
        @Nullable
        public FirClassLikeSymbol<?> getClassLikeSymbolByClassId(@NotNull ClassId classId) {
            Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
            FirClassLikeDeclaration firClassLikeDeclaration = LLFirProvider.this.getFirClassifierByFqName(classId);
            return firClassLikeDeclaration != null ? firClassLikeDeclaration.getSymbol() : null;
        }
    }
}

