/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.descriptors.components;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.components.KtImportOptimizer;
import org.jetbrains.kotlin.analysis.api.components.KtImportOptimizerResult;
import org.jetbrains.kotlin.analysis.api.descriptors.KtFe10AnalysisSession;
import org.jetbrains.kotlin.analysis.api.descriptors.components.base.Fe10KtAnalysisSessionComponent;
import org.jetbrains.kotlin.analysis.api.lifetime.KtInaccessibleLifetimeOwnerAccessException;
import org.jetbrains.kotlin.analysis.api.lifetime.KtInvalidLifetimeOwnerAccessException;
import org.jetbrains.kotlin.analysis.api.lifetime.KtLifetimeOwner;
import org.jetbrains.kotlin.analysis.api.lifetime.KtLifetimeToken;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtImportDirective;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/analysis/api/descriptors/components/KtFe10ImportOptimizer;", "Lorg/jetbrains/kotlin/analysis/api/components/KtImportOptimizer;", "Lorg/jetbrains/kotlin/analysis/api/descriptors/components/base/Fe10KtAnalysisSessionComponent;", "analysisSession", "Lorg/jetbrains/kotlin/analysis/api/descriptors/KtFe10AnalysisSession;", "(Lorg/jetbrains/kotlin/analysis/api/descriptors/KtFe10AnalysisSession;)V", "getAnalysisSession", "()Lorg/jetbrains/kotlin/analysis/api/descriptors/KtFe10AnalysisSession;", "token", "Lorg/jetbrains/kotlin/analysis/api/lifetime/KtLifetimeToken;", "getToken", "()Lorg/jetbrains/kotlin/analysis/api/lifetime/KtLifetimeToken;", "analyseImports", "Lorg/jetbrains/kotlin/analysis/api/components/KtImportOptimizerResult;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "analysis-api-fe10"})
@SourceDebugExtension(value={"SMAP\nKtFe10ImportOptimizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KtFe10ImportOptimizer.kt\norg/jetbrains/kotlin/analysis/api/descriptors/components/KtFe10ImportOptimizer\n+ 2 KtLifetimeOwner.kt\norg/jetbrains/kotlin/analysis/api/lifetime/KtLifetimeOwnerKt\n+ 3 KtLifetimeToken.kt\norg/jetbrains/kotlin/analysis/api/lifetime/KtLifetimeTokenKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,46:1\n20#2:47\n16#2:48\n17#2,5:56\n32#3,7:49\n3190#4,10:61\n*S KotlinDebug\n*F\n+ 1 KtFe10ImportOptimizer.kt\norg/jetbrains/kotlin/analysis/api/descriptors/components/KtFe10ImportOptimizer\n*L\n24#1:47\n24#1:48\n24#1:56,5\n24#1:49,7\n25#1:61,10\n*E\n"})
public final class KtFe10ImportOptimizer
extends KtImportOptimizer
implements Fe10KtAnalysisSessionComponent {
    @NotNull
    private final KtFe10AnalysisSession analysisSession;

    public KtFe10ImportOptimizer(@NotNull KtFe10AnalysisSession analysisSession) {
        Intrinsics.checkNotNullParameter((Object)analysisSession, (String)"analysisSession");
        this.analysisSession = analysisSession;
    }

    @Override
    @NotNull
    public KtFe10AnalysisSession getAnalysisSession() {
        return this.analysisSession;
    }

    @Override
    @NotNull
    public KtLifetimeToken getToken() {
        return this.getAnalysisSession().getToken();
    }

    @Override
    @NotNull
    public KtImportOptimizerResult analyseImports(@NotNull KtFile file2) {
        FqName fqName2;
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        KtLifetimeOwner $this$withValidityAssertion$iv = this;
        boolean $i$f$withValidityAssertion = false;
        KtLifetimeOwner $this$assertIsValidAndAccessible$iv$iv = $this$withValidityAssertion$iv;
        boolean $i$f$assertIsValidAndAccessible = false;
        KtLifetimeToken $this$assertIsValidAndAccessible$iv$iv$iv = $this$assertIsValidAndAccessible$iv$iv.getToken();
        boolean $i$f$assertIsValidAndAccessible2 = false;
        if (!$this$assertIsValidAndAccessible$iv$iv$iv.isValid()) {
            throw new KtInvalidLifetimeOwnerAccessException("Access to invalid " + $this$assertIsValidAndAccessible$iv$iv$iv + ": " + $this$assertIsValidAndAccessible$iv$iv$iv.getInvalidationReason());
        }
        if (!$this$assertIsValidAndAccessible$iv$iv$iv.isAccessible()) {
            throw new KtInaccessibleLifetimeOwnerAccessException($this$assertIsValidAndAccessible$iv$iv$iv + " is inaccessible: " + $this$assertIsValidAndAccessible$iv$iv$iv.getInaccessibilityReason());
        }
        boolean bl = false;
        Iterable $this$partition$iv = file2.getImportDirectives();
        boolean $i$f$partition = false;
        ArrayList first$iv = new ArrayList();
        ArrayList second$iv = new ArrayList();
        for (Object element$iv : $this$partition$iv) {
            KtImportDirective it = (KtImportDirective)element$iv;
            boolean bl2 = false;
            if (it.isAllUnder()) {
                first$iv.add(element$iv);
                continue;
            }
            second$iv.add(element$iv);
        }
        Pair pair = new Pair(first$iv, second$iv);
        List allUnderImports = (List)pair.component1();
        List otherImports = (List)pair.component2();
        LinkedHashSet unusedImports = new LinkedHashSet();
        HashSet<FqName> importedPackages = new HashSet<FqName>();
        for (KtImportDirective ktImportDirective : allUnderImports) {
            if (ktImportDirective.getImportedFqName() == null) continue;
            Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"import.importedFqName ?: continue");
            if (importedPackages.add(fqName2)) continue;
            ((Collection)unusedImports).add(ktImportDirective);
        }
        for (KtImportDirective ktImportDirective : otherImports) {
            if (ktImportDirective.getImportedFqName() == null) continue;
            Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"import.importedFqName ?: continue");
            if (ktImportDirective.getAlias() != null || !importedPackages.contains(fqName2.parent())) continue;
            ((Collection)unusedImports).add(ktImportDirective);
        }
        return new KtImportOptimizerResult(unusedImports);
    }
}

