/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.interpreter.intrinsics;

import java.util.List;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.interpreter.IrInterpreterEnvironment;
import org.jetbrains.kotlin.ir.interpreter.UtilsKt;
import org.jetbrains.kotlin.ir.interpreter.intrinsics.IntrinsicBase;
import org.jetbrains.kotlin.ir.interpreter.stack.CallStack;
import org.jetbrains.kotlin.ir.interpreter.state.StateKt;
import org.jetbrains.kotlin.ir.symbols.IrValueParameterSymbol;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u000e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/ir/interpreter/intrinsics/Indent;", "Lorg/jetbrains/kotlin/ir/interpreter/intrinsics/IntrinsicBase;", "()V", "evaluate", "", "irFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "environment", "Lorg/jetbrains/kotlin/ir/interpreter/IrInterpreterEnvironment;", "getListOfAcceptableFunctions", "", "", "ir.interpreter"})
public final class Indent
extends IntrinsicBase {
    @NotNull
    public static final Indent INSTANCE = new Indent();

    private Indent() {
        super(null);
    }

    @Override
    @NotNull
    public List<String> getListOfAcceptableFunctions() {
        Object[] objectArray = new String[]{"kotlin.text.StringsKt.trimIndent", "kotlin.text.trimIndent", "kotlin.text.StringsKt.trimMargin", "kotlin.text.trimMargin", "kotlin.text.StringsKt.trimMargin$default", "kotlin.text.trimMargin$default"};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @Override
    public void evaluate(@NotNull IrFunction irFunction2, @NotNull IrInterpreterEnvironment environment2) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)irFunction2, (String)"irFunction");
        Intrinsics.checkNotNullParameter((Object)environment2, (String)"environment");
        CallStack callStack = environment2.getCallStack$ir_interpreter();
        IrValueParameterSymbol irValueParameterSymbol = UtilsKt.getExtensionReceiver(irFunction2);
        Intrinsics.checkNotNull((Object)irValueParameterSymbol);
        String str = StateKt.asString(callStack.loadState(irValueParameterSymbol));
        switch (UtilsKt.getFqName(irFunction2)) {
            case "kotlin.text.StringsKt.trimIndent": 
            case "kotlin.text.trimIndent": {
                string2 = StringsKt.trimIndent((String)str);
                break;
            }
            case "kotlin.text.StringsKt.trimMargin": 
            case "kotlin.text.trimMargin": {
                String marginPrefix = StateKt.asString(environment2.getCallStack$ir_interpreter().loadState(((IrValueParameter)CollectionsKt.single(irFunction2.getValueParameters())).getSymbol()));
                string2 = StringsKt.trimMargin((String)str, (String)marginPrefix);
                break;
            }
            case "kotlin.text.trimMargin$default": 
            case "kotlin.text.StringsKt.trimMargin$default": {
                string2 = StringsKt.trimMargin$default((String)str, null, (int)1, null);
                break;
            }
            default: {
                String string3 = "unknown trim function";
                throw new NotImplementedError("An operation is not implemented: " + string3);
            }
        }
        String trimmed = string2;
        environment2.getCallStack$ir_interpreter().pushState(environment2.convertToState$ir_interpreter(trimmed, irFunction2.getReturnType()));
    }
}

