/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.fir.components;

import com.intellij.openapi.project.Project;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlinx.collections.immutable.PersistentList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.components.KtImplicitReceiver;
import org.jetbrains.kotlin.analysis.api.components.KtScopeContext;
import org.jetbrains.kotlin.analysis.api.components.KtScopeProvider;
import org.jetbrains.kotlin.analysis.api.fir.KtFirAnalysisSession;
import org.jetbrains.kotlin.analysis.api.fir.KtSymbolByFirBuilder;
import org.jetbrains.kotlin.analysis.api.fir.components.EnumEntryContainingNamesAwareScope;
import org.jetbrains.kotlin.analysis.api.fir.scopes.KtFirDelegatedMemberScope;
import org.jetbrains.kotlin.analysis.api.fir.scopes.KtFirDelegatingScope;
import org.jetbrains.kotlin.analysis.api.fir.scopes.KtFirDelegatingTypeScope;
import org.jetbrains.kotlin.analysis.api.fir.scopes.KtFirFileScope;
import org.jetbrains.kotlin.analysis.api.fir.scopes.KtFirNonStarImportingScope;
import org.jetbrains.kotlin.analysis.api.fir.scopes.KtFirPackageScope;
import org.jetbrains.kotlin.analysis.api.fir.scopes.KtFirStarImportingScope;
import org.jetbrains.kotlin.analysis.api.fir.symbols.KtFirAnonymousObjectSymbol;
import org.jetbrains.kotlin.analysis.api.fir.symbols.KtFirEnumEntrySymbol;
import org.jetbrains.kotlin.analysis.api.fir.symbols.KtFirFileSymbol;
import org.jetbrains.kotlin.analysis.api.fir.symbols.KtFirNamedClassOrObjectSymbol;
import org.jetbrains.kotlin.analysis.api.fir.types.KtFirType;
import org.jetbrains.kotlin.analysis.api.impl.base.scopes.KtCompositeScope;
import org.jetbrains.kotlin.analysis.api.impl.base.scopes.KtCompositeTypeScope;
import org.jetbrains.kotlin.analysis.api.impl.base.scopes.KtEmptyScope;
import org.jetbrains.kotlin.analysis.api.lifetime.KtLifetimeToken;
import org.jetbrains.kotlin.analysis.api.scopes.KtScope;
import org.jetbrains.kotlin.analysis.api.scopes.KtTypeScope;
import org.jetbrains.kotlin.analysis.api.symbols.KtEnumEntrySymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KtFileSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KtPackageSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.markers.KtSymbolWithMembers;
import org.jetbrains.kotlin.analysis.api.types.KtType;
import org.jetbrains.kotlin.analysis.low.level.api.fir.api.LLFirResolveSession;
import org.jetbrains.kotlin.analysis.utils.printer.PsiUtilsKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirEnumEntry;
import org.jetbrains.kotlin.fir.declarations.FirField;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.declarations.FirTowerDataContext;
import org.jetbrains.kotlin.fir.declarations.FirTowerDataElement;
import org.jetbrains.kotlin.fir.declarations.utils.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirAnonymousObjectExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.resolve.ScopeUtilsKt;
import org.jetbrains.kotlin.fir.resolve.calls.FirSyntheticPropertiesScope;
import org.jetbrains.kotlin.fir.resolve.calls.ImplicitReceiverValue;
import org.jetbrains.kotlin.fir.scopes.FakeOverrideTypeCalculator;
import org.jetbrains.kotlin.fir.scopes.FirContainingNamesAwareScope;
import org.jetbrains.kotlin.fir.scopes.FirKotlinScopeProviderKt;
import org.jetbrains.kotlin.fir.scopes.FirScope;
import org.jetbrains.kotlin.fir.scopes.FirTypeScope;
import org.jetbrains.kotlin.fir.scopes.impl.FirAbstractSimpleImportingScope;
import org.jetbrains.kotlin.fir.scopes.impl.FirAbstractStarImportingScope;
import org.jetbrains.kotlin.fir.scopes.impl.FirDeclaredMemberScopeProviderKt;
import org.jetbrains.kotlin.fir.scopes.impl.FirDelegatedMemberScope;
import org.jetbrains.kotlin.fir.scopes.impl.FirLocalScope;
import org.jetbrains.kotlin.fir.scopes.impl.FirPackageMemberScope;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.FirPhaseManagerKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0016\u0010\u001e\u001a\u00020\u00102\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00100 H\u0016J\u0010\u0010!\u001a\u00020\u00102\u0006\u0010\"\u001a\u00020\u000fH\u0016J\u0010\u0010#\u001a\u00020\u00102\u0006\u0010\"\u001a\u00020\u000fH\u0016J\b\u0010$\u001a\u00020\u0010H\u0016J\u0010\u0010%\u001a\u00020\u00102\u0006\u0010&\u001a\u00020\u0013H\u0016J\u0010\u0010'\u001a\u00020\u00102\u0006\u0010\"\u001a\u00020\u000fH\u0016J\u0010\u0010(\u001a\u00020\u00102\u0006\u0010)\u001a\u00020\u0016H\u0016J\u0018\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/H\u0016J\u0010\u00100\u001a\u00020\u00102\u0006\u00101\u001a\u00020\u000fH\u0016J\u0012\u00102\u001a\u0004\u0018\u00010\u001d2\u0006\u00103\u001a\u000204H\u0016J0\u00105\u001a\u0004\u0018\u0001H6\"\u0004\b\u0000\u00106*\u00020\u000f2\u0014\b\u0004\u00107\u001a\u000e\u0012\u0004\u0012\u000209\u0012\u0004\u0012\u0002H608H\u0082\b\u00a2\u0006\u0002\u0010:R\u0014\u0010\u0002\u001a\u00020\u0003X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00100\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00100\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006;"}, d2={"Lorg/jetbrains/kotlin/analysis/api/fir/components/KtFirScopeProvider;", "Lorg/jetbrains/kotlin/analysis/api/components/KtScopeProvider;", "analysisSession", "Lorg/jetbrains/kotlin/analysis/api/fir/KtFirAnalysisSession;", "builder", "Lorg/jetbrains/kotlin/analysis/api/fir/KtSymbolByFirBuilder;", "project", "Lcom/intellij/openapi/project/Project;", "firResolveSession", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/api/LLFirResolveSession;", "(Lorg/jetbrains/kotlin/analysis/api/fir/KtFirAnalysisSession;Lorg/jetbrains/kotlin/analysis/api/fir/KtSymbolByFirBuilder;Lcom/intellij/openapi/project/Project;Lorg/jetbrains/kotlin/analysis/low/level/api/fir/api/LLFirResolveSession;)V", "getAnalysisSession", "()Lorg/jetbrains/kotlin/analysis/api/fir/KtFirAnalysisSession;", "declaredMemberScopeCache", "Ljava/util/IdentityHashMap;", "Lorg/jetbrains/kotlin/analysis/api/symbols/markers/KtSymbolWithMembers;", "Lorg/jetbrains/kotlin/analysis/api/scopes/KtScope;", "delegatedMemberScopeCache", "fileScopeCache", "Lorg/jetbrains/kotlin/analysis/api/symbols/KtFileSymbol;", "memberScopeCache", "packageMemberScopeCache", "Lorg/jetbrains/kotlin/analysis/api/symbols/KtPackageSymbol;", "scopeSession", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "convertToKtScope", "firScope", "Lorg/jetbrains/kotlin/fir/scopes/FirScope;", "convertToKtTypeScope", "Lorg/jetbrains/kotlin/analysis/api/scopes/KtTypeScope;", "getCompositeScope", "subScopes", "", "getDeclaredMemberScope", "classSymbol", "getDelegatedMemberScope", "getEmptyScope", "getFileScope", "fileSymbol", "getMemberScope", "getPackageScope", "packageSymbol", "getScopeContextForPosition", "Lorg/jetbrains/kotlin/analysis/api/components/KtScopeContext;", "originalFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "positionInFakeFile", "Lorg/jetbrains/kotlin/psi/KtElement;", "getStaticMemberScope", "symbol", "getTypeScope", "type", "Lorg/jetbrains/kotlin/analysis/api/types/KtType;", "withFirForScope", "T", "body", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "(Lorg/jetbrains/kotlin/analysis/api/symbols/markers/KtSymbolWithMembers;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "analysis-api-fir"})
public final class KtFirScopeProvider
extends KtScopeProvider {
    @NotNull
    private final KtFirAnalysisSession analysisSession;
    @NotNull
    private final KtSymbolByFirBuilder builder;
    @NotNull
    private final Project project;
    @NotNull
    private final LLFirResolveSession firResolveSession;
    @NotNull
    private final ScopeSession scopeSession;
    @NotNull
    private final IdentityHashMap<KtSymbolWithMembers, KtScope> memberScopeCache;
    @NotNull
    private final IdentityHashMap<KtSymbolWithMembers, KtScope> declaredMemberScopeCache;
    @NotNull
    private final IdentityHashMap<KtSymbolWithMembers, KtScope> delegatedMemberScopeCache;
    @NotNull
    private final IdentityHashMap<KtFileSymbol, KtScope> fileScopeCache;
    @NotNull
    private final IdentityHashMap<KtPackageSymbol, KtScope> packageMemberScopeCache;

    public KtFirScopeProvider(@NotNull KtFirAnalysisSession analysisSession, @NotNull KtSymbolByFirBuilder builder2, @NotNull Project project, @NotNull LLFirResolveSession firResolveSession) {
        Intrinsics.checkNotNullParameter((Object)analysisSession, (String)"analysisSession");
        Intrinsics.checkNotNullParameter((Object)builder2, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)firResolveSession, (String)"firResolveSession");
        this.analysisSession = analysisSession;
        this.builder = builder2;
        this.project = project;
        this.firResolveSession = firResolveSession;
        this.scopeSession = this.getAnalysisSession().getScopeSessionFor(this.getAnalysisSession().getUseSiteSession$analysis_api_fir());
        this.memberScopeCache = new IdentityHashMap();
        this.declaredMemberScopeCache = new IdentityHashMap();
        this.delegatedMemberScopeCache = new IdentityHashMap();
        this.fileScopeCache = new IdentityHashMap();
        this.packageMemberScopeCache = new IdentityHashMap();
    }

    @Override
    @NotNull
    protected KtFirAnalysisSession getAnalysisSession() {
        return this.analysisSession;
    }

    private final <T> T withFirForScope(KtSymbolWithMembers $this$withFirForScope, Function1<? super FirClass, ? extends T> body2) {
        Object object;
        boolean $i$f$withFirForScope = false;
        KtSymbolWithMembers ktSymbolWithMembers = $this$withFirForScope;
        if (ktSymbolWithMembers instanceof KtFirNamedClassOrObjectSymbol) {
            FirPhaseManagerKt.ensureResolved(((KtFirNamedClassOrObjectSymbol)$this$withFirForScope).getFirSymbol(), FirResolvePhase.TYPES);
            object = body2.invoke(((KtFirNamedClassOrObjectSymbol)$this$withFirForScope).getFirSymbol().getFir());
        } else if (ktSymbolWithMembers instanceof KtFirAnonymousObjectSymbol) {
            FirPhaseManagerKt.ensureResolved(((KtFirAnonymousObjectSymbol)$this$withFirForScope).getFirSymbol(), FirResolvePhase.TYPES);
            object = body2.invoke(((KtFirAnonymousObjectSymbol)$this$withFirForScope).getFirSymbol().getFir());
        } else if (ktSymbolWithMembers instanceof KtFirEnumEntrySymbol) {
            FirPhaseManagerKt.ensureResolved(((KtFirEnumEntrySymbol)$this$withFirForScope).getFirSymbol(), FirResolvePhase.IMPLICIT_TYPES_BODY_RESOLVE);
            FirExpression firExpression2 = ((FirEnumEntry)((KtFirEnumEntrySymbol)$this$withFirForScope).getFirSymbol().getFir()).getInitializer();
            if (firExpression2 == null) {
                return null;
            }
            FirExpression initializer2 = firExpression2;
            if (!(initializer2 instanceof FirAnonymousObjectExpression)) {
                boolean bl = false;
                String string2 = "Unexpected enum entry initializer: " + initializer2.getClass();
                throw new IllegalStateException(string2.toString());
            }
            object = body2.invoke((Object)((FirAnonymousObjectExpression)initializer2).getAnonymousObject());
        } else {
            throw new IllegalStateException(new Function0<String>($this$withFirForScope){
                final /* synthetic */ KtSymbolWithMembers $this_withFirForScope;
                {
                    this.$this_withFirForScope = $receiver;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return "Unknown KtSymbolWithDeclarations implementation " + Reflection.getOrCreateKotlinClass(this.$this_withFirForScope.getClass()).getQualifiedName();
                }
            }.toString());
        }
        return (T)object;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public KtScope getMemberScope(@NotNull KtSymbolWithMembers classSymbol2) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)classSymbol2, (String)"classSymbol");
        Map $this$getOrPut$iv = this.memberScopeCache;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(classSymbol2);
        if (value$iv == null) {
            KtScope ktScope;
            FirTypeScope firTypeScope;
            boolean bl;
            FirClass fir;
            boolean bl2 = false;
            KtFirScopeProvider ktFirScopeProvider = this;
            Object $this$withFirForScope$iv = classSymbol2;
            boolean $i$f$withFirForScope = false;
            Object object2 = $this$withFirForScope$iv;
            if (object2 instanceof KtFirNamedClassOrObjectSymbol) {
                FirPhaseManagerKt.ensureResolved(((KtFirNamedClassOrObjectSymbol)$this$withFirForScope$iv).getFirSymbol(), FirResolvePhase.TYPES);
                fir = (FirClass)((KtFirNamedClassOrObjectSymbol)$this$withFirForScope$iv).getFirSymbol().getFir();
                bl = false;
                FirSession firSession = this.getAnalysisSession().getUseSiteSession$analysis_api_fir();
                firTypeScope = FirKotlinScopeProviderKt.unsubstitutedScope(fir, firSession, this.scopeSession, false);
            } else if (object2 instanceof KtFirAnonymousObjectSymbol) {
                FirPhaseManagerKt.ensureResolved(((KtFirAnonymousObjectSymbol)$this$withFirForScope$iv).getFirSymbol(), FirResolvePhase.TYPES);
                fir = (FirClass)((KtFirAnonymousObjectSymbol)$this$withFirForScope$iv).getFirSymbol().getFir();
                bl = false;
                FirSession firSession = this.getAnalysisSession().getUseSiteSession$analysis_api_fir();
                firTypeScope = FirKotlinScopeProviderKt.unsubstitutedScope(fir, firSession, this.scopeSession, false);
            } else if (object2 instanceof KtFirEnumEntrySymbol) {
                FirPhaseManagerKt.ensureResolved(((KtFirEnumEntrySymbol)$this$withFirForScope$iv).getFirSymbol(), FirResolvePhase.IMPLICIT_TYPES_BODY_RESOLVE);
                FirExpression firExpression2 = ((FirEnumEntry)((KtFirEnumEntrySymbol)$this$withFirForScope$iv).getFirSymbol().getFir()).getInitializer();
                if (firExpression2 == null) {
                    firTypeScope = null;
                } else {
                    FirExpression initializer$iv = firExpression2;
                    if (!(initializer$iv instanceof FirAnonymousObjectExpression)) {
                        boolean bl3 = false;
                        String string2 = "Unexpected enum entry initializer: " + initializer$iv.getClass();
                        throw new IllegalStateException(string2.toString());
                    }
                    fir = ((FirAnonymousObjectExpression)initializer$iv).getAnonymousObject();
                    bl = false;
                    FirSession firSession = this.getAnalysisSession().getUseSiteSession$analysis_api_fir();
                    firTypeScope = FirKotlinScopeProviderKt.unsubstitutedScope(fir, firSession, this.scopeSession, false);
                }
            } else {
                throw new IllegalStateException(new /* invalid duplicate definition of identical inner class */.toString());
            }
            FirTypeScope firTypeScope2 = firTypeScope;
            if (firTypeScope2 == null) {
                ktScope = this.getEmptyScope();
            } else {
                EnumEntryContainingNamesAwareScope enumEntryContainingNamesAwareScope;
                void $this$applyIf$iv;
                $this$withFirForScope$iv = firTypeScope2;
                boolean if$iv = classSymbol2 instanceof KtEnumEntrySymbol;
                boolean $i$f$applyIf = false;
                if (if$iv) {
                    FirContainingNamesAwareScope p0 = (FirContainingNamesAwareScope)$this$applyIf$iv;
                    boolean bl4 = false;
                    enumEntryContainingNamesAwareScope = new EnumEntryContainingNamesAwareScope(p0);
                } else {
                    enumEntryContainingNamesAwareScope = $this$applyIf$iv;
                }
                FirContainingNamesAwareScope firScope2 = enumEntryContainingNamesAwareScope;
                ktScope = new KtFirDelegatingScope(firScope2, this.builder, this.getToken());
            }
            KtScope answer$iv = ktScope;
            $this$getOrPut$iv.put(classSymbol2, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        Intrinsics.checkNotNullExpressionValue(object, (String)"memberScopeCache.getOrPu\u2026builder, token)\n        }");
        return (KtScope)object;
    }

    @Override
    @NotNull
    public KtScope getStaticMemberScope(@NotNull KtSymbolWithMembers symbol2) {
        FirContainingNamesAwareScope firContainingNamesAwareScope;
        Intrinsics.checkNotNullParameter((Object)symbol2, (String)"symbol");
        KtFirScopeProvider ktFirScopeProvider = this;
        KtSymbolWithMembers $this$withFirForScope$iv = symbol2;
        boolean $i$f$withFirForScope = false;
        KtSymbolWithMembers ktSymbolWithMembers = $this$withFirForScope$iv;
        if (ktSymbolWithMembers instanceof KtFirNamedClassOrObjectSymbol) {
            FirPhaseManagerKt.ensureResolved(((KtFirNamedClassOrObjectSymbol)$this$withFirForScope$iv).getFirSymbol(), FirResolvePhase.TYPES);
            FirClass fir = (FirClass)((KtFirNamedClassOrObjectSymbol)$this$withFirForScope$iv).getFirSymbol().getFir();
            boolean bl = false;
            FirSession firSession = this.getAnalysisSession().getUseSiteSession$analysis_api_fir();
            firContainingNamesAwareScope = fir.getScopeProvider().getStaticScope(fir, firSession, this.scopeSession);
        } else if (ktSymbolWithMembers instanceof KtFirAnonymousObjectSymbol) {
            FirPhaseManagerKt.ensureResolved(((KtFirAnonymousObjectSymbol)$this$withFirForScope$iv).getFirSymbol(), FirResolvePhase.TYPES);
            FirClass fir = (FirClass)((KtFirAnonymousObjectSymbol)$this$withFirForScope$iv).getFirSymbol().getFir();
            boolean bl = false;
            FirSession firSession = this.getAnalysisSession().getUseSiteSession$analysis_api_fir();
            firContainingNamesAwareScope = fir.getScopeProvider().getStaticScope(fir, firSession, this.scopeSession);
        } else if (ktSymbolWithMembers instanceof KtFirEnumEntrySymbol) {
            FirPhaseManagerKt.ensureResolved(((KtFirEnumEntrySymbol)$this$withFirForScope$iv).getFirSymbol(), FirResolvePhase.IMPLICIT_TYPES_BODY_RESOLVE);
            FirExpression firExpression2 = ((FirEnumEntry)((KtFirEnumEntrySymbol)$this$withFirForScope$iv).getFirSymbol().getFir()).getInitializer();
            if (firExpression2 == null) {
                firContainingNamesAwareScope = null;
            } else {
                FirExpression initializer$iv = firExpression2;
                if (!(initializer$iv instanceof FirAnonymousObjectExpression)) {
                    boolean bl = false;
                    String string2 = "Unexpected enum entry initializer: " + initializer$iv.getClass();
                    throw new IllegalStateException(string2.toString());
                }
                FirClass fir = ((FirAnonymousObjectExpression)initializer$iv).getAnonymousObject();
                boolean bl = false;
                FirSession firSession = this.getAnalysisSession().getUseSiteSession$analysis_api_fir();
                firContainingNamesAwareScope = fir.getScopeProvider().getStaticScope(fir, firSession, this.scopeSession);
            }
        } else {
            throw new IllegalStateException(new /* invalid duplicate definition of identical inner class */.toString());
        }
        if (firContainingNamesAwareScope == null) {
            return this.getEmptyScope();
        }
        FirContainingNamesAwareScope firScope2 = firContainingNamesAwareScope;
        return new KtFirDelegatingScope(firScope2, this.builder, this.getToken());
    }

    @Override
    @NotNull
    public KtScope getDeclaredMemberScope(@NotNull KtSymbolWithMembers classSymbol2) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)classSymbol2, (String)"classSymbol");
        Map $this$getOrPut$iv = this.declaredMemberScopeCache;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(classSymbol2);
        if (value$iv == null) {
            KtScope ktScope;
            FirContainingNamesAwareScope firContainingNamesAwareScope;
            boolean bl = false;
            KtFirScopeProvider ktFirScopeProvider = this;
            KtSymbolWithMembers $this$withFirForScope$iv = classSymbol2;
            boolean $i$f$withFirForScope = false;
            KtSymbolWithMembers ktSymbolWithMembers = $this$withFirForScope$iv;
            if (ktSymbolWithMembers instanceof KtFirNamedClassOrObjectSymbol) {
                FirPhaseManagerKt.ensureResolved(((KtFirNamedClassOrObjectSymbol)$this$withFirForScope$iv).getFirSymbol(), FirResolvePhase.TYPES);
                FirClass it = (FirClass)((KtFirNamedClassOrObjectSymbol)$this$withFirForScope$iv).getFirSymbol().getFir();
                boolean bl2 = false;
                firContainingNamesAwareScope = FirDeclaredMemberScopeProviderKt.declaredMemberScope(this.getAnalysisSession().getUseSiteSession$analysis_api_fir(), it);
            } else if (ktSymbolWithMembers instanceof KtFirAnonymousObjectSymbol) {
                FirPhaseManagerKt.ensureResolved(((KtFirAnonymousObjectSymbol)$this$withFirForScope$iv).getFirSymbol(), FirResolvePhase.TYPES);
                FirClass it = (FirClass)((KtFirAnonymousObjectSymbol)$this$withFirForScope$iv).getFirSymbol().getFir();
                boolean bl3 = false;
                firContainingNamesAwareScope = FirDeclaredMemberScopeProviderKt.declaredMemberScope(this.getAnalysisSession().getUseSiteSession$analysis_api_fir(), it);
            } else if (ktSymbolWithMembers instanceof KtFirEnumEntrySymbol) {
                FirPhaseManagerKt.ensureResolved(((KtFirEnumEntrySymbol)$this$withFirForScope$iv).getFirSymbol(), FirResolvePhase.IMPLICIT_TYPES_BODY_RESOLVE);
                FirExpression firExpression2 = ((FirEnumEntry)((KtFirEnumEntrySymbol)$this$withFirForScope$iv).getFirSymbol().getFir()).getInitializer();
                if (firExpression2 == null) {
                    firContainingNamesAwareScope = null;
                } else {
                    FirExpression initializer$iv = firExpression2;
                    if (!(initializer$iv instanceof FirAnonymousObjectExpression)) {
                        boolean bl4 = false;
                        String string2 = "Unexpected enum entry initializer: " + initializer$iv.getClass();
                        throw new IllegalStateException(string2.toString());
                    }
                    FirClass it = ((FirAnonymousObjectExpression)initializer$iv).getAnonymousObject();
                    boolean bl5 = false;
                    firContainingNamesAwareScope = FirDeclaredMemberScopeProviderKt.declaredMemberScope(this.getAnalysisSession().getUseSiteSession$analysis_api_fir(), it);
                }
            } else {
                throw new IllegalStateException(new /* invalid duplicate definition of identical inner class */.toString());
            }
            if (firContainingNamesAwareScope == null) {
                ktScope = this.getEmptyScope();
            } else {
                FirContainingNamesAwareScope firScope2 = firContainingNamesAwareScope;
                ktScope = new KtFirDelegatingScope(firScope2, this.builder, this.getToken());
            }
            KtScope answer$iv = ktScope;
            $this$getOrPut$iv.put(classSymbol2, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        Intrinsics.checkNotNullExpressionValue(object, (String)"declaredMemberScopeCache\u2026builder, token)\n        }");
        return (KtScope)object;
    }

    @Override
    @NotNull
    public KtScope getDelegatedMemberScope(@NotNull KtSymbolWithMembers classSymbol2) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)classSymbol2, (String)"classSymbol");
        KtScope ktScope = this.getDeclaredMemberScope(classSymbol2);
        Object object2 = ktScope instanceof KtFirDelegatingScope ? (KtFirDelegatingScope)ktScope : null;
        if (object2 == null || (object2 = ((KtFirDelegatingScope)object2).getFirScope()) == null) {
            Object object3;
            Map $this$getOrPut$iv = this.delegatedMemberScopeCache;
            boolean $i$f$getOrPut = false;
            Object value$iv2 = $this$getOrPut$iv.get(classSymbol2);
            if (value$iv2 == null) {
                boolean bl = false;
                KtScope answer$iv = this.getEmptyScope();
                $this$getOrPut$iv.put(classSymbol2, answer$iv);
                object3 = answer$iv;
            } else {
                object3 = value$iv2;
            }
            Intrinsics.checkNotNullExpressionValue(object3, (String)"delegatedMemberScopeCach\u2026mbol) { getEmptyScope() }");
            return (KtScope)object3;
        }
        Object declaredScope = object2;
        Map $this$getOrPut$iv = this.delegatedMemberScopeCache;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(classSymbol2);
        if (value$iv == null) {
            KtScope ktScope2;
            FirDelegatedMemberScope firDelegatedMemberScope;
            boolean bl = false;
            KtFirScopeProvider value$iv2 = this;
            KtSymbolWithMembers $this$withFirForScope$iv = classSymbol2;
            boolean $i$f$withFirForScope = false;
            KtSymbolWithMembers ktSymbolWithMembers = $this$withFirForScope$iv;
            if (ktSymbolWithMembers instanceof KtFirNamedClassOrObjectSymbol) {
                FirPhaseManagerKt.ensureResolved(((KtFirNamedClassOrObjectSymbol)$this$withFirForScope$iv).getFirSymbol(), FirResolvePhase.TYPES);
                FirClass fir = (FirClass)((KtFirNamedClassOrObjectSymbol)$this$withFirForScope$iv).getFirSymbol().getFir();
                boolean bl2 = false;
                List<FirField> delegateFields = FirDeclarationUtilKt.getDelegateFields(fir);
                if (!((Collection)delegateFields).isEmpty()) {
                    FirSession firSession = this.getAnalysisSession().getUseSiteSession$analysis_api_fir();
                    firDelegatedMemberScope = new FirDelegatedMemberScope(firSession, this.scopeSession, fir, (FirContainingNamesAwareScope)declaredScope, delegateFields);
                } else {
                    firDelegatedMemberScope = null;
                }
            } else if (ktSymbolWithMembers instanceof KtFirAnonymousObjectSymbol) {
                FirPhaseManagerKt.ensureResolved(((KtFirAnonymousObjectSymbol)$this$withFirForScope$iv).getFirSymbol(), FirResolvePhase.TYPES);
                FirClass fir = (FirClass)((KtFirAnonymousObjectSymbol)$this$withFirForScope$iv).getFirSymbol().getFir();
                boolean bl3 = false;
                List<FirField> delegateFields = FirDeclarationUtilKt.getDelegateFields(fir);
                if (!((Collection)delegateFields).isEmpty()) {
                    FirSession firSession = this.getAnalysisSession().getUseSiteSession$analysis_api_fir();
                    firDelegatedMemberScope = new FirDelegatedMemberScope(firSession, this.scopeSession, fir, (FirContainingNamesAwareScope)declaredScope, delegateFields);
                } else {
                    firDelegatedMemberScope = null;
                }
            } else if (ktSymbolWithMembers instanceof KtFirEnumEntrySymbol) {
                FirPhaseManagerKt.ensureResolved(((KtFirEnumEntrySymbol)$this$withFirForScope$iv).getFirSymbol(), FirResolvePhase.IMPLICIT_TYPES_BODY_RESOLVE);
                FirExpression firExpression2 = ((FirEnumEntry)((KtFirEnumEntrySymbol)$this$withFirForScope$iv).getFirSymbol().getFir()).getInitializer();
                if (firExpression2 == null) {
                    firDelegatedMemberScope = null;
                } else {
                    FirExpression initializer$iv = firExpression2;
                    if (!(initializer$iv instanceof FirAnonymousObjectExpression)) {
                        boolean bl4 = false;
                        String string2 = "Unexpected enum entry initializer: " + initializer$iv.getClass();
                        throw new IllegalStateException(string2.toString());
                    }
                    FirClass fir = ((FirAnonymousObjectExpression)initializer$iv).getAnonymousObject();
                    boolean bl5 = false;
                    List<FirField> delegateFields = FirDeclarationUtilKt.getDelegateFields(fir);
                    if (!((Collection)delegateFields).isEmpty()) {
                        FirSession firSession = this.getAnalysisSession().getUseSiteSession$analysis_api_fir();
                        firDelegatedMemberScope = new FirDelegatedMemberScope(firSession, this.scopeSession, fir, (FirContainingNamesAwareScope)declaredScope, delegateFields);
                    } else {
                        firDelegatedMemberScope = null;
                    }
                }
            } else {
                throw new IllegalStateException(new /* invalid duplicate definition of identical inner class */.toString());
            }
            if (firDelegatedMemberScope == null) {
                ktScope2 = this.getEmptyScope();
            } else {
                FirDelegatedMemberScope firScope2 = firDelegatedMemberScope;
                ktScope2 = new KtFirDelegatedMemberScope((FirContainingNamesAwareScope)firScope2, this.getToken(), this.builder);
            }
            KtScope answer$iv = ktScope2;
            $this$getOrPut$iv.put(classSymbol2, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        Intrinsics.checkNotNullExpressionValue(object, (String)"delegatedMemberScopeCach\u2026token, builder)\n        }");
        return (KtScope)object;
    }

    @Override
    @NotNull
    public KtScope getFileScope(@NotNull KtFileSymbol fileSymbol) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)fileSymbol, (String)"fileSymbol");
        Map $this$getOrPut$iv = this.fileScopeCache;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(fileSymbol);
        if (value$iv == null) {
            boolean bl = false;
            if (!(fileSymbol instanceof KtFirFileSymbol)) {
                boolean bl2 = false;
                String string2 = "KtFirScopeProvider can only work with KtFirFileSymbol, but " + Reflection.getOrCreateKotlinClass(fileSymbol.getClass()) + " was provided";
                throw new IllegalStateException(string2.toString());
            }
            KtScope answer$iv = new KtFirFileScope((KtFirFileSymbol)fileSymbol, this.getToken(), this.builder);
            $this$getOrPut$iv.put(fileSymbol, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (KtScope)object;
    }

    @Override
    @NotNull
    public KtScope getEmptyScope() {
        return new KtEmptyScope(this.getToken());
    }

    @Override
    @NotNull
    public KtScope getPackageScope(@NotNull KtPackageSymbol packageSymbol) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)packageSymbol, (String)"packageSymbol");
        Map $this$getOrPut$iv = this.packageMemberScopeCache;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(packageSymbol);
        if (value$iv == null) {
            boolean bl = false;
            FqName fqName2 = packageSymbol.getFqName();
            KtLifetimeToken ktLifetimeToken = this.getToken();
            GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope((Project)this.project);
            Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"allScope(project)");
            KtScope answer$iv = new KtFirPackageScope(fqName2, this.project, this.builder, ktLifetimeToken, globalSearchScope, this.getAnalysisSession().getTargetPlatform$analysis_api_fir());
            $this$getOrPut$iv.put(packageSymbol, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (KtScope)object;
    }

    @Override
    @NotNull
    public KtScope getCompositeScope(@NotNull List<? extends KtScope> subScopes) {
        Intrinsics.checkNotNullParameter(subScopes, (String)"subScopes");
        return new KtCompositeScope(subScopes, this.getToken());
    }

    @Override
    @Nullable
    public KtTypeScope getTypeScope(@NotNull KtType type2) {
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        if (!(type2 instanceof KtFirType)) {
            boolean $i$a$-check-KtFirScopeProvider$getTypeScope$22 = false;
            String $i$a$-check-KtFirScopeProvider$getTypeScope$22 = "KtFirScopeProvider can only work with KtFirType, but " + Reflection.getOrCreateKotlinClass(type2.getClass()) + " was provided";
            throw new IllegalStateException($i$a$-check-KtFirScopeProvider$getTypeScope$22.toString());
        }
        FirSession firSession = this.firResolveSession.getUseSiteFirSession();
        FirTypeScope firTypeScope = ScopeUtilsKt.scope(((KtFirType)((Object)type2)).getConeType(), firSession, this.scopeSession, FakeOverrideTypeCalculator.Forced.INSTANCE);
        if (firTypeScope == null) {
            return null;
        }
        FirTypeScope firTypeScope2 = firTypeScope;
        Object[] objectArray = new KtTypeScope[]{this.convertToKtTypeScope(firTypeScope2), this.convertToKtTypeScope(new FirSyntheticPropertiesScope(firSession, firTypeScope2))};
        return new KtCompositeTypeScope(CollectionsKt.listOf((Object[])objectArray), this.getToken());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public KtScopeContext getScopeContextForPosition(@NotNull KtFile originalFile, @NotNull KtElement positionInFakeFile) {
        List list2;
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNullTo$iv$iv2;
        void $this$mapTo$iv$iv;
        Object element$iv$iv$iv;
        void $this$mapNotNullTo$iv$iv3;
        Intrinsics.checkNotNullParameter((Object)originalFile, (String)"originalFile");
        Intrinsics.checkNotNullParameter((Object)positionInFakeFile, (String)"positionInFakeFile");
        FirTowerDataContext firTowerDataContext = this.getAnalysisSession().getFirResolveSession().getTowerContextProvider(originalFile).getClosestAvailableParentContext(positionInFakeFile);
        if (firTowerDataContext == null) {
            throw new IllegalStateException(("Cannot find enclosing declaration for " + PsiUtilsKt.getElementTextInContext(positionInFakeFile)).toString());
        }
        FirTowerDataContext towerDataContext = firTowerDataContext;
        Iterable $this$mapNotNull$iv = towerDataContext.getNonLocalTowerDataElements();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Iterable<ImplicitReceiverValue<?>> destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv3;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            ImplicitReceiverValue<?> it$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            FirTowerDataElement it = (FirTowerDataElement)element$iv$iv;
            boolean bl2 = false;
            if (it.getImplicitReceiver() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List implicitReceivers2 = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
        Iterable $this$map$iv = implicitReceivers2;
        boolean $i$f$map = false;
        destination$iv$iv = $this$map$iv;
        Iterable destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void receiver;
            element$iv$iv$iv = (ImplicitReceiverValue)item$iv$iv;
            Collection collection = destination$iv$iv2;
            boolean bl = false;
            collection.add(new KtImplicitReceiver(this.getToken(), this.builder.getTypeBuilder().buildKtType(receiver.getType()), this.builder.buildSymbol((FirDeclaration)((FirBasedSymbol)receiver.getBoundSymbol()).getFir())));
        }
        List implicitKtReceivers = (List)destination$iv$iv2;
        Iterable $this$mapNotNull$iv2 = implicitReceivers2;
        boolean $i$f$mapNotNull2 = false;
        destination$iv$iv2 = $this$mapNotNull$iv2;
        Iterable<FirTypeScope> destination$iv$iv3 = new ArrayList();
        boolean $i$f$mapNotNullTo2 = false;
        void $this$forEach$iv$iv$iv2 = $this$mapNotNullTo$iv$iv2;
        boolean $i$f$forEach2 = false;
        Iterator bl = $this$forEach$iv$iv$iv2.iterator();
        while (bl.hasNext()) {
            FirTypeScope it$iv$iv;
            Object element$iv$iv$iv2;
            Object element$iv$iv = element$iv$iv$iv2 = bl.next();
            boolean bl4 = false;
            ImplicitReceiverValue it = (ImplicitReceiverValue)element$iv$iv;
            boolean bl5 = false;
            if (it.getImplicitScope() == null) continue;
            boolean bl6 = false;
            destination$iv$iv3.add(it$iv$iv);
        }
        List implicitReceiverScopes = (List)destination$iv$iv3;
        Iterable $this$mapNotNull$iv3 = towerDataContext.getNonLocalTowerDataElements();
        boolean $i$f$mapNotNull3 = false;
        destination$iv$iv3 = $this$mapNotNull$iv3;
        Collection destination$iv$iv4 = new ArrayList();
        boolean $i$f$mapNotNullTo3 = false;
        void $this$forEach$iv$iv$iv3 = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach3 = false;
        Iterator iterator3 = $this$forEach$iv$iv$iv3.iterator();
        while (iterator3.hasNext()) {
            FirScope it$iv$iv;
            Object element$iv$iv$iv3;
            Object element$iv$iv = element$iv$iv$iv3 = iterator3.next();
            boolean bl7 = false;
            FirTowerDataElement it = (FirTowerDataElement)element$iv$iv;
            boolean bl8 = false;
            if (it.getScope() == null) continue;
            boolean bl9 = false;
            destination$iv$iv4.add(it$iv$iv);
        }
        List nonLocalScopes = CollectionsKt.distinct((Iterable)((List)destination$iv$iv4));
        PersistentList<FirLocalScope> firLocalScopes = towerDataContext.getLocalScopes();
        List $this$getScopeContextForPosition_u24lambda_u2420 = list2 = CollectionsKt.createListBuilder();
        boolean bl10 = false;
        Iterable $this$mapTo$iv = implicitReceiverScopes;
        boolean $i$f$mapTo2 = false;
        for (Object item$iv : $this$mapTo$iv) {
            void p0;
            FirScope element$iv$iv = (FirScope)item$iv;
            Collection collection = $this$getScopeContextForPosition_u24lambda_u2420;
            boolean bl11 = false;
            collection.add(this.convertToKtScope((FirScope)p0));
        }
        $this$mapTo$iv = nonLocalScopes;
        $i$f$mapTo2 = false;
        for (Object item$iv : $this$mapTo$iv) {
            FirScope p0 = (FirScope)item$iv;
            Collection collection = $this$getScopeContextForPosition_u24lambda_u2420;
            boolean bl12 = false;
            collection.add(this.convertToKtScope(p0));
        }
        $this$mapTo$iv = firLocalScopes;
        $i$f$mapTo2 = false;
        for (Object item$iv : $this$mapTo$iv) {
            FirScope p0 = (FirScope)item$iv;
            Collection collection = $this$getScopeContextForPosition_u24lambda_u2420;
            boolean bl13 = false;
            collection.add(this.convertToKtScope(p0));
        }
        List allKtScopes = CollectionsKt.build((List)list2);
        return new KtScopeContext(this.getCompositeScope(CollectionsKt.asReversed((List)allKtScopes)), CollectionsKt.asReversed((List)implicitKtReceivers), this.getToken());
    }

    private final KtScope convertToKtScope(FirScope firScope2) {
        KtScope ktScope;
        FirScope firScope3 = firScope2;
        if (firScope3 instanceof FirAbstractSimpleImportingScope) {
            ktScope = new KtFirNonStarImportingScope((FirAbstractSimpleImportingScope)firScope2, this.builder, this.getToken());
        } else if (firScope3 instanceof FirAbstractStarImportingScope) {
            ktScope = new KtFirStarImportingScope((FirAbstractStarImportingScope)firScope2, this.builder, this.project, this.getToken());
        } else if (firScope3 instanceof FirPackageMemberScope) {
            FqName fqName2 = ((FirPackageMemberScope)firScope2).getFqName();
            KtLifetimeToken ktLifetimeToken = this.getToken();
            GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope((Project)this.project);
            Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"allScope(project)");
            ktScope = new KtFirPackageScope(fqName2, this.project, this.builder, ktLifetimeToken, globalSearchScope, this.getAnalysisSession().getTargetPlatform$analysis_api_fir());
        } else if (firScope3 instanceof FirContainingNamesAwareScope) {
            ktScope = new KtFirDelegatingScope((FirContainingNamesAwareScope)firScope2, this.builder, this.getToken());
        } else {
            String string2 = Reflection.getOrCreateKotlinClass(firScope2.getClass()).toString();
            throw new NotImplementedError("An operation is not implemented: " + string2);
        }
        return ktScope;
    }

    private final KtTypeScope convertToKtTypeScope(FirScope firScope2) {
        if (!(firScope2 instanceof FirContainingNamesAwareScope)) {
            String string2 = Reflection.getOrCreateKotlinClass(firScope2.getClass()).toString();
            throw new NotImplementedError("An operation is not implemented: " + string2);
        }
        return new KtFirDelegatingTypeScope((FirContainingNamesAwareScope)firScope2, this.builder, this.getToken());
    }
}

