/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.fir.components;

import com.intellij.psi.PsiElement;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.analysis.api.KtTypeArgument;
import org.jetbrains.kotlin.analysis.api.components.KtExpressionTypeProvider;
import org.jetbrains.kotlin.analysis.api.diagnostics.KtDiagnosticWithPsi;
import org.jetbrains.kotlin.analysis.api.fir.KtFirAnalysisSession;
import org.jetbrains.kotlin.analysis.api.fir.KtSymbolByFirBuilder;
import org.jetbrains.kotlin.analysis.api.fir.components.DefiniteNullability;
import org.jetbrains.kotlin.analysis.api.fir.components.KtCallWithArgument;
import org.jetbrains.kotlin.analysis.api.fir.components.KtFirAnalysisSessionComponent;
import org.jetbrains.kotlin.analysis.api.fir.components.KtFirExpressionTypeProviderKt;
import org.jetbrains.kotlin.analysis.api.fir.utils.FirUtilsKt;
import org.jetbrains.kotlin.analysis.api.lifetime.KtLifetimeToken;
import org.jetbrains.kotlin.analysis.api.symbols.KtCallableSymbol;
import org.jetbrains.kotlin.analysis.api.types.KtSubstitutor;
import org.jetbrains.kotlin.analysis.api.types.KtType;
import org.jetbrains.kotlin.analysis.low.level.api.fir.api.InvalidFirElementTypeExceptionKt;
import org.jetbrains.kotlin.analysis.low.level.api.fir.api.LLFirResolveSession;
import org.jetbrains.kotlin.analysis.low.level.api.fir.api.LowLevelFirApiFacadeKt;
import org.jetbrains.kotlin.diagnostics.KtPsiDiagnostic;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirLabel;
import org.jetbrains.kotlin.fir.FirPackageDirective;
import org.jetbrains.kotlin.fir.FirPureAbstractElement;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirImport;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.utils.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.diagnostics.ConeDiagnostic;
import org.jetbrains.kotlin.fir.expressions.FirArgumentList;
import org.jetbrains.kotlin.fir.expressions.FirCall;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpressionWithSmartcast;
import org.jetbrains.kotlin.fir.expressions.FirExpressionWithSmartcastToNothing;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirLambdaArgumentExpression;
import org.jetbrains.kotlin.fir.expressions.FirNamedArgumentExpression;
import org.jetbrains.kotlin.fir.expressions.FirPropertyAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccess;
import org.jetbrains.kotlin.fir.expressions.FirSpreadArgumentExpression;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.expressions.FirThisReceiverExpression;
import org.jetbrains.kotlin.fir.expressions.FirVariableAssignment;
import org.jetbrains.kotlin.fir.expressions.FirWhenBranch;
import org.jetbrains.kotlin.fir.expressions.impl.FirResolvedArgumentList;
import org.jetbrains.kotlin.fir.references.FirNamedReference;
import org.jetbrains.kotlin.fir.references.FirResolvedNamedReference;
import org.jetbrains.kotlin.fir.references.FirSuperReference;
import org.jetbrains.kotlin.fir.references.FirThisReference;
import org.jetbrains.kotlin.fir.resolve.ResolveUtilsKt;
import org.jetbrains.kotlin.fir.resolve.substitution.ConeSubstitutor;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeInferenceContext;
import org.jetbrains.kotlin.fir.types.ConeIntersectionType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.FirErrorTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeComponentsKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtArrayAccessExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpressionWithTypeRHS;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.KtUnaryExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.psi.KtWhileExpressionBase;
import org.jetbrains.kotlin.types.TypeCheckerState;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u000e\u001a\u00020\u0012H\u0016J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u000e\u001a\u00020\u0012H\u0002J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u000e\u001a\u00020\u0012H\u0002J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u000e\u001a\u00020\u0012H\u0002J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u000e\u001a\u00020\u0012H\u0002J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u000e\u001a\u00020\u0012H\u0002J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u000e\u001a\u00020\u0012H\u0002J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u000e\u001a\u00020\u0012H\u0002J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u000e\u001a\u00020\u0012H\u0002J\u0010\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u001a\u0010\u001f\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010 \u001a\u00020!H\u0002J\u0010\u0010\"\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020#H\u0016J\u0010\u0010$\u001a\u00020%2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010&\u001a\u00020%2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u000e\u0010'\u001a\u0004\u0018\u00010(*\u00020\u0012H\u0002J\u000e\u0010)\u001a\u0004\u0018\u00010**\u00020\u0012H\u0002J\f\u0010+\u001a\u00020%*\u00020\u0012H\u0002J\f\u0010,\u001a\u00020%*\u00020\u0012H\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0005\u001a\u00020\u0006X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006-"}, d2={"Lorg/jetbrains/kotlin/analysis/api/fir/components/KtFirExpressionTypeProvider;", "Lorg/jetbrains/kotlin/analysis/api/components/KtExpressionTypeProvider;", "Lorg/jetbrains/kotlin/analysis/api/fir/components/KtFirAnalysisSessionComponent;", "analysisSession", "Lorg/jetbrains/kotlin/analysis/api/fir/KtFirAnalysisSession;", "token", "Lorg/jetbrains/kotlin/analysis/api/lifetime/KtLifetimeToken;", "(Lorg/jetbrains/kotlin/analysis/api/fir/KtFirAnalysisSession;Lorg/jetbrains/kotlin/analysis/api/lifetime/KtLifetimeToken;)V", "getAnalysisSession", "()Lorg/jetbrains/kotlin/analysis/api/fir/KtFirAnalysisSession;", "getToken", "()Lorg/jetbrains/kotlin/analysis/api/lifetime/KtLifetimeToken;", "getDefiniteNullability", "Lorg/jetbrains/kotlin/analysis/api/fir/components/DefiniteNullability;", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "getExpectedType", "Lorg/jetbrains/kotlin/analysis/api/types/KtType;", "Lcom/intellij/psi/PsiElement;", "getExpectedTypeByFunctionExpressionBody", "getExpectedTypeByPropertyDeclaration", "getExpectedTypeByReturnExpression", "getExpectedTypeByTypeCast", "getExpectedTypeByVariableAssignment", "getExpectedTypeOfFunctionParameter", "getExpectedTypeOfInfixFunctionParameter", "getExpressionTypeByIfOrBooleanCondition", "getFunctionalTypeForKtFunction", "declaration", "Lorg/jetbrains/kotlin/psi/KtFunction;", "getKtExpressionType", "getReturnTypeForArrayStyleAssignmentTarget", "fir", "Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;", "getReturnTypeForKtDeclaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "isDefinitelyNotNull", "", "isDefinitelyNull", "getFunctionCallAsWithThisAsParameter", "Lorg/jetbrains/kotlin/analysis/api/fir/components/KtCallWithArgument;", "getReturnExpressionWithThisType", "Lorg/jetbrains/kotlin/psi/KtReturnExpression;", "isIfCondition", "isWhileLoopCondition", "analysis-api-fir"})
public final class KtFirExpressionTypeProvider
extends KtExpressionTypeProvider
implements KtFirAnalysisSessionComponent {
    @NotNull
    private final KtFirAnalysisSession analysisSession;
    @NotNull
    private final KtLifetimeToken token;

    public KtFirExpressionTypeProvider(@NotNull KtFirAnalysisSession analysisSession, @NotNull KtLifetimeToken token) {
        Intrinsics.checkNotNullParameter((Object)analysisSession, (String)"analysisSession");
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        this.analysisSession = analysisSession;
        this.token = token;
    }

    @Override
    @NotNull
    public KtFirAnalysisSession getAnalysisSession() {
        return this.analysisSession;
    }

    @Override
    @NotNull
    protected KtLifetimeToken getToken() {
        return this.token;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public KtType getKtExpressionType(@NotNull KtExpression expression2) {
        KtType ktType;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        FirElement fir = LowLevelFirApiFacadeKt.getOrBuildFir(FirUtilsKt.unwrap(expression2), this.getFirResolveSession());
        if (fir instanceof FirFunctionCall) {
            ktType = this.getReturnTypeForArrayStyleAssignmentTarget(expression2, (FirFunctionCall)fir);
            if (ktType == null) {
                ktType = this.asKtType(FirTypeUtilsKt.getConeType(((FirFunctionCall)fir).getTypeRef()));
            }
        } else if (fir instanceof FirPropertyAccessExpression) {
            FirClassSymbol containingClass;
            FirExpression firExpression2 = ((FirPropertyAccessExpression)fir).getDispatchReceiver();
            FirPureAbstractElement firPureAbstractElement = firExpression2 instanceof FirThisReceiverExpression ? (FirThisReceiverExpression)firExpression2 : null;
            FirBasedSymbol<?> firBasedSymbol = firPureAbstractElement != null && (firPureAbstractElement = ((FirThisReceiverExpression)firPureAbstractElement).getCalleeReference()) != null ? ((FirThisReference)firPureAbstractElement).getBoundSymbol() : null;
            FirClassSymbol firClassSymbol = containingClass = firBasedSymbol instanceof FirClassSymbol ? (FirClassSymbol)firBasedSymbol : null;
            if (((FirPropertyAccessExpression)fir).getCalleeReference() instanceof FirSuperReference && ((FirPropertyAccessExpression)fir).getTypeRef() instanceof FirErrorTypeRef && containingClass != null) {
                List<ConeClassLikeType> superTypes2 = FirDeclarationUtilKt.getSuperConeTypes(containingClass);
                switch (superTypes2.size()) {
                    case 0: {
                        ktType = this.getAnalysisSession().getBuiltinTypes().getANY();
                        break;
                    }
                    case 1: {
                        ktType = this.asKtType((ConeKotlinType)CollectionsKt.single(superTypes2));
                        break;
                    }
                    default: {
                        ktType = this.asKtType(new ConeIntersectionType(superTypes2, null, 2, null));
                        break;
                    }
                }
            } else {
                ktType = this.asKtType(FirTypeUtilsKt.getConeType(((FirPropertyAccessExpression)fir).getTypeRef()));
            }
        } else if (fir instanceof FirVariableAssignment) {
            ktType = expression2 instanceof KtUnaryExpression && KtTokens.INCREMENT_AND_DECREMENT.contains(((KtUnaryExpression)expression2).getOperationToken()) ? this.asKtType(FirTypeUtilsKt.getConeType(((FirVariableAssignment)fir).getRValue().getTypeRef())) : this.getAnalysisSession().getBuiltinTypes().getUNIT();
        } else if (fir instanceof FirExpression) {
            ktType = this.asKtType(FirTypeUtilsKt.getConeType(((FirExpression)fir).getTypeRef()));
        } else if (fir instanceof FirNamedReference) {
            ktType = this.asKtType(FirUtilsKt.getReferencedElementType((FirNamedReference)fir));
        } else if (fir instanceof FirStatement) {
            KtFirAnalysisSession $this$getKtExpressionType_u24lambda_u240 = this.getAnalysisSession();
            boolean bl = false;
            ktType = $this$getKtExpressionType_u24lambda_u240.getBuiltinTypes().getUNIT();
        } else if (((fir instanceof FirTypeRef ? true : fir instanceof FirImport) ? true : fir instanceof FirPackageDirective) ? true : fir instanceof FirLabel) {
            ktType = null;
        } else if (fir instanceof FirWhenBranch) {
            ktType = null;
        } else {
            KClass kClass2;
            StringBuilder stringBuilder2 = new StringBuilder().append("Unexpected ");
            FirElement firElement = fir;
            if (firElement != null) {
                void it;
                FirElement $this$getKtExpressionType_u24lambda_u240 = firElement;
                StringBuilder stringBuilder3 = stringBuilder2;
                boolean bl = false;
                kClass2 = Reflection.getOrCreateKotlinClass(it.getClass());
                stringBuilder2 = stringBuilder3;
            } else {
                kClass2 = null;
            }
            String string2 = stringBuilder2.append(kClass2).append(" for ").append(Reflection.getOrCreateKotlinClass(expression2.getClass())).append(" with text `").append(expression2.getText()).append('`').toString();
            throw new IllegalStateException(string2.toString());
        }
        return ktType;
    }

    private final KtType getReturnTypeForArrayStyleAssignmentTarget(KtExpression expression2, FirFunctionCall fir) {
        if (!(fir.getCalleeReference() instanceof FirResolvedNamedReference)) {
            return null;
        }
        if (!(expression2 instanceof KtArrayAccessExpression)) {
            return null;
        }
        PsiElement psiElement = ((KtArrayAccessExpression)expression2).getParent();
        KtBinaryExpression ktBinaryExpression = psiElement instanceof KtBinaryExpression ? (KtBinaryExpression)psiElement : null;
        if (ktBinaryExpression == null) {
            return null;
        }
        KtBinaryExpression assignment = ktBinaryExpression;
        if (!KtTokens.ALL_ASSIGNMENTS.contains(assignment.getOperationToken())) {
            return null;
        }
        FirCall $this$argumentMapping$iv = fir;
        boolean $i$f$getArgumentMapping = false;
        FirArgumentList argumentList$iv = $this$argumentMapping$iv.getArgumentList();
        LinkedHashMap<FirExpression, FirValueParameter> linkedHashMap = argumentList$iv instanceof FirResolvedArgumentList ? ((FirResolvedArgumentList)argumentList$iv).getMapping() : null;
        Object object = linkedHashMap;
        if (linkedHashMap == null || (object = ((LinkedHashMap)object).entrySet()) == null || (object = (Map.Entry)CollectionsKt.last((Iterable)((Iterable)object))) == null || (object = (FirValueParameter)object.getValue()) == null) {
            return null;
        }
        Object setTargetArgumentParameter = object;
        return this.asKtType(FirTypeUtilsKt.getConeType(((FirValueParameter)setTargetArgumentParameter).getReturnTypeRef()));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public KtType getReturnTypeForKtDeclaration(@NotNull KtDeclaration declaration) {
        void $this$getOrBuildFirOfType$iv;
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        KtElement ktElement = declaration;
        LLFirResolveSession firResolveSession$iv = this.getFirResolveSession();
        boolean $i$f$getOrBuildFirOfType = false;
        FirElement fir$iv = LowLevelFirApiFacadeKt.getOrBuildFir((KtElement)$this$getOrBuildFirOfType$iv, firResolveSession$iv);
        if (!(fir$iv instanceof FirCallableDeclaration)) {
            KClass[] kClassArray = new KClass[]{Reflection.getOrCreateKotlinClass(FirCallableDeclaration.class)};
            InvalidFirElementTypeExceptionKt.throwUnexpectedFirElementError(fir$iv, (KtElement)$this$getOrBuildFirOfType$iv, kClassArray);
            throw null;
        }
        FirCallableDeclaration firDeclaration = (FirCallableDeclaration)fir$iv;
        return this.asKtType(FirTypeUtilsKt.getConeType(firDeclaration.getReturnTypeRef()));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public KtType getFunctionalTypeForKtFunction(@NotNull KtFunction declaration) {
        void $this$getOrBuildFirOfType$iv;
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        KtElement ktElement = declaration;
        LLFirResolveSession firResolveSession$iv = this.getFirResolveSession();
        boolean $i$f$getOrBuildFirOfType = false;
        FirElement fir$iv = LowLevelFirApiFacadeKt.getOrBuildFir((KtElement)$this$getOrBuildFirOfType$iv, firResolveSession$iv);
        if (!(fir$iv instanceof FirFunction)) {
            KClass[] kClassArray = new KClass[]{Reflection.getOrCreateKotlinClass(FirFunction.class)};
            InvalidFirElementTypeExceptionKt.throwUnexpectedFirElementError(fir$iv, (KtElement)$this$getOrBuildFirOfType$iv, kClassArray);
            throw null;
        }
        FirFunction firFunction = (FirFunction)fir$iv;
        FirMemberDeclaration $this$isSuspend$iv = firFunction;
        boolean $i$f$isSuspend = false;
        return this.asKtType(ResolveUtilsKt.constructFunctionalType(firFunction, $this$isSuspend$iv.getStatus().isSuspend()));
    }

    @Override
    @Nullable
    public KtType getExpectedType(@NotNull PsiElement expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        PsiElement unwrapped = FirUtilsKt.unwrap(expression2);
        KtType ktType = this.getExpectedTypeByReturnExpression(unwrapped);
        if (ktType == null && (ktType = this.getExpressionTypeByIfOrBooleanCondition(unwrapped)) == null && (ktType = this.getExpectedTypeByTypeCast(unwrapped)) == null && (ktType = this.getExpectedTypeOfFunctionParameter(unwrapped)) == null && (ktType = this.getExpectedTypeOfInfixFunctionParameter(unwrapped)) == null && (ktType = this.getExpectedTypeByVariableAssignment(unwrapped)) == null && (ktType = this.getExpectedTypeByPropertyDeclaration(unwrapped)) == null) {
            ktType = this.getExpectedTypeByFunctionExpressionBody(unwrapped);
        }
        KtType expectedType = ktType;
        return expectedType;
    }

    /*
     * Unable to fully structure code
     */
    private final KtType getExpectedTypeByTypeCast(PsiElement expression) {
        block6: {
            block7: {
                block5: {
                    $this$unwrapQualified$iv = expression;
                    $i$f$unwrapQualified = false;
                    parent$iv = KtFirExpressionTypeProviderKt.access$getNonContainerParent($this$unwrapQualified$iv);
                    if (!(parent$iv instanceof KtBinaryExpressionWithTypeRHS)) break block5;
                    var6_5 = $this$unwrapQualified$iv;
                    castExpr = (KtBinaryExpressionWithTypeRHS)parent$iv;
                    $i$a$-unwrapQualified-KtFirExpressionTypeProvider$getExpectedTypeByTypeCast$typeCastExpression$1 = false;
                    if (!Intrinsics.areEqual((Object)castExpr.getLeft(), (Object)expr)) break block5;
                    v0 = parent$iv;
                    break block6;
                }
                if (!(parent$iv instanceof KtQualifiedExpression) || !Intrinsics.areEqual((Object)((KtQualifiedExpression)parent$iv).getSelectorExpression(), (Object)$this$unwrapQualified$iv)) break block7;
                grandParent$iv = KtFirExpressionTypeProviderKt.access$getNonContainerParent(parent$iv);
                if (!(grandParent$iv instanceof KtBinaryExpressionWithTypeRHS)) ** GOTO lbl-1000
                $i$a$-unwrapQualified-KtFirExpressionTypeProvider$getExpectedTypeByTypeCast$typeCastExpression$1 = parent$iv;
                castExpr = (KtBinaryExpressionWithTypeRHS)grandParent$iv;
                $i$a$-unwrapQualified-KtFirExpressionTypeProvider$getExpectedTypeByTypeCast$typeCastExpression$1 = false;
                if (Intrinsics.areEqual((Object)castExpr.getLeft(), (Object)expr)) {
                    v0 = grandParent$iv;
                } else lbl-1000:
                // 2 sources

                {
                    v0 = null;
                }
                break block6;
            }
            v0 = null;
        }
        v1 = (KtBinaryExpressionWithTypeRHS)v0;
        if (v1 == null) {
            return null;
        }
        typeCastExpression = v1;
        $this$getExpectedTypeByTypeCast_u24lambda_u243 = this.getAnalysisSession();
        $i$a$-with-KtFirExpressionTypeProvider$getExpectedTypeByTypeCast$1 = false;
        v2 = var5_4 = typeCastExpression.getRight();
        if (v2 != null) {
            Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"right");
            v3 = $this$getExpectedTypeByTypeCast_u24lambda_u243.getKtType(var5_4);
        } else {
            v3 = null;
        }
        return v3;
    }

    /*
     * WARNING - void declaration
     */
    private final KtType getExpectedTypeOfFunctionParameter(PsiElement expression2) {
        FirValueParameter firValueParameter;
        Object v9;
        block9: {
            void $this$getOrBuildFirSafe$iv;
            KtCallWithArgument ktCallWithArgument = this.getFunctionCallAsWithThisAsParameter(expression2);
            if (ktCallWithArgument == null) {
                return null;
            }
            KtCallWithArgument ktCallWithArgument2 = ktCallWithArgument;
            KtCallExpression ktCallExpression = ktCallWithArgument2.component1();
            KtExpression argumentExpression = ktCallWithArgument2.component2();
            KtElement ktElement = ktCallExpression;
            Object firResolveSession$iv = this.getFirResolveSession();
            boolean $i$f$getOrBuildFirSafe = false;
            FirElement firElement = LowLevelFirApiFacadeKt.getOrBuildFir((KtElement)$this$getOrBuildFirSafe$iv, (LLFirResolveSession)firResolveSession$iv);
            if (!(firElement instanceof FirFunctionCall)) {
                firElement = null;
            }
            FirFunctionCall firFunctionCall = (FirFunctionCall)((FirElement)((FirFunctionCall)firElement));
            if (firFunctionCall == null) {
                return null;
            }
            FirFunctionCall firCall = firFunctionCall;
            firResolveSession$iv = firCall.getCalleeReference();
            FirResolvedNamedReference firResolvedNamedReference = firResolveSession$iv instanceof FirResolvedNamedReference ? (FirResolvedNamedReference)firResolveSession$iv : null;
            FirBasedSymbol<Object> callee = firResolvedNamedReference != null ? firResolvedNamedReference.getResolvedSymbol() : null;
            FirBasedSymbol<?> firBasedSymbol = callee;
            if (Intrinsics.areEqual((Object)(firBasedSymbol != null && (firBasedSymbol = firBasedSymbol.getFir()) != null ? ((FirDeclaration)((Object)firBasedSymbol)).getOrigin() : null), (Object)FirDeclarationOrigin.SamConstructor.INSTANCE)) {
                Object obj = callee.getFir();
                Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.declarations.FirSimpleFunction");
                return this.asKtType(FirTypeUtilsKt.getConeType(((FirSimpleFunction)obj).getReturnTypeRef()));
            }
            FirCall $this$argumentMapping$iv = firCall;
            boolean $i$f$getArgumentMapping = false;
            FirArgumentList argumentList$iv = $this$argumentMapping$iv.getArgumentList();
            LinkedHashMap<FirExpression, FirValueParameter> linkedHashMap = argumentList$iv instanceof FirResolvedArgumentList ? ((FirResolvedArgumentList)argumentList$iv).getMapping() : null;
            if (linkedHashMap == null) {
                return null;
            }
            LinkedHashMap<FirExpression, FirValueParameter> arguments2 = linkedHashMap;
            Set<Map.Entry<FirExpression, FirValueParameter>> set = arguments2.entrySet();
            Intrinsics.checkNotNullExpressionValue(set, (String)"arguments.entries");
            Iterable $this$firstOrNull$iv = set;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                boolean bl;
                FirExpression arg;
                Map.Entry entry = (Map.Entry)element$iv;
                boolean bl2 = false;
                Intrinsics.checkNotNullExpressionValue((Object)entry, (String)"(arg, _)");
                FirExpression firExpression2 = arg = (FirExpression)entry.getKey();
                if ((firExpression2 instanceof FirLambdaArgumentExpression ? true : firExpression2 instanceof FirNamedArgumentExpression) ? true : firExpression2 instanceof FirSpreadArgumentExpression) {
                    Intrinsics.checkNotNullExpressionValue((Object)arg, (String)"arg");
                    bl = Intrinsics.areEqual((Object)UtilsKt.getPsi(arg), (Object)argumentExpression.getParent());
                } else {
                    Intrinsics.checkNotNullExpressionValue((Object)arg, (String)"arg");
                    bl = Intrinsics.areEqual((Object)UtilsKt.getPsi(arg), (Object)argumentExpression);
                }
                if (!bl) continue;
                v9 = element$iv;
                break block9;
            }
            v9 = null;
        }
        Map.Entry entry = v9;
        if (entry == null || (firValueParameter = (FirValueParameter)entry.getValue()) == null) {
            return null;
        }
        FirValueParameter firParameterForExpression = firValueParameter;
        return this.asKtType(FirTypeUtilsKt.getConeType(firParameterForExpression.getReturnTypeRef()));
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final KtCallWithArgument getFunctionCallAsWithThisAsParameter(PsiElement $this$getFunctionCallAsWithThisAsParameter) {
        block6: {
            block7: {
                block5: {
                    $this$unwrapQualified$iv = $this$getFunctionCallAsWithThisAsParameter;
                    $i$f$unwrapQualified = false;
                    parent$iv = KtFirExpressionTypeProviderKt.access$getNonContainerParent($this$unwrapQualified$iv);
                    if (!(parent$iv instanceof KtValueArgument)) break block5;
                    var7_6 = $this$unwrapQualified$iv;
                    valueArg = (KtValueArgument)parent$iv;
                    $i$a$-unwrapQualified-KtFirExpressionTypeProvider$getFunctionCallAsWithThisAsParameter$valueArgument$1 = false;
                    if (!Intrinsics.areEqual((Object)valueArg.getArgumentExpression(), (Object)expr)) break block5;
                    v0 = parent$iv;
                    break block6;
                }
                if (!(parent$iv instanceof KtQualifiedExpression) || !Intrinsics.areEqual((Object)((KtQualifiedExpression)parent$iv).getSelectorExpression(), (Object)$this$unwrapQualified$iv)) break block7;
                grandParent$iv = KtFirExpressionTypeProviderKt.access$getNonContainerParent(parent$iv);
                if (!(grandParent$iv instanceof KtValueArgument)) ** GOTO lbl-1000
                $i$a$-unwrapQualified-KtFirExpressionTypeProvider$getFunctionCallAsWithThisAsParameter$valueArgument$1 = parent$iv;
                valueArg = (KtValueArgument)grandParent$iv;
                $i$a$-unwrapQualified-KtFirExpressionTypeProvider$getFunctionCallAsWithThisAsParameter$valueArgument$1 = false;
                if (Intrinsics.areEqual((Object)valueArg.getArgumentExpression(), (Object)expr)) {
                    v0 = grandParent$iv;
                } else lbl-1000:
                // 2 sources

                {
                    v0 = null;
                }
                break block6;
            }
            v0 = null;
        }
        v1 = (KtValueArgument)v0;
        if (v1 == null) {
            return null;
        }
        valueArgument = v1;
        var7_6 = valueArgument.getParent();
        v2 = var7_6 instanceof KtValueArgumentList != false ? (KtValueArgumentList)var7_6 : null;
        var5_4 /* !! */  = v2 != null ? v2.getParent() : null;
        v3 = var5_4 /* !! */  instanceof KtCallExpression != false ? (KtCallExpression)var5_4 /* !! */  : null;
        if (v3 == null && (v3 = (var6_5 = valueArgument.getParent()) instanceof KtCallExpression != false ? (KtCallExpression)var6_5 : null) == null) {
            return null;
        }
        callExpression = v3;
        v4 = valueArgument.getArgumentExpression();
        if (v4 == null) {
            return null;
        }
        argumentExpression = v4;
        return new KtCallWithArgument(callExpression, argumentExpression);
    }

    /*
     * Unable to fully structure code
     */
    private final KtType getExpectedTypeOfInfixFunctionParameter(PsiElement expression) {
        block8: {
            block9: {
                block7: {
                    $this$unwrapQualified$iv = expression;
                    $i$f$unwrapQualified = false;
                    parent$iv = KtFirExpressionTypeProviderKt.access$getNonContainerParent($this$unwrapQualified$iv);
                    if (!(parent$iv instanceof KtBinaryExpression)) break block7;
                    var7_6 = $this$unwrapQualified$iv;
                    binaryExpr = (KtBinaryExpression)parent$iv;
                    $i$a$-unwrapQualified-KtFirExpressionTypeProvider$getExpectedTypeOfInfixFunctionParameter$infixCallExpression$1 = false;
                    if (!Intrinsics.areEqual((Object)binaryExpr.getRight(), (Object)expr)) break block7;
                    v0 = parent$iv;
                    break block8;
                }
                if (!(parent$iv instanceof KtQualifiedExpression) || !Intrinsics.areEqual((Object)((KtQualifiedExpression)parent$iv).getSelectorExpression(), (Object)$this$unwrapQualified$iv)) break block9;
                grandParent$iv = KtFirExpressionTypeProviderKt.access$getNonContainerParent(parent$iv);
                if (!(grandParent$iv instanceof KtBinaryExpression)) ** GOTO lbl-1000
                $i$a$-unwrapQualified-KtFirExpressionTypeProvider$getExpectedTypeOfInfixFunctionParameter$infixCallExpression$1 = parent$iv;
                binaryExpr = (KtBinaryExpression)grandParent$iv;
                $i$a$-unwrapQualified-KtFirExpressionTypeProvider$getExpectedTypeOfInfixFunctionParameter$infixCallExpression$1 = false;
                if (Intrinsics.areEqual((Object)binaryExpr.getRight(), (Object)expr)) {
                    v0 = grandParent$iv;
                } else lbl-1000:
                // 2 sources

                {
                    v0 = null;
                }
                break block8;
            }
            v0 = null;
        }
        v1 = (KtBinaryExpression)v0;
        if (v1 == null) {
            return null;
        }
        infixCallExpression = v1;
        $i$f$unwrapQualified = infixCallExpression;
        firResolveSession$iv = this.getFirResolveSession();
        $i$f$getOrBuildFirSafe = false;
        v2 = LowLevelFirApiFacadeKt.getOrBuildFir((KtElement)$this$getOrBuildFirSafe$iv, firResolveSession$iv);
        if (!(v2 instanceof FirFunctionCall)) {
            v2 = null;
        }
        v3 = (FirFunctionCall)((FirElement)((FirFunctionCall)v2));
        if (v3 == null) {
            return null;
        }
        firCall = v3;
        $this$argumentMapping$iv = firCall;
        $i$f$getArgumentMapping = false;
        argumentList$iv = $this$argumentMapping$iv.getArgumentList();
        v4 = argumentList$iv instanceof FirResolvedArgumentList ? ((FirResolvedArgumentList)argumentList$iv).getMapping() : null;
        if (v4 == null) {
            return null;
        }
        arguments = v4;
        v5 = arguments.values();
        Intrinsics.checkNotNullExpressionValue(v5, (String)"arguments.values");
        v6 = (FirValueParameter)CollectionsKt.singleOrNull((Iterable)v5);
        if (v6 == null) {
            return null;
        }
        firParameterForExpression = v6;
        return this.asKtType(FirTypeUtilsKt.getConeType(firParameterForExpression.getReturnTypeRef()));
    }

    private final KtType getExpectedTypeByReturnExpression(PsiElement expression2) {
        KtReturnExpression ktReturnExpression = this.getReturnExpressionWithThisType(expression2);
        if (ktReturnExpression == null) {
            return null;
        }
        KtReturnExpression returnParent = ktReturnExpression;
        KtFirAnalysisSession $this$getExpectedTypeByReturnExpression_u24lambda_u247 = this.getAnalysisSession();
        boolean bl = false;
        KtCallableSymbol ktCallableSymbol = $this$getExpectedTypeByReturnExpression_u24lambda_u247.getReturnTargetSymbol(returnParent);
        if (ktCallableSymbol == null) {
            return null;
        }
        KtCallableSymbol targetSymbol = ktCallableSymbol;
        return targetSymbol.getReturnType();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private final KtReturnExpression getReturnExpressionWithThisType(PsiElement $this$getReturnExpressionWithThisType) {
        PsiElement psiElement;
        PsiElement $this$unwrapQualified$iv = $this$getReturnExpressionWithThisType;
        boolean $i$f$unwrapQualified = false;
        PsiElement parent$iv = KtFirExpressionTypeProviderKt.access$getNonContainerParent($this$unwrapQualified$iv);
        if (parent$iv instanceof KtReturnExpression) {
            void target;
            PsiElement psiElement2 = $this$unwrapQualified$iv;
            KtReturnExpression returnExpr = (KtReturnExpression)parent$iv;
            boolean bl = false;
            if (Intrinsics.areEqual((Object)returnExpr.getReturnedExpression(), (Object)target)) {
                psiElement = parent$iv;
                return (KtReturnExpression)psiElement;
            }
        }
        if (parent$iv instanceof KtQualifiedExpression && Intrinsics.areEqual((Object)((KtQualifiedExpression)parent$iv).getSelectorExpression(), (Object)$this$unwrapQualified$iv)) {
            PsiElement grandParent$iv = KtFirExpressionTypeProviderKt.access$getNonContainerParent(parent$iv);
            if (grandParent$iv instanceof KtReturnExpression) {
                void target;
                PsiElement bl = parent$iv;
                KtReturnExpression returnExpr = (KtReturnExpression)grandParent$iv;
                boolean $i$a$-unwrapQualified-KtFirExpressionTypeProvider$getReturnExpressionWithThisType$2 = false;
                if (Intrinsics.areEqual((Object)returnExpr.getReturnedExpression(), (Object)target)) {
                    psiElement = grandParent$iv;
                    return (KtReturnExpression)psiElement;
                }
            }
            psiElement = null;
            return (KtReturnExpression)psiElement;
        }
        psiElement = null;
        return (KtReturnExpression)psiElement;
    }

    private final KtType getExpressionTypeByIfOrBooleanCondition(PsiElement expression2) {
        KtType ktType;
        if (this.isWhileLoopCondition(expression2) || this.isIfCondition(expression2)) {
            KtFirAnalysisSession $this$getExpressionTypeByIfOrBooleanCondition_u24lambda_u249 = this.getAnalysisSession();
            boolean bl = false;
            ktType = $this$getExpressionTypeByIfOrBooleanCondition_u24lambda_u249.getBuiltinTypes().getBOOLEAN();
        } else {
            ktType = null;
        }
        return ktType;
    }

    /*
     * Unable to fully structure code
     */
    private final KtType getExpectedTypeByVariableAssignment(PsiElement expression) {
        block5: {
            block6: {
                block4: {
                    $this$unwrapQualified$iv = expression;
                    $i$f$unwrapQualified = false;
                    parent$iv = KtFirExpressionTypeProviderKt.access$getNonContainerParent($this$unwrapQualified$iv);
                    if (!(parent$iv instanceof KtBinaryExpression)) break block4;
                    var7_6 = $this$unwrapQualified$iv;
                    binaryExpr = (KtBinaryExpression)parent$iv;
                    $i$a$-unwrapQualified-KtFirExpressionTypeProvider$getExpectedTypeByVariableAssignment$assignmentExpression$1 = false;
                    if (!(Intrinsics.areEqual((Object)binaryExpr.getRight(), (Object)expr) != false && Intrinsics.areEqual((Object)binaryExpr.getOperationToken(), (Object)KtTokens.EQ) != false)) break block4;
                    v0 = parent$iv;
                    break block5;
                }
                if (!(parent$iv instanceof KtQualifiedExpression) || !Intrinsics.areEqual((Object)((KtQualifiedExpression)parent$iv).getSelectorExpression(), (Object)$this$unwrapQualified$iv)) break block6;
                grandParent$iv = KtFirExpressionTypeProviderKt.access$getNonContainerParent(parent$iv);
                if (!(grandParent$iv instanceof KtBinaryExpression)) ** GOTO lbl-1000
                $i$a$-unwrapQualified-KtFirExpressionTypeProvider$getExpectedTypeByVariableAssignment$assignmentExpression$1 = parent$iv;
                binaryExpr = (KtBinaryExpression)grandParent$iv;
                $i$a$-unwrapQualified-KtFirExpressionTypeProvider$getExpectedTypeByVariableAssignment$assignmentExpression$1 = false;
                if (Intrinsics.areEqual((Object)binaryExpr.getRight(), (Object)expr) != false && Intrinsics.areEqual((Object)binaryExpr.getOperationToken(), (Object)KtTokens.EQ) != false) {
                    v0 = grandParent$iv;
                } else lbl-1000:
                // 2 sources

                {
                    v0 = null;
                }
                break block5;
            }
            v0 = null;
        }
        v1 = (KtBinaryExpression)v0;
        if (v1 == null) {
            return null;
        }
        assignmentExpression = v1;
        var5_4 = assignmentExpression.getLeft();
        v2 = var5_4 instanceof KtNameReferenceExpression != false ? (KtNameReferenceExpression)var5_4 : null;
        if (v2 == null) {
            return null;
        }
        variableExpression = v2;
        return this.getKtExpressionType(variableExpression);
    }

    /*
     * Unable to fully structure code
     */
    private final KtType getExpectedTypeByPropertyDeclaration(PsiElement expression) {
        block4: {
            block5: {
                block3: {
                    $this$unwrapQualified$iv = expression;
                    $i$f$unwrapQualified = false;
                    parent$iv = KtFirExpressionTypeProviderKt.access$getNonContainerParent($this$unwrapQualified$iv);
                    if (!(parent$iv instanceof KtProperty)) break block3;
                    var6_5 = $this$unwrapQualified$iv;
                    property = (KtProperty)parent$iv;
                    $i$a$-unwrapQualified-KtFirExpressionTypeProvider$getExpectedTypeByPropertyDeclaration$property$1 = false;
                    if (!Intrinsics.areEqual((Object)property.getInitializer(), (Object)expr)) break block3;
                    v0 = parent$iv;
                    break block4;
                }
                if (!(parent$iv instanceof KtQualifiedExpression) || !Intrinsics.areEqual((Object)((KtQualifiedExpression)parent$iv).getSelectorExpression(), (Object)$this$unwrapQualified$iv)) break block5;
                grandParent$iv = KtFirExpressionTypeProviderKt.access$getNonContainerParent(parent$iv);
                if (!(grandParent$iv instanceof KtProperty)) ** GOTO lbl-1000
                $i$a$-unwrapQualified-KtFirExpressionTypeProvider$getExpectedTypeByPropertyDeclaration$property$1 = parent$iv;
                property = (KtProperty)grandParent$iv;
                $i$a$-unwrapQualified-KtFirExpressionTypeProvider$getExpectedTypeByPropertyDeclaration$property$1 = false;
                if (Intrinsics.areEqual((Object)property.getInitializer(), (Object)expr)) {
                    v0 = grandParent$iv;
                } else lbl-1000:
                // 2 sources

                {
                    v0 = null;
                }
                break block4;
            }
            v0 = null;
        }
        v1 = (KtProperty)v0;
        if (v1 == null) {
            return null;
        }
        property = v1;
        return this.getReturnTypeForKtDeclaration(property);
    }

    /*
     * Unable to fully structure code
     */
    private final KtType getExpectedTypeByFunctionExpressionBody(PsiElement expression) {
        block5: {
            block6: {
                block4: {
                    $this$unwrapQualified$iv = expression;
                    $i$f$unwrapQualified = false;
                    parent$iv = KtFirExpressionTypeProviderKt.access$getNonContainerParent($this$unwrapQualified$iv);
                    if (!(parent$iv instanceof KtFunction)) break block4;
                    var6_5 = $this$unwrapQualified$iv;
                    function = (KtFunction)parent$iv;
                    $i$a$-unwrapQualified-KtFirExpressionTypeProvider$getExpectedTypeByFunctionExpressionBody$function$1 = false;
                    if (!Intrinsics.areEqual((Object)function.getBodyExpression(), (Object)expr)) break block4;
                    v0 = parent$iv;
                    break block5;
                }
                if (!(parent$iv instanceof KtQualifiedExpression) || !Intrinsics.areEqual((Object)((KtQualifiedExpression)parent$iv).getSelectorExpression(), (Object)$this$unwrapQualified$iv)) break block6;
                grandParent$iv = KtFirExpressionTypeProviderKt.access$getNonContainerParent(parent$iv);
                if (!(grandParent$iv instanceof KtFunction)) ** GOTO lbl-1000
                $i$a$-unwrapQualified-KtFirExpressionTypeProvider$getExpectedTypeByFunctionExpressionBody$function$1 = parent$iv;
                function = (KtFunction)grandParent$iv;
                $i$a$-unwrapQualified-KtFirExpressionTypeProvider$getExpectedTypeByFunctionExpressionBody$function$1 = false;
                if (Intrinsics.areEqual((Object)function.getBodyExpression(), (Object)expr)) {
                    v0 = grandParent$iv;
                } else lbl-1000:
                // 2 sources

                {
                    v0 = null;
                }
                break block5;
            }
            v0 = null;
        }
        v1 = (KtFunction)v0;
        if (v1 == null) {
            return null;
        }
        function = v1;
        if (function.getBodyBlockExpression() != null) {
            return null;
        }
        return this.getReturnTypeForKtDeclaration(function);
    }

    /*
     * Unable to fully structure code
     */
    private final boolean isWhileLoopCondition(PsiElement $this$isWhileLoopCondition) {
        block3: {
            block4: {
                block2: {
                    $this$unwrapQualified$iv = $this$isWhileLoopCondition;
                    $i$f$unwrapQualified = false;
                    parent$iv = KtFirExpressionTypeProviderKt.access$getNonContainerParent($this$unwrapQualified$iv);
                    if (!(parent$iv instanceof KtWhileExpressionBase)) break block2;
                    var5_5 = $this$unwrapQualified$iv;
                    whileExpr = (KtWhileExpressionBase)parent$iv;
                    $i$a$-unwrapQualified-KtFirExpressionTypeProvider$isWhileLoopCondition$1 = false;
                    if (!Intrinsics.areEqual((Object)whileExpr.getCondition(), (Object)cond)) break block2;
                    v0 = parent$iv;
                    break block3;
                }
                if (!(parent$iv instanceof KtQualifiedExpression) || !Intrinsics.areEqual((Object)((KtQualifiedExpression)parent$iv).getSelectorExpression(), (Object)$this$unwrapQualified$iv)) break block4;
                grandParent$iv = KtFirExpressionTypeProviderKt.access$getNonContainerParent(parent$iv);
                if (!(grandParent$iv instanceof KtWhileExpressionBase)) ** GOTO lbl-1000
                $i$a$-unwrapQualified-KtFirExpressionTypeProvider$isWhileLoopCondition$1 = parent$iv;
                whileExpr = (KtWhileExpressionBase)grandParent$iv;
                $i$a$-unwrapQualified-KtFirExpressionTypeProvider$isWhileLoopCondition$1 = false;
                if (Intrinsics.areEqual((Object)whileExpr.getCondition(), (Object)cond)) {
                    v0 = grandParent$iv;
                } else lbl-1000:
                // 2 sources

                {
                    v0 = null;
                }
                break block3;
            }
            v0 = null;
        }
        return v0 != null;
    }

    /*
     * Unable to fully structure code
     */
    private final boolean isIfCondition(PsiElement $this$isIfCondition) {
        block3: {
            block4: {
                block2: {
                    $this$unwrapQualified$iv = $this$isIfCondition;
                    $i$f$unwrapQualified = false;
                    parent$iv = KtFirExpressionTypeProviderKt.access$getNonContainerParent($this$unwrapQualified$iv);
                    if (!(parent$iv instanceof KtIfExpression)) break block2;
                    var5_5 = $this$unwrapQualified$iv;
                    ifExpr = (KtIfExpression)parent$iv;
                    $i$a$-unwrapQualified-KtFirExpressionTypeProvider$isIfCondition$1 = false;
                    if (!Intrinsics.areEqual((Object)ifExpr.getCondition(), (Object)cond)) break block2;
                    v0 = parent$iv;
                    break block3;
                }
                if (!(parent$iv instanceof KtQualifiedExpression) || !Intrinsics.areEqual((Object)((KtQualifiedExpression)parent$iv).getSelectorExpression(), (Object)$this$unwrapQualified$iv)) break block4;
                grandParent$iv = KtFirExpressionTypeProviderKt.access$getNonContainerParent(parent$iv);
                if (!(grandParent$iv instanceof KtIfExpression)) ** GOTO lbl-1000
                $i$a$-unwrapQualified-KtFirExpressionTypeProvider$isIfCondition$1 = parent$iv;
                ifExpr = (KtIfExpression)grandParent$iv;
                $i$a$-unwrapQualified-KtFirExpressionTypeProvider$isIfCondition$1 = false;
                if (Intrinsics.areEqual((Object)ifExpr.getCondition(), (Object)cond)) {
                    v0 = grandParent$iv;
                } else lbl-1000:
                // 2 sources

                {
                    v0 = null;
                }
                break block3;
            }
            v0 = null;
        }
        return v0 != null;
    }

    @Override
    public boolean isDefinitelyNull(@NotNull KtExpression expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        return this.getDefiniteNullability(expression2) == DefiniteNullability.DEFINITELY_NULL;
    }

    @Override
    public boolean isDefinitelyNotNull(@NotNull KtExpression expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        return this.getDefiniteNullability(expression2) == DefiniteNullability.DEFINITELY_NOT_NULL;
    }

    private final DefiniteNullability getDefiniteNullability(KtExpression expression2) {
        FirElement fir = LowLevelFirApiFacadeKt.getOrBuildFir(expression2, this.getAnalysisSession().getFirResolveSession());
        if (fir instanceof FirExpressionWithSmartcastToNothing) {
            if (((FirExpressionWithSmartcastToNothing)fir).isStable()) {
                return DefiniteNullability.DEFINITELY_NULL;
            }
        } else if (fir instanceof FirExpressionWithSmartcast ? ((FirExpressionWithSmartcast)fir).isStable() && KtFirExpressionTypeProvider.getDefiniteNullability$isNotNullable((FirExpression)fir, this) : fir instanceof FirExpression && KtFirExpressionTypeProvider.getDefiniteNullability$isNotNullable((FirExpression)fir, this)) {
            return DefiniteNullability.DEFINITELY_NOT_NULL;
        }
        return DefiniteNullability.UNKNOWN;
    }

    @Override
    @NotNull
    public FirSession getRootModuleSession() {
        return KtFirAnalysisSessionComponent.DefaultImpls.getRootModuleSession(this);
    }

    @Override
    @NotNull
    public ConeInferenceContext getTypeContext() {
        return KtFirAnalysisSessionComponent.DefaultImpls.getTypeContext(this);
    }

    @Override
    @NotNull
    public KtSymbolByFirBuilder getFirSymbolBuilder() {
        return KtFirAnalysisSessionComponent.DefaultImpls.getFirSymbolBuilder(this);
    }

    @Override
    @NotNull
    public LLFirResolveSession getFirResolveSession() {
        return KtFirAnalysisSessionComponent.DefaultImpls.getFirResolveSession(this);
    }

    @Override
    @NotNull
    public KtType asKtType(@NotNull ConeKotlinType $this$asKtType) {
        return KtFirAnalysisSessionComponent.DefaultImpls.asKtType(this, $this$asKtType);
    }

    @Override
    @NotNull
    public KtDiagnosticWithPsi<?> asKtDiagnostic(@NotNull KtPsiDiagnostic $this$asKtDiagnostic) {
        return KtFirAnalysisSessionComponent.DefaultImpls.asKtDiagnostic(this, $this$asKtDiagnostic);
    }

    @Override
    @Nullable
    public KtDiagnosticWithPsi<?> asKtDiagnostic(@NotNull ConeDiagnostic $this$asKtDiagnostic, @NotNull KtSourceElement source2, @Nullable KtSourceElement qualifiedAccessSource) {
        return KtFirAnalysisSessionComponent.DefaultImpls.asKtDiagnostic(this, $this$asKtDiagnostic, source2, qualifiedAccessSource);
    }

    @Override
    @NotNull
    public ConeKotlinType getConeType(@NotNull KtType $this$coneType) {
        return KtFirAnalysisSessionComponent.DefaultImpls.getConeType(this, $this$coneType);
    }

    @Override
    @NotNull
    public ConeTypeProjection getConeTypeProjection(@NotNull KtTypeArgument $this$coneTypeProjection) {
        return KtFirAnalysisSessionComponent.DefaultImpls.getConeTypeProjection(this, $this$coneTypeProjection);
    }

    @Override
    @NotNull
    public TypeCheckerState createTypeCheckerContext() {
        return KtFirAnalysisSessionComponent.DefaultImpls.createTypeCheckerContext(this);
    }

    @Override
    @Nullable
    public KtSubstitutor createSubstitutorFromTypeArguments(@NotNull FirQualifiedAccess $this$createSubstitutorFromTypeArguments) {
        return KtFirAnalysisSessionComponent.DefaultImpls.createSubstitutorFromTypeArguments(this, $this$createSubstitutorFromTypeArguments);
    }

    @Override
    @NotNull
    public KtSubstitutor createSubstitutorFromTypeArguments(@NotNull FirQualifiedAccess $this$createSubstitutorFromTypeArguments, @NotNull FirCallableSymbol<?> callableSymbol) {
        return KtFirAnalysisSessionComponent.DefaultImpls.createSubstitutorFromTypeArguments(this, $this$createSubstitutorFromTypeArguments, callableSymbol);
    }

    @Override
    @Nullable
    public ConeSubstitutor createConeSubstitutorFromTypeArguments(@NotNull FirQualifiedAccess $this$createConeSubstitutorFromTypeArguments) {
        return KtFirAnalysisSessionComponent.DefaultImpls.createConeSubstitutorFromTypeArguments(this, $this$createConeSubstitutorFromTypeArguments);
    }

    @Override
    @NotNull
    public ConeSubstitutor createConeSubstitutorFromTypeArguments(@NotNull FirQualifiedAccess $this$createConeSubstitutorFromTypeArguments, @NotNull FirCallableSymbol<?> callableSymbol) {
        return KtFirAnalysisSessionComponent.DefaultImpls.createConeSubstitutorFromTypeArguments(this, $this$createConeSubstitutorFromTypeArguments, callableSymbol);
    }

    @Override
    @NotNull
    public KtSubstitutor toKtSubstitutor(@NotNull ConeSubstitutor $this$toKtSubstitutor) {
        return KtFirAnalysisSessionComponent.DefaultImpls.toKtSubstitutor(this, $this$toKtSubstitutor);
    }

    private static final boolean getDefiniteNullability$isNotNullable(FirExpression $this$getDefiniteNullability_u24isNotNullable, KtFirExpressionTypeProvider this$0) {
        ConeInferenceContext $this$getDefiniteNullability_u24isNotNullable_u24lambda_u2415 = TypeComponentsKt.getTypeContext(this$0.getAnalysisSession().getUseSiteSession$analysis_api_fir());
        boolean bl = false;
        return !$this$getDefiniteNullability_u24isNotNullable_u24lambda_u2415.isNullableType(FirTypeUtilsKt.getConeType($this$getDefiniteNullability_u24isNotNullable.getTypeRef()));
    }
}

