/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.util;

import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.util.CounterWithExclude;
import org.jetbrains.kotlin.util.PerformanceCounter;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \u00142\u00020\u0001:\u0002\u0013\u0014B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0005\"\u00020\u0001\u00a2\u0006\u0002\u0010\u0006J!\u0010\u000b\u001a\u0002H\f\"\u0004\b\u0000\u0010\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\f0\u000eH\u0014\u00a2\u0006\u0002\u0010\u000fJ\u0006\u0010\u0010\u001a\u00020\u0011J\u0006\u0010\u0012\u001a\u00020\u0011R\u0014\u0010\u0007\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/util/CounterWithExclude;", "Lorg/jetbrains/kotlin/util/PerformanceCounter;", "name", "", "excludedCounters", "", "(Ljava/lang/String;[Lorg/jetbrains/kotlin/util/PerformanceCounter;)V", "callStack", "Lorg/jetbrains/kotlin/util/CounterWithExclude$CallStackWithTime;", "getCallStack", "()Lorg/jetbrains/kotlin/util/CounterWithExclude$CallStackWithTime;", "countTime", "T", "block", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "enterExcludedMethod", "", "exitExcludedMethod", "CallStackWithTime", "Companion", "util.runtime"})
public final class CounterWithExclude
extends PerformanceCounter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final ThreadLocal<Map<CounterWithExclude, CallStackWithTime>> counterToCallStackMapThreadLocal = new ThreadLocal();

    public CounterWithExclude(@NotNull String name2, PerformanceCounter ... excludedCounters) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)excludedCounters, (String)"excludedCounters");
        super(name2);
        PerformanceCounter[] $this$forEach$iv = excludedCounters;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            PerformanceCounter element$iv;
            PerformanceCounter it = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            it.getExcludedFrom$util_runtime().add(this);
        }
    }

    private final CallStackWithTime getCallStack() {
        return CounterWithExclude.Companion.getCallStack(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected <T> T countTime(@NotNull Function0<? extends T> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        this.incrementTime(this.getCallStack().push(true));
        try {
            Object object = block.invoke();
            return (T)object;
        }
        finally {
            this.incrementTime(this.getCallStack().pop(true));
        }
    }

    public final void enterExcludedMethod() {
        this.incrementTime(this.getCallStack().push(false));
    }

    public final void exitExcludedMethod() {
        this.incrementTime(this.getCallStack().pop(false));
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0006H\u0002R \u0010\u0003\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/util/CounterWithExclude$Companion;", "", "()V", "counterToCallStackMapThreadLocal", "Ljava/lang/ThreadLocal;", "", "Lorg/jetbrains/kotlin/util/CounterWithExclude;", "Lorg/jetbrains/kotlin/util/CounterWithExclude$CallStackWithTime;", "getCallStack", "counter", "util.runtime"})
    public static final class Companion {
        private Companion() {
        }

        private final CallStackWithTime getCallStack(CounterWithExclude counter) {
            Object object;
            PerformanceCounter.Companion companion = PerformanceCounter.Companion;
            ThreadLocal threadLocal$iv = counterToCallStackMapThreadLocal;
            boolean $i$f$getOrPut$util_runtime = false;
            Object value$iv = threadLocal$iv.get();
            if (value$iv == null) {
                boolean bl = false;
                value$iv = new HashMap();
                threadLocal$iv.set(value$iv);
            }
            Map $this$getOrPut$iv = (Map)value$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv2 = $this$getOrPut$iv.get(counter);
            if (value$iv2 == null) {
                boolean bl = false;
                CallStackWithTime answer$iv = new CallStackWithTime();
                $this$getOrPut$iv.put(counter, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv2;
            }
            return (CallStackWithTime)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J'\u0010\b\u001a\u00020\u00072\u001d\u0010\t\u001a\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\u0002\b\fH\u0002J\u0006\u0010\r\u001a\u00020\u0005J\u000e\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0005J\u000e\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0005J\u001d\u0010\u0011\u001a\n \u0012*\u0004\u0018\u00010\u00050\u0005*\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0002\u0010\u0013R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/util/CounterWithExclude$CallStackWithTime;", "", "()V", "callStack", "Ljava/util/Stack;", "", "intervalStartTime", "", "intervalUsefulTime", "callStackUpdate", "Lkotlin/Function1;", "", "Lkotlin/ExtensionFunctionType;", "isEnteredCounter", "pop", "usefulCall", "push", "peekOrFalse", "kotlin.jvm.PlatformType", "(Ljava/util/Stack;)Ljava/lang/Boolean;", "util.runtime"})
    private static final class CallStackWithTime {
        @NotNull
        private final Stack<Boolean> callStack = new Stack();
        private long intervalStartTime;

        public final Boolean peekOrFalse(@NotNull Stack<Boolean> $this$peekOrFalse) {
            Intrinsics.checkNotNullParameter($this$peekOrFalse, (String)"<this>");
            return $this$peekOrFalse.isEmpty() ? Boolean.valueOf(false) : $this$peekOrFalse.peek();
        }

        private final long intervalUsefulTime(Function1<? super Stack<Boolean>, Unit> callStackUpdate) {
            Boolean bl = this.peekOrFalse(this.callStack);
            Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"callStack.peekOrFalse()");
            long delta = bl != false ? PerformanceCounter.Companion.currentTime() - this.intervalStartTime : 0L;
            callStackUpdate.invoke(this.callStack);
            this.intervalStartTime = PerformanceCounter.Companion.currentTime();
            return delta;
        }

        public final long push(boolean usefulCall) {
            if (!this.isEnteredCounter() && !usefulCall) {
                return 0L;
            }
            return this.intervalUsefulTime((Function1<? super Stack<Boolean>, Unit>)((Function1)new Function1<Stack<Boolean>, Unit>(usefulCall){
                final /* synthetic */ boolean $usefulCall;
                {
                    this.$usefulCall = $usefulCall;
                    super(1);
                }

                public final void invoke(@NotNull Stack<Boolean> $this$intervalUsefulTime) {
                    Intrinsics.checkNotNullParameter($this$intervalUsefulTime, (String)"$this$intervalUsefulTime");
                    $this$intervalUsefulTime.push(this.$usefulCall);
                }
            }));
        }

        public final long pop(boolean usefulCall) {
            if (!this.isEnteredCounter()) {
                return 0L;
            }
            boolean bl = Intrinsics.areEqual((Object)this.callStack.peek(), (Object)usefulCall);
            if (_Assertions.ENABLED && !bl) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            return this.intervalUsefulTime((Function1<? super Stack<Boolean>, Unit>)((Function1)pop.1.INSTANCE));
        }

        public final boolean isEnteredCounter() {
            return !this.callStack.isEmpty();
        }
    }
}

