/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.checkers;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.impl.FunctionExpressionDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.psi.KtTypeParameterListOwner;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J,\u0010\u000b\u001a\u00020\u00042\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u0013H\u0007J*\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u0013H\u0007\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/UnderscoreChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "checkIdentifier", "identifier", "Lcom/intellij/psi/PsiElement;", "diagnosticHolder", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "allowSingleUnderscore", "", "checkNamed", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "frontend"})
public final class UnderscoreChecker
implements DeclarationChecker {
    @NotNull
    public static final UnderscoreChecker INSTANCE = new UnderscoreChecker();

    private UnderscoreChecker() {
    }

    /*
     * Enabled aggressive block sorting
     */
    @JvmOverloads
    public final void checkIdentifier(@Nullable PsiElement identifier, @NotNull DiagnosticSink diagnosticHolder, @NotNull LanguageVersionSettings languageVersionSettings2, boolean allowSingleUnderscore) {
        boolean isValidSingleUnderscore;
        Intrinsics.checkNotNullParameter((Object)diagnosticHolder, (String)"diagnosticHolder");
        Intrinsics.checkNotNullParameter((Object)languageVersionSettings2, (String)"languageVersionSettings");
        if (identifier == null) return;
        String string2 = identifier.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"identifier.text");
        if (((CharSequence)string2).length() == 0) {
            return;
        }
        boolean bl = false;
        if (bl) {
            return;
        }
        boolean bl2 = isValidSingleUnderscore = allowSingleUnderscore && Intrinsics.areEqual((Object)identifier.getText(), (Object)"_");
        if (!isValidSingleUnderscore) {
            boolean bl3;
            block5: {
                String string3 = identifier.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"identifier.text");
                CharSequence $this$all$iv = string3;
                boolean $i$f$all = false;
                for (int i = 0; i < $this$all$iv.length(); ++i) {
                    char element$iv;
                    char it = element$iv = $this$all$iv.charAt(i);
                    boolean bl4 = false;
                    if (it == '_') continue;
                    bl3 = false;
                    break block5;
                }
                bl3 = true;
            }
            if (bl3) {
                diagnosticHolder.report(Errors.UNDERSCORE_IS_RESERVED.on(identifier));
                return;
            }
        }
        if (!isValidSingleUnderscore) return;
        if (languageVersionSettings2.supportsFeature(LanguageFeature.SingleUnderscoreForParameterName)) return;
        diagnosticHolder.report(Errors.UNSUPPORTED_FEATURE.on(identifier, (Pair<LanguageFeature, LanguageVersionSettings>)TuplesKt.to((Object)((Object)LanguageFeature.SingleUnderscoreForParameterName), (Object)languageVersionSettings2)));
    }

    public static /* synthetic */ void checkIdentifier$default(UnderscoreChecker underscoreChecker, PsiElement psiElement, DiagnosticSink diagnosticSink, LanguageVersionSettings languageVersionSettings2, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            bl = false;
        }
        underscoreChecker.checkIdentifier(psiElement, diagnosticSink, languageVersionSettings2, bl);
    }

    @JvmOverloads
    public final void checkNamed(@NotNull KtNamedDeclaration declaration, @NotNull DiagnosticSink diagnosticHolder, @NotNull LanguageVersionSettings languageVersionSettings2, boolean allowSingleUnderscore) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)diagnosticHolder, (String)"diagnosticHolder");
        Intrinsics.checkNotNullParameter((Object)languageVersionSettings2, (String)"languageVersionSettings");
        this.checkIdentifier(declaration.getNameIdentifier(), diagnosticHolder, languageVersionSettings2, allowSingleUnderscore);
    }

    public static /* synthetic */ void checkNamed$default(UnderscoreChecker underscoreChecker, KtNamedDeclaration ktNamedDeclaration, DiagnosticSink diagnosticSink, LanguageVersionSettings languageVersionSettings2, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            bl = false;
        }
        underscoreChecker.checkNamed(ktNamedDeclaration, diagnosticSink, languageVersionSettings2, bl);
    }

    @Override
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (declaration instanceof KtProperty && !(descriptor2 instanceof VariableDescriptor)) {
            return;
        }
        if (declaration instanceof KtCallableDeclaration) {
            for (KtParameter parameter2 : ((KtCallableDeclaration)declaration).getValueParameters()) {
                Intrinsics.checkNotNullExpressionValue((Object)parameter2, (String)"parameter");
                this.checkNamed(parameter2, context.getTrace(), context.getLanguageVersionSettings(), descriptor2 instanceof FunctionExpressionDescriptor);
            }
        }
        if (declaration instanceof KtTypeParameterListOwner) {
            for (KtTypeParameter typeParameter : ((KtTypeParameterListOwner)declaration).getTypeParameters()) {
                Intrinsics.checkNotNullExpressionValue((Object)typeParameter, (String)"typeParameter");
                UnderscoreChecker.checkNamed$default(this, typeParameter, context.getTrace(), context.getLanguageVersionSettings(), false, 8, null);
            }
        }
        if (!(declaration instanceof KtNamedDeclaration)) {
            return;
        }
        UnderscoreChecker.checkNamed$default(this, (KtNamedDeclaration)declaration, context.getTrace(), context.getLanguageVersionSettings(), false, 8, null);
    }

    @JvmOverloads
    public final void checkIdentifier(@Nullable PsiElement identifier, @NotNull DiagnosticSink diagnosticHolder, @NotNull LanguageVersionSettings languageVersionSettings2) {
        Intrinsics.checkNotNullParameter((Object)diagnosticHolder, (String)"diagnosticHolder");
        Intrinsics.checkNotNullParameter((Object)languageVersionSettings2, (String)"languageVersionSettings");
        UnderscoreChecker.checkIdentifier$default(this, identifier, diagnosticHolder, languageVersionSettings2, false, 8, null);
    }

    @JvmOverloads
    public final void checkNamed(@NotNull KtNamedDeclaration declaration, @NotNull DiagnosticSink diagnosticHolder, @NotNull LanguageVersionSettings languageVersionSettings2) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)diagnosticHolder, (String)"diagnosticHolder");
        Intrinsics.checkNotNullParameter((Object)languageVersionSettings2, (String)"languageVersionSettings");
        UnderscoreChecker.checkNamed$default(this, declaration, diagnosticHolder, languageVersionSettings2, false, 8, null);
    }
}

