/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.interpreter.intrinsics;

import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.interpreter.Instruction;
import org.jetbrains.kotlin.ir.interpreter.IrInterpreterEnvironment;
import org.jetbrains.kotlin.ir.interpreter.UtilsKt;
import org.jetbrains.kotlin.ir.interpreter.intrinsics.ArrayConstructor;
import org.jetbrains.kotlin.ir.interpreter.intrinsics.ArrayOf;
import org.jetbrains.kotlin.ir.interpreter.intrinsics.ArrayOfNulls;
import org.jetbrains.kotlin.ir.interpreter.intrinsics.AssertIntrinsic;
import org.jetbrains.kotlin.ir.interpreter.intrinsics.DataClassArrayToString;
import org.jetbrains.kotlin.ir.interpreter.intrinsics.EmptyArray;
import org.jetbrains.kotlin.ir.interpreter.intrinsics.EnumIntrinsics;
import org.jetbrains.kotlin.ir.interpreter.intrinsics.EnumValueOf;
import org.jetbrains.kotlin.ir.interpreter.intrinsics.EnumValues;
import org.jetbrains.kotlin.ir.interpreter.intrinsics.Indent;
import org.jetbrains.kotlin.ir.interpreter.intrinsics.IntrinsicBase;
import org.jetbrains.kotlin.ir.interpreter.intrinsics.JsPrimitives;
import org.jetbrains.kotlin.ir.interpreter.intrinsics.SourceLocation;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rR\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/ir/interpreter/intrinsics/IntrinsicEvaluator;", "", "()V", "fqNameToHandler", "", "", "Lorg/jetbrains/kotlin/ir/interpreter/intrinsics/IntrinsicBase;", "unwindInstructions", "", "Lorg/jetbrains/kotlin/ir/interpreter/Instruction;", "irFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "environment", "Lorg/jetbrains/kotlin/ir/interpreter/IrInterpreterEnvironment;", "ir.interpreter"})
public final class IntrinsicEvaluator {
    @NotNull
    public static final IntrinsicEvaluator INSTANCE;
    @NotNull
    private static final Map<String, IntrinsicBase> fqNameToHandler;

    private IntrinsicEvaluator() {
    }

    @Nullable
    public final List<Instruction> unwindInstructions(@NotNull IrFunction irFunction2, @NotNull IrInterpreterEnvironment environment2) {
        Intrinsics.checkNotNullParameter((Object)irFunction2, (String)"irFunction");
        Intrinsics.checkNotNullParameter((Object)environment2, (String)"environment");
        String fqName2 = UtilsKt.getFqName(irFunction2);
        Object object = fqNameToHandler.get(fqName2);
        if (object == null || (object = ((IntrinsicBase)object).unwind(irFunction2, environment2)) == null) {
            object = EnumIntrinsics.INSTANCE.canHandleFunctionWithName(fqName2, irFunction2.getOrigin()) ? EnumIntrinsics.INSTANCE.unwind(irFunction2, environment2) : null;
        }
        return object;
    }

    static {
        Map map;
        INSTANCE = new IntrinsicEvaluator();
        Map $this$fqNameToHandler_u24lambda_u242 = map = MapsKt.createMapBuilder();
        boolean bl = false;
        Object[] objectArray = new IntrinsicBase[]{EmptyArray.INSTANCE, ArrayOf.INSTANCE, ArrayOfNulls.INSTANCE, ArrayConstructor.INSTANCE, EnumValues.INSTANCE, EnumValueOf.INSTANCE, JsPrimitives.INSTANCE, SourceLocation.INSTANCE, AssertIntrinsic.INSTANCE, DataClassArrayToString.INSTANCE, Indent.INSTANCE};
        Iterable $this$forEach$iv = CollectionsKt.listOf((Object[])objectArray);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IntrinsicBase intrinsic = (IntrinsicBase)element$iv;
            boolean bl2 = false;
            Iterable $this$forEach$iv2 = intrinsic.getListOfAcceptableFunctions();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                String it = (String)element$iv2;
                boolean bl3 = false;
                $this$fqNameToHandler_u24lambda_u242.put(it, intrinsic);
            }
        }
        fqNameToHandler = MapsKt.build((Map)map);
    }
}

