/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.providers.impl;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.providers.KotlinDeclarationProvider;
import org.jetbrains.kotlin.analysis.providers.KotlinDeclarationProviderFactory;
import org.jetbrains.kotlin.analysis.providers.impl.KotlinStaticDeclarationIndex;
import org.jetbrains.kotlin.analysis.providers.impl.KotlinStaticDeclarationProvider;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtTypeAlias;
import org.jetbrains.kotlin.psi.KtVisitorVoid;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\fB\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/analysis/providers/impl/KotlinStaticDeclarationProviderFactory;", "Lorg/jetbrains/kotlin/analysis/providers/KotlinDeclarationProviderFactory;", "files", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "(Ljava/util/Collection;)V", "index", "Lorg/jetbrains/kotlin/analysis/providers/impl/KotlinStaticDeclarationIndex;", "createDeclarationProvider", "Lorg/jetbrains/kotlin/analysis/providers/KotlinDeclarationProvider;", "searchScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "KtDeclarationRecorder", "analysis-api-providers"})
public final class KotlinStaticDeclarationProviderFactory
extends KotlinDeclarationProviderFactory {
    @NotNull
    private final KotlinStaticDeclarationIndex index;

    public KotlinStaticDeclarationProviderFactory(@NotNull Collection<? extends KtFile> files2) {
        Intrinsics.checkNotNullParameter(files2, (String)"files");
        this.index = new KotlinStaticDeclarationIndex();
        KtDeclarationRecorder recorder2 = new KtDeclarationRecorder(this.index);
        Iterable $this$forEach$iv = files2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KtFile it = (KtFile)element$iv;
            boolean bl = false;
            it.accept(recorder2);
        }
    }

    @Override
    @NotNull
    public KotlinDeclarationProvider createDeclarationProvider(@NotNull GlobalSearchScope searchScope) {
        Intrinsics.checkNotNullParameter((Object)searchScope, (String)"searchScope");
        return new KotlinStaticDeclarationProvider(this.index, searchScope);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/analysis/providers/impl/KotlinStaticDeclarationProviderFactory$KtDeclarationRecorder;", "Lorg/jetbrains/kotlin/psi/KtVisitorVoid;", "index", "Lorg/jetbrains/kotlin/analysis/providers/impl/KotlinStaticDeclarationIndex;", "(Lorg/jetbrains/kotlin/analysis/providers/impl/KotlinStaticDeclarationIndex;)V", "visitClassOrObject", "", "classOrObject", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "visitElement", "element", "Lcom/intellij/psi/PsiElement;", "visitKtFile", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "visitNamedFunction", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "visitProperty", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "visitTypeAlias", "typeAlias", "Lorg/jetbrains/kotlin/psi/KtTypeAlias;", "analysis-api-providers"})
    private static final class KtDeclarationRecorder
    extends KtVisitorVoid {
        @NotNull
        private final KotlinStaticDeclarationIndex index;

        public KtDeclarationRecorder(@NotNull KotlinStaticDeclarationIndex index2) {
            Intrinsics.checkNotNullParameter((Object)index2, (String)"index");
            this.index = index2;
        }

        public void visitElement(@NotNull PsiElement element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            element.acceptChildren((PsiElementVisitor)this);
        }

        @Override
        public void visitKtFile(@NotNull KtFile file2) {
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            if (file2.hasTopLevelCallables()) {
                this.index.getFacadeFileMap$analysis_api_providers().computeIfAbsent(file2.getPackageFqName(), KtDeclarationRecorder::visitKtFile$lambda$0).add(file2);
            }
            super.visitKtFile(file2);
        }

        @Override
        public void visitClassOrObject(@NotNull KtClassOrObject classOrObject) {
            Intrinsics.checkNotNullParameter((Object)classOrObject, (String)"classOrObject");
            ClassId classId = classOrObject.getClassId();
            if (classId != null) {
                ClassId classId2 = classId;
                boolean bl = false;
                this.index.getClassMap$analysis_api_providers().computeIfAbsent(classId2.getPackageFqName(), KtDeclarationRecorder::visitClassOrObject$lambda$2$lambda$1).add(classOrObject);
            }
            super.visitClassOrObject(classOrObject);
        }

        @Override
        public void visitTypeAlias(@NotNull KtTypeAlias typeAlias) {
            Intrinsics.checkNotNullParameter((Object)typeAlias, (String)"typeAlias");
            ClassId classId = typeAlias.getClassId();
            if (classId != null) {
                ClassId classId2 = classId;
                boolean bl = false;
                this.index.getTypeAliasMap$analysis_api_providers().computeIfAbsent(classId2.getPackageFqName(), KtDeclarationRecorder::visitTypeAlias$lambda$4$lambda$3).add(typeAlias);
            }
            super.visitTypeAlias(typeAlias);
        }

        @Override
        public void visitNamedFunction(@NotNull KtNamedFunction function2) {
            Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
            if (function2.isTopLevel()) {
                PsiElement psiElement = function2.getParent();
                Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFile");
                FqName packageFqName = ((KtFile)psiElement).getPackageFqName();
                this.index.getTopLevelFunctionMap$analysis_api_providers().computeIfAbsent(packageFqName, KtDeclarationRecorder::visitNamedFunction$lambda$5).add(function2);
            }
            super.visitNamedFunction(function2);
        }

        @Override
        public void visitProperty(@NotNull KtProperty property2) {
            Intrinsics.checkNotNullParameter((Object)property2, (String)"property");
            if (property2.isTopLevel()) {
                PsiElement psiElement = property2.getParent();
                Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFile");
                FqName packageFqName = ((KtFile)psiElement).getPackageFqName();
                this.index.getTopLevelPropertyMap$analysis_api_providers().computeIfAbsent(packageFqName, KtDeclarationRecorder::visitProperty$lambda$6).add(property2);
            }
            super.visitProperty(property2);
        }

        private static final Set visitKtFile$lambda$0(FqName it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return new LinkedHashSet();
        }

        private static final Set visitClassOrObject$lambda$2$lambda$1(FqName it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return new LinkedHashSet();
        }

        private static final Set visitTypeAlias$lambda$4$lambda$3(FqName it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return new LinkedHashSet();
        }

        private static final Set visitNamedFunction$lambda$5(FqName it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return new LinkedHashSet();
        }

        private static final Set visitProperty$lambda$6(FqName it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return new LinkedHashSet();
        }
    }
}

