/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.low.level.api.fir;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.low.level.api.fir.api.FirDeclarationDesignation;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u000f\u001a\u00020\u0010J\u0006\u0010\u0011\u001a\u00020\u0012J\u0006\u0010\u0013\u001a\u00020\u0012R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\t\u001a\u0004\u0018\u00010\u00068F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\bR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/analysis/low/level/api/fir/FirDesignationState;", "", "designation", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/api/FirDeclarationDesignation;", "(Lorg/jetbrains/kotlin/analysis/low/level/api/fir/api/FirDeclarationDesignation;)V", "currentDeclaration", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "getCurrentDeclaration", "()Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "currentDeclarationIfPresent", "getCurrentDeclarationIfPresent", "currentIndex", "", "getDesignation", "()Lorg/jetbrains/kotlin/analysis/low/level/api/fir/api/FirDeclarationDesignation;", "canGoNext", "", "goNext", "", "goToInnerDeclaration", "low-level-api-fir"})
final class FirDesignationState {
    @NotNull
    private final FirDeclarationDesignation designation;
    private int currentIndex;

    public FirDesignationState(@NotNull FirDeclarationDesignation designation2) {
        Intrinsics.checkNotNullParameter((Object)designation2, (String)"designation");
        this.designation = designation2;
        this.currentIndex = -1;
    }

    @NotNull
    public final FirDeclarationDesignation getDesignation() {
        return this.designation;
    }

    public final boolean canGoNext() {
        return this.currentIndex < this.designation.getPath().size();
    }

    @Nullable
    public final FirDeclaration getCurrentDeclarationIfPresent() {
        int n = this.currentIndex;
        return (0 <= n ? n < this.designation.getPath().size() : false) ? this.designation.getPath().get(this.currentIndex) : (n == this.designation.getPath().size() ? this.designation.getDeclaration() : null);
    }

    @NotNull
    public final FirDeclaration getCurrentDeclaration() {
        FirDeclaration firDeclaration = this.getCurrentDeclarationIfPresent();
        if (firDeclaration == null) {
            throw new IllegalStateException("Went inside target declaration".toString());
        }
        return firDeclaration;
    }

    public final void goNext() {
        if (!this.canGoNext()) {
            throw new IndexOutOfBoundsException();
        }
        int n = this.currentIndex;
        this.currentIndex = n + 1;
    }

    public final void goToInnerDeclaration() {
        if (this.currentIndex != this.designation.getPath().size()) {
            throw new IndexOutOfBoundsException();
        }
        int n = this.currentIndex;
        this.currentIndex = n + 1;
    }
}

