/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.impl.base;

import com.intellij.openapi.project.Project;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.KtAnalysisApiInternals;
import org.jetbrains.kotlin.analysis.api.KtAnalysisSession;
import org.jetbrains.kotlin.analysis.api.impl.base.KtAnalysisSessionCache;
import org.jetbrains.kotlin.analysis.api.lifetime.KtLifetimeToken;
import org.jetbrains.kotlin.analysis.api.lifetime.KtLifetimeTokenFactory;
import org.jetbrains.kotlin.analysis.api.session.KtAnalysisSessionProvider;
import org.jetbrains.kotlin.analysis.api.symbols.KtSymbol;
import org.jetbrains.kotlin.analysis.project.structure.KtModule;
import org.jetbrains.kotlin.psi.KtElement;

@KtAnalysisApiInternals
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b'\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\f\u001a\u00020\rJ\u001d\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00028\u00002\u0006\u0010\u0011\u001a\u00020\u000bH$\u00a2\u0006\u0002\u0010\u0012J\u0016\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u001aJ\u0016\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0016\u001a\u00020\u0017J\u001f\u0010\u001e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00028\u00002\u0006\u0010\u0011\u001a\u00020\u000bH\u0002\u00a2\u0006\u0002\u0010\u0012J\u0015\u0010\u001f\u001a\u00028\u00002\u0006\u0010\u0019\u001a\u00020\u001aH$\u00a2\u0006\u0002\u0010 J\u0015\u0010\u001f\u001a\u00028\u00002\u0006\u0010!\u001a\u00020\u001dH$\u00a2\u0006\u0002\u0010\"J\u0015\u0010\u001f\u001a\u00028\u00002\u0006\u0010#\u001a\u00020\u0015H$\u00a2\u0006\u0002\u0010$R(\u0010\u0007\u001a\u001c\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00028\u0000\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n0\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lorg/jetbrains/kotlin/analysis/api/impl/base/CachingKtAnalysisSessionProvider;", "State", "", "Lorg/jetbrains/kotlin/analysis/api/session/KtAnalysisSessionProvider;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "cache", "Lorg/jetbrains/kotlin/analysis/api/impl/base/KtAnalysisSessionCache;", "Lkotlin/Pair;", "Lkotlin/reflect/KClass;", "Lorg/jetbrains/kotlin/analysis/api/lifetime/KtLifetimeToken;", "clearCaches", "", "createAnalysisSession", "Lorg/jetbrains/kotlin/analysis/api/KtAnalysisSession;", "firResolveSession", "token", "(Ljava/lang/Object;Lorg/jetbrains/kotlin/analysis/api/lifetime/KtLifetimeToken;)Lorg/jetbrains/kotlin/analysis/api/KtAnalysisSession;", "getAnalysisSession", "useSiteKtElement", "Lorg/jetbrains/kotlin/psi/KtElement;", "factory", "Lorg/jetbrains/kotlin/analysis/api/lifetime/KtLifetimeTokenFactory;", "getAnalysisSessionBySymbol", "contextSymbol", "Lorg/jetbrains/kotlin/analysis/api/symbols/KtSymbol;", "getAnalysisSessionByUseSiteKtModule", "useSiteKtModule", "Lorg/jetbrains/kotlin/analysis/project/structure/KtModule;", "getCachedAnalysisSession", "getFirResolveSession", "(Lorg/jetbrains/kotlin/analysis/api/symbols/KtSymbol;)Ljava/lang/Object;", "contextModule", "(Lorg/jetbrains/kotlin/analysis/project/structure/KtModule;)Ljava/lang/Object;", "contextElement", "(Lorg/jetbrains/kotlin/psi/KtElement;)Ljava/lang/Object;", "analysis-api-impl-base"})
public abstract class CachingKtAnalysisSessionProvider<State>
extends KtAnalysisSessionProvider {
    @NotNull
    private final KtAnalysisSessionCache<Pair<State, KClass<? extends KtLifetimeToken>>> cache;

    public CachingKtAnalysisSessionProvider(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project);
        this.cache = new KtAnalysisSessionCache(project);
    }

    @NotNull
    protected abstract State getFirResolveSession(@NotNull KtElement var1);

    @NotNull
    protected abstract State getFirResolveSession(@NotNull KtSymbol var1);

    @NotNull
    protected abstract State getFirResolveSession(@NotNull KtModule var1);

    @NotNull
    protected abstract KtAnalysisSession createAnalysisSession(@NotNull State var1, @NotNull KtLifetimeToken var2);

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public final KtAnalysisSession getAnalysisSession(@NotNull KtElement useSiteKtElement, @NotNull KtLifetimeTokenFactory factory2) {
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)useSiteKtElement, (String)"useSiteKtElement");
        Intrinsics.checkNotNullParameter((Object)factory2, (String)"factory");
        State firResolveSession = this.getFirResolveSession(useSiteKtElement);
        KtAnalysisSessionCache<Pair<State, KClass<? extends KtLifetimeToken>>> ktAnalysisSessionCache = this.cache;
        Pair key$iv = TuplesKt.to(firResolveSession, factory2.getIdentifier());
        boolean $i$f$getAnalysisSession = false;
        Object object = KtAnalysisSessionCache.access$getCache$p((KtAnalysisSessionCache)this_$iv).getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"cache.value");
        ConcurrentMap $this$getOrPut$iv$iv = (ConcurrentMap)object;
        boolean $i$f$getOrPut = false;
        Object object2 = $this$getOrPut$iv$iv.get(key$iv);
        if (object2 == null) {
            boolean bl = false;
            boolean bl2 = false;
            KtLifetimeToken token = factory2.create(this.getProject());
            KtAnalysisSession default$iv$iv = this.createAnalysisSession(firResolveSession, token);
            boolean bl3 = false;
            object2 = $this$getOrPut$iv$iv.putIfAbsent(key$iv, default$iv$iv);
            if (object2 == null) {
                object2 = default$iv$iv;
            }
        }
        Intrinsics.checkNotNullExpressionValue(object2, (String)"cache.value.getOrPut(key) { create() }");
        return (KtAnalysisSession)object2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public final KtAnalysisSession getAnalysisSessionByUseSiteKtModule(@NotNull KtModule useSiteKtModule, @NotNull KtLifetimeTokenFactory factory2) {
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)useSiteKtModule, (String)"useSiteKtModule");
        Intrinsics.checkNotNullParameter((Object)factory2, (String)"factory");
        State firResolveSession = this.getFirResolveSession(useSiteKtModule);
        KtAnalysisSessionCache<Pair<State, KClass<? extends KtLifetimeToken>>> ktAnalysisSessionCache = this.cache;
        Pair key$iv = TuplesKt.to(firResolveSession, factory2.getIdentifier());
        boolean $i$f$getAnalysisSession = false;
        Object object = KtAnalysisSessionCache.access$getCache$p((KtAnalysisSessionCache)this_$iv).getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"cache.value");
        ConcurrentMap $this$getOrPut$iv$iv = (ConcurrentMap)object;
        boolean $i$f$getOrPut = false;
        Object object2 = $this$getOrPut$iv$iv.get(key$iv);
        if (object2 == null) {
            boolean bl = false;
            boolean bl2 = false;
            KtLifetimeToken validityToken = factory2.create(this.getProject());
            KtAnalysisSession default$iv$iv = this.createAnalysisSession(firResolveSession, validityToken);
            boolean bl3 = false;
            object2 = $this$getOrPut$iv$iv.putIfAbsent(key$iv, default$iv$iv);
            if (object2 == null) {
                object2 = default$iv$iv;
            }
        }
        Intrinsics.checkNotNullExpressionValue(object2, (String)"cache.value.getOrPut(key) { create() }");
        return (KtAnalysisSession)object2;
    }

    @Override
    @NotNull
    public final KtAnalysisSession getAnalysisSessionBySymbol(@NotNull KtSymbol contextSymbol) {
        Intrinsics.checkNotNullParameter((Object)contextSymbol, (String)"contextSymbol");
        State firResolveSession = this.getFirResolveSession(contextSymbol);
        KtLifetimeToken token = contextSymbol.getToken();
        KtAnalysisSession ktAnalysisSession = this.getCachedAnalysisSession(firResolveSession, token);
        if (ktAnalysisSession == null) {
            ktAnalysisSession = this.createAnalysisSession(firResolveSession, contextSymbol.getToken());
        }
        return ktAnalysisSession;
    }

    private final KtAnalysisSession getCachedAnalysisSession(State firResolveSession, KtLifetimeToken token) {
        return this.cache.getCachedAnalysisSession(TuplesKt.to(firResolveSession, (Object)Reflection.getOrCreateKotlinClass(token.getClass())));
    }

    @Override
    public final void clearCaches() {
        this.cache.clear();
    }
}

