/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.fir.utils;

import com.intellij.psi.PsiElement;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.KtConstantInitializerValue;
import org.jetbrains.kotlin.analysis.api.KtInitializerValue;
import org.jetbrains.kotlin.analysis.api.KtNonConstantInitializerValue;
import org.jetbrains.kotlin.analysis.api.base.KtConstantValue;
import org.jetbrains.kotlin.analysis.api.components.KtConstantEvaluationMode;
import org.jetbrains.kotlin.analysis.api.fir.evaluate.FirCompileTimeConstantEvaluator;
import org.jetbrains.kotlin.analysis.api.types.KtTypeNullability;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.references.FirErrorNamedReference;
import org.jetbrains.kotlin.fir.references.FirNamedReference;
import org.jetbrains.kotlin.fir.references.FirResolvedNamedReference;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeUnresolvedNameError;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;
import org.jetbrains.kotlin.fir.types.ConeErrorType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeNullability;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtAnnotatedExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtLabeledExpression;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtObjectLiteralExpression;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000:\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0002H\u0000\u001a\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u0004*\u0006\u0012\u0002\b\u00030\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a\f\u0010\b\u001a\u00020\t*\u00020\nH\u0000\u001a\f\u0010\u000b\u001a\u00020\f*\u00020\rH\u0000\u001a\f\u0010\u000e\u001a\u00020\u000f*\u00020\u000fH\u0000\u001a\f\u0010\u000e\u001a\u00020\u0010*\u00020\u0010H\u0000\u00a8\u0006\u0011"}, d2={"asKtInitializerValue", "Lorg/jetbrains/kotlin/analysis/api/KtInitializerValue;", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "computeImportableName", "Lorg/jetbrains/kotlin/name/FqName;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "useSiteSession", "Lorg/jetbrains/kotlin/fir/FirSession;", "getReferencedElementType", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "Lorg/jetbrains/kotlin/fir/references/FirNamedReference;", "toConeNullability", "Lorg/jetbrains/kotlin/fir/types/ConeNullability;", "Lorg/jetbrains/kotlin/analysis/api/types/KtTypeNullability;", "unwrap", "Lcom/intellij/psi/PsiElement;", "Lorg/jetbrains/kotlin/psi/KtExpression;", "analysis-api-fir"})
public final class FirUtilsKt {
    @NotNull
    public static final PsiElement unwrap(@NotNull PsiElement $this$unwrap) {
        Intrinsics.checkNotNullParameter((Object)$this$unwrap, (String)"<this>");
        return $this$unwrap instanceof KtExpression ? (PsiElement)FirUtilsKt.unwrap((KtExpression)$this$unwrap) : $this$unwrap;
    }

    @NotNull
    public static final KtExpression unwrap(@NotNull KtExpression $this$unwrap) {
        KtExpression ktExpression;
        KtExpression ktExpression2;
        Intrinsics.checkNotNullParameter((Object)$this$unwrap, (String)"<this>");
        KtExpression ktExpression3 = $this$unwrap;
        if (ktExpression3 instanceof KtLabeledExpression) {
            KtExpression ktExpression4 = ((KtLabeledExpression)$this$unwrap).getBaseExpression();
            ktExpression2 = ktExpression4 != null ? FirUtilsKt.unwrap(ktExpression4) : null;
        } else if (ktExpression3 instanceof KtAnnotatedExpression) {
            KtExpression ktExpression5 = ((KtAnnotatedExpression)$this$unwrap).getBaseExpression();
            ktExpression2 = ktExpression5 != null ? FirUtilsKt.unwrap(ktExpression5) : null;
        } else if (ktExpression3 instanceof KtObjectLiteralExpression) {
            ktExpression2 = ((KtObjectLiteralExpression)$this$unwrap).getObjectDeclaration();
        } else if (ktExpression3 instanceof KtFunctionLiteral) {
            PsiElement psiElement = ((KtFunctionLiteral)$this$unwrap).getParent();
            KtLambdaExpression ktLambdaExpression = psiElement instanceof KtLambdaExpression ? (KtLambdaExpression)psiElement : null;
            ktExpression2 = ktLambdaExpression != null ? FirUtilsKt.unwrap(ktLambdaExpression) : null;
        } else {
            ktExpression2 = ktExpression = $this$unwrap;
        }
        if (ktExpression2 == null) {
            ktExpression = $this$unwrap;
        }
        return ktExpression;
    }

    @NotNull
    public static final ConeKotlinType getReferencedElementType(@NotNull FirNamedReference $this$getReferencedElementType) {
        Collection<FirBasedSymbol<?>> collection;
        Intrinsics.checkNotNullParameter((Object)$this$getReferencedElementType, (String)"<this>");
        FirNamedReference firNamedReference = $this$getReferencedElementType;
        if (firNamedReference instanceof FirResolvedNamedReference) {
            collection = CollectionsKt.listOf(((FirResolvedNamedReference)$this$getReferencedElementType).getResolvedSymbol());
        } else if (firNamedReference instanceof FirErrorNamedReference) {
            collection = org.jetbrains.kotlin.analysis.api.fir.FirUtilsKt.getCandidateSymbols((FirErrorNamedReference)$this$getReferencedElementType);
        } else {
            throw new IllegalStateException(("Unexpected " + Reflection.getOrCreateKotlinClass($this$getReferencedElementType.getClass())).toString());
        }
        Collection<FirBasedSymbol<?>> symbols = collection;
        FirBasedSymbol firBasedSymbol = (FirBasedSymbol)CollectionsKt.singleOrNull((Iterable)symbols);
        Object e = firBasedSymbol != null ? firBasedSymbol.getFir() : null;
        FirCallableDeclaration firCallableDeclaration = e instanceof FirCallableDeclaration ? (FirCallableDeclaration)e : null;
        if (firCallableDeclaration == null) {
            return new ConeErrorType(new ConeUnresolvedNameError($this$getReferencedElementType.getName()), false, null, 6, null);
        }
        FirCallableDeclaration firCallableDeclaration2 = firCallableDeclaration;
        return firCallableDeclaration2.getSymbol().getResolvedReturnType();
    }

    @NotNull
    public static final ConeNullability toConeNullability(@NotNull KtTypeNullability $this$toConeNullability) {
        ConeNullability coneNullability;
        Intrinsics.checkNotNullParameter((Object)((Object)$this$toConeNullability), (String)"<this>");
        switch (WhenMappings.$EnumSwitchMapping$0[$this$toConeNullability.ordinal()]) {
            case 1: {
                coneNullability = ConeNullability.NULLABLE;
                break;
            }
            case 2: {
                coneNullability = ConeNullability.NOT_NULL;
                break;
            }
            case 3: {
                coneNullability = ConeNullability.UNKNOWN;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return coneNullability;
    }

    @Nullable
    public static final FqName computeImportableName(@NotNull FirCallableSymbol<?> $this$computeImportableName, @NotNull FirSession useSiteSession) {
        Intrinsics.checkNotNullParameter($this$computeImportableName, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)useSiteSession, (String)"useSiteSession");
        ClassId classId = $this$computeImportableName.getCallableId().getClassId();
        if (classId == null) {
            return $this$computeImportableName.getCallableId().asSingleFqName();
        }
        ClassId containingClassId = classId;
        if ($this$computeImportableName instanceof FirConstructorSymbol) {
            return containingClassId.asSingleFqName();
        }
        FirClassLikeSymbol<?> firClassLikeSymbol = FirHelpersKt.getContainingClassSymbol((FirBasedSymbol)$this$computeImportableName, useSiteSession);
        if (firClassLikeSymbol == null) {
            return null;
        }
        FirClassLikeSymbol<?> containingClass = firClassLikeSymbol;
        boolean canBeImported = containingClass.getOrigin() instanceof FirDeclarationOrigin.Java || FirHelpersKt.getClassKind(containingClass) == ClassKind.ENUM_CLASS || FirHelpersKt.getClassKind(containingClass) == ClassKind.OBJECT;
        return canBeImported ? $this$computeImportableName.getCallableId().asSingleFqName() : null;
    }

    @NotNull
    public static final KtInitializerValue asKtInitializerValue(@NotNull FirExpression $this$asKtInitializerValue) {
        Intrinsics.checkNotNullParameter((Object)$this$asKtInitializerValue, (String)"<this>");
        PsiElement psiElement = UtilsKt.getPsi($this$asKtInitializerValue);
        KtExpression ktExpression = psiElement instanceof KtExpression ? (KtExpression)psiElement : null;
        KtConstantValue evaluated = FirCompileTimeConstantEvaluator.INSTANCE.evaluateAsKtConstantValue($this$asKtInitializerValue, KtConstantEvaluationMode.CONSTANT_EXPRESSION_EVALUATION);
        return evaluated == null ? (KtInitializerValue)new KtNonConstantInitializerValue(ktExpression) : (KtInitializerValue)new KtConstantInitializerValue(evaluated, ktExpression);
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[KtTypeNullability.values().length];
            try {
                nArray[KtTypeNullability.NULLABLE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KtTypeNullability.NON_NULLABLE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KtTypeNullability.UNKNOWN.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

