/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.fir.evaluate;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.annotations.KtAnnotationApplication;
import org.jetbrains.kotlin.analysis.api.annotations.KtAnnotationApplicationValue;
import org.jetbrains.kotlin.analysis.api.annotations.KtAnnotationValue;
import org.jetbrains.kotlin.analysis.api.annotations.KtArrayAnnotationValue;
import org.jetbrains.kotlin.analysis.api.annotations.KtConstantAnnotationValue;
import org.jetbrains.kotlin.analysis.api.annotations.KtEnumEntryAnnotationValue;
import org.jetbrains.kotlin.analysis.api.annotations.KtKClassAnnotationValue;
import org.jetbrains.kotlin.analysis.api.annotations.KtNamedAnnotationValue;
import org.jetbrains.kotlin.analysis.api.annotations.KtUnsupportedAnnotationValue;
import org.jetbrains.kotlin.analysis.api.base.KtConstantValue;
import org.jetbrains.kotlin.analysis.api.base.KtConstantValueFactory;
import org.jetbrains.kotlin.analysis.api.components.KtConstantEvaluationMode;
import org.jetbrains.kotlin.analysis.api.fir.evaluate.FirCompileTimeConstantEvaluator;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.expressions.FirArgumentList;
import org.jetbrains.kotlin.fir.expressions.FirArrayOfCall;
import org.jetbrains.kotlin.fir.expressions.FirCall;
import org.jetbrains.kotlin.fir.expressions.FirConstExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirGetClassCall;
import org.jetbrains.kotlin.fir.expressions.FirNamedArgumentExpression;
import org.jetbrains.kotlin.fir.expressions.FirPropertyAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirResolvedQualifier;
import org.jetbrains.kotlin.fir.expressions.FirSpreadArgumentExpression;
import org.jetbrains.kotlin.fir.expressions.FirVarargArgumentsExpression;
import org.jetbrains.kotlin.fir.expressions.impl.FirResolvedArgumentList;
import org.jetbrains.kotlin.fir.references.FirNamedReference;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.references.FirResolvedNamedReference;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirEnumEntrySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtCallElement;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.ArrayFqNames;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ(\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00060\r2\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\u000f\u001a\u00020\u0010*\u0004\u0018\u00010\u0011H\u0002J \u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00040\u0013*\b\u0012\u0004\u0012\u00020\u00060\u00132\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u001a\u0010\u0012\u001a\u0004\u0018\u00010\u0014\"\u0004\b\u0000\u0010\u0015*\b\u0012\u0004\u0012\u0002H\u00150\u0016H\u0002J\u0016\u0010\u0012\u001a\u0004\u0018\u00010\u0004*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u001e\u0010\u0017\u001a\u0004\u0018\u00010\u0004*\b\u0012\u0004\u0012\u00020\u00040\u00132\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0002\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/analysis/api/fir/evaluate/FirAnnotationValueConverter;", "", "()V", "toConstantValue", "Lorg/jetbrains/kotlin/analysis/api/annotations/KtAnnotationValue;", "firExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "toNamedConstantValue", "", "Lorg/jetbrains/kotlin/analysis/api/annotations/KtNamedAnnotationValue;", "argumentMapping", "", "Lorg/jetbrains/kotlin/name/Name;", "arrayConversionExpected", "", "Lorg/jetbrains/kotlin/psi/ValueArgument;", "convertConstantExpression", "", "Lorg/jetbrains/kotlin/analysis/api/annotations/KtConstantAnnotationValue;", "T", "Lorg/jetbrains/kotlin/fir/expressions/FirConstExpression;", "toArrayConstantValueIfNecessary", "sourcePsi", "Lorg/jetbrains/kotlin/psi/KtElement;", "analysis-api-fir"})
public final class FirAnnotationValueConverter {
    @NotNull
    public static final FirAnnotationValueConverter INSTANCE = new FirAnnotationValueConverter();

    private FirAnnotationValueConverter() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<KtNamedAnnotationValue> toNamedConstantValue(@NotNull Map<Name, ? extends FirExpression> argumentMapping, @NotNull FirSession session2) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(argumentMapping, (String)"argumentMapping");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        Map<Name, ? extends FirExpression> $this$map$iv = argumentMapping;
        boolean $i$f$map = false;
        Map<Name, ? extends FirExpression> map = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator2.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Name name2 = (Name)entry.getKey();
            FirExpression expression2 = (FirExpression)entry.getValue();
            KtAnnotationValue ktAnnotationValue = INSTANCE.convertConstantExpression(expression2, session2);
            if (ktAnnotationValue == null) {
                ktAnnotationValue = KtUnsupportedAnnotationValue.INSTANCE;
            }
            collection.add(new KtNamedAnnotationValue(name2, ktAnnotationValue));
        }
        return (List)destination$iv$iv;
    }

    private final <T> KtConstantAnnotationValue convertConstantExpression(FirConstExpression<T> $this$convertConstantExpression) {
        PsiElement psiElement;
        KtConstantValue ktConstantValue = KtConstantValueFactory.INSTANCE.createConstantValue($this$convertConstantExpression.getValue(), (psiElement = UtilsKt.getPsi($this$convertConstantExpression)) instanceof KtElement ? (KtElement)psiElement : null);
        if (ktConstantValue == null) {
            return null;
        }
        KtConstantValue constantValue = ktConstantValue;
        return new KtConstantAnnotationValue(constantValue);
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<KtAnnotationValue> convertConstantExpression(Collection<? extends FirExpression> $this$convertConstantExpression, FirSession session2) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = $this$convertConstantExpression;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            KtAnnotationValue it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            FirExpression it = (FirExpression)element$iv$iv;
            boolean bl2 = false;
            if (INSTANCE.convertConstantExpression(it, session2) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final boolean arrayConversionExpected(ValueArgument $this$arrayConversionExpected) {
        return $this$arrayConversionExpected == null ? false : ($this$arrayConversionExpected instanceof KtValueArgument && ((KtValueArgument)$this$arrayConversionExpected).isSpread() ? false : !$this$arrayConversionExpected.isNamed());
    }

    private final KtAnnotationValue toArrayConstantValueIfNecessary(Collection<? extends KtAnnotationValue> $this$toArrayConstantValueIfNecessary, KtElement sourcePsi) {
        ValueArgument valueArgument;
        ValueArgument valueArgument2;
        if (sourcePsi instanceof ValueArgument) {
            valueArgument2 = (ValueArgument)sourcePsi;
        } else {
            PsiElement psiElement;
            Sequence<PsiElement> sequence2 = sourcePsi;
            if (sequence2 != null && (sequence2 = PsiUtilsKt.getParents((PsiElement)sequence2)) != null) {
                Object v2;
                block5: {
                    Sequence<PsiElement> $this$firstOrNull$iv = sequence2;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        PsiElement it = (PsiElement)element$iv;
                        boolean bl = false;
                        if (!(it instanceof ValueArgument)) continue;
                        v2 = element$iv;
                        break block5;
                    }
                    v2 = null;
                }
                psiElement = v2;
            } else {
                psiElement = null;
            }
            PsiElement psiElement2 = psiElement;
            valueArgument2 = psiElement2 instanceof ValueArgument ? (ValueArgument)psiElement2 : null;
        }
        ValueArgument valueArgument3 = valueArgument = valueArgument2;
        boolean wrap = valueArgument3 != null ? this.arrayConversionExpected(valueArgument3) : false;
        return wrap ? (KtAnnotationValue)new KtArrayAnnotationValue($this$toArrayConstantValueIfNecessary, (KtElement)sourcePsi) : (KtAnnotationValue)CollectionsKt.singleOrNull((Iterable)$this$toArrayConstantValueIfNecessary);
    }

    @Nullable
    public final KtAnnotationValue toConstantValue(@NotNull FirExpression firExpression2, @NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter((Object)firExpression2, (String)"firExpression");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        return this.convertConstantExpression(firExpression2, session2);
    }

    private final KtAnnotationValue convertConstantExpression(FirExpression $this$convertConstantExpression, FirSession session2) {
        KtAnnotationValue ktAnnotationValue;
        KtAnnotationValue ktAnnotationValue2;
        PsiElement psiElement = UtilsKt.getPsi($this$convertConstantExpression);
        KtElement sourcePsi = psiElement instanceof KtElement ? (KtElement)psiElement : null;
        FirConstExpression<?> firConstExpression = $this$convertConstantExpression;
        if (firConstExpression instanceof FirConstExpression) {
            ktAnnotationValue2 = this.convertConstantExpression($this$convertConstantExpression);
        } else if (firConstExpression instanceof FirNamedArgumentExpression) {
            ktAnnotationValue2 = this.convertConstantExpression(((FirNamedArgumentExpression)((Object)$this$convertConstantExpression)).getExpression(), session2);
        } else if (firConstExpression instanceof FirSpreadArgumentExpression) {
            ktAnnotationValue2 = this.convertConstantExpression(((FirSpreadArgumentExpression)((Object)$this$convertConstantExpression)).getExpression(), session2);
        } else if (firConstExpression instanceof FirVarargArgumentsExpression) {
            ktAnnotationValue2 = this.toArrayConstantValueIfNecessary(this.convertConstantExpression((Collection<? extends FirExpression>)((FirVarargArgumentsExpression)((Object)$this$convertConstantExpression)).getArguments(), session2), sourcePsi);
        } else if (firConstExpression instanceof FirArrayOfCall) {
            ktAnnotationValue2 = new KtArrayAnnotationValue(this.convertConstantExpression((Collection<? extends FirExpression>)((FirArrayOfCall)((Object)$this$convertConstantExpression)).getArgumentList().getArguments(), session2), sourcePsi);
        } else if (firConstExpression instanceof FirFunctionCall) {
            FirNamedReference firNamedReference = ((FirFunctionCall)((Object)$this$convertConstantExpression)).getCalleeReference();
            FirResolvedNamedReference firResolvedNamedReference = firNamedReference instanceof FirResolvedNamedReference ? (FirResolvedNamedReference)firNamedReference : null;
            if (firResolvedNamedReference == null) {
                return null;
            }
            FirResolvedNamedReference reference = firResolvedNamedReference;
            FirBasedSymbol<?> resolvedSymbol = reference.getResolvedSymbol();
            if (resolvedSymbol instanceof FirConstructorSymbol) {
                KtAnnotationApplicationValue ktAnnotationApplicationValue;
                FirClassLikeSymbol<?> firClassLikeSymbol = FirHelpersKt.getContainingClassSymbol(resolvedSymbol, session2);
                if (firClassLikeSymbol == null) {
                    return null;
                }
                FirClassLikeSymbol<?> classSymbol2 = firClassLikeSymbol;
                Object object = classSymbol2.getFir();
                FirClass firClass = object instanceof FirClass ? (FirClass)object : null;
                if ((firClass != null ? firClass.getClassKind() : null) == ClassKind.ANNOTATION_CLASS) {
                    Map resultMap = new LinkedHashMap();
                    FirCall $this$argumentMapping$iv = (FirCall)((Object)$this$convertConstantExpression);
                    boolean $i$f$getArgumentMapping = false;
                    FirArgumentList argumentList$iv = $this$argumentMapping$iv.getArgumentList();
                    LinkedHashMap<FirExpression, FirValueParameter> linkedHashMap = argumentList$iv instanceof FirResolvedArgumentList ? ((FirResolvedArgumentList)argumentList$iv).getMapping() : null;
                    Object object2 = linkedHashMap;
                    if (linkedHashMap != null && (object2 = ((LinkedHashMap)object2).entrySet()) != null) {
                        Iterable $this$forEach$iv = (Iterable)object2;
                        boolean $i$f$forEach = false;
                        for (Object element$iv : $this$forEach$iv) {
                            Map.Entry entry = (Map.Entry)element$iv;
                            boolean bl = false;
                            Intrinsics.checkNotNullExpressionValue((Object)entry, (String)"(arg, param)");
                            FirExpression arg = (FirExpression)entry.getKey();
                            FirValueParameter param = (FirValueParameter)entry.getValue();
                            Name name2 = param.getName();
                            Intrinsics.checkNotNullExpressionValue((Object)arg, (String)"arg");
                            resultMap.put(name2, arg);
                        }
                    }
                    ktAnnotationApplicationValue = new KtAnnotationApplicationValue(new KtAnnotationApplication(((FirConstructorSymbol)resolvedSymbol).getCallableId().getClassId(), (object = UtilsKt.getPsi($this$convertConstantExpression)) instanceof KtCallElement ? (KtCallElement)object : null, null, this.toNamedConstantValue(resultMap, session2)));
                } else {
                    ktAnnotationApplicationValue = null;
                }
                ktAnnotationValue2 = ktAnnotationApplicationValue;
            } else {
                ktAnnotationValue2 = resolvedSymbol instanceof FirNamedFunctionSymbol ? (ArrayFqNames.ARRAY_CALL_FQ_NAMES.contains(((FirNamedFunctionSymbol)resolvedSymbol).getCallableId().asSingleFqName()) ? this.convertConstantExpression((FirExpression)CollectionsKt.single(((FirFunctionCall)((Object)$this$convertConstantExpression)).getArgumentList().getArguments()), session2) : null) : null;
            }
        } else if (firConstExpression instanceof FirPropertyAccessExpression) {
            FirReference firReference = ((FirPropertyAccessExpression)((Object)$this$convertConstantExpression)).getCalleeReference();
            FirResolvedNamedReference firResolvedNamedReference = firReference instanceof FirResolvedNamedReference ? (FirResolvedNamedReference)firReference : null;
            if (firResolvedNamedReference == null) {
                return null;
            }
            FirResolvedNamedReference reference = firResolvedNamedReference;
            FirBasedSymbol<?> resolvedSymbol = reference.getResolvedSymbol();
            ktAnnotationValue2 = resolvedSymbol instanceof FirEnumEntrySymbol ? new KtEnumEntryAnnotationValue(((FirEnumEntrySymbol)resolvedSymbol).getCallableId(), sourcePsi) : null;
        } else if (firConstExpression instanceof FirGetClassCall) {
            KtKClassAnnotationValue ktKClassAnnotationValue;
            FirExpression firExpression2 = ((FirGetClassCall)((Object)$this$convertConstantExpression)).getArgument();
            Intrinsics.checkNotNull((Object)firExpression2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirResolvedQualifier");
            FirClassLikeSymbol<?> symbol2 = ((FirResolvedQualifier)firExpression2).getSymbol();
            if (symbol2 == null) {
                ktKClassAnnotationValue = new KtKClassAnnotationValue.KtErrorClassAnnotationValue(sourcePsi);
            } else if (symbol2.getClassId().isLocal()) {
                PsiElement psiElement2 = UtilsKt.getPsi((FirElement)symbol2.getFir());
                Intrinsics.checkNotNull((Object)psiElement2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtClassOrObject");
                ktKClassAnnotationValue = new KtKClassAnnotationValue.KtLocalKClassAnnotationValue((KtClassOrObject)psiElement2, sourcePsi);
            } else {
                ktKClassAnnotationValue = new KtKClassAnnotationValue.KtNonLocalKClassAnnotationValue(symbol2.getClassId(), sourcePsi);
            }
            ktAnnotationValue2 = ktKClassAnnotationValue;
        } else {
            ktAnnotationValue2 = ktAnnotationValue = null;
        }
        if (ktAnnotationValue2 == null) {
            firConstExpression = FirCompileTimeConstantEvaluator.INSTANCE.evaluate((FirElement)$this$convertConstantExpression, KtConstantEvaluationMode.CONSTANT_EXPRESSION_EVALUATION);
            ktAnnotationValue = firConstExpression != null ? this.convertConstantExpression(firConstExpression) : null;
        }
        return ktAnnotationValue;
    }
}

