/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.fir.components;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.analysis.api.KtTypeArgument;
import org.jetbrains.kotlin.analysis.api.components.KtTypeInfoProvider;
import org.jetbrains.kotlin.analysis.api.diagnostics.KtDiagnosticWithPsi;
import org.jetbrains.kotlin.analysis.api.fir.KtFirAnalysisSession;
import org.jetbrains.kotlin.analysis.api.fir.KtSymbolByFirBuilder;
import org.jetbrains.kotlin.analysis.api.fir.components.KtFirAnalysisSessionComponent;
import org.jetbrains.kotlin.analysis.api.fir.types.KtFirType;
import org.jetbrains.kotlin.analysis.api.fir.types.PublicTypeApproximator;
import org.jetbrains.kotlin.analysis.api.lifetime.KtLifetimeToken;
import org.jetbrains.kotlin.analysis.api.types.KtSubstitutor;
import org.jetbrains.kotlin.analysis.api.types.KtType;
import org.jetbrains.kotlin.analysis.low.level.api.fir.api.LLFirResolveSession;
import org.jetbrains.kotlin.builtins.functions.FunctionClassKind;
import org.jetbrains.kotlin.diagnostics.KtPsiDiagnostic;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.diagnostics.ConeDiagnostic;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccess;
import org.jetbrains.kotlin.fir.resolve.FirSamResolverImpl;
import org.jetbrains.kotlin.fir.resolve.substitution.ConeSubstitutor;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.types.ConeInferenceContext;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.InferenceUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeComponentsKt;
import org.jetbrains.kotlin.types.TypeApproximatorConfiguration;
import org.jetbrains.kotlin.types.TypeCheckerState;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0012\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0013\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0005\u001a\u00020\u0006X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/analysis/api/fir/components/KtFirTypeInfoProvider;", "Lorg/jetbrains/kotlin/analysis/api/components/KtTypeInfoProvider;", "Lorg/jetbrains/kotlin/analysis/api/fir/components/KtFirAnalysisSessionComponent;", "analysisSession", "Lorg/jetbrains/kotlin/analysis/api/fir/KtFirAnalysisSession;", "token", "Lorg/jetbrains/kotlin/analysis/api/lifetime/KtLifetimeToken;", "(Lorg/jetbrains/kotlin/analysis/api/fir/KtFirAnalysisSession;Lorg/jetbrains/kotlin/analysis/api/lifetime/KtLifetimeToken;)V", "getAnalysisSession", "()Lorg/jetbrains/kotlin/analysis/api/fir/KtFirAnalysisSession;", "getToken", "()Lorg/jetbrains/kotlin/analysis/api/lifetime/KtLifetimeToken;", "canBeNull", "", "type", "Lorg/jetbrains/kotlin/analysis/api/types/KtType;", "getFunctionClassKind", "Lorg/jetbrains/kotlin/builtins/functions/FunctionClassKind;", "isDenotable", "isFunctionalInterfaceType", "analysis-api-fir"})
public final class KtFirTypeInfoProvider
extends KtTypeInfoProvider
implements KtFirAnalysisSessionComponent {
    @NotNull
    private final KtFirAnalysisSession analysisSession;
    @NotNull
    private final KtLifetimeToken token;

    public KtFirTypeInfoProvider(@NotNull KtFirAnalysisSession analysisSession, @NotNull KtLifetimeToken token) {
        Intrinsics.checkNotNullParameter((Object)analysisSession, (String)"analysisSession");
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        this.analysisSession = analysisSession;
        this.token = token;
    }

    @Override
    @NotNull
    public KtFirAnalysisSession getAnalysisSession() {
        return this.analysisSession;
    }

    @Override
    @NotNull
    protected KtLifetimeToken getToken() {
        return this.token;
    }

    @Override
    public boolean isFunctionalInterfaceType(@NotNull KtType type2) {
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        ConeKotlinType coneType = ((KtFirType)((Object)type2)).getConeType();
        FirSession firSession = this.getAnalysisSession().getUseSiteSession$analysis_api_fir();
        FirSamResolverImpl samResolver = new FirSamResolverImpl(firSession, this.getAnalysisSession().getScopeSessionFor(firSession), null, 4, null);
        return samResolver.getSamInfoForPossibleSamType(coneType) != null;
    }

    @Override
    @Nullable
    public FunctionClassKind getFunctionClassKind(@NotNull KtType type2) {
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        ConeKotlinType coneType = ((KtFirType)((Object)type2)).getConeType();
        return InferenceUtilsKt.functionClassKind(coneType, this.getAnalysisSession().getUseSiteSession$analysis_api_fir());
    }

    @Override
    public boolean canBeNull(@NotNull KtType type2) {
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        return FirTypeUtilsKt.getCanBeNull(((KtFirType)((Object)type2)).getConeType());
    }

    @Override
    public boolean isDenotable(@NotNull KtType type2) {
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        ConeKotlinType coneType = ((KtFirType)((Object)type2)).getConeType();
        return TypeComponentsKt.getTypeApproximator(this.getAnalysisSession().getUseSiteSession$analysis_api_fir()).approximateToSuperType(coneType, (TypeApproximatorConfiguration)new PublicTypeApproximator.PublicApproximatorConfiguration(false)) == null;
    }

    @Override
    @NotNull
    public FirSession getRootModuleSession() {
        return KtFirAnalysisSessionComponent.DefaultImpls.getRootModuleSession(this);
    }

    @Override
    @NotNull
    public ConeInferenceContext getTypeContext() {
        return KtFirAnalysisSessionComponent.DefaultImpls.getTypeContext(this);
    }

    @Override
    @NotNull
    public KtSymbolByFirBuilder getFirSymbolBuilder() {
        return KtFirAnalysisSessionComponent.DefaultImpls.getFirSymbolBuilder(this);
    }

    @Override
    @NotNull
    public LLFirResolveSession getFirResolveSession() {
        return KtFirAnalysisSessionComponent.DefaultImpls.getFirResolveSession(this);
    }

    @Override
    @NotNull
    public KtType asKtType(@NotNull ConeKotlinType $this$asKtType) {
        return KtFirAnalysisSessionComponent.DefaultImpls.asKtType(this, $this$asKtType);
    }

    @Override
    @NotNull
    public KtDiagnosticWithPsi<?> asKtDiagnostic(@NotNull KtPsiDiagnostic $this$asKtDiagnostic) {
        return KtFirAnalysisSessionComponent.DefaultImpls.asKtDiagnostic(this, $this$asKtDiagnostic);
    }

    @Override
    @Nullable
    public KtDiagnosticWithPsi<?> asKtDiagnostic(@NotNull ConeDiagnostic $this$asKtDiagnostic, @NotNull KtSourceElement source2, @Nullable KtSourceElement qualifiedAccessSource) {
        return KtFirAnalysisSessionComponent.DefaultImpls.asKtDiagnostic(this, $this$asKtDiagnostic, source2, qualifiedAccessSource);
    }

    @Override
    @NotNull
    public ConeKotlinType getConeType(@NotNull KtType $this$coneType) {
        return KtFirAnalysisSessionComponent.DefaultImpls.getConeType(this, $this$coneType);
    }

    @Override
    @NotNull
    public ConeTypeProjection getConeTypeProjection(@NotNull KtTypeArgument $this$coneTypeProjection) {
        return KtFirAnalysisSessionComponent.DefaultImpls.getConeTypeProjection(this, $this$coneTypeProjection);
    }

    @Override
    @NotNull
    public TypeCheckerState createTypeCheckerContext() {
        return KtFirAnalysisSessionComponent.DefaultImpls.createTypeCheckerContext(this);
    }

    @Override
    @Nullable
    public KtSubstitutor createSubstitutorFromTypeArguments(@NotNull FirQualifiedAccess $this$createSubstitutorFromTypeArguments) {
        return KtFirAnalysisSessionComponent.DefaultImpls.createSubstitutorFromTypeArguments(this, $this$createSubstitutorFromTypeArguments);
    }

    @Override
    @NotNull
    public KtSubstitutor createSubstitutorFromTypeArguments(@NotNull FirQualifiedAccess $this$createSubstitutorFromTypeArguments, @NotNull FirCallableSymbol<?> callableSymbol) {
        return KtFirAnalysisSessionComponent.DefaultImpls.createSubstitutorFromTypeArguments(this, $this$createSubstitutorFromTypeArguments, callableSymbol);
    }

    @Override
    @Nullable
    public ConeSubstitutor createConeSubstitutorFromTypeArguments(@NotNull FirQualifiedAccess $this$createConeSubstitutorFromTypeArguments) {
        return KtFirAnalysisSessionComponent.DefaultImpls.createConeSubstitutorFromTypeArguments(this, $this$createConeSubstitutorFromTypeArguments);
    }

    @Override
    @NotNull
    public ConeSubstitutor createConeSubstitutorFromTypeArguments(@NotNull FirQualifiedAccess $this$createConeSubstitutorFromTypeArguments, @NotNull FirCallableSymbol<?> callableSymbol) {
        return KtFirAnalysisSessionComponent.DefaultImpls.createConeSubstitutorFromTypeArguments(this, $this$createConeSubstitutorFromTypeArguments, callableSymbol);
    }

    @Override
    @NotNull
    public KtSubstitutor toKtSubstitutor(@NotNull ConeSubstitutor $this$toKtSubstitutor) {
        return KtFirAnalysisSessionComponent.DefaultImpls.toKtSubstitutor(this, $this$toKtSubstitutor);
    }
}

