/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.descriptors.components;

import com.intellij.openapi.project.Project;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.components.KtSymbolContainingDeclarationProvider;
import org.jetbrains.kotlin.analysis.api.descriptors.Fe10AnalysisContext;
import org.jetbrains.kotlin.analysis.api.descriptors.KtFe10AnalysisSession;
import org.jetbrains.kotlin.analysis.api.descriptors.components.base.Fe10KtAnalysisSessionComponent;
import org.jetbrains.kotlin.analysis.api.descriptors.symbols.descriptorBased.base.Kt1DescUtilsKt;
import org.jetbrains.kotlin.analysis.api.descriptors.symbols.descriptorBased.base.KtFe10DescSymbol;
import org.jetbrains.kotlin.analysis.api.descriptors.symbols.psiBased.base.KtFe10PsiSymbol;
import org.jetbrains.kotlin.analysis.api.lifetime.KtLifetimeToken;
import org.jetbrains.kotlin.analysis.api.symbols.KtBackingFieldSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KtPackageSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KtSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KtValueParameterSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.markers.KtSymbolKind;
import org.jetbrains.kotlin.analysis.api.symbols.markers.KtSymbolWithKind;
import org.jetbrains.kotlin.analysis.project.structure.KtLibraryModule;
import org.jetbrains.kotlin.analysis.project.structure.KtLibrarySourceModule;
import org.jetbrains.kotlin.analysis.project.structure.KtModule;
import org.jetbrains.kotlin.analysis.project.structure.ProjectStructureProviderKt;
import org.jetbrains.kotlin.cfg.CfgContainingDeclarationUtilsKt;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.load.kotlin.JvmPackagePartSource;
import org.jetbrains.kotlin.load.kotlin.KotlinJvmBinaryClass;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.resolve.PlatformDependentAnalyzerServices;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.jvm.platform.JvmPlatformAnalyzerServices;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DescriptorWithContainerSource;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedContainerSource;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\f\u0010\u0012\u001a\u00020\u0011*\u00020\u0013H\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/analysis/api/descriptors/components/KtFe10SymbolContainingDeclarationProvider;", "Lorg/jetbrains/kotlin/analysis/api/components/KtSymbolContainingDeclarationProvider;", "Lorg/jetbrains/kotlin/analysis/api/descriptors/components/base/Fe10KtAnalysisSessionComponent;", "analysisSession", "Lorg/jetbrains/kotlin/analysis/api/descriptors/KtFe10AnalysisSession;", "(Lorg/jetbrains/kotlin/analysis/api/descriptors/KtFe10AnalysisSession;)V", "getAnalysisSession", "()Lorg/jetbrains/kotlin/analysis/api/descriptors/KtFe10AnalysisSession;", "token", "Lorg/jetbrains/kotlin/analysis/api/lifetime/KtLifetimeToken;", "getToken", "()Lorg/jetbrains/kotlin/analysis/api/lifetime/KtLifetimeToken;", "getContainingDeclaration", "Lorg/jetbrains/kotlin/analysis/api/symbols/markers/KtSymbolWithKind;", "symbol", "Lorg/jetbrains/kotlin/analysis/api/symbols/KtSymbol;", "getContainingModule", "Lorg/jetbrains/kotlin/analysis/project/structure/KtModule;", "getFakeContainingKtModule", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "analysis-api-fe10"})
public final class KtFe10SymbolContainingDeclarationProvider
extends KtSymbolContainingDeclarationProvider
implements Fe10KtAnalysisSessionComponent {
    @NotNull
    private final KtFe10AnalysisSession analysisSession;

    public KtFe10SymbolContainingDeclarationProvider(@NotNull KtFe10AnalysisSession analysisSession) {
        Intrinsics.checkNotNullParameter((Object)analysisSession, (String)"analysisSession");
        this.analysisSession = analysisSession;
    }

    @Override
    @NotNull
    public KtFe10AnalysisSession getAnalysisSession() {
        return this.analysisSession;
    }

    @Override
    @NotNull
    protected KtLifetimeToken getToken() {
        return this.getAnalysisSession().getToken();
    }

    @Override
    @Nullable
    public KtSymbolWithKind getContainingDeclaration(@NotNull KtSymbol symbol2) {
        KtSymbolWithKind ktSymbolWithKind;
        Intrinsics.checkNotNullParameter((Object)symbol2, (String)"symbol");
        if (symbol2 instanceof KtSymbolWithKind && ((KtSymbolWithKind)symbol2).getSymbolKind() == KtSymbolKind.TOP_LEVEL) {
            return null;
        }
        KtSymbol ktSymbol = symbol2;
        if (ktSymbol instanceof KtPackageSymbol) {
            ktSymbolWithKind = null;
        } else if (ktSymbol instanceof KtBackingFieldSymbol) {
            ktSymbolWithKind = ((KtBackingFieldSymbol)symbol2).getOwningProperty();
        } else if (ktSymbol instanceof KtFe10DescSymbol) {
            KtSymbol ktSymbol2;
            DeclarationDescriptor declarationDescriptor = ((KtFe10DescSymbol)symbol2).getDescriptor().getContainingDeclaration();
            KtSymbol ktSymbol3 = ktSymbol2 = declarationDescriptor != null ? Kt1DescUtilsKt.toKtSymbol(declarationDescriptor, this.getAnalysisContext()) : null;
            ktSymbolWithKind = ktSymbol2 instanceof KtSymbolWithKind ? (KtSymbolWithKind)ktSymbol2 : null;
        } else {
            if (ktSymbol instanceof KtFe10PsiSymbol) {
                KtDeclaration parentDeclaration = CfgContainingDeclarationUtilsKt.getElementParentDeclaration(((KtFe10PsiSymbol)symbol2).getPsi());
                if (parentDeclaration != null) {
                    KtFe10AnalysisSession $this$getContainingDeclaration_u24lambda_u240 = this.getAnalysisSession();
                    boolean bl = false;
                    KtSymbol ktSymbol4 = $this$getContainingDeclaration_u24lambda_u240.getSymbol(parentDeclaration);
                    return ktSymbol4 instanceof KtSymbolWithKind ? (KtSymbolWithKind)ktSymbol4 : null;
                }
                return null;
            }
            ktSymbolWithKind = null;
        }
        return ktSymbolWithKind;
    }

    @Override
    @NotNull
    public KtModule getContainingModule(@NotNull KtSymbol symbol2) {
        Object object;
        block7: {
            block6: {
                KtSymbolWithKind ktSymbolWithKind;
                Intrinsics.checkNotNullParameter((Object)symbol2, (String)"symbol");
                KtValueParameterSymbol ktValueParameterSymbol = symbol2 instanceof KtValueParameterSymbol ? (KtValueParameterSymbol)symbol2 : null;
                boolean bl = ktValueParameterSymbol != null ? ktValueParameterSymbol.isImplicitLambdaParameter() : false;
                if (bl && (ktSymbolWithKind = this.getContainingDeclaration(symbol2)) != null) {
                    KtSymbolWithKind parentLambdaSymbol = ktSymbolWithKind;
                    boolean bl2 = false;
                    return this.getContainingModule(parentLambdaSymbol);
                }
                object = symbol2.getPsi();
                if (object == null) break block6;
                Project project = this.getAnalysisSession().getAnalysisContext().getResolveSession().getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"analysisSession.analysis\u2026xt.resolveSession.project");
                if ((object = ProjectStructureProviderKt.getKtModule(object, project)) != null) break block7;
            }
            DeclarationDescriptor declarationDescriptor = Kt1DescUtilsKt.getDescriptor(symbol2);
            if (declarationDescriptor != null) {
                object = this.getFakeContainingKtModule(declarationDescriptor);
            } else {
                String string2 = symbol2.toString();
                throw new NotImplementedError("An operation is not implemented: " + string2);
            }
        }
        return object;
    }

    private final KtModule getFakeContainingKtModule(DeclarationDescriptor $this$getFakeContainingKtModule) {
        if (!($this$getFakeContainingKtModule instanceof DescriptorWithContainerSource)) {
            String string2 = $this$getFakeContainingKtModule.toString();
            throw new NotImplementedError("An operation is not implemented: " + string2);
        }
        DeserializedContainerSource deserializedContainerSource = ((DescriptorWithContainerSource)$this$getFakeContainingKtModule).getContainerSource();
        Intrinsics.checkNotNull((Object)deserializedContainerSource, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.load.kotlin.JvmPackagePartSource");
        KotlinJvmBinaryClass kotlinJvmBinaryClass2 = ((JvmPackagePartSource)deserializedContainerSource).getKnownJvmBinaryClass();
        String string3 = kotlinJvmBinaryClass2 != null ? kotlinJvmBinaryClass2.getContainingLibrary() : null;
        Intrinsics.checkNotNull((Object)string3);
        Path libraryPath = Paths.get(string3, new String[0]);
        return new KtLibraryModule(libraryPath, $this$getFakeContainingKtModule, this){
            @NotNull
            private final String libraryName;
            @Nullable
            private final KtLibrarySourceModule librarySources;
            @NotNull
            private final List<KtModule> directRegularDependencies;
            @NotNull
            private final List<KtModule> directRefinementDependencies;
            @NotNull
            private final List<KtModule> directFriendDependencies;
            @NotNull
            private final GlobalSearchScope contentScope;
            final /* synthetic */ Path $libraryPath;
            final /* synthetic */ DeclarationDescriptor $this_getFakeContainingKtModule;
            final /* synthetic */ KtFe10SymbolContainingDeclarationProvider this$0;
            {
                this.$libraryPath = $libraryPath;
                this.$this_getFakeContainingKtModule = $receiver;
                this.this$0 = $receiver2;
                this.libraryName = StringsKt.substringBeforeLast$default((String)((Object)$libraryPath.getFileName()).toString(), (String)".", null, (int)2, null);
                this.directRegularDependencies = CollectionsKt.emptyList();
                this.directRefinementDependencies = CollectionsKt.emptyList();
                this.directFriendDependencies = CollectionsKt.emptyList();
                GlobalSearchScope globalSearchScope = ProjectScope.getLibrariesScope((Project)this.getProject());
                Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"getLibrariesScope(project)");
                this.contentScope = globalSearchScope;
            }

            @NotNull
            public String getLibraryName() {
                return this.libraryName;
            }

            @Nullable
            public KtLibrarySourceModule getLibrarySources() {
                return this.librarySources;
            }

            @NotNull
            public Collection<Path> getBinaryRoots() {
                return CollectionsKt.listOf((Object)this.$libraryPath);
            }

            @NotNull
            public List<KtModule> getDirectRegularDependencies() {
                return this.directRegularDependencies;
            }

            @NotNull
            public List<KtModule> getDirectRefinementDependencies() {
                return this.directRefinementDependencies;
            }

            @NotNull
            public List<KtModule> getDirectFriendDependencies() {
                return this.directFriendDependencies;
            }

            @NotNull
            public GlobalSearchScope getContentScope() {
                return this.contentScope;
            }

            @NotNull
            public TargetPlatform getPlatform() {
                TargetPlatform targetPlatform = DescriptorUtilsKt.getPlatform(this.$this_getFakeContainingKtModule);
                Intrinsics.checkNotNull((Object)targetPlatform);
                return targetPlatform;
            }

            @NotNull
            public PlatformDependentAnalyzerServices getAnalyzerServices() {
                return JvmPlatformAnalyzerServices.INSTANCE;
            }

            @NotNull
            public Project getProject() {
                Project project = this.this$0.getAnalysisSession().getAnalysisContext().getResolveSession().getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"analysisSession.analysis\u2026xt.resolveSession.project");
                return project;
            }

            @NotNull
            public String getModuleDescription() {
                return KtLibraryModule.DefaultImpls.getModuleDescription(this);
            }
        };
    }

    @Override
    @NotNull
    public Fe10AnalysisContext getAnalysisContext() {
        return Fe10KtAnalysisSessionComponent.DefaultImpls.getAnalysisContext(this);
    }
}

