/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import com.intellij.psi.tree.IElementType;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.analysis.FirSourceUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirVariable;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.expressions.FirWhenExpression;
import org.jetbrains.kotlin.lexer.KtKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirWhenSubjectChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirWhenExpression;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirWhenExpressionChecker;", "()V", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers"})
public final class FirWhenSubjectChecker
extends FirExpressionChecker<FirWhenExpression> {
    @NotNull
    public static final FirWhenSubjectChecker INSTANCE = new FirWhenSubjectChecker();

    private FirWhenSubjectChecker() {
    }

    @Override
    public void check(@NotNull FirWhenExpression expression2, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter2) {
        FirVariable subjectVariable;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter2, (String)"reporter");
        FirExpression subject = expression2.getSubject();
        FirVariable firVariable = subjectVariable = expression2.getSubjectVariable();
        Object object = firVariable != null ? (FirElement)firVariable : (FirElement)subject;
        if (object == null || (object = ((FirStatement)object).getSource()) == null) {
            return;
        }
        Object source = object;
        Object object2 = subject;
        if (Intrinsics.areEqual((Object)(object2 != null && (object2 = ((FirExpression)object2).getSource()) != null ? ((KtSourceElement)object2).getElementType() : null), (Object)KtNodeTypes.DESTRUCTURING_DECLARATION)) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getILLEGAL_DECLARATION_IN_WHEN_SUBJECT(), (Object)"destructuring declaration", (DiagnosticContext)context, null, 16, null);
        } else {
            KtSourceElement ktSourceElement;
            Object object3 = subjectVariable;
            if (object3 != null && (object3 = ((FirVariable)object3).getSource()) != null) {
                KtKeywordToken ktKeywordToken = KtTokens.VAR_KEYWORD;
                Intrinsics.checkNotNullExpressionValue((Object)((Object)ktKeywordToken), (String)"VAR_KEYWORD");
                ktSourceElement = FirSourceUtilsKt.getChild$default((KtSourceElement)object3, ktKeywordToken, 0, 0, false, 14, null);
            } else {
                ktSourceElement = null;
            }
            if (ktSourceElement != null) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getILLEGAL_DECLARATION_IN_WHEN_SUBJECT(), (Object)"var", (DiagnosticContext)context, null, 16, null);
            } else {
                KtSourceElement ktSourceElement2;
                Object object4 = subjectVariable;
                if (object4 != null && (object4 = ((FirVariable)object4).getSource()) != null) {
                    IElementType iElementType = KtNodeTypes.PROPERTY_DELEGATE;
                    Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"PROPERTY_DELEGATE");
                    ktSourceElement2 = FirSourceUtilsKt.getChild$default((KtSourceElement)object4, iElementType, 0, 0, false, 14, null);
                } else {
                    ktSourceElement2 = null;
                }
                if (ktSourceElement2 != null) {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getILLEGAL_DECLARATION_IN_WHEN_SUBJECT(), (Object)"delegated property", (DiagnosticContext)context, null, 16, null);
                } else if (subjectVariable != null && subjectVariable.getInitializer() == null) {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getILLEGAL_DECLARATION_IN_WHEN_SUBJECT(), (Object)"variable without initializer", (DiagnosticContext)context, null, 16, null);
                }
            }
        }
    }
}

