/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpressionUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.references.FirSuperReference;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirSuperclassNotAccessibleFromInterfaceChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirQualifiedAccessExpressionChecker;", "()V", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers"})
public final class FirSuperclassNotAccessibleFromInterfaceChecker
extends FirExpressionChecker<FirQualifiedAccessExpression> {
    @NotNull
    public static final FirSuperclassNotAccessibleFromInterfaceChecker INSTANCE = new FirSuperclassNotAccessibleFromInterfaceChecker();

    private FirSuperclassNotAccessibleFromInterfaceChecker() {
    }

    @Override
    public void check(@NotNull FirQualifiedAccessExpression expression2, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter2) {
        FirElement firElement;
        block10: {
            FirQualifiedAccessExpression firQualifiedAccessExpression;
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)reporter2, (String)"reporter");
            FirExpression $this$safeAs$iv = expression2.getExplicitReceiver();
            boolean $i$f$safeAs = false;
            FirExpression firExpression2 = $this$safeAs$iv;
            if (!(firExpression2 instanceof FirQualifiedAccessExpression)) {
                firExpression2 = null;
            }
            FirReference $this$safeAs$iv2 = (firQualifiedAccessExpression = (FirQualifiedAccessExpression)firExpression2) != null ? firQualifiedAccessExpression.getCalleeReference() : null;
            boolean $i$f$safeAs2 = false;
            FirReference firReference = $this$safeAs$iv2;
            if (!(firReference instanceof FirSuperReference)) {
                firReference = null;
            }
            if ((FirSuperReference)firReference == null) {
                return;
            }
            CheckerContext $this$findClosest_u24default$iv = context;
            boolean $i$f$findClosest = false;
            for (FirDeclaration it$iv : CollectionsKt.asReversed($this$findClosest_u24default$iv.getContainingDeclarations())) {
                FirElement firElement2;
                FirDeclaration firDeclaration = it$iv;
                if (!(firDeclaration instanceof FirRegularClass)) {
                    firDeclaration = null;
                }
                if ((firElement = (FirElement)((FirRegularClass)firDeclaration)) == null) continue;
                FirElement firElement3 = firElement2 = firElement;
                boolean bl = false;
                FirElement it = firElement3;
                firElement = true ? firElement2 : null;
                if (firElement == null) {
                    continue;
                }
                break block10;
            }
            firElement = null;
        }
        FirRegularClass firRegularClass = (FirRegularClass)firElement;
        if (firRegularClass == null) {
            return;
        }
        FirRegularClass closestClass = firRegularClass;
        if (closestClass.getClassKind() == ClassKind.INTERFACE) {
            FirCallableSymbol<?> firCallableSymbol = FirExpressionUtilKt.toResolvedCallableSymbol(expression2);
            FirClassLikeSymbol<?> firClassLikeSymbol = firCallableSymbol != null ? FirHelpersKt.getContainingClassSymbol((FirBasedSymbol)firCallableSymbol, context.getSession()) : null;
            FirRegularClassSymbol firRegularClassSymbol = firClassLikeSymbol instanceof FirRegularClassSymbol ? (FirRegularClassSymbol)firClassLikeSymbol : null;
            if (firRegularClassSymbol == null) {
                return;
            }
            FirRegularClassSymbol containingClassSymbol = firRegularClassSymbol;
            if (containingClassSymbol.getSource() != null && containingClassSymbol.getClassKind() == ClassKind.CLASS) {
                FirExpression firExpression3 = expression2.getExplicitReceiver();
                KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)(firExpression3 != null ? firExpression3.getSource() : null), FirErrors.INSTANCE.getSUPERCLASS_NOT_ACCESSIBLE_FROM_INTERFACE(), (DiagnosticContext)context, null, 8, null);
            }
        }
    }
}

