/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.ReferenceUtilsKt;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.references.FirSuperReference;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.types.FirTypeRef;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirQualifiedSupertypeExtendedByOtherSupertypeChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirQualifiedAccessExpressionChecker;", "()V", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers"})
public final class FirQualifiedSupertypeExtendedByOtherSupertypeChecker
extends FirExpressionChecker<FirQualifiedAccessExpression> {
    @NotNull
    public static final FirQualifiedSupertypeExtendedByOtherSupertypeChecker INSTANCE = new FirQualifiedSupertypeExtendedByOtherSupertypeChecker();

    private FirQualifiedSupertypeExtendedByOtherSupertypeChecker() {
    }

    @Override
    public void check(@NotNull FirQualifiedAccessExpression expression2, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter2) {
        Object it;
        FirSuperReference $i$f$safeAs22;
        FirReference $this$safeAs$iv;
        block11: {
            block10: {
                FirSuperReference firSuperReference;
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                Intrinsics.checkNotNullParameter((Object)reporter2, (String)"reporter");
                if (context.getLanguageVersionSettings().supportsFeature(LanguageFeature.QualifiedSupertypeMayBeExtendedByOtherSupertype)) {
                    return;
                }
                $this$safeAs$iv = expression2.getCalleeReference();
                boolean $i$f$safeAs22 = false;
                FirReference firReference = $this$safeAs$iv;
                if (!(firReference instanceof FirSuperReference)) {
                    firReference = null;
                }
                if ((firSuperReference = (FirSuperReference)firReference) == null) break block10;
                $i$f$safeAs22 = firSuperReference;
                it = $i$f$safeAs22;
                boolean bl = false;
                FirReference firReference2 = $this$safeAs$iv = ReferenceUtilsKt.hadExplicitTypeInSource((FirSuperReference)it) ? $i$f$safeAs22 : null;
                if ($this$safeAs$iv != null) break block11;
            }
            return;
        }
        FirReference superReference = $this$safeAs$iv;
        it = FirHelpersKt.toClassLikeSymbol(((FirSuperReference)superReference).getSuperTypeRef(), context.getSession());
        $i$f$safeAs22 = it != null ? FirHelpersKt.fullyExpandedClass(it, context.getSession()) : null;
        FirClassSymbol firClassSymbol = $i$f$safeAs22 instanceof FirClassSymbol ? (FirClassSymbol)((Object)$i$f$safeAs22) : null;
        if (firClassSymbol == null) {
            return;
        }
        FirClassSymbol explicitType = firClassSymbol;
        FirClass firClass = FirHelpersKt.findClosestClassOrObject(context);
        if (firClass == null) {
            return;
        }
        FirClass surroundingType = firClass;
        int count = 0;
        FirClassSymbol candidate2 = null;
        for (FirTypeRef it2 : surroundingType.getSuperTypeRefs()) {
            FirClassSymbol that;
            FirClassLikeSymbol<?> firClassLikeSymbol = FirHelpersKt.toClassLikeSymbol(it2, context.getSession());
            FirRegularClassSymbol firRegularClassSymbol = firClassLikeSymbol != null ? FirHelpersKt.fullyExpandedClass(firClassLikeSymbol, context.getSession()) : null;
            if ((firRegularClassSymbol instanceof FirClassSymbol ? (FirClassSymbol)firRegularClassSymbol : null) == null) continue;
            that = that;
            boolean isSupertype = FirHelpersKt.isSupertypeOf(explicitType, that, context.getSession());
            if (!Intrinsics.areEqual((Object)explicitType, (Object)that) && !isSupertype) continue;
            if (isSupertype) {
                candidate2 = that;
            }
            if (++count < 2) continue;
        }
        if (count >= 2 && candidate2 != null) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)((FirSuperReference)superReference).getSuperTypeRef().getSource(), FirErrors.INSTANCE.getQUALIFIED_SUPERTYPE_EXTENDED_BY_OTHER_SUPERTYPE(), candidate2, (DiagnosticContext)context, null, 16, null);
        }
    }
}

