/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.standalone;

import com.intellij.mock.MockApplication;
import com.intellij.mock.MockProject;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.impl.jar.CoreJarFileSystem;
import com.intellij.psi.PsiElementFinder;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.KtAnalysisSessionProvider;
import org.jetbrains.kotlin.analysis.api.fir.KtFirAnalysisSessionProvider;
import org.jetbrains.kotlin.analysis.api.impl.base.references.HLApiReferenceProviderService;
import org.jetbrains.kotlin.analysis.api.standalone.RegisterComponentService;
import org.jetbrains.kotlin.analysis.decompiled.light.classes.ClsJavaStubByVirtualFileCache;
import org.jetbrains.kotlin.analysis.low.level.api.fir.api.services.FirSealedClassInheritorsProcessorFactory;
import org.jetbrains.kotlin.analysis.low.level.api.fir.api.services.PackagePartProviderFactory;
import org.jetbrains.kotlin.analysis.project.structure.KtModuleScopeProvider;
import org.jetbrains.kotlin.analysis.project.structure.KtModuleScopeProviderImpl;
import org.jetbrains.kotlin.analysis.project.structure.ProjectStructureProvider;
import org.jetbrains.kotlin.analysis.project.structure.impl.ProjectStructureProviderByCompilerConfiguration;
import org.jetbrains.kotlin.analysis.providers.KotlinAnnotationsResolverFactory;
import org.jetbrains.kotlin.analysis.providers.KotlinDeclarationProviderFactory;
import org.jetbrains.kotlin.analysis.providers.KotlinModificationTrackerFactory;
import org.jetbrains.kotlin.analysis.providers.KotlinPackageProviderFactory;
import org.jetbrains.kotlin.analysis.providers.impl.KotlinStaticAnnotationsResolverFactory;
import org.jetbrains.kotlin.analysis.providers.impl.KotlinStaticDeclarationProviderFactory;
import org.jetbrains.kotlin.analysis.providers.impl.KotlinStaticModificationTrackerFactory;
import org.jetbrains.kotlin.analysis.providers.impl.KotlinStaticPackageProviderFactory;
import org.jetbrains.kotlin.asJava.KotlinAsJavaSupport;
import org.jetbrains.kotlin.asJava.finder.JavaElementFinder;
import org.jetbrains.kotlin.cli.jvm.config.JvmContentRootsKt;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.fir.declarations.SealedClassInheritorsProvider;
import org.jetbrains.kotlin.fir.declarations.SealedClassInheritorsProviderImpl;
import org.jetbrains.kotlin.idea.references.KotlinFirReferenceContributor;
import org.jetbrains.kotlin.idea.references.KotlinReferenceProviderContributor;
import org.jetbrains.kotlin.light.classes.symbol.KotlinAsJavaFirSupport;
import org.jetbrains.kotlin.light.classes.symbol.caches.SymbolLightClassFacadeCache;
import org.jetbrains.kotlin.load.kotlin.PackagePartProvider;
import org.jetbrains.kotlin.psi.KotlinReferenceProvidersService;
import org.jetbrains.kotlin.psi.KtFile;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000R\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a4\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n2\b\b\u0002\u0010\r\u001a\u00020\u000e\u001aD\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n2\b\b\u0002\u0010\r\u001a\u00020\u000eH\u0000\u001a$\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0005\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0002\u001a\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00160\u00182\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\u0010\u0010\u0019\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0013H\u0002\u00a8\u0006\u001a"}, d2={"configureApplicationEnvironment", "", "app", "Lcom/intellij/mock/MockApplication;", "configureProjectEnvironment", "project", "Lcom/intellij/mock/MockProject;", "compilerConfig", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "packagePartProvider", "Lkotlin/Function1;", "Lcom/intellij/psi/search/GlobalSearchScope;", "Lorg/jetbrains/kotlin/load/kotlin/PackagePartProvider;", "jarFileSystem", "Lcom/intellij/openapi/vfs/impl/jar/CoreJarFileSystem;", "ktFiles", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "getKtFilesFromPaths", "Lcom/intellij/openapi/project/Project;", "paths", "", "", "getSourceFilePaths", "", "reRegisterJavaElementFinder", "analysis-api-standalone"})
public final class StandaloneModeUtilsKt {
    public static final void configureApplicationEnvironment(@NotNull MockApplication app) {
        Intrinsics.checkNotNullParameter((Object)app, (String)"app");
        if (app.getServiceIfCreated(KotlinReferenceProvidersService.class) == null) {
            app.registerService(KotlinReferenceProvidersService.class, HLApiReferenceProviderService.class);
        }
        if (app.getServiceIfCreated(KotlinReferenceProviderContributor.class) == null) {
            app.registerService(KotlinReferenceProviderContributor.class, KotlinFirReferenceContributor.class);
        }
    }

    public static final void configureProjectEnvironment(@NotNull MockProject project, @NotNull CompilerConfiguration compilerConfig, @NotNull Function1<? super GlobalSearchScope, ? extends PackagePartProvider> packagePartProvider, @NotNull CoreJarFileSystem jarFileSystem) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)compilerConfig, (String)"compilerConfig");
        Intrinsics.checkNotNullParameter(packagePartProvider, (String)"packagePartProvider");
        Intrinsics.checkNotNullParameter((Object)jarFileSystem, (String)"jarFileSystem");
        List<KtFile> ktFiles = StandaloneModeUtilsKt.getKtFilesFromPaths((Project)project, (Collection<String>)StandaloneModeUtilsKt.getSourceFilePaths(compilerConfig));
        StandaloneModeUtilsKt.configureProjectEnvironment(project, compilerConfig, ktFiles, packagePartProvider, jarFileSystem);
    }

    public static /* synthetic */ void configureProjectEnvironment$default(MockProject mockProject, CompilerConfiguration compilerConfiguration, Function1 function1, CoreJarFileSystem coreJarFileSystem, int n, Object object) {
        if ((n & 8) != 0) {
            coreJarFileSystem = new CoreJarFileSystem();
        }
        StandaloneModeUtilsKt.configureProjectEnvironment(mockProject, compilerConfiguration, (Function1<? super GlobalSearchScope, ? extends PackagePartProvider>)function1, coreJarFileSystem);
    }

    private static final Set<String> getSourceFilePaths(CompilerConfiguration compilerConfig) {
        Set set;
        Set $this$getSourceFilePaths_u24lambda_u2d2 = set = SetsKt.createSetBuilder();
        boolean bl = false;
        Iterable $this$forEach$iv = JvmContentRootsKt.getJavaSourceRoots(compilerConfig);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String srcRoot = (String)element$iv;
            boolean bl2 = false;
            Path path2 = Paths.get(srcRoot, new String[0]);
            if (Files.isDirectory(path2, new LinkOption[0])) {
                Files.walk(path2, new FileVisitOption[0]).filter(p0 -> Files.isRegularFile(p0, new LinkOption[0])).forEach(arg_0 -> StandaloneModeUtilsKt.getSourceFilePaths$lambda-2$lambda-1$lambda-0($this$getSourceFilePaths_u24lambda_u2d2, arg_0));
                continue;
            }
            $this$getSourceFilePaths_u24lambda_u2d2.add(srcRoot);
        }
        return SetsKt.build((Set)set);
    }

    private static final List<KtFile> getKtFilesFromPaths(Project project, Collection<String> paths) {
        List list2;
        VirtualFileSystem fs = StandardFileSystems.local();
        PsiManager psiManager2 = PsiManager.getInstance((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)psiManager2, (String)"getInstance(project)");
        PsiManager psiManager3 = psiManager2;
        List $this$getKtFilesFromPaths_u24lambda_u2d3 = list2 = CollectionsKt.createListBuilder();
        boolean bl = false;
        for (String path2 : paths) {
            KtFile ktFile;
            VirtualFile vFile;
            if (fs.findFileByPath(path2) == null) continue;
            Intrinsics.checkNotNullExpressionValue((Object)vFile, (String)"fs.findFileByPath(path) ?: continue");
            PsiFile psiFile = psiManager3.findFile(vFile);
            if ((psiFile instanceof KtFile ? (KtFile)psiFile : null) == null) continue;
            ktFile = ktFile;
            $this$getKtFilesFromPaths_u24lambda_u2d3.add(ktFile);
        }
        return CollectionsKt.build((List)list2);
    }

    public static final void configureProjectEnvironment(@NotNull MockProject project, @NotNull CompilerConfiguration compilerConfig, @NotNull List<? extends KtFile> ktFiles, @NotNull Function1<? super GlobalSearchScope, ? extends PackagePartProvider> packagePartProvider, @NotNull CoreJarFileSystem jarFileSystem) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)compilerConfig, (String)"compilerConfig");
        Intrinsics.checkNotNullParameter(ktFiles, (String)"ktFiles");
        Intrinsics.checkNotNullParameter(packagePartProvider, (String)"packagePartProvider");
        Intrinsics.checkNotNullParameter((Object)jarFileSystem, (String)"jarFileSystem");
        StandaloneModeUtilsKt.reRegisterJavaElementFinder((Project)project);
        project.registerService(SymbolLightClassFacadeCache.class);
        project.registerService(ClsJavaStubByVirtualFileCache.class);
        project.getPicoContainer().registerComponentInstance((Object)Reflection.getOrCreateKotlinClass(KotlinModificationTrackerFactory.class).getQualifiedName(), (Object)new KotlinStaticModificationTrackerFactory());
        project.registerService(KotlinAnnotationsResolverFactory.class, (Object)new KotlinStaticAnnotationsResolverFactory((Collection<? extends KtFile>)ktFiles));
        RegisterComponentService.registerLLFirResolveStateService(project);
        project.getPicoContainer().registerComponentInstance((Object)Reflection.getOrCreateKotlinClass(FirSealedClassInheritorsProcessorFactory.class).getQualifiedName(), (Object)new FirSealedClassInheritorsProcessorFactory(){

            @NotNull
            public SealedClassInheritorsProvider createSealedClassInheritorsProvider() {
                return SealedClassInheritorsProviderImpl.INSTANCE;
            }
        });
        project.getPicoContainer().registerComponentInstance((Object)Reflection.getOrCreateKotlinClass(KtModuleScopeProvider.class).getQualifiedName(), (Object)new KtModuleScopeProviderImpl());
        project.getPicoContainer().registerComponentInstance((Object)Reflection.getOrCreateKotlinClass(ProjectStructureProvider.class).getQualifiedName(), (Object)new ProjectStructureProviderByCompilerConfiguration(compilerConfig, (Project)project, ktFiles, jarFileSystem));
        project.getPicoContainer().registerComponentInstance((Object)Reflection.getOrCreateKotlinClass(KotlinDeclarationProviderFactory.class).getQualifiedName(), (Object)new KotlinStaticDeclarationProviderFactory((Collection<? extends KtFile>)ktFiles));
        project.getPicoContainer().registerComponentInstance((Object)Reflection.getOrCreateKotlinClass(KotlinPackageProviderFactory.class).getQualifiedName(), (Object)new KotlinStaticPackageProviderFactory((Collection<? extends KtFile>)ktFiles));
        project.getPicoContainer().registerComponentInstance((Object)Reflection.getOrCreateKotlinClass(PackagePartProviderFactory.class).getQualifiedName(), (Object)new PackagePartProviderFactory(packagePartProvider){
            final /* synthetic */ Function1<GlobalSearchScope, PackagePartProvider> $packagePartProvider;
            {
                this.$packagePartProvider = $packagePartProvider;
            }

            @NotNull
            public PackagePartProvider createPackagePartProviderForLibrary(@NotNull GlobalSearchScope scope2) {
                Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
                return (PackagePartProvider)this.$packagePartProvider.invoke((Object)scope2);
            }
        });
    }

    public static /* synthetic */ void configureProjectEnvironment$default(MockProject mockProject, CompilerConfiguration compilerConfiguration, List list2, Function1 function1, CoreJarFileSystem coreJarFileSystem, int n, Object object) {
        if ((n & 0x10) != 0) {
            coreJarFileSystem = new CoreJarFileSystem();
        }
        StandaloneModeUtilsKt.configureProjectEnvironment(mockProject, compilerConfiguration, list2, (Function1<? super GlobalSearchScope, ? extends PackagePartProvider>)function1, coreJarFileSystem);
    }

    private static final void reRegisterJavaElementFinder(Project project) {
        PsiElementFinder.EP.getPoint((AreaInstance)project).unregisterExtension(JavaElementFinder.class);
        Intrinsics.checkNotNull((Object)project, (String)"null cannot be cast to non-null type com.intellij.mock.MockProject");
        MockProject $this$reRegisterJavaElementFinder_u24lambda_u2d4 = (MockProject)project;
        boolean bl = false;
        $this$reRegisterJavaElementFinder_u24lambda_u2d4.getPicoContainer().registerComponentInstance((Object)Reflection.getOrCreateKotlinClass(KtAnalysisSessionProvider.class).getQualifiedName(), (Object)new KtFirAnalysisSessionProvider((Project)$this$reRegisterJavaElementFinder_u24lambda_u2d4));
        $this$reRegisterJavaElementFinder_u24lambda_u2d4.getPicoContainer().unregisterComponent((Object)Reflection.getOrCreateKotlinClass(KotlinAsJavaSupport.class).getQualifiedName());
        $this$reRegisterJavaElementFinder_u24lambda_u2d4.getPicoContainer().registerComponentInstance((Object)Reflection.getOrCreateKotlinClass(KotlinAsJavaSupport.class).getQualifiedName(), (Object)new KotlinAsJavaFirSupport(project));
        PsiElementFinder.EP.getPoint((AreaInstance)project).registerExtension((Object)new JavaElementFinder(project));
    }

    private static final void getSourceFilePaths$lambda-2$lambda-1$lambda-0(Set $this_buildSet, Path it) {
        Intrinsics.checkNotNullParameter((Object)$this_buildSet, (String)"$this_buildSet");
        $this_buildSet.add(((Object)it).toString());
    }
}

