/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi2ir.generators;

import com.intellij.psi.tree.IElementType;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.ir.expressions.IrDynamicOperator;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtArrayAccessExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtUnaryExpression;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\u0018\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0002H\u0000\u001a\u0010\u0010\u0003\u001a\u00020\u0004*\u0006\u0012\u0002\b\u00030\u0005H\u0000\u001a\u0010\u0010\u0006\u001a\u00020\u0004*\u0006\u0012\u0002\b\u00030\u0005H\u0000\u001a\u0010\u0010\u0007\u001a\u00020\u0004*\u0006\u0012\u0002\b\u00030\u0005H\u0000\u00a8\u0006\b"}, d2={"getDynamicOperator", "Lorg/jetbrains/kotlin/ir/expressions/IrDynamicOperator;", "Lorg/jetbrains/kotlin/psi/KtElement;", "isImplicitGet", "", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "isImplicitInvoke", "isImplicitSet", "ir.psi2ir"})
public final class DynamicCallsKt {
    public static final boolean isImplicitInvoke(@NotNull ResolvedCall<?> $this$isImplicitInvoke) {
        Intrinsics.checkNotNullParameter($this$isImplicitInvoke, (String)"<this>");
        if (!Intrinsics.areEqual((Object)$this$isImplicitInvoke.getResultingDescriptor().getName(), (Object)OperatorNameConventions.INVOKE)) {
            return false;
        }
        KtElement ktElement = $this$isImplicitInvoke.getCall().getCallElement();
        KtCallExpression ktCallExpression = ktElement instanceof KtCallExpression ? (KtCallExpression)ktElement : null;
        if (ktCallExpression == null) {
            return false;
        }
        KtCallExpression callExpression = ktCallExpression;
        KtExpression ktExpression = callExpression.getCalleeExpression();
        KtSimpleNameExpression ktSimpleNameExpression = ktExpression instanceof KtSimpleNameExpression ? (KtSimpleNameExpression)ktExpression : null;
        if (ktSimpleNameExpression == null) {
            return true;
        }
        KtSimpleNameExpression calleeExpression = ktSimpleNameExpression;
        return !Intrinsics.areEqual((Object)calleeExpression.getReferencedName(), (Object)OperatorNameConventions.INVOKE.asString());
    }

    public static final boolean isImplicitGet(@NotNull ResolvedCall<?> $this$isImplicitGet) {
        Intrinsics.checkNotNullParameter($this$isImplicitGet, (String)"<this>");
        return Intrinsics.areEqual((Object)$this$isImplicitGet.getResultingDescriptor().getName(), (Object)OperatorNameConventions.GET) && $this$isImplicitGet.getCall().getCallElement() instanceof KtArrayAccessExpression;
    }

    public static final boolean isImplicitSet(@NotNull ResolvedCall<?> $this$isImplicitSet) {
        Intrinsics.checkNotNullParameter($this$isImplicitSet, (String)"<this>");
        return Intrinsics.areEqual((Object)$this$isImplicitSet.getResultingDescriptor().getName(), (Object)OperatorNameConventions.SET) && $this$isImplicitSet.getCall().getCallElement() instanceof KtArrayAccessExpression;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public static final IrDynamicOperator getDynamicOperator(@NotNull KtElement $this$getDynamicOperator) {
        IrDynamicOperator irDynamicOperator;
        Intrinsics.checkNotNullParameter((Object)$this$getDynamicOperator, (String)"<this>");
        KtElement ktElement = $this$getDynamicOperator;
        if (ktElement instanceof KtUnaryExpression) {
            IElementType iElementType = ((KtUnaryExpression)$this$getDynamicOperator).getOperationToken();
            if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.PLUS))) {
                irDynamicOperator = IrDynamicOperator.UNARY_PLUS;
                return irDynamicOperator;
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.MINUS))) {
                irDynamicOperator = IrDynamicOperator.UNARY_MINUS;
                return irDynamicOperator;
            } else {
                if (!Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.EXCL))) throw new AssertionError((Object)("Unexpected unary operator expression: " + ((KtUnaryExpression)$this$getDynamicOperator).getText()));
                irDynamicOperator = IrDynamicOperator.EXCL;
            }
            return irDynamicOperator;
        } else {
            if (!(ktElement instanceof KtBinaryExpression)) throw new AssertionError((Object)("Unexpected operator expression: " + $this$getDynamicOperator.getText()));
            IElementType iElementType = ((KtBinaryExpression)$this$getDynamicOperator).getOperationToken();
            if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.PLUS))) {
                irDynamicOperator = IrDynamicOperator.BINARY_PLUS;
                return irDynamicOperator;
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.MINUS))) {
                irDynamicOperator = IrDynamicOperator.BINARY_MINUS;
                return irDynamicOperator;
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.MUL))) {
                irDynamicOperator = IrDynamicOperator.MUL;
                return irDynamicOperator;
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.DIV))) {
                irDynamicOperator = IrDynamicOperator.DIV;
                return irDynamicOperator;
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.PERC))) {
                irDynamicOperator = IrDynamicOperator.MOD;
                return irDynamicOperator;
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.LT))) {
                irDynamicOperator = IrDynamicOperator.LT;
                return irDynamicOperator;
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.LTEQ))) {
                irDynamicOperator = IrDynamicOperator.LE;
                return irDynamicOperator;
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.GT))) {
                irDynamicOperator = IrDynamicOperator.GT;
                return irDynamicOperator;
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.GTEQ))) {
                irDynamicOperator = IrDynamicOperator.GE;
                return irDynamicOperator;
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.ANDAND))) {
                irDynamicOperator = IrDynamicOperator.ANDAND;
                return irDynamicOperator;
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.OROR))) {
                irDynamicOperator = IrDynamicOperator.OROR;
                return irDynamicOperator;
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.EQEQ))) {
                irDynamicOperator = IrDynamicOperator.EQEQ;
                return irDynamicOperator;
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.EQEQEQ))) {
                irDynamicOperator = IrDynamicOperator.EQEQEQ;
                return irDynamicOperator;
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.EXCLEQ))) {
                irDynamicOperator = IrDynamicOperator.EXCLEQ;
                return irDynamicOperator;
            } else {
                if (!Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.EXCLEQEQEQ))) throw new AssertionError((Object)("Unexpected binary operator expression: " + ((KtBinaryExpression)$this$getDynamicOperator).getText()));
                irDynamicOperator = IrDynamicOperator.EXCLEQEQ;
            }
        }
        return irDynamicOperator;
    }
}

