/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.interpreter.stack;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.interpreter.Instruction;
import org.jetbrains.kotlin.ir.interpreter.stack.DataStack;
import org.jetbrains.kotlin.ir.interpreter.stack.Variable;
import org.jetbrains.kotlin.ir.interpreter.state.State;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000bJ\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\b\u0010\u0015\u001a\u0004\u0018\u00010\tJ\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0017J\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u0013\u001a\u00020\u0014J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0006\u0010\u001b\u001a\u00020\u0012J\b\u0010\u001c\u001a\u0004\u0018\u00010\u0019J\u0006\u0010\u001d\u001a\u00020\tJ\u0006\u0010\u001e\u001a\u00020\u0019J\u000e\u0010\u001f\u001a\u00020\u000f2\u0006\u0010 \u001a\u00020\tJ\u000e\u0010!\u001a\u00020\u000f2\u0006\u0010\"\u001a\u00020\u0019J\u0016\u0010#\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010$\u001a\u00020\u0019R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006%"}, d2={"Lorg/jetbrains/kotlin/ir/interpreter/stack/SubFrame;", "", "owner", "Lorg/jetbrains/kotlin/ir/IrElement;", "(Lorg/jetbrains/kotlin/ir/IrElement;)V", "dataStack", "Lorg/jetbrains/kotlin/ir/interpreter/stack/DataStack;", "instructions", "", "Lorg/jetbrains/kotlin/ir/interpreter/Instruction;", "memory", "Lorg/jetbrains/kotlin/ir/interpreter/stack/Variable;", "getOwner", "()Lorg/jetbrains/kotlin/ir/IrElement;", "addVariable", "", "variable", "containsVariable", "", "symbol", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "dropInstructions", "getAll", "", "getState", "Lorg/jetbrains/kotlin/ir/interpreter/state/State;", "getVariable", "isEmpty", "peekState", "popInstruction", "popState", "pushInstruction", "instruction", "pushState", "state", "setState", "newState", "ir.interpreter"})
public final class SubFrame {
    @NotNull
    private final IrElement owner;
    @NotNull
    private final List<Instruction> instructions;
    @NotNull
    private final DataStack dataStack;
    @NotNull
    private final List<Variable> memory;

    public SubFrame(@NotNull IrElement owner) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        this.owner = owner;
        boolean bl = false;
        this.instructions = new ArrayList();
        this.dataStack = new DataStack();
        bl = false;
        this.memory = new ArrayList();
    }

    @NotNull
    public final IrElement getOwner() {
        return this.owner;
    }

    public final boolean isEmpty() {
        return this.instructions.isEmpty();
    }

    public final void pushInstruction(@NotNull Instruction instruction) {
        Intrinsics.checkNotNullParameter((Object)instruction, (String)"instruction");
        this.instructions.add(0, instruction);
    }

    @NotNull
    public final Instruction popInstruction() {
        return (Instruction)CollectionsKt.removeFirst(this.instructions);
    }

    @Nullable
    public final Instruction dropInstructions() {
        Instruction instruction;
        Instruction instruction2 = (Instruction)CollectionsKt.lastOrNull(this.instructions);
        if (instruction2 == null) {
            instruction = null;
        } else {
            Instruction instruction3 = instruction2;
            boolean bl = false;
            boolean bl2 = false;
            Instruction $this$dropInstructions_u24lambda_u2d0 = instruction3;
            boolean bl3 = false;
            this.instructions.clear();
            instruction = instruction3;
        }
        return instruction;
    }

    public final void pushState(@NotNull State state2) {
        Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
        this.dataStack.push(state2);
    }

    @NotNull
    public final State popState() {
        return this.dataStack.pop();
    }

    @Nullable
    public final State peekState() {
        return this.dataStack.peek();
    }

    public final void addVariable(@NotNull Variable variable2) {
        Intrinsics.checkNotNullParameter((Object)variable2, (String)"variable");
        SubFrame subFrame = this;
        Collection collection = subFrame.memory;
        boolean bl = false;
        collection.add(variable2);
    }

    private final Variable getVariable(IrSymbol symbol2) {
        Object v0;
        block1: {
            Iterable $this$firstOrNull$iv = this.memory;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Variable it = (Variable)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getSymbol(), (Object)symbol2)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    public final boolean containsVariable(@NotNull IrSymbol symbol2) {
        Intrinsics.checkNotNullParameter((Object)symbol2, (String)"symbol");
        return this.getVariable(symbol2) != null;
    }

    @Nullable
    public final State getState(@NotNull IrSymbol symbol2) {
        Intrinsics.checkNotNullParameter((Object)symbol2, (String)"symbol");
        Variable variable2 = this.getVariable(symbol2);
        return variable2 == null ? null : variable2.getState();
    }

    public final void setState(@NotNull IrSymbol symbol2, @NotNull State newState) {
        Intrinsics.checkNotNullParameter((Object)symbol2, (String)"symbol");
        Intrinsics.checkNotNullParameter((Object)newState, (String)"newState");
        Variable variable2 = this.getVariable(symbol2);
        if (variable2 != null) {
            variable2.setState(newState);
        }
    }

    @NotNull
    public final List<Variable> getAll() {
        return this.memory;
    }
}

